/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsRequestContext;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.CmsMessages;
import org.opencms.report.I_CmsReport;
import org.opencms.report.Messages;
import org.opencms.util.CmsStringUtil;

public abstract class A_CmsReport
implements I_CmsReport {
    private List<Object> m_errors = new ArrayList<Object>();
    private long m_lastEntryTime;
    private Locale m_locale;
    private CmsMessages m_messages;
    private String m_siteRoot;
    private long m_starttime;
    private List<Object> m_warnings = new ArrayList<Object>();

    @Override
    public void addError(Object obj) {
        this.m_errors.add(obj);
    }

    @Override
    public void addWarning(Object obj) {
        this.m_warnings.add(obj);
    }

    @Override
    public String formatRuntime() {
        return CmsStringUtil.formatRuntime(this.getRuntime());
    }

    @Override
    public List<Object> getErrors() {
        return this.m_errors;
    }

    @Override
    public long getLastEntryTime() {
        return this.m_lastEntryTime;
    }

    @Override
    public Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public long getRuntime() {
        return System.currentTimeMillis() - this.m_starttime;
    }

    @Override
    public String getSiteRoot() {
        return this.m_siteRoot;
    }

    @Override
    public List<Object> getWarnings() {
        return this.m_warnings;
    }

    @Override
    public boolean hasError() {
        return this.m_errors.size() > 0;
    }

    @Override
    public boolean hasWarning() {
        return this.m_warnings.size() > 0;
    }

    @Override
    public void print(CmsMessageContainer container) {
        this.print(container.key(this.getLocale()), 0);
    }

    @Override
    public void print(CmsMessageContainer container, int format) {
        this.print(container.key(this.getLocale()), format);
    }

    @Override
    public void println(CmsMessageContainer container) {
        this.println(container.key(this.getLocale()), 0);
    }

    @Override
    public void println(CmsMessageContainer container, int format) {
        this.println(container.key(this.getLocale()), format);
    }

    @Override
    public void printMessageWithParam(CmsMessageContainer container, Object param) {
        this.print(container, 3);
        this.print(Messages.get().container("RPT_ARGUMENT_1", param));
        this.print(Messages.get().container("RPT_DOTS_0"));
    }

    @Override
    public void printMessageWithParam(int m, int n, CmsMessageContainer container, Object param) {
        this.print(Messages.get().container("RPT_SUCCESSION_2", String.valueOf(m), String.valueOf(n)), 3);
        this.printMessageWithParam(container, param);
    }

    @Override
    public String removeSiteRoot(String resourcename) {
        if (this.m_siteRoot == null) {
            return resourcename;
        }
        String siteRoot = CmsRequestContext.getAdjustedSiteRoot(this.m_siteRoot, resourcename);
        if (siteRoot.equals(this.m_siteRoot) && resourcename.startsWith(siteRoot)) {
            resourcename = resourcename.substring(siteRoot.length());
        }
        return resourcename;
    }

    @Override
    public void resetRuntime() {
        this.m_starttime = System.currentTimeMillis();
    }

    protected CmsMessages getMessages() {
        return this.m_messages;
    }

    protected void init(Locale locale, String siteRoot) {
        this.m_starttime = System.currentTimeMillis();
        this.m_locale = locale;
        this.m_siteRoot = siteRoot;
        this.m_messages = Messages.get().getBundle(locale);
    }

    protected void print(String value) {
        this.print(value, 0);
    }

    protected abstract void print(String var1, int var2);

    protected void println(String value) {
        this.println(value, 0);
    }

    protected void println(String value, int format) {
        this.print(value, format);
        this.println();
    }

    protected void setLastEntryTime(long time) {
        this.m_lastEntryTime = time;
    }
}

