/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.CmsDocumentXmlContent;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.galleries.CmsGalleryNameMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.A_CmsXmlDocument;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsGalleryDocumentXmlContent
extends CmsDocumentXmlContent {
    public static final String MAPPING_GALLERY_NAME = "galleryName";
    private static final Log LOG = CmsLog.getLog(CmsDocumentXmlContent.class);

    public CmsGalleryDocumentXmlContent(String name) {
        super(name);
    }

    public static void collectSchemaXpathsForSimpleValues(CmsObject cms, CmsXmlContentDefinition def, String path, Set<String> result) {
        List<I_CmsXmlSchemaType> nestedTypes = def.getTypeSequence();
        for (I_CmsXmlSchemaType nestedType : nestedTypes) {
            String subPath = path + "/" + nestedType.getName();
            if (nestedType instanceof CmsXmlNestedContentDefinition) {
                CmsXmlContentDefinition nestedDef = ((CmsXmlNestedContentDefinition)nestedType).getNestedContentDefinition();
                CmsGalleryDocumentXmlContent.collectSchemaXpathsForSimpleValues(cms, nestedDef, subPath, result);
                continue;
            }
            result.add(subPath);
        }
    }

    @Override
    public I_CmsSearchDocument createDocument(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        I_CmsExtractionResult content = null;
        try {
            content = this.extractContent(cms, resource, index);
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
        return index.getFieldConfiguration().createDocument(cms, resource, index, content);
    }

    @Override
    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        this.logContentExtraction(resource, index);
        try {
            CmsFile file = this.readFile(cms, resource);
            CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, file);
            HashMap<String, String> items = new HashMap<String, String>();
            StringBuffer locales = new StringBuffer();
            for (Locale locale : xmlContent.getLocales()) {
                List<String> mappings;
                locales.append(locale.toString());
                locales.append(' ');
                StringBuffer content = new StringBuffer();
                boolean hasTitleMapping = false;
                String galleryNameTemplate = null;
                for (String xpath : xmlContent.getNames(locale)) {
                    String extracted;
                    I_CmsXmlContentValue value = xmlContent.getValue(xpath, locale);
                    if (value.getContentDefinition().getContentHandler().isSearchable(value) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted = value.getPlainText(cms))) {
                        content.append(extracted);
                        content.append('\n');
                    }
                    if ((mappings = xmlContent.getHandler().getMappings(value.getPath())).size() <= 0) continue;
                    for (String mapping : mappings) {
                        if (mapping.startsWith("property:")) {
                            String extracted2;
                            String propertyName = mapping.substring(mapping.lastIndexOf(58) + 1);
                            if (!"Title".equals(propertyName) && !"Description".equals(propertyName) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted2 = value.getPlainText(cms))) continue;
                            String fieldName = null;
                            if ("Title".equals(propertyName)) {
                                hasTitleMapping = true;
                                fieldName = "title";
                            } else {
                                fieldName = "description";
                            }
                            this.putMappingValue(xmlContent, fieldName, locale, items, extracted2);
                            continue;
                        }
                        if (!mapping.equals(MAPPING_GALLERY_NAME)) continue;
                        galleryNameTemplate = value.getPlainText(cms);
                        LOG.info((Object)("Found gallery name template for " + resource.getRootPath() + ":" + galleryNameTemplate));
                    }
                }
                if (galleryNameTemplate == null) {
                    HashSet xpaths = Sets.newHashSet();
                    CmsGalleryDocumentXmlContent.collectSchemaXpathsForSimpleValues(cms, xmlContent.getContentDefinition(), "", xpaths);
                    block5: for (String xpath : xpaths) {
                        mappings = xmlContent.getHandler().getMappings(CmsXmlUtils.createXpath(xpath, 1));
                        for (String mapping : mappings) {
                            if (!mapping.equals(MAPPING_GALLERY_NAME)) continue;
                            galleryNameTemplate = xmlContent.getHandler().getDefault(cms, xmlContent.getFile(), null, xpath, locale);
                            LOG.info((Object)("Using default value for gallery name template in " + resource.getRootPath() + ": " + galleryNameTemplate));
                            continue block5;
                        }
                    }
                }
                if (!hasTitleMapping) {
                    String title = cms.readPropertyObject(resource, "Title", false).getValue();
                    this.putMappingValue(xmlContent, "title", locale, items, title);
                }
                if (galleryNameTemplate != null) {
                    CmsGalleryNameMacroResolver macroResolver = new CmsGalleryNameMacroResolver(cms, xmlContent, locale);
                    String galleryName = macroResolver.resolveMacros(galleryNameTemplate);
                    LOG.info((Object)("Using gallery name mapping '" + galleryNameTemplate + "' for '" + resource.getRootPath() + "' in locale " + locale + ", resulting in gallery name '" + galleryName + "'"));
                    this.putMappingValue(xmlContent, "title", locale, items, galleryName);
                }
                if (content.length() > 0) {
                    items.put(CmsSearchFieldConfiguration.getLocaleExtendedName("content", locale), content.toString());
                }
                items.put("res_locales", CmsStringUtil.listAsString(this.getLocalesToStore(xmlContent), " "));
            }
            return new CmsExtractionResult(null, items);
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
    }

    @Override
    public boolean isLocaleDependend() {
        return false;
    }

    protected List<Locale> getLocalesToStore(A_CmsXmlDocument content) {
        if (this.isGroup(content) || CmsResourceTypeXmlContainerPage.isContainerPage(content.getFile())) {
            return OpenCms.getLocaleManager().getAvailableLocales();
        }
        return content.getLocales();
    }

    protected List<Locale> getTargetLocalesForField(A_CmsXmlDocument xmlContent, String fieldName, Locale sourceLocale) {
        if (this.isGroup(xmlContent) && sourceLocale.equals(Locale.ENGLISH)) {
            return OpenCms.getLocaleManager().getAvailableLocales();
        }
        return Collections.singletonList(sourceLocale);
    }

    protected boolean isGroup(A_CmsXmlDocument content) {
        try {
            int typeId = content.getFile().getTypeId();
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(typeId);
            String typeName = type.getTypeName();
            return "groupcontainer".equals(typeName) || "inheritance_group".equals(typeName);
        }
        catch (CmsLoaderException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    protected void putMappingValue(A_CmsXmlDocument xmlContent, String fieldName, Locale sourceLocale, Map<String, String> items, String value) {
        List<Locale> fieldTargetLocales = this.getTargetLocalesForField(xmlContent, fieldName, sourceLocale);
        for (Locale targetLocale : fieldTargetLocales) {
            items.put(CmsSearchFieldConfiguration.getLocaleExtendedName(fieldName, targetLocale), value);
        }
    }
}

