/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.CmsDocumentDependency;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsLuceneField;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.search.solr.CmsSolrDocument;
import org.opencms.search.solr.CmsSolrDocumentXmlContent;
import org.opencms.search.solr.CmsSolrField;
import org.opencms.search.solr.Messages;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.content.I_CmsXmlContentHandler;

public class CmsSolrFieldConfiguration
extends CmsSearchFieldConfiguration {
    private static final Log LOG = CmsLog.getLog(CmsSolrFieldConfiguration.class);
    private List<Locale> m_contentLocales;
    private Map<String, CmsSolrField> m_solrFields = new HashMap<String, CmsSolrField>();

    @Override
    public void addAdditionalFields() {
        this.addContentFields();
        this.addLuceneFields();
        CmsSolrField sfield = new CmsSolrField("mimetype", null, null, null, 0.0f);
        this.m_solrFields.put(sfield.getName(), sfield);
        sfield = new CmsSolrField("filename", null, null, null, 0.0f);
        this.m_solrFields.put(sfield.getName(), sfield);
        sfield = new CmsSolrField("version", null, null, null, 0.0f);
        this.m_solrFields.put(sfield.getName(), sfield);
        sfield = new CmsSolrField("state", null, null, null, 0.0f);
        CmsSearchFieldMapping map = new CmsSearchFieldMapping(CmsSearchFieldMappingType.ATTRIBUTE, "state");
        sfield.addMapping(map);
        this.m_solrFields.put(sfield.getName(), sfield);
        sfield = new CmsSolrField("userLastModified", null, null, null, 0.0f);
        map = new CmsSearchFieldMapping(CmsSearchFieldMappingType.ATTRIBUTE, "userLastModified");
        sfield.addMapping(map);
        this.m_solrFields.put(sfield.getName(), sfield);
        sfield = new CmsSolrField("userCreated", null, null, null, 0.0f);
        map = new CmsSearchFieldMapping(CmsSearchFieldMappingType.ATTRIBUTE, "userCreated");
        sfield.addMapping(map);
        this.m_solrFields.put(sfield.getName(), sfield);
        this.getFields().clear();
        this.getFields().addAll(this.m_solrFields.values());
    }

    @Override
    public I_CmsSearchDocument appendFields(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        String mimeType = OpenCms.getResourceManager().getMimeType(resource.getName(), null);
        if (mimeType != null) {
            document.addSearchField(this.m_solrFields.get("mimetype"), mimeType);
        }
        document.addSearchField(this.m_solrFields.get("filename"), resource.getName());
        document.addSearchField(this.m_solrFields.get("version"), "" + resource.getVersion());
        return document;
    }

    public Map<String, CmsSolrField> getSolrFields() {
        return Collections.unmodifiableMap(this.m_solrFields);
    }

    protected void addAdditionalFields(List<CmsSolrField> additionalFields) {
        if (additionalFields != null) {
            for (CmsSolrField solrField : additionalFields) {
                this.m_solrFields.put(solrField.getName(), solrField);
            }
        }
    }

    @Override
    protected I_CmsSearchDocument appendDates(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        document.addDateField("created", resource.getDateCreated(), false);
        document.addDateField("lastmodified", resource.getDateLastModified(), false);
        document.addDateField("contentdate", resource.getDateContent(), false);
        document.addDateField("released", resource.getDateReleased(), false);
        document.addDateField("expired", resource.getDateExpired(), false);
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendFieldMapping(I_CmsSearchDocument document, CmsSearchField sfield, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        CmsSolrField field = (CmsSolrField)sfield;
        try {
            StringBuffer text = new StringBuffer();
            for (I_CmsSearchFieldMapping mapping : field.getMappings()) {
                String value;
                if (extractionResult != null) {
                    String mapResult = null;
                    if (field.getLocale() != null && mapping.getType().equals(CmsSearchFieldMappingType.CONTENT)) {
                        String key = CmsSearchFieldConfiguration.getLocaleExtendedName("content", field.getLocale());
                        mapResult = extractionResult.getContentItems().get(key);
                        if (mapResult == null && !CmsResourceTypeXmlContent.isXmlContent(resource) && !CmsResourceTypeXmlPage.isXmlPage(resource) && this.m_contentLocales != null && this.m_contentLocales.contains(field.getLocale())) {
                            mapResult = extractionResult.getContent();
                        }
                    } else {
                        mapResult = mapping.getStringValue(cms, resource, extractionResult, properties, propertiesSearched);
                    }
                    if (mapResult != null) {
                        if (text.length() > 0) {
                            text.append('\n');
                        }
                        text.append(mapResult);
                        continue;
                    }
                    if (mapping.getDefaultValue() == null) continue;
                    text.append("\n" + mapping.getDefaultValue());
                    continue;
                }
                if (mapping.getStringValue(cms, resource, extractionResult, properties, propertiesSearched) == null || (value = mapping.getStringValue(cms, resource, extractionResult, properties, propertiesSearched)) == null) continue;
                document.addSearchField(field, value);
            }
            if (text.length() <= 0 && field.getDefaultValue() != null) {
                text.append(field.getDefaultValue());
            }
            if (text.length() > 0) {
                document.addSearchField(field, text.toString());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendFieldMappings(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        Set<CmsSearchField> mappedFields = this.getXSDMappings(cms, resource);
        if (mappedFields != null) {
            for (CmsSearchField cmsSearchField : mappedFields) {
                document = this.appendFieldMapping(document, cmsSearchField, cms, resource, extractionResult, properties, propertiesSearched);
            }
        }
        if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
            document = this.appendFieldMappingsFromElementsOnThePage(document, cms, resource);
        }
        for (CmsSolrField cmsSolrField : this.m_solrFields.values()) {
            document = this.appendFieldMapping(document, cmsSolrField, cms, resource, extractionResult, properties, propertiesSearched);
        }
        return document;
    }

    protected I_CmsSearchDocument appendFieldMappingsFromElementsOnThePage(I_CmsSearchDocument document, CmsObject cms, CmsResource resource) {
        try {
            CmsFile file = cms.readFile(resource);
            CmsXmlContainerPage containerPage = CmsXmlContainerPageFactory.unmarshal(cms, file);
            CmsContainerPageBean containerBean = containerPage.getContainerPage(cms);
            if (containerBean != null) {
                for (CmsContainerElementBean element : containerBean.getElements()) {
                    element.initResource(cms);
                    CmsResource elemResource = element.getResource();
                    Set<CmsSearchField> mappedFields = this.getXSDMappingsForPage(cms, elemResource);
                    if (mappedFields == null) continue;
                    for (CmsSearchField field : mappedFields) {
                        document = this.appendFieldMapping(document, field, cms, elemResource, CmsSolrDocumentXmlContent.extractXmlContent(cms, elemResource, this.getIndex()), cms.readPropertyObjects(resource, false), cms.readPropertyObjects(resource, true));
                    }
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendLocales(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        List<String> itemLocales = null;
        ArrayList<Locale> resourceLocales = new ArrayList();
        if (extraction != null && extraction.getContentItems() != null && extraction.getContentItems().get("res_locales") != null) {
            String localesAsString = extraction.getContentItems().get("res_locales");
            itemLocales = CmsStringUtil.splitAsList(localesAsString, ' ');
            for (String locale : itemLocales) {
                resourceLocales.add(new Locale(locale));
            }
        } else {
            resourceLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        }
        document.addResourceLocales(resourceLocales);
        this.m_contentLocales = new ArrayList<Locale>();
        this.m_contentLocales = itemLocales != null ? resourceLocales : this.getContentLocales(cms, resource, extraction);
        document.addContentLocales(this.m_contentLocales);
        if (this.hasLocaleDependencies()) {
            CmsDocumentDependency dep = CmsDocumentDependency.load(cms, resource);
            ((CmsSolrDocument)document).addDocumentDependency(cms, dep);
        }
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendProperties(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        for (CmsProperty prop : propertiesSearched) {
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(prop.getValue())) continue;
            document.addSearchField(new CmsSolrField(prop.getName() + "_prop", null, null, null, 1.0f), prop.getValue());
            document.addSearchField(new CmsSolrField(prop.getName() + "_prop" + "_s", null, null, null, 1.0f), prop.getValue());
        }
        return document;
    }

    protected List<Locale> getContentLocales(CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction) {
        Locale detectedLocale = CmsStringUtil.getLocaleForName(resource.getRootPath());
        if (this.getIndex().isLanguageDetection() && detectedLocale == null && extraction != null && extraction.getContent() != null) {
            detectedLocale = CmsStringUtil.getLocaleForText(extraction.getContent());
        }
        ArrayList<Locale> result = new ArrayList<Locale>();
        if (detectedLocale != null) {
            result.add(detectedLocale);
        } else {
            result.add(OpenCms.getLocaleManager().getDefaultLocales(cms, resource).get(0));
            LOG.debug((Object)Messages.get().getBundle().key("LOG_LANGUAGE_DETECTION_FAILED_1", resource));
        }
        return result;
    }

    protected Set<CmsSearchField> getXSDMappings(CmsObject cms, CmsResource resource) {
        try {
            I_CmsXmlContentHandler handler;
            if (CmsResourceTypeXmlContent.isXmlContent(resource) && (handler = CmsXmlContentDefinition.getContentHandlerForResource(cms, resource)) != null && !handler.getSearchFields().isEmpty()) {
                return handler.getSearchFields();
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected Set<CmsSearchField> getXSDMappingsForPage(CmsObject cms, CmsResource resource) {
        try {
            I_CmsXmlContentHandler handler;
            if (CmsResourceTypeXmlContent.isXmlContent(resource) && (handler = CmsXmlContentDefinition.getContentHandlerForResource(cms, resource)) != null && !handler.getSearchFieldsForPage().isEmpty()) {
                return handler.getSearchFieldsForPage();
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void addContentFields() {
        CmsSolrField solrField = new CmsSolrField("content", null, null, null, 1.0f);
        solrField.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.CONTENT, "content"));
        this.m_solrFields.put(solrField.getName(), solrField);
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            solrField = new CmsSolrField(CmsSearchFieldConfiguration.getLocaleExtendedName("content", locale), Collections.singletonList(locale.toString() + "_excerpt"), locale, null, 1.0f);
            solrField.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.CONTENT, "content"));
            this.m_solrFields.put(solrField.getName(), solrField);
        }
    }

    private void addLuceneFields() {
        for (CmsSearchField field : this.getFields()) {
            if (!(field instanceof CmsLuceneField)) continue;
            CmsSolrField solrField = new CmsSolrField((CmsLuceneField)field);
            this.m_solrFields.put(solrField.getName(), solrField);
        }
    }

    private boolean hasLocaleDependencies() {
        for (CmsSearchIndexSource source : this.getIndex().getSources()) {
            if (!source.getIndexer().isLocaleDependenciesEnable()) continue;
            return true;
        }
        return false;
    }
}

