/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site.xmlsitemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsXmlSeoConfiguration {
    public static final Object MODE_ROBOTS_TXT = "robotstxt";
    public static final Object MODE_XML_SITEMAP = "xmlsitemap";
    public static final String N_COMPUTE_CONTAINER_PAGE_DATES = "ComputeContPageDates";
    public static final String N_EXCLUDE = "SitemapExclude";
    public static final String N_GENERATOR_CLASS = "GeneratorClass";
    public static final String N_INCLUDE = "SitemapInclude";
    public static final String N_MODE = "Mode";
    public static final String N_ROBOTS_TXT_TEXT = "RobotsTxtText";
    public static final String SEO_FILE_TYPE = "seo_file";
    protected List<String> m_excludes = new ArrayList<String>();
    protected List<String> m_includes = new ArrayList<String>();
    protected String m_mode;
    protected String m_robotsTxtText = "";
    private boolean m_computeContainerPageDates;
    private String m_generatorClassName;

    public List<String> getExcludes() {
        return Collections.unmodifiableList(this.m_excludes);
    }

    public List<String> getIncludes() {
        return Collections.unmodifiableList(this.m_includes);
    }

    public String getMode() {
        return this.m_mode;
    }

    public String getRobotsTxtText() {
        return this.m_robotsTxtText;
    }

    public String getSitemapGeneratorClassName() {
        return this.m_generatorClassName;
    }

    public boolean isXmlSitemapMode() {
        return MODE_XML_SITEMAP.equals(this.m_mode);
    }

    public void load(CmsObject cms, CmsResource resource) throws CmsException {
        I_CmsXmlContentValue generatorClassValue;
        I_CmsXmlContentValue computeContPageDates;
        CmsFile file = cms.readFile(resource);
        CmsObject rootCms = OpenCms.initCmsObject(cms);
        rootCms.getRequestContext().setSiteRoot("");
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
        Locale en = new Locale("en");
        for (I_CmsXmlContentValue value : content.getValues(N_INCLUDE, en)) {
            String include = value.getStringValue(rootCms);
            if (CmsStringUtil.isEmpty(include)) continue;
            this.m_includes.add(include);
        }
        for (I_CmsXmlContentValue value : content.getValues(N_EXCLUDE, en)) {
            String exclude = value.getStringValue(rootCms);
            if (CmsStringUtil.isEmpty(exclude)) continue;
            this.m_excludes.add(exclude);
        }
        I_CmsXmlContentValue robotsValue = content.getValue(N_MODE, en);
        this.m_mode = robotsValue.getStringValue(rootCms);
        I_CmsXmlContentValue robotsTxtTextValue = content.getValue(N_ROBOTS_TXT_TEXT, en);
        if (robotsTxtTextValue != null) {
            this.m_robotsTxtText = robotsTxtTextValue.getStringValue(rootCms);
        }
        if ((computeContPageDates = content.getValue(N_COMPUTE_CONTAINER_PAGE_DATES, en)) != null) {
            this.m_computeContainerPageDates = Boolean.parseBoolean(computeContPageDates.getStringValue(rootCms));
        }
        if ((generatorClassValue = content.getValue(N_GENERATOR_CLASS, en)) != null) {
            this.m_generatorClassName = generatorClassValue.getStringValue(rootCms);
        }
    }

    public boolean shouldComputeContainerPageModificationDates() {
        return this.m_computeContainerPageDates;
    }
}

