/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.synchronize;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbIoException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.synchronize.CmsSynchronizeException;
import org.opencms.synchronize.CmsSynchronizeList;
import org.opencms.synchronize.CmsSynchronizeSettings;
import org.opencms.synchronize.I_CmsSynchronizeModification;
import org.opencms.synchronize.Messages;
import org.opencms.util.CmsFileUtil;

public class CmsSynchronize {
    static final int DELETE_VFS = 3;
    static final int EXPORT_VFS = 1;
    static final String SYNCLIST_FILENAME = "#synclist.txt";
    static final int UPDATE_VFS = 2;
    private static final Log LOG = CmsLog.getLog(CmsSynchronize.class);
    private static List<I_CmsSynchronizeModification> m_synchronizeModifications = new ArrayList<I_CmsSynchronizeModification>();
    private CmsObject m_cms;
    private int m_count;
    private String m_destinationPathInRfs;
    private HashMap<String, CmsSynchronizeList> m_newSyncList;
    private I_CmsReport m_report;
    private HashMap<String, CmsSynchronizeList> m_syncList;

    public CmsSynchronize(CmsObject cms, CmsSynchronizeSettings settings, I_CmsReport report) throws CmsSynchronizeException, CmsException {
        if (settings != null && settings.isSyncEnabled()) {
            this.m_cms = OpenCms.initCmsObject(cms);
            this.m_cms.getRequestContext().setSiteRoot("/");
            this.m_report = report;
            this.m_count = 1;
            this.m_destinationPathInRfs = settings.getDestinationPathInRfs();
            File destinationFolder = new File(this.m_destinationPathInRfs);
            if (!destinationFolder.exists() || !destinationFolder.isDirectory()) {
                throw new CmsSynchronizeException(Messages.get().container("ERR_RFS_DESTINATION_NOT_THERE_1", this.m_destinationPathInRfs));
            }
            if (!destinationFolder.canWrite()) {
                throw new CmsSynchronizeException(Messages.get().container("ERR_RFS_DESTINATION_NO_WRITE_1", this.m_destinationPathInRfs));
            }
            this.m_syncList = this.readSyncList();
            this.m_newSyncList = new HashMap();
            for (String sourcePathInVfs : settings.getSourceListInVfs()) {
                String destPath = this.m_destinationPathInRfs + sourcePathInVfs.replace('/', File.separatorChar);
                report.println(org.opencms.workplace.threads.Messages.get().container("RPT_SYNCHRONIZE_FOLDERS_2", sourcePathInVfs, destPath), 2);
                this.syncVfsToRfs(sourcePathInVfs);
            }
            this.removeFromRfs(this.m_destinationPathInRfs);
            Iterator<String> i = settings.getSourceListInVfs().iterator();
            while (i.hasNext()) {
                this.copyFromRfs(i.next());
            }
        } else {
            throw new CmsSynchronizeException(Messages.get().container("ERR_INIT_SYNC_0"));
        }
        this.writeSyncList();
        this.m_syncList = null;
        this.m_newSyncList = null;
        this.m_cms = null;
    }

    public int getCount() {
        return this.m_count;
    }

    private void copyFromRfs(String folder) throws CmsException {
        File fsFile = this.getFileInRfs(folder);
        try {
            this.m_cms.readFolder(this.translate(folder), CmsResourceFilter.IGNORE_EXPIRATION);
        }
        catch (CmsException e) {
            String foldername = this.translate(folder);
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", String.valueOf(this.m_count++)), 3);
            this.m_report.print(Messages.get().container("RPT_IMPORT_FOLDER_0"), 3);
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", fsFile.getAbsolutePath().replace('\\', '/')));
            this.m_report.print(Messages.get().container("RPT_FROM_FS_TO_0"), 3);
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", foldername));
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            CmsResource newFolder = this.m_cms.createResource(foldername, 0);
            Iterator<I_CmsSynchronizeModification> i = m_synchronizeModifications.iterator();
            while (i.hasNext()) {
                try {
                    i.next().modifyVfs(this.m_cms, newFolder, fsFile);
                }
                catch (CmsSynchronizeException e1) {
                    // empty catch block
                    break;
                }
            }
            newFolder = this.m_cms.readFolder(foldername, CmsResourceFilter.IGNORE_EXPIRATION);
            String resourcename = this.m_cms.getSitePath(newFolder);
            CmsSynchronizeList sync = new CmsSynchronizeList(folder, resourcename, newFolder.getDateLastModified(), fsFile.lastModified());
            this.m_newSyncList.put(resourcename, sync);
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        }
        if (fsFile.isDirectory()) {
            File[] res = fsFile.listFiles();
            for (int i = 0; i < res.length; ++i) {
                if (this.isExcluded(res[i])) continue;
                String resname = res[i].getAbsolutePath();
                resname = resname.substring(this.m_destinationPathInRfs.length());
                resname = resname.replace(File.separatorChar, '/');
                if (res[i].isFile()) {
                    if (this.m_newSyncList.containsKey(this.translate(resname))) continue;
                    this.importToVfs(res[i], resname, folder);
                    continue;
                }
                this.copyFromRfs(resname + "/");
            }
        }
    }

    private void createNewLocalFile(File newFile) throws CmsException {
        block12: {
            if (newFile.exists()) {
                throw new CmsSynchronizeException(Messages.get().container("ERR_EXISTENT_FILE_1", newFile.getPath()));
            }
            FileOutputStream fOut = null;
            try {
                File parentFolder = new File(newFile.getPath().replace('/', File.separatorChar).substring(0, newFile.getPath().lastIndexOf(File.separator)));
                parentFolder.mkdirs();
                if (parentFolder.exists()) {
                    fOut = new FileOutputStream(newFile);
                    break block12;
                }
                throw new CmsSynchronizeException(Messages.get().container("ERR_CREATE_DIR_1", newFile.getPath()));
            }
            catch (IOException e) {
                throw new CmsSynchronizeException(Messages.get().container("ERR_CREATE_FILE_1", this.getClass().getName(), newFile.getPath()), (Throwable)e);
            }
            finally {
                if (fOut != null) {
                    try {
                        fOut.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private void deleteFromVfs(CmsResource res) throws CmsException {
        String resourcename = this.m_cms.getSitePath(res);
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", String.valueOf(this.m_count++)), 3);
        if (res.isFile()) {
            this.m_report.print(Messages.get().container("RPT_DEL_FILE_0"), 3);
        } else {
            this.m_report.print(Messages.get().container("RPT_DEL_FOLDER_0"), 3);
        }
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", resourcename));
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
        this.m_cms.lockResource(resourcename);
        this.m_cms.deleteResource(resourcename, CmsResource.DELETE_PRESERVE_SIBLINGS);
        this.m_syncList.remove(this.translate(resourcename));
        this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
    }

    private void exportToRfs(CmsResource res) throws CmsException {
        String resourcename;
        CmsSynchronizeList sync = this.m_syncList.get(this.translate(this.m_cms.getSitePath(res)));
        if (sync != null) {
            resourcename = sync.getResName();
        } else {
            resourcename = this.m_cms.getSitePath(res);
            String parent = CmsResource.getParentFolder(resourcename);
            CmsSynchronizeList parentSync = this.m_newSyncList.get(parent);
            if (parentSync != null) {
                resourcename = parentSync.getResName() + res.getName();
            }
        }
        if (res.isFolder() && !resourcename.endsWith("/")) {
            resourcename = resourcename + "/";
        }
        File fsFile = this.getFileInRfs(resourcename);
        try {
            CmsFile vfsFile;
            if (!res.getState().isDeleted()) {
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", String.valueOf(this.m_count++)), 3);
                if (res.isFile()) {
                    this.m_report.print(Messages.get().container("RPT_EXPORT_FILE_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.m_cms.getSitePath(res)));
                    this.m_report.print(Messages.get().container("RPT_TO_FS_AS_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", fsFile.getAbsolutePath().replace('\\', '/')));
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    if (!fsFile.exists()) {
                        this.createNewLocalFile(fsFile);
                    }
                    vfsFile = this.m_cms.readFile(this.m_cms.getSitePath(res), CmsResourceFilter.IGNORE_EXPIRATION);
                    try {
                        this.writeFileByte(vfsFile.getContents(), fsFile);
                    }
                    catch (IOException e) {
                        throw new CmsSynchronizeException(Messages.get().container("ERR_WRITE_FILE_0"));
                    }
                    Iterator<I_CmsSynchronizeModification> i = m_synchronizeModifications.iterator();
                    while (i.hasNext()) {
                        try {
                            i.next().modifyFs(this.m_cms, vfsFile, fsFile);
                        }
                        catch (CmsSynchronizeException e) {
                            if (!LOG.isWarnEnabled()) break;
                            LOG.warn((Object)Messages.get().getBundle().key("LOG_SYNCHRONIZE_EXPORT_FAILED_1", res.getRootPath()), (Throwable)e);
                            break;
                        }
                    }
                    fsFile.setLastModified(res.getDateLastModified());
                } else {
                    this.m_report.print(Messages.get().container("RPT_EXPORT_FOLDER_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.m_cms.getSitePath(res)));
                    this.m_report.print(Messages.get().container("RPT_TO_FS_AS_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", fsFile.getAbsolutePath().replace('\\', '/')));
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    fsFile.mkdirs();
                }
                CmsSynchronizeList syncList = new CmsSynchronizeList(resourcename, this.translate(resourcename), res.getDateLastModified(), fsFile.lastModified());
                this.m_newSyncList.put(this.translate(resourcename), syncList);
                this.m_syncList.remove(this.translate(resourcename));
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
            vfsFile = null;
        }
        catch (CmsException e) {
            throw new CmsSynchronizeException(e.getMessageContainer(), (Throwable)e);
        }
    }

    private File getFileInRfs(String res) {
        String path = this.m_destinationPathInRfs + res.substring(0, res.lastIndexOf("/"));
        String fileName = res.substring(res.lastIndexOf("/") + 1);
        return new File(path, fileName);
    }

    private String getFilenameInVfs(File res) {
        String resname = res.getAbsolutePath();
        if (res.isDirectory()) {
            resname = resname + "/";
        }
        resname = resname.replace(File.separatorChar, '/');
        return resname.substring(this.m_destinationPathInRfs.length());
    }

    private void importToVfs(File fsFile, String resName, String folder) throws CmsException {
        try {
            byte[] content = CmsFileUtil.readFile(fsFile);
            String filename = this.translate(fsFile.getName());
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", String.valueOf(this.m_count++)), 3);
            if (fsFile.isFile()) {
                this.m_report.print(Messages.get().container("RPT_IMPORT_FILE_0"), 3);
            } else {
                this.m_report.print(Messages.get().container("RPT_IMPORT_FOLDER_0"), 3);
            }
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", fsFile.getAbsolutePath().replace('\\', '/')));
            this.m_report.print(Messages.get().container("RPT_FROM_FS_TO_0"), 3);
            int resType = OpenCms.getResourceManager().getDefaultTypeForName(resName).getTypeId();
            CmsResource newFile = this.m_cms.createResource(this.translate(folder) + filename, resType, content, new ArrayList<CmsProperty>());
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.m_cms.getSitePath(newFile)));
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            Iterator<I_CmsSynchronizeModification> i = m_synchronizeModifications.iterator();
            while (i.hasNext()) {
                try {
                    i.next().modifyVfs(this.m_cms, newFile, fsFile);
                }
                catch (CmsSynchronizeException e) {
                    // empty catch block
                    break;
                }
            }
            this.m_cms.setDateLastModified(this.m_cms.getSitePath(newFile), fsFile.lastModified(), false);
            CmsResource newRes = this.m_cms.readResource(this.m_cms.getSitePath(newFile));
            CmsSynchronizeList syncList = new CmsSynchronizeList(resName, this.translate(resName), newRes.getDateLastModified(), fsFile.lastModified());
            this.m_newSyncList.put(this.translate(resName), syncList);
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        }
        catch (IOException e) {
            throw new CmsSynchronizeException(Messages.get().container("ERR_READING_FILE_1", fsFile.getName()), (Throwable)e);
        }
    }

    private boolean isExcluded(File file) {
        ArrayList<Pattern> excludes = OpenCms.getWorkplaceManager().getSynchronizeExcludePatterns();
        for (Pattern pattern : excludes) {
            if (!pattern.matcher(file.getName()).find()) continue;
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", String.valueOf(this.m_count++)), 3);
            this.m_report.print(Messages.get().container("RPT_EXCLUDING_0"), 3);
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", file.getAbsolutePath().replace("\\", "/")));
            return true;
        }
        return false;
    }

    private HashMap<String, CmsSynchronizeList> readSyncList() throws CmsException {
        HashMap<String, CmsSynchronizeList> syncList = new HashMap<String, CmsSynchronizeList>();
        File syncListFile = new File(this.m_destinationPathInRfs, SYNCLIST_FILENAME);
        if (syncListFile.exists()) {
            FileReader fIn = null;
            BufferedReader lIn = null;
            try {
                fIn = new FileReader(syncListFile);
                lIn = new LineNumberReader(fIn);
                String line = ((LineNumberReader)lIn).readLine();
                while (line != null) {
                    line = ((LineNumberReader)lIn).readLine();
                    if (line == null) continue;
                    StringTokenizer tok = new StringTokenizer(line, ":");
                    String resName = tok.nextToken();
                    String tranResName = tok.nextToken();
                    long modifiedVfs = new Long(tok.nextToken());
                    long modifiedFs = new Long(tok.nextToken());
                    CmsSynchronizeList sync = new CmsSynchronizeList(resName, tranResName, modifiedVfs, modifiedFs);
                    syncList.put(this.translate(resName), sync);
                }
            }
            catch (IOException e) {
                throw new CmsSynchronizeException(Messages.get().container("ERR_READ_SYNC_LIST_0"), (Throwable)e);
            }
            finally {
                try {
                    if (lIn != null) {
                        lIn.close();
                    }
                    if (fIn != null) {
                        fIn.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return syncList;
    }

    private void removeFromRfs(String folder) throws CmsException {
        File rfsFile = new File(folder);
        File[] res = rfsFile.listFiles();
        for (int i = 0; i < res.length; ++i) {
            CmsSynchronizeList sync;
            if (this.isExcluded(res[i])) continue;
            String vfsFile = this.getFilenameInVfs(res[i]);
            if (res[i].isDirectory()) {
                this.removeFromRfs(res[i].getAbsolutePath());
            }
            if ((sync = this.m_syncList.get(this.translate(vfsFile))) == null) continue;
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", String.valueOf(this.m_count++)), 3);
            if (res[i].isFile()) {
                this.m_report.print(Messages.get().container("RPT_DEL_FS_FILE_0"), 3);
            } else {
                this.m_report.print(Messages.get().container("RPT_DEL_FS_FOLDER_0"), 3);
            }
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", res[i].getAbsolutePath().replace('\\', '/')));
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            res[i].delete();
            this.m_syncList.remove(this.translate(vfsFile));
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        }
    }

    private void skipResource(CmsResource res) {
        String resname = this.m_cms.getSitePath(res);
        CmsSynchronizeList syncList = this.m_syncList.get(this.translate(resname));
        this.m_newSyncList.put(this.translate(resname), syncList);
        this.m_syncList.remove(this.translate(resname));
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", String.valueOf(this.m_count++)), 3);
        this.m_report.print(Messages.get().container("RPT_SKIPPING_0"), 3);
        this.m_report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", resname));
    }

    private void syncVfsToRfs(String folder) throws CmsException {
        int action = 0;
        List<CmsResource> resources = this.m_cms.getResourcesInFolder(folder, CmsResourceFilter.IGNORE_EXPIRATION);
        for (int i = 0; i < resources.size(); ++i) {
            CmsResource res = resources.get(i);
            if (res.getState().isDeleted()) continue;
            if (res.isFolder()) {
                action = this.testSyncVfs(res);
                if (action == 1) {
                    this.exportToRfs(res);
                } else if (action != 3) {
                    this.skipResource(res);
                }
                this.syncVfsToRfs(this.m_cms.getSitePath(res));
                if (action == 3) {
                    this.deleteFromVfs(res);
                }
            } else {
                action = this.testSyncVfs(res);
                switch (action) {
                    case 1: {
                        this.exportToRfs(res);
                        break;
                    }
                    case 2: {
                        this.updateFromRfs(res);
                        break;
                    }
                    case 3: {
                        this.deleteFromVfs(res);
                        break;
                    }
                    default: {
                        this.skipResource(res);
                    }
                }
            }
            res = null;
        }
        resources = null;
    }

    private int testSyncVfs(CmsResource res) {
        File fsFile;
        int action = 0;
        String resourcename = this.m_cms.getSitePath(res);
        if (this.m_syncList.containsKey(this.translate(resourcename))) {
            CmsSynchronizeList sync = this.m_syncList.get(this.translate(resourcename));
            fsFile = this.getFileInRfs(sync.getResName());
            if (res.getDateLastModified() > sync.getModifiedVfs()) {
                action = fsFile.lastModified() > sync.getModifiedFs() && fsFile.lastModified() > res.getDateLastModified() ? 2 : 1;
            } else if (!fsFile.exists()) {
                action = 3;
            } else if (fsFile.lastModified() > sync.getModifiedFs()) {
                action = 2;
            }
        } else {
            action = 1;
        }
        fsFile = null;
        return action;
    }

    private String translate(String name) {
        String translation = null;
        Iterator<I_CmsSynchronizeModification> i = m_synchronizeModifications.iterator();
        while (i.hasNext()) {
            try {
                translation = i.next().translate(this.m_cms, name);
            }
            catch (CmsSynchronizeException e) {
                if (!LOG.isInfoEnabled()) break;
                LOG.info((Object)Messages.get().getBundle().key("LOG_EXTERNAL_TRANSLATION_1", name), (Throwable)e);
                break;
            }
        }
        if (translation == null) {
            translation = this.m_cms.getRequestContext().getFileTranslator().translateResource(name);
        }
        return translation;
    }

    private void updateFromRfs(CmsResource res) throws CmsSynchronizeException, CmsException {
        String resourcename = this.m_cms.getSitePath(res);
        CmsSynchronizeList sync = this.m_syncList.get(this.translate(resourcename));
        File fsFile = this.getFileInRfs(sync.getResName());
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", String.valueOf(this.m_count++)), 3);
        this.m_report.print(Messages.get().container("RPT_UPDATE_FILE_0"), 3);
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", resourcename));
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
        this.m_cms.lockResource(resourcename);
        CmsFile vfsFile = this.m_cms.readFile(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        try {
            vfsFile.setContents(CmsFileUtil.readFile(fsFile));
        }
        catch (IOException e) {
            throw new CmsSynchronizeException(Messages.get().container("ERR_IMPORT_1", fsFile.getName()));
        }
        this.m_cms.writeFile(vfsFile);
        Iterator<I_CmsSynchronizeModification> i = m_synchronizeModifications.iterator();
        while (i.hasNext()) {
            try {
                i.next().modifyVfs(this.m_cms, vfsFile, fsFile);
            }
            catch (CmsSynchronizeException e) {
                if (!LOG.isInfoEnabled()) break;
                LOG.info((Object)Messages.get().getBundle().key("LOG_SYNCHRONIZE_UPDATE_FAILED_1", res.getRootPath()), (Throwable)e);
                break;
            }
        }
        this.m_cms.setDateLastModified(resourcename, fsFile.lastModified(), false);
        res = this.m_cms.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsSynchronizeList syncList = new CmsSynchronizeList(sync.getResName(), this.translate(resourcename), res.getDateLastModified(), fsFile.lastModified());
        this.m_newSyncList.put(this.translate(resourcename), syncList);
        this.m_syncList.remove(this.translate(resourcename));
        vfsFile = null;
        this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
    }

    private void writeFileByte(byte[] content, File file) throws IOException {
        FileOutputStream fOut = null;
        DataOutputStream dOut = null;
        try {
            fOut = new FileOutputStream(file);
            dOut = new DataOutputStream(fOut);
            dOut.write(content);
            dOut.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (fOut != null) {
                    fOut.close();
                }
            }
            catch (IOException e) {}
            try {
                if (dOut != null) {
                    dOut.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void writeSyncList() throws CmsException {
        File syncListFile = new File(this.m_destinationPathInRfs, SYNCLIST_FILENAME);
        FileOutputStream fOut = null;
        PrintWriter pOut = null;
        try {
            fOut = new FileOutputStream(syncListFile);
            pOut = new PrintWriter(fOut);
            pOut.println(CmsSynchronizeList.getFormatDescription());
            for (CmsSynchronizeList sync : this.m_newSyncList.values()) {
                pOut.println(sync.toString());
            }
        }
        catch (IOException e) {
            throw new CmsDbIoException(Messages.get().container("ERR_IO_WRITE_SYNCLIST_0"), (Throwable)e);
        }
        finally {
            try {
                if (pOut != null) {
                    pOut.flush();
                    pOut.close();
                }
                if (fOut != null) {
                    fOut.flush();
                    fOut.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

