/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class CmsManyToOneMap<K, V> {
    private Map<K, V> m_forwardMap = Maps.newHashMap();
    private HashMultimap<V, K> m_reverseMap = HashMultimap.create();

    public CmsManyToOneMap() {
    }

    public CmsManyToOneMap(CmsManyToOneMap<K, V> other) {
        for (Map.Entry<K, V> entry : other.getForwardMap().entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public V get(K key) {
        return this.m_forwardMap.get(key);
    }

    public void put(K key, V value) {
        this.m_forwardMap.put(key, value);
        this.m_reverseMap.put(value, key);
    }

    public void remove(K key) {
        V removedValue = this.m_forwardMap.remove(key);
        if (removedValue != null) {
            this.m_reverseMap.remove(removedValue, key);
        }
    }

    public void removeValue(V value) {
        Set keys = this.m_reverseMap.removeAll(value);
        for (Object key : keys) {
            this.m_forwardMap.remove(key);
        }
    }

    Map<K, V> getForwardMap() {
        return Collections.unmodifiableMap(this.m_forwardMap);
    }

    Multimap<V, K> getReverseMap() {
        return Multimaps.unmodifiableSetMultimap(this.m_reverseMap);
    }
}

