/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.db.CmsExportPoint;
import org.opencms.db.CmsUserSettings;
import org.opencms.db.mssql.CmsUserDriver;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeFolderExtended;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsAcceptLanguageHeaderParser;
import org.opencms.i18n.CmsI18nInfo;
import org.opencms.i18n.CmsLocaleComparator;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.I_CmsLocaleHandler;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleManager;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsRfsFileViewer;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsRepositoryFolderHandler;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceCustomFoot;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.CmsWorkplaceUserInfoManager;
import org.opencms.workplace.CmsWorkplaceView;
import org.opencms.workplace.I_CmsDialogHandler;
import org.opencms.workplace.I_CmsGroupNameTranslation;
import org.opencms.workplace.I_CmsPostUploadDialogHandler;
import org.opencms.workplace.I_CmsRepositoryFolderHandler;
import org.opencms.workplace.Messages;
import org.opencms.workplace.editors.CmsEditorDisplayOptions;
import org.opencms.workplace.editors.CmsEditorHandler;
import org.opencms.workplace.editors.CmsWorkplaceEditorManager;
import org.opencms.workplace.editors.I_CmsEditorActionHandler;
import org.opencms.workplace.editors.I_CmsEditorCssHandler;
import org.opencms.workplace.editors.I_CmsEditorHandler;
import org.opencms.workplace.editors.I_CmsPreEditorActionDefinition;
import org.opencms.workplace.editors.directedit.CmsDirectEditDefaultProvider;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;
import org.opencms.workplace.explorer.CmsExplorerContextMenu;
import org.opencms.workplace.explorer.CmsExplorerTypeAccess;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.menu.CmsMenuRule;
import org.opencms.workplace.galleries.A_CmsAjaxGallery;
import org.opencms.workplace.tools.CmsToolManager;

public final class CmsWorkplaceManager
implements I_CmsLocaleHandler,
I_CmsEventListener {
    public static final String DEFAULT_WORKPLACE_ENCODING = "UTF-8";
    public static final String PARAM_LOGIN_REQUESTED_RESOURCE = "requestedResource";
    public static final String SESSION_WORKPLACE_SETTINGS = "__CmsWorkplace.WORKPLACE_SETTINGS";
    private static final Log LOG = CmsLog.getLog(CmsWorkplaceManager.class);
    private String m_acaciaUnlock;
    private CmsObject m_adminCms;
    private boolean m_autoLockResources;
    private String m_categoryFolder;
    private CmsWorkplaceCustomFoot m_customFoot;
    private CmsExplorerTypeAccess m_defaultAccess;
    private Locale m_defaultLocale;
    private boolean m_defaultPropertiesOnStructure;
    private CmsDefaultUserSettings m_defaultUserSettings;
    private Map<String, I_CmsDialogHandler> m_dialogHandler;
    private I_CmsDirectEditProvider m_directEditProvider;
    private I_CmsEditorActionHandler m_editorAction;
    private List<I_CmsEditorCssHandler> m_editorCssHandlers;
    private CmsEditorDisplayOptions m_editorDisplayOptions;
    private I_CmsEditorHandler m_editorHandler;
    private CmsWorkplaceEditorManager m_editorManager;
    private boolean m_enableAdvancedPropertyTabs;
    private String m_encoding;
    private List<CmsExplorerTypeSettings> m_explorerTypeSettings;
    private List<CmsExplorerTypeSettings> m_explorerTypeSettingsFromModules;
    private List<CmsExplorerTypeSettings> m_explorerTypeSettingsFromXml;
    private Map<String, CmsExplorerTypeSettings> m_explorerTypeSettingsMap;
    private Set<CmsExportPoint> m_exportPoints;
    private int m_fileMaxUploadSize;
    private CmsRfsFileViewer m_fileViewSettings;
    private Map<String, A_CmsAjaxGallery> m_galleries;
    private String m_galleryDefaultScope;
    private I_CmsGroupNameTranslation m_groupNameTranslation;
    private String m_groupTranslationClass;
    private Boolean m_keepAlive;
    private List<String> m_labelSiteFolders;
    private List<Locale> m_locales;
    private List<String> m_localizedFolders;
    private List<CmsMenuRule> m_menuRules;
    private Map<String, CmsMenuRule> m_menuRulesMap;
    private Map<Locale, CmsWorkplaceMessages> m_messages;
    private CmsExplorerContextMenu m_multiContextMenu;
    private List<I_CmsPreEditorActionDefinition> m_preEditorConditionDefinitions;
    private I_CmsRepositoryFolderHandler m_repositoryFolderHandler;
    private boolean m_showUserGroupIcon;
    private ArrayList<Pattern> m_synchronizeExcludePatterns;
    private CmsProject m_tempFileProject;
    private CmsToolManager m_toolManager;
    private CmsWorkplaceUserInfoManager m_userInfoManager;
    private String m_userListMode;
    private List<CmsWorkplaceView> m_views;
    private boolean m_xmlContentAutoCorrect;

    public CmsWorkplaceManager() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_INITIALIZE_START_0"));
        }
        this.m_locales = new ArrayList<Locale>();
        this.m_labelSiteFolders = new ArrayList<String>();
        this.m_localizedFolders = new ArrayList<String>();
        this.m_autoLockResources = true;
        this.m_categoryFolder = "/.categories/";
        this.m_xmlContentAutoCorrect = true;
        this.m_showUserGroupIcon = true;
        this.m_dialogHandler = new HashMap<String, I_CmsDialogHandler>();
        this.m_views = new ArrayList<CmsWorkplaceView>();
        this.m_exportPoints = new HashSet<CmsExportPoint>();
        this.m_editorHandler = new CmsEditorHandler();
        this.m_fileMaxUploadSize = -1;
        this.m_fileViewSettings = new CmsRfsFileViewer();
        this.m_explorerTypeSettingsFromXml = new ArrayList<CmsExplorerTypeSettings>();
        this.m_explorerTypeSettingsFromModules = new ArrayList<CmsExplorerTypeSettings>();
        this.m_defaultPropertiesOnStructure = true;
        this.m_enableAdvancedPropertyTabs = true;
        this.m_defaultUserSettings = new CmsDefaultUserSettings();
        this.m_defaultAccess = new CmsExplorerTypeAccess();
        this.m_galleries = new HashMap<String, A_CmsAjaxGallery>();
        this.m_menuRules = new ArrayList<CmsMenuRule>();
        this.m_menuRulesMap = new HashMap<String, CmsMenuRule>();
        this.flushMessageCache();
        this.m_multiContextMenu = new CmsExplorerContextMenu();
        this.m_multiContextMenu.setMultiMenu(true);
        this.m_preEditorConditionDefinitions = new ArrayList<I_CmsPreEditorActionDefinition>();
        this.m_editorCssHandlers = new ArrayList<I_CmsEditorCssHandler>();
        this.m_customFoot = new CmsWorkplaceCustomFoot();
        this.m_synchronizeExcludePatterns = new ArrayList();
        this.m_explorerTypeSettings = null;
    }

    public static boolean isWorkplaceUser(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            return null != session.getAttribute(SESSION_WORKPLACE_SETTINGS);
        }
        return false;
    }

    public void addDialogHandler(I_CmsDialogHandler clazz) {
        this.m_dialogHandler.put(clazz.getDialogHandler(), clazz);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_DIALOG_HANDLER_2", clazz.getDialogHandler(), clazz.getClass().getName()));
        }
    }

    public void addEditorCssHandler(String editorCssHandlerClassName) {
        try {
            I_CmsEditorCssHandler editorCssHandler = (I_CmsEditorCssHandler)Class.forName(editorCssHandlerClassName).newInstance();
            this.m_editorCssHandlers.add(editorCssHandler);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EDITOR_CSSHANDLER_CLASS_1", editorCssHandlerClassName));
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_EDITOR_CSSHANDLER_1", editorCssHandlerClassName), (Throwable)e);
        }
    }

    public void addEditorCssHandlerToHead(String editorCssHandlerClassName) {
        try {
            I_CmsEditorCssHandler editorCssHandler = (I_CmsEditorCssHandler)Class.forName(editorCssHandlerClassName).newInstance();
            ArrayList<I_CmsEditorCssHandler> editorCssHandlers = new ArrayList<I_CmsEditorCssHandler>();
            editorCssHandlers.add(editorCssHandler);
            editorCssHandlers.addAll(this.m_editorCssHandlers);
            this.m_editorCssHandlers = editorCssHandlers;
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EDITOR_CSSHANDLER_CLASS_1", editorCssHandlerClassName));
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_EDITOR_CSSHANDLER_1", editorCssHandlerClassName), (Throwable)e);
        }
    }

    public void addExplorerTypeSetting(CmsExplorerTypeSettings settings) {
        this.m_explorerTypeSettingsFromXml.add(settings);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_TYPE_SETTING_1", settings.getName()));
        }
        if (this.m_explorerTypeSettings != null) {
            this.initExplorerTypeSettings();
        }
    }

    public void addExplorerTypeSettings(CmsModule module) {
        List<CmsExplorerTypeSettings> explorerTypes = module.getExplorerTypes();
        if (explorerTypes != null && explorerTypes.size() > 0) {
            for (CmsExplorerTypeSettings settings : explorerTypes) {
                if (this.m_explorerTypeSettingsFromModules.contains(settings)) {
                    this.m_explorerTypeSettingsFromModules.remove(settings);
                }
                this.m_explorerTypeSettingsFromModules.add(settings);
                if (!CmsLog.INIT.isInfoEnabled()) continue;
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_TYPE_SETTING_1", settings.getName()));
            }
            this.initExplorerTypeSettings();
        }
    }

    public void addExportPoint(String uri, String destination) {
        CmsExportPoint point = new CmsExportPoint(uri, destination);
        this.m_exportPoints.add(point);
        if (CmsLog.INIT.isInfoEnabled() && point.getDestinationPath() != null) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_EXPORT_POINT_2", point.getUri(), point.getDestinationPath()));
        }
    }

    public void addLabeledFolder(String uri) {
        this.m_labelSiteFolders.add(uri);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LABEL_LINKS_IN_FOLDER_1", uri));
        }
    }

    public void addLocalizedFolder(String uri) {
        this.m_localizedFolders.add(uri);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_LOCALIZED_1", uri));
        }
    }

    public void addMenuRule(CmsMenuRule menuRule) {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_MENURULE_1", menuRule.getName()));
        }
        this.m_menuRules.add(menuRule);
    }

    public void addPreEditorConditionDefinition(I_CmsPreEditorActionDefinition preEditorCondition) {
        this.m_preEditorConditionDefinitions.add(preEditorCondition);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EDITOR_PRE_ACTION_2", preEditorCondition.getClass().getName(), preEditorCondition.getResourceTypeName()));
        }
    }

    public void addPreEditorConditionDefinition(String resourceTypeName, String preEditorConditionDefinitionClassName) {
        try {
            I_CmsPreEditorActionDefinition preEditorCondition = (I_CmsPreEditorActionDefinition)Class.forName(preEditorConditionDefinitionClassName).newInstance();
            preEditorCondition.setResourceTypeName(resourceTypeName);
            this.m_preEditorConditionDefinitions.add(preEditorCondition);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EDITOR_PRE_ACTION_2", preEditorConditionDefinitionClassName, resourceTypeName));
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_EDITOR_PRE_ACTION_1", preEditorConditionDefinitionClassName), (Throwable)e);
        }
    }

    public void addSynchronizeExcludePattern(String pattern) {
        try {
            this.m_synchronizeExcludePatterns.add(Pattern.compile(pattern));
        }
        catch (PatternSyntaxException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_SYNCHRONIZE_EXCLUDE_PATTERN_1", pattern), (Throwable)e);
        }
    }

    public boolean autoLockResources() {
        return this.m_autoLockResources;
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 5: {
                this.flushMessageCache();
                this.m_editorDisplayOptions.clearCache();
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_CLEAR_CACHES_0"));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String createTempFile(CmsObject cms, String resourceName, CmsUUID currentProjectId) throws CmsException {
        String temporaryFilename;
        if (!cms.hasPermissions(cms.readResource(resourceName, CmsResourceFilter.ALL), CmsPermissionSet.ACCESS_WRITE)) {
            throw new CmsPermissionViolationException(org.opencms.db.Messages.get().container("ERR_PERM_DENIED_2", resourceName, "w"));
        }
        CmsObject adminCms = this.getAdminCms(cms);
        if (adminCms.existsResource(temporaryFilename = CmsWorkplace.getTemporaryFileName(resourceName), CmsResourceFilter.ALL)) {
            if (!cms.getLock(temporaryFilename).isUnlocked()) {
                cms.changeLock(temporaryFilename);
            } else {
                cms.lockResource(temporaryFilename);
            }
            cms.deleteResource(temporaryFilename, CmsResource.DELETE_PRESERVE_SIBLINGS);
        }
        try {
            adminCms.getRequestContext().setCurrentProject(cms.readProject(this.getTempFileProjectId()));
            adminCms.copyResource(resourceName, temporaryFilename, CmsResource.COPY_AS_NEW);
        }
        finally {
            adminCms.getRequestContext().setCurrentProject(cms.readProject(currentProjectId));
        }
        try {
            cms.getRequestContext().setCurrentProject(cms.readProject(OpenCms.getWorkplaceManager().getTempFileProjectId()));
            cms.changeLock(temporaryFilename);
            cms.setDateLastModified(temporaryFilename, System.currentTimeMillis(), false);
            CmsResource tempFile = cms.readResource(temporaryFilename, CmsResourceFilter.ALL);
            int flags = tempFile.getFlags();
            if ((flags & 0x400) == 0) {
                flags += 1024;
            }
            cms.chflags(temporaryFilename, flags);
            cms.setDateReleased(temporaryFilename, 0L, false);
            cms.setDateExpired(temporaryFilename, Long.MAX_VALUE, false);
            if (cms.hasPermissions(tempFile, CmsPermissionSet.ACCESS_CONTROL)) {
                cms.chacc(temporaryFilename, "GROUP", OpenCms.getDefaultUsers().getGroupUsers(), "-v");
            }
        }
        finally {
            cms.getRequestContext().setCurrentProject(cms.readProject(currentProjectId));
        }
        return temporaryFilename;
    }

    public void flushMessageCache() {
        this.m_messages = new HashMap<Locale, CmsWorkplaceMessages>();
    }

    public String getAcaciaUnlock() {
        return this.m_acaciaUnlock;
    }

    public String getCategoryFolder() {
        return this.m_categoryFolder;
    }

    public CmsWorkplaceCustomFoot getCustomFoot() {
        return this.m_customFoot;
    }

    public CmsExplorerTypeAccess getDefaultAccess() {
        return this.m_defaultAccess;
    }

    public Locale getDefaultLocale() {
        return this.m_defaultLocale;
    }

    public CmsDefaultUserSettings getDefaultUserSettings() {
        return this.m_defaultUserSettings;
    }

    public Map<String, I_CmsDialogHandler> getDialogHandler() {
        return this.m_dialogHandler;
    }

    public I_CmsDialogHandler getDialogHandler(String key) {
        return this.m_dialogHandler.get(key);
    }

    public I_CmsDirectEditProvider getDirectEditProvider() {
        return this.m_directEditProvider.newInstance();
    }

    public I_CmsEditorActionHandler getEditorActionHandler() {
        return this.m_editorAction;
    }

    public List<I_CmsEditorCssHandler> getEditorCssHandlers() {
        return this.m_editorCssHandlers;
    }

    public CmsEditorDisplayOptions getEditorDisplayOptions() {
        return this.m_editorDisplayOptions;
    }

    public I_CmsEditorHandler getEditorHandler() {
        return this.m_editorHandler;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public CmsExplorerTypeSettings getExplorerTypeSetting(String type) {
        return this.m_explorerTypeSettingsMap.get(type);
    }

    public List<CmsExplorerTypeSettings> getExplorerTypeSettings() {
        if (this.m_explorerTypeSettings == null) {
            this.initExplorerTypeSettings();
        }
        return this.m_explorerTypeSettings;
    }

    public Set<CmsExportPoint> getExportPoints() {
        return this.m_exportPoints;
    }

    public long getFileBytesMaxUploadSize(CmsObject cms) {
        int maxFileSize = this.getFileMaxUploadSize();
        long maxFileSizeBytes = maxFileSize * 1024;
        if (maxFileSize <= 0 || OpenCms.getRoleManager().hasRole(cms, CmsRole.VFS_MANAGER)) {
            maxFileSizeBytes = -1L;
        }
        return maxFileSizeBytes;
    }

    public int getFileMaxUploadSize() {
        return this.m_fileMaxUploadSize;
    }

    public CmsRfsFileViewer getFileViewSettings() {
        return this.m_fileViewSettings;
    }

    public Map<String, A_CmsAjaxGallery> getGalleries() {
        return this.m_galleries;
    }

    public CmsGallerySearchScope getGalleryDefaultScope() {
        CmsGallerySearchScope result = CmsGallerySearchScope.siteShared;
        if (this.m_galleryDefaultScope != null) {
            try {
                result = CmsGallerySearchScope.valueOf(this.m_galleryDefaultScope);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public String getGalleryDefaultScopeString() {
        return this.m_galleryDefaultScope;
    }

    public I_CmsGroupNameTranslation getGroupNameTranslation() {
        if (this.m_groupNameTranslation != null) {
            return this.m_groupNameTranslation;
        }
        if (this.m_groupTranslationClass != null) {
            try {
                this.m_groupNameTranslation = (I_CmsGroupNameTranslation)Class.forName(this.m_groupTranslationClass).newInstance();
                return this.m_groupNameTranslation;
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (ClassCastException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            this.m_groupNameTranslation = this.getDefaultGroupNameTranslation();
            return this.m_groupNameTranslation;
        }
        this.m_groupNameTranslation = this.getDefaultGroupNameTranslation();
        return this.m_groupNameTranslation;
    }

    public String getGroupTranslationClass() {
        return this.m_groupTranslationClass;
    }

    @Override
    public CmsI18nInfo getI18nInfo(HttpServletRequest req, CmsUser user, CmsProject project, String resource) {
        Locale locale = null;
        if (req != null) {
            CmsWorkplaceSettings settings;
            try {
                req.setCharacterEncoding(this.m_encoding);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_UNSUPPORTED_ENCODING_SET_1", this.m_encoding), (Throwable)e);
            }
            HttpSession session = req.getSession(false);
            if (session != null && (settings = (CmsWorkplaceSettings)session.getAttribute(SESSION_WORKPLACE_SETTINGS)) != null) {
                locale = settings.getUserSettings().getLocale();
            }
        }
        if (locale == null) {
            if (!user.isGuestUser()) {
                CmsUserSettings settings = new CmsUserSettings(user);
                locale = settings.getLocale();
            }
            if (req != null) {
                List<Locale> acceptedLocales = new CmsAcceptLanguageHeaderParser(req, this.getDefaultLocale()).getAcceptedLocales();
                if (locale != null && !acceptedLocales.contains(locale)) {
                    acceptedLocales.add(0, locale);
                }
                locale = OpenCms.getLocaleManager().getFirstMatchingLocale(acceptedLocales, this.m_locales);
            }
            if (locale == null) {
                locale = this.getDefaultLocale();
            }
        }
        return new CmsI18nInfo(locale, this.m_encoding);
    }

    public List<String> getLabelSiteFolders() {
        return this.m_labelSiteFolders;
    }

    public List<Locale> getLocales() {
        return this.m_locales;
    }

    public List<String> getLocalizedFolders() {
        return this.m_localizedFolders;
    }

    public CmsMenuRule getMenuRule(String ruleName) {
        return this.m_menuRulesMap.get(ruleName);
    }

    public List<CmsMenuRule> getMenuRules() {
        return this.m_menuRules;
    }

    public Map<String, CmsMenuRule> getMenuRulesMap() {
        return this.m_menuRulesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsWorkplaceMessages getMessages(Locale locale) {
        CmsWorkplaceMessages result = this.m_messages.get(locale);
        if (result != null) {
            return result;
        }
        CmsWorkplaceManager cmsWorkplaceManager = this;
        synchronized (cmsWorkplaceManager) {
            result = new CmsWorkplaceMessages(locale);
            this.m_messages.put(locale, result);
        }
        return result;
    }

    public CmsExplorerContextMenu getMultiContextMenu() {
        return this.m_multiContextMenu;
    }

    public I_CmsPreEditorActionDefinition getPreEditorConditionDefinition(I_CmsResourceType resourceType) {
        Iterator<I_CmsPreEditorActionDefinition> i = this.m_preEditorConditionDefinitions.iterator();
        I_CmsPreEditorActionDefinition result = null;
        int matchResult = -1;
        while (i.hasNext()) {
            I_CmsPreEditorActionDefinition currentDefinition = i.next();
            if (!resourceType.getClass().isInstance(currentDefinition.getResourceType())) continue;
            int matchDistance = 0;
            for (Class<?> superClass = resourceType.getClass(); superClass != null && !superClass.getName().equals(currentDefinition.getResourceType().getClass().getName()); superClass = superClass.getSuperclass()) {
                ++matchDistance;
            }
            if (matchResult != -1) {
                if (matchDistance >= matchResult) continue;
                matchResult = matchDistance;
                result = currentDefinition;
                continue;
            }
            matchResult = matchDistance;
            result = currentDefinition;
        }
        return result;
    }

    public List<I_CmsPreEditorActionDefinition> getPreEditorConditionDefinitions() {
        return this.m_preEditorConditionDefinitions;
    }

    public I_CmsRepositoryFolderHandler getRepositoryFolderHandler() {
        if (this.m_repositoryFolderHandler == null) {
            this.m_repositoryFolderHandler = new CmsRepositoryFolderHandler();
        }
        return this.m_repositoryFolderHandler;
    }

    public ArrayList<Pattern> getSynchronizeExcludePatterns() {
        return this.m_synchronizeExcludePatterns;
    }

    public CmsUUID getTempFileProjectId() {
        if (this.m_tempFileProject != null) {
            return this.m_tempFileProject.getUuid();
        }
        return null;
    }

    public CmsToolManager getToolManager() {
        if (this.m_toolManager == null) {
            this.m_toolManager = new CmsToolManager();
        }
        return this.m_toolManager;
    }

    public String getUploadHook(CmsObject cms, String uploadFolder) {
        I_CmsDialogHandler handler = this.getDialogHandler("class_dialog_property");
        if (handler != null && handler instanceof I_CmsPostUploadDialogHandler) {
            return ((I_CmsPostUploadDialogHandler)((Object)handler)).getUploadHook(cms, uploadFolder);
        }
        return null;
    }

    public CmsWorkplaceUserInfoManager getUserInfoManager() {
        return this.m_userInfoManager;
    }

    public String getUserListModeString() {
        return this.m_userListMode;
    }

    public List<CmsWorkplaceView> getViews() {
        return this.m_views;
    }

    public CmsWorkplaceEditorManager getWorkplaceEditorManager() {
        return this.m_editorManager;
    }

    public Locale getWorkplaceLocale(CmsObject cms) {
        Locale wpLocale = new CmsUserSettings(cms.getRequestContext().getCurrentUser()).getLocale();
        if (wpLocale == null && (wpLocale = this.getDefaultLocale()) == null) {
            wpLocale = cms.getRequestContext().getLocale();
        }
        return wpLocale;
    }

    @Override
    public void initHandler(CmsObject cms) {
        this.m_locales = this.initWorkplaceLocales(cms);
    }

    public synchronized void initialize(CmsObject cms) throws CmsException, CmsRoleViolationException {
        try {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.WORKPLACE_MANAGER);
            try {
                CmsResource wpFolderRes = cms.readResource("/system/workplace/");
                this.m_encoding = CmsLocaleManager.getResourceEncoding(cms, wpFolderRes);
            }
            catch (CmsVfsResourceNotFoundException e) {
                this.m_encoding = OpenCms.getSystemInfo().getDefaultEncoding();
            }
            if (this.m_directEditProvider == null) {
                this.m_directEditProvider = new CmsDirectEditDefaultProvider();
            }
            this.m_explorerTypeSettingsFromModules.clear();
            CmsModuleManager moduleManager = OpenCms.getModuleManager();
            Iterator<String> moduleNameIterator = moduleManager.getModuleNames().iterator();
            while (moduleNameIterator.hasNext()) {
                CmsModule module = moduleManager.getModule(moduleNameIterator.next());
                if (module == null) continue;
                this.addExplorerTypeSettings(module);
            }
            this.initMenuRules();
            this.initExplorerTypeSettings();
            this.initWorkplaceViews(cms);
            this.m_editorManager = new CmsWorkplaceEditorManager(cms);
            this.initHandler(cms);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_ACCESS_INITIALIZED_0"));
            }
            try {
                this.m_tempFileProject = cms.readProject("tempFileProject");
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_NO_TEMP_FILE_PROJECT_0"));
            }
            this.m_editorDisplayOptions = new CmsEditorDisplayOptions();
            this.m_galleries.clear();
            for (I_CmsResourceType resourceType : OpenCms.getResourceManager().getResourceTypes()) {
                CmsResourceTypeFolderExtended galleryType;
                String folderClassName;
                if (!(resourceType instanceof CmsResourceTypeFolderExtended) || !CmsStringUtil.isNotEmpty(folderClassName = (galleryType = (CmsResourceTypeFolderExtended)resourceType).getFolderClassName())) continue;
                try {
                    if (!A_CmsAjaxGallery.class.isAssignableFrom(Class.forName(folderClassName))) continue;
                    A_CmsAjaxGallery galleryInstance = (A_CmsAjaxGallery)Class.forName(folderClassName).newInstance();
                    galleryInstance.setResourceType(galleryType);
                    this.m_galleries.put(galleryType.getTypeName(), galleryInstance);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)e.getLocalizedMessage());
                }
                catch (InstantiationException e) {
                    LOG.error((Object)e.getLocalizedMessage());
                }
                catch (IllegalAccessException e) {
                    LOG.error((Object)e.getLocalizedMessage());
                }
            }
            this.getDefaultUserSettings().initPreferences(this);
            this.getToolManager().configure(cms);
            this.flushMessageCache();
            OpenCms.addCmsEventListener(this, new int[]{5});
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw new CmsException(Messages.get().container("ERR_INITIALIZE_WORKPLACE_0"));
        }
        this.m_adminCms = cms;
    }

    public boolean isDefaultPropertiesOnStructure() {
        return this.m_defaultPropertiesOnStructure;
    }

    public boolean isEnableAdvancedPropertyTabs() {
        return this.m_enableAdvancedPropertyTabs;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive(true);
    }

    public Boolean isKeepAlive(boolean useDefault) {
        if (this.m_keepAlive != null) {
            return this.m_keepAlive;
        }
        if (useDefault) {
            return Boolean.TRUE;
        }
        return null;
    }

    public boolean isXmlContentAutoCorrect() {
        return this.m_xmlContentAutoCorrect;
    }

    public boolean lazyUserListsEnabled() {
        return true;
    }

    public void removeExplorerTypeSettings(CmsModule module) {
        List<CmsExplorerTypeSettings> explorerTypes = module.getExplorerTypes();
        if (explorerTypes != null && explorerTypes.size() > 0) {
            for (CmsExplorerTypeSettings settings : explorerTypes) {
                if (!this.m_explorerTypeSettingsFromModules.contains(settings)) continue;
                this.m_explorerTypeSettingsFromModules.remove(settings);
                if (!CmsLog.INIT.isInfoEnabled()) continue;
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_REMOVE_EXPLORER_TYPE_SETTING_1", settings.getName()));
            }
            this.initExplorerTypeSettings();
        }
    }

    public void setAcaciaUnlock(String value) {
        this.m_acaciaUnlock = value;
    }

    public void setAutoLock(String value) {
        this.m_autoLockResources = Boolean.valueOf(value);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key(this.m_autoLockResources ? "INIT_AUTO_LOCK_ENABLED_0" : "INIT_AUTO_LOCK_DISABLED_0"));
        }
    }

    public void setCategoryFolder(String categoryFolder) {
        this.m_categoryFolder = categoryFolder;
    }

    public void setCustomFoot(CmsWorkplaceCustomFoot footCustom) {
        this.m_customFoot = footCustom;
    }

    public void setDefaultAccess(CmsExplorerTypeAccess access) {
        this.m_defaultAccess = access;
    }

    public void setDefaultLocale(String locale) {
        block3: {
            try {
                this.m_defaultLocale = CmsLocaleManager.getLocale(locale);
            }
            catch (Exception e) {
                if (!CmsLog.INIT.isWarnEnabled()) break block3;
                CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_NONCRIT_ERROR_0"), (Throwable)e);
            }
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DEFAULT_LOCALE_1", this.m_defaultLocale));
        }
    }

    public void setDefaultPropertiesOnStructure(String defaultPropertiesOnStructure) {
        this.m_defaultPropertiesOnStructure = Boolean.valueOf(defaultPropertiesOnStructure);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key(this.m_defaultPropertiesOnStructure ? "INIT_PROP_ON_STRUCT_TRUE_0" : "INIT_PROP_ON_STRUCT_FALSE_0"));
        }
    }

    public void setDefaultUserSettings(CmsDefaultUserSettings defaultUserSettings) {
        this.m_defaultUserSettings = defaultUserSettings;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DEFAULT_USER_SETTINGS_1", this.m_defaultUserSettings.getClass().getName()));
        }
    }

    public void setDirectEditProvider(I_CmsDirectEditProvider clazz) {
        this.m_directEditProvider = clazz;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DIRECT_EDIT_PROVIDER_1", this.m_directEditProvider.getClass().getName()));
        }
    }

    public void setEditorAction(I_CmsEditorActionHandler clazz) {
        this.m_editorAction = clazz;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EDITOR_ACTION_CLASS_1", this.m_editorAction.getClass().getName()));
        }
    }

    public void setEditorDisplayOptions(CmsEditorDisplayOptions clazz) {
        this.m_editorDisplayOptions = clazz;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EDITOR_DISPLAY_OPTS_1", this.m_editorAction.getClass().getName()));
        }
    }

    public void setEditorHandler(I_CmsEditorHandler clazz) {
        this.m_editorHandler = clazz;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EDITOR_HANDLER_CLASS_1", this.m_editorHandler.getClass().getName()));
        }
    }

    public void setEnableAdvancedPropertyTabs(String enableAdvancedPropertyTabs) {
        this.m_enableAdvancedPropertyTabs = Boolean.valueOf(enableAdvancedPropertyTabs);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key(this.m_enableAdvancedPropertyTabs ? "INIT_ADV_PROP_DIALOG_SHOW_TABS_0" : "INIT_ADV_PROP_DIALOG_HIDE_TABS_0"));
        }
    }

    public void setFileMaxUploadSize(String value) {
        try {
            this.m_fileMaxUploadSize = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e.getLocalizedMessage());
            }
            this.m_fileMaxUploadSize = -1;
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            if (this.m_fileMaxUploadSize > 0) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_MAX_FILE_UPLOAD_SIZE_1", new Integer(this.m_fileMaxUploadSize)));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_MAX_FILE_UPLOAD_SIZE_UNLIMITED_0"));
            }
        }
    }

    public void setFileViewSettings(CmsObject cms, CmsRfsFileViewer fileViewSettings) throws CmsRoleViolationException {
        if (OpenCms.getRunLevel() > 2) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        }
        this.m_fileViewSettings = fileViewSettings;
        this.m_fileViewSettings.setFrozen(true);
    }

    public void setGalleryDefaultScope(String galleryDefaultScope) {
        this.m_galleryDefaultScope = galleryDefaultScope;
        try {
            CmsGallerySearchScope.valueOf(galleryDefaultScope);
        }
        catch (Throwable t) {
            LOG.warn((Object)t.getLocalizedMessage(), t);
        }
    }

    public void setGroupTranslationClass(String translationClassName) {
        this.m_groupTranslationClass = translationClassName;
    }

    public void setKeepAlive(String keepAlive) {
        this.m_keepAlive = Boolean.valueOf(keepAlive);
    }

    public void setMultiContextMenu(CmsExplorerContextMenu multiContextMenu) {
        multiContextMenu.setMultiMenu(true);
        this.m_multiContextMenu = multiContextMenu;
    }

    public void setRepositoryFolderHandler(I_CmsRepositoryFolderHandler clazz) {
        this.m_repositoryFolderHandler = clazz;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.configuration.Messages.get().getBundle().key("INIT_REPOSITORY_FOLDER_1", this.m_repositoryFolderHandler.getClass().getName()));
        }
    }

    public void setToolManager(CmsToolManager toolManager) {
        this.m_toolManager = toolManager;
    }

    public void setUserInfoManager(CmsWorkplaceUserInfoManager userInfoManager) {
        this.m_userInfoManager = userInfoManager;
    }

    public void setUserListMode(String mode) {
        this.m_userListMode = mode;
    }

    public void setUserManagementEnabled(String value) {
        this.m_showUserGroupIcon = Boolean.valueOf(value);
        if (CmsLog.INIT.isInfoEnabled()) {
            if (this.m_showUserGroupIcon) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_USER_MANAGEMENT_ICON_ENABLED_0"));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_USER_MANAGEMENT_ICON_DISABLED_0"));
            }
        }
    }

    public void setXmlContentAutoCorrect(String xmlContentAutoCorrect) {
        this.m_xmlContentAutoCorrect = Boolean.valueOf(xmlContentAutoCorrect);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key(this.m_xmlContentAutoCorrect ? "INIT_XMLCONTENT_AUTOCORRECT_ENABLED_0" : "INIT_XMLCONTENT_AUTOCORRECT_DISABLED_0"));
        }
    }

    public boolean shouldAcaciaUnlock() {
        if (this.m_acaciaUnlock == null) {
            return true;
        }
        return Boolean.parseBoolean(this.m_acaciaUnlock);
    }

    public boolean showUserGroupIcon() {
        return this.m_showUserGroupIcon;
    }

    public boolean supportsLazyUserLists() {
        boolean result = "lazy".equalsIgnoreCase(this.m_userListMode);
        if (CmsUserDriver.isInstantiated()) {
            LOG.warn((Object)"Lazy user lists currently not supported on MSSQL, using classic user list mode as a fallback.");
            result = false;
        }
        return result;
    }

    public String translateGroupName(String groupName, boolean keepOu) {
        I_CmsGroupNameTranslation translation = this.getGroupNameTranslation();
        return translation.translateGroupName(groupName, keepOu);
    }

    private CmsObject getAdminCms(CmsObject cms) throws CmsException {
        CmsObject adminCms = OpenCms.initCmsObject(this.m_adminCms);
        adminCms.getRequestContext().setSiteRoot(cms.getRequestContext().getSiteRoot());
        adminCms.getRequestContext().setRequestTime(cms.getRequestContext().getRequestTime());
        adminCms.getRequestContext().setCurrentProject(cms.getRequestContext().getCurrentProject());
        adminCms.getRequestContext().setEncoding(cms.getRequestContext().getEncoding());
        adminCms.getRequestContext().setUri(cms.getRequestContext().getUri());
        return adminCms;
    }

    private I_CmsGroupNameTranslation getDefaultGroupNameTranslation() {
        return new I_CmsGroupNameTranslation(){

            @Override
            public String translateGroupName(String group, boolean keepOu) {
                return keepOu ? group : CmsOrganizationalUnit.getSimpleName(group);
            }
        };
    }

    private synchronized void initExplorerTypeSettings() {
        ArrayList<CmsExplorerTypeSettings> explorerTypeSettings;
        HashMap<String, CmsExplorerTypeSettings> explorerTypeSettingsMap;
        block6: {
            explorerTypeSettingsMap = new HashMap<String, CmsExplorerTypeSettings>();
            explorerTypeSettings = new ArrayList<CmsExplorerTypeSettings>();
            if (this.m_defaultAccess.getAccessControlList() == null) {
                try {
                    this.m_defaultAccess.createAccessControlList("DEFAULT");
                }
                catch (CmsException e) {
                    if (!CmsLog.INIT.isInfoEnabled()) break block6;
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_TYPE_SETTING_FAILED_1", "DEFAULT"), (Throwable)e);
                }
            }
        }
        explorerTypeSettings.addAll(this.m_explorerTypeSettingsFromXml);
        explorerTypeSettings.addAll(this.m_explorerTypeSettingsFromModules);
        for (int i = 0; i < explorerTypeSettings.size(); ++i) {
            CmsExplorerTypeSettings settings = (CmsExplorerTypeSettings)explorerTypeSettings.get(i);
            explorerTypeSettingsMap.put(settings.getName(), settings);
            if (this.getDefaultAccess() == settings.getAccess()) continue;
            try {
                settings.getAccess().createAccessControlList(settings.getName());
                continue;
            }
            catch (CmsException e) {
                if (!CmsLog.INIT.isInfoEnabled()) continue;
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_TYPE_SETTING_FAILED_1", settings.getName()), (Throwable)e);
            }
        }
        Collections.sort(explorerTypeSettings);
        this.m_explorerTypeSettings = Collections.unmodifiableList(explorerTypeSettings);
        this.m_explorerTypeSettingsMap = Collections.unmodifiableMap(explorerTypeSettingsMap);
    }

    private void initMenuRules() {
        for (CmsMenuRule currentRule : this.m_menuRules) {
            currentRule.freeze();
            this.m_menuRulesMap.put(currentRule.getName(), currentRule);
        }
    }

    private List<Locale> initWorkplaceLocales(CmsObject cms) {
        List<CmsResource> localeFolders;
        HashSet<Locale> locales = new HashSet<Locale>();
        try {
            localeFolders = cms.getSubFolders("/system/workplace/locales/");
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_WORKPLACE_INIT_NO_LOCALES_1", "/system/workplace/locales/"));
            localeFolders = new ArrayList<CmsResource>();
        }
        for (CmsFolder cmsFolder : localeFolders) {
            Locale locale = CmsLocaleManager.getLocale(cmsFolder.getName());
            locales.add(locale);
            locales.add(new Locale(locale.getLanguage(), locale.getCountry()));
            locales.add(new Locale(locale.getLanguage()));
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        arrayList.addAll(locales);
        Collections.sort(arrayList, CmsLocaleComparator.getComparator());
        return arrayList;
    }

    private List<CmsWorkplaceView> initWorkplaceViews(CmsObject cms) {
        List<CmsResource> viewFolders;
        try {
            viewFolders = cms.getSubFolders("/system/workplace/views/");
        }
        catch (CmsException e) {
            if (OpenCms.getRunLevel() > 2 && LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_WORKPLACE_INIT_NO_VIEWS_1", "/system/workplace/views/"), (Throwable)e);
            }
            viewFolders = new ArrayList<CmsResource>();
        }
        this.m_views = new ArrayList<CmsWorkplaceView>(viewFolders.size());
        for (int i = 0; i < viewFolders.size(); ++i) {
            CmsFolder folder = (CmsFolder)viewFolders.get(i);
            String folderPath = cms.getSitePath(folder);
            try {
                Float orderValue;
                String order = cms.readPropertyObject(folderPath, "NavPos", false).getValue();
                String key = cms.readPropertyObject(folderPath, "NavText", false).getValue();
                String viewUri = cms.readPropertyObject(folderPath, "default-file", false).getValue();
                if (viewUri == null) {
                    viewUri = folderPath;
                } else if (!viewUri.startsWith("/")) {
                    viewUri = folderPath + viewUri;
                }
                if (order == null) {
                    order = "" + i;
                }
                try {
                    orderValue = Float.valueOf(order);
                }
                catch (NumberFormatException e) {
                    orderValue = Float.valueOf("" + i);
                }
                if (key == null) {
                    key = "View " + i;
                    continue;
                }
                CmsWorkplaceView view = new CmsWorkplaceView(key, viewUri, orderValue);
                this.m_views.add(view);
                if (!CmsLog.INIT.isInfoEnabled()) continue;
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_VIEW_1", view.getUri()));
                continue;
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_READING_VIEW_FOLDER_FAILED_1", folderPath), (Throwable)e);
            }
        }
        Collections.sort(this.m_views);
        return this.m_views;
    }
}

