/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.list.A_CmsListResourceTypeDialog;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListOrderEnum;

public class CmsChtype
extends A_CmsListResourceTypeDialog {
    public static final int ACTION_ADVANCED = 555;
    public static final String DIALOG_TYPE = "chtype";
    public static final String SESSION_ATTR_ADVANCED = "ocms_chtype_adv";
    private boolean m_advancedMode;
    private String m_availableResTypes;
    private boolean m_limitedRestypes;

    public CmsChtype(CmsJspActionElement jsp) {
        super(jsp, "nrt", Messages.get().container("GUI_CHTYPE_PLEASE_SELECT_0"), "nrcn", CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsChtype(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionChtype() throws JspException {
        int plainId;
        try {
            plainId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()).getTypeId();
        }
        catch (CmsLoaderException e) {
            plainId = CmsResourceTypePlain.getStaticTypeId();
        }
        try {
            int newType = plainId;
            try {
                newType = Integer.parseInt(this.getParamSelectedType());
            }
            catch (NumberFormatException nf) {
                throw new CmsException(Messages.get().container("ERR_GET_RESTYPE_1", this.getParamSelectedType()));
            }
            this.checkLock(this.getParamResource());
            this.getCms().chtype(this.getParamResource(), newType);
            this.actionCloseDialog();
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    @Override
    public void actionDialog() throws JspException, ServletException, IOException {
        if (this.getAction() == 3) {
            this.actionChtype();
            return;
        }
        if (this.getAction() == 555) {
            this.refreshList();
            return;
        }
        super.actionDialog();
    }

    @Override
    public String dialogButtons() {
        return this.dialogButtonsOkAdvancedCancel(" onclick=\"submitChtype(form);\"", " onclick=\"submitAdvanced(form);\"", null);
    }

    public String dialogButtonsOkAdvancedCancel(String okAttrs, String advancedAttrs, String cancelAttrs) {
        if (!this.m_advancedMode && this.m_limitedRestypes && OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.VFS_MANAGER)) {
            return this.dialogButtons(new int[]{0, 3, 1}, new String[]{okAttrs, advancedAttrs, cancelAttrs});
        }
        return this.dialogButtonsOkCancel(okAttrs, cancelAttrs);
    }

    @Override
    public String getParamSelectedType() {
        String item = super.getParamSelectedType();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(item)) {
            try {
                CmsResource res = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
                return Integer.toString(res.getTypeId());
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return item;
    }

    @Override
    protected String customHtmlBeforeList() {
        StringBuffer result = new StringBuffer(256);
        result.append(this.dialogBlockStart(null));
        result.append(this.key("GUI_LABEL_TITLE_0"));
        result.append(": ");
        result.append(this.getJsp().property("Title", this.getParamResource(), ""));
        result.append("<br>");
        result.append(this.key("GUI_LABEL_STATE_0"));
        result.append(": ");
        try {
            result.append(this.getState());
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        result.append("<br>");
        result.append(this.key("GUI_LABEL_PERMALINK_0"));
        result.append(": ");
        result.append(OpenCms.getLinkManager().getPermalink(this.getCms(), this.getParamResource()));
        result.append(this.dialogBlockEnd());
        result.append(this.dialogSpacer());
        return result.toString();
    }

    @Override
    protected String customHtmlStart() {
        StringBuffer result = new StringBuffer(256);
        result.append(super.customHtmlStart());
        result.append("<script type='text/javascript'>\n");
        result.append("function submitAdvanced(theForm) {\n");
        result.append("\ttheForm.action.value = \"advanced\";\n");
        result.append("\ttheForm.submit();\n");
        result.append("}\n\n");
        result.append("function submitChtype(theForm) {\n");
        result.append("\ttheForm.action.value = \"ok\";\n");
        result.append("\ttheForm.submit();\n");
        result.append("}\n\n");
        result.append("</script>");
        return result.toString();
    }

    @Override
    protected List<CmsListItem> getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List<Object> availableResTypes = new ArrayList();
        if (!this.m_advancedMode && this.m_limitedRestypes) {
            availableResTypes = this.m_availableResTypes.indexOf(44) > -1 ? CmsStringUtil.splitAsList(this.m_availableResTypes, ',', true) : CmsStringUtil.splitAsList(this.m_availableResTypes, '|', true);
        }
        CmsObject cms = this.getCms();
        CmsResource res = cms.readResource(this.getParamResource(), CmsResourceFilter.ALL);
        List<CmsExplorerTypeSettings> resTypes = OpenCms.getWorkplaceManager().getExplorerTypeSettings();
        boolean isFolder = res.isFolder();
        for (int i = 0; i < resTypes.size(); ++i) {
            CmsPermissionSet permissions;
            boolean isResourceType;
            boolean changeable = false;
            CmsExplorerTypeSettings settings = resTypes.get(i);
            I_CmsResourceType type = new CmsResourceTypePlain();
            try {
                type = OpenCms.getResourceManager().getResourceType(settings.getName());
                isResourceType = true;
            }
            catch (CmsLoaderException e) {
                isResourceType = false;
            }
            if (!isResourceType || !this.m_advancedMode && this.m_limitedRestypes && availableResTypes.indexOf(type.getTypeName()) == -1) continue;
            int resTypeId = OpenCms.getResourceManager().getResourceType(settings.getName()).getTypeId();
            if (isFolder && OpenCms.getResourceManager().getResourceType(resTypeId).isFolder()) {
                changeable = true;
            } else if (!isFolder && !OpenCms.getResourceManager().getResourceType(resTypeId).isFolder()) {
                changeable = true;
            }
            if (!changeable || !(permissions = settings.getAccess().getPermissions(cms, res)).requiresWritePermission() || !permissions.requiresControlPermission()) continue;
            CmsListItem item = this.getList().newItem(Integer.toString(resTypeId));
            item.set("nrcn", this.key(settings.getKey()));
            item.set("nrci", "<img src=\"" + CmsChtype.getSkinUri() + "filetypes/" + settings.getIcon() + "\" style=\"width: 16px; height: 16px;\" />");
            ret.add(item);
        }
        return ret;
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setAction(0);
        super.initWorkplaceRequestValues(settings, request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
            this.getJsp().getRequest().getSession(true).removeAttribute(SESSION_ATTR_ADVANCED);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
            this.getJsp().getRequest().getSession(true).removeAttribute(SESSION_ATTR_ADVANCED);
        } else {
            this.setParamTitle(this.key("GUI_CHTYPE_1", new Object[]{CmsResource.getName(this.getParamResource())}));
        }
        String sessionAttr = (String)request.getSession(true).getAttribute(SESSION_ATTR_ADVANCED);
        if ("advanced".equals(this.getParamAction()) || sessionAttr != null) {
            if (sessionAttr == null) {
                request.getSession(true).setAttribute(SESSION_ATTR_ADVANCED, (Object)"true");
                this.setAction(555);
            }
            this.m_advancedMode = true;
        } else {
            String newResTypesProperty = "";
            try {
                newResTypesProperty = this.getCms().readPropertyObject(this.getParamResource(), "restypes.available", true).getValue();
            }
            catch (CmsException e) {
                // empty catch block
            }
            if (CmsStringUtil.isNotEmpty(newResTypesProperty) && !newResTypesProperty.equals("default")) {
                this.m_limitedRestypes = true;
                this.m_availableResTypes = newResTypesProperty;
            }
        }
    }
}

