/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryProject;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemActionIconComparator;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListItemSelectionAction;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListRadioMultiAction;
import org.opencms.workplace.list.CmsListResourceIconAction;
import org.opencms.workplace.list.I_CmsListFormatter;

public class CmsHistoryList
extends A_CmsListDialog {
    public static final String GUI_LIST_HISTORY_DETAIL_PROJECT_0 = "lhdp";
    public static final String LIST_ACTION_RESTORE = "ar";
    public static final String LIST_ACTION_VIEW = "av";
    public static final String LIST_COLUMN_DATE_LAST_MODIFIED = "cm";
    public static final String LIST_COLUMN_DATE_PUBLISHED = "cdp";
    public static final String LIST_COLUMN_FILE_TYPE = "ct";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_PUBLISH_TAG = "cbt";
    public static final String LIST_COLUMN_RESOURCE_PATH = "crp";
    public static final String LIST_COLUMN_RESTORE = "cr";
    public static final String LIST_COLUMN_SEL1 = "cs1";
    public static final String LIST_COLUMN_SEL2 = "cs2";
    public static final String LIST_COLUMN_SIZE = "cs";
    public static final String LIST_COLUMN_STRUCTURE_ID = "csi";
    public static final String LIST_COLUMN_USER = "cu";
    public static final String LIST_COLUMN_VERSION = "cv";
    public static final String LIST_COLUMN_VERSION_ENABLE = "cve";
    public static final String LIST_COLUMN_VIEW = "cp";
    public static final String LIST_ID = "him";
    public static final String LIST_RACTION_SEL1 = "rs1";
    public static final String LIST_RACTION_SEL2 = "rs2";
    public static final String PARAM_ID_1 = "id1";
    public static final String PARAM_ID_2 = "id2";
    public static final String PARAM_VERSION_1 = "version1";
    public static final String PARAM_VERSION_2 = "version2";
    public static final String PATH_BUTTONS = "buttons/";
    private static final String LIST_MACTION_COMPARE = "mc";
    private static final Log LOG = CmsLog.getLog(CmsHistoryList.class);

    public CmsHistoryList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_HISTORY_0"), LIST_COLUMN_VERSION, CmsListOrderEnum.ORDER_DESCENDING, null);
    }

    public CmsHistoryList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static String getDisplayVersion(String version, Locale locale) {
        int ver = Integer.parseInt(version);
        if (ver == Integer.MAX_VALUE) {
            return Messages.get().getBundle(locale).key("GUI_PROJECT_OFFLINE_0");
        }
        if (ver < 0) {
            ver *= -1;
            if (locale != null) {
                return Messages.get().getBundle(locale).key("GUI_PROJECT_ONLINE_1", new Integer(ver));
            }
        }
        return "" + ver;
    }

    public static String getHistoryLink(CmsObject cms, CmsUUID structureId, String version) {
        String resourcePath;
        try {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.ALL);
            resourcePath = resource.getRootPath();
        }
        catch (CmsException e) {
            throw new CmsRuntimeException(e.getMessageContainer(), (Throwable)e);
        }
        StringBuffer link = new StringBuffer();
        link.append("/system/shared/showversion");
        link.append(resourcePath);
        link.append('?');
        link.append("version");
        link.append('=');
        link.append(CmsHistoryList.getVersion("" + version));
        return link.toString();
    }

    public static int getVersion(String version) {
        int ver = Integer.parseInt(version);
        return Math.abs(ver);
    }

    @Override
    public void actionDialog() throws JspException, ServletException, IOException {
        super.actionDialog();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.getList().getSortedColumn())) {
            this.getList().setSortedColumn(LIST_COLUMN_VERSION);
        }
    }

    @Override
    public void executeListMultiActions() throws IOException, ServletException {
        if (this.getParamListAction().equals(LIST_MACTION_COMPARE)) {
            CmsVersionWrapper ver;
            CmsListItem item1 = this.getSelectedItems().get(0);
            CmsListItem item2 = this.getSelectedItems().get(1);
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            if (item2.get(LIST_COLUMN_VERSION) instanceof CmsVersionWrapper && (ver = (CmsVersionWrapper)item2.get(LIST_COLUMN_VERSION)).compareTo(item1.get(LIST_COLUMN_VERSION)) > 0) {
                params.put(PARAM_VERSION_1, new String[]{item1.get(LIST_COLUMN_VERSION).toString()});
                params.put(PARAM_VERSION_2, new String[]{item2.get(LIST_COLUMN_VERSION).toString()});
                params.put(PARAM_ID_1, new String[]{item1.get(LIST_COLUMN_STRUCTURE_ID).toString()});
                params.put(PARAM_ID_2, new String[]{item2.get(LIST_COLUMN_STRUCTURE_ID).toString()});
            }
            if (params.isEmpty()) {
                params.put(PARAM_VERSION_1, new String[]{item2.get(LIST_COLUMN_VERSION).toString()});
                params.put(PARAM_VERSION_2, new String[]{item1.get(LIST_COLUMN_VERSION).toString()});
                params.put(PARAM_ID_1, new String[]{item2.get(LIST_COLUMN_STRUCTURE_ID).toString()});
                params.put(PARAM_ID_2, new String[]{item1.get(LIST_COLUMN_STRUCTURE_ID).toString()});
            }
            params.put("action", new String[]{"initial"});
            params.put("style", new String[]{"new"});
            params.put("resource", new String[]{this.getParamResource()});
            this.getToolManager().jspForwardTool(this, "/history/comparison", params);
        }
        this.refreshList();
    }

    @Override
    public void executeListSingleActions() throws IOException, ServletException {
        if (this.getParamListAction().equals(LIST_ACTION_RESTORE)) {
            try {
                this.performRestoreOperation();
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                params.put("action", new String[]{"initial"});
                this.getToolManager().jspForwardPage(this, "/system/workplace/views/explorer/explorer_files.jsp", params);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new CmsRuntimeException(e.getMessageContainer());
            }
        }
        this.refreshList();
    }

    @Override
    protected String defaultActionHtmlStart() {
        return this.getList().listJs() + this.dialogContentStart(this.getParamTitle());
    }

    @Override
    protected void fillDetails(String detailId) {
        List<CmsListItem> items = this.getList().getAllContent();
        for (CmsListItem item : items) {
            if (!detailId.equals(GUI_LIST_HISTORY_DETAIL_PROJECT_0)) continue;
            this.fillDetailProject(item, detailId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<CmsListItem> getListItems() throws CmsException {
        ArrayList<CmsListItem> result = new ArrayList<CmsListItem>();
        List<I_CmsHistoryResource> historicalVersions = this.getCms().readAllAvailableVersions(this.getParamResource());
        for (I_CmsHistoryResource histRes : historicalVersions) {
            CmsFile file;
            byte[] content;
            boolean isEnabled = true;
            CmsResource resource = (CmsResource)((Object)this.getCms().readResource(this.getCms().readResource(histRes.getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION).getStructureId(), histRes.getVersion()));
            if (resource.isFile() && (content = (file = this.getCms().readFile(resource)).getContents()).length < 1) {
                isEnabled = false;
            }
            int publishTag = histRes.getPublishTag();
            CmsHistoryProject project = this.getCms().readHistoryProject(publishTag);
            String filetype = String.valueOf(histRes.getTypeId());
            String dateLastModified = this.getMessages().getDateTime(histRes.getDateLastModified());
            String datePublished = this.getMessages().getDateTime(project.getPublishingDate());
            CmsListItem item = this.getList().newItem("" + histRes.getVersion());
            int factor = 1;
            if (result.isEmpty() && !histRes.getState().isDeleted()) {
                factor = -1;
            }
            CmsVersionWrapper version = new CmsVersionWrapper(factor * histRes.getVersion());
            item.set(LIST_COLUMN_VERSION, version);
            item.set(LIST_COLUMN_DATE_PUBLISHED, datePublished);
            item.set(LIST_COLUMN_DATE_LAST_MODIFIED, dateLastModified);
            item.set(LIST_COLUMN_FILE_TYPE, filetype);
            String user = histRes.getUserLastModified().toString();
            try {
                user = CmsPrincipal.readPrincipalIncludingHistory(this.getCms(), histRes.getUserLastModified()).getName();
            }
            catch (CmsDbEntryNotFoundException e) {
                // empty catch block
            }
            item.set(LIST_COLUMN_USER, user);
            item.set(LIST_COLUMN_RESOURCE_PATH, this.getCms().getRequestContext().removeSiteRoot(histRes.getRootPath()));
            item.set(LIST_COLUMN_SIZE, new Integer(histRes.getLength()).toString());
            item.set(LIST_COLUMN_PUBLISH_TAG, new Integer(publishTag));
            item.set(LIST_COLUMN_STRUCTURE_ID, histRes.getStructureId().toString());
            item.set(LIST_COLUMN_VERSION_ENABLE, new Boolean(isEnabled));
            result.add(item);
        }
        if (result.isEmpty()) {
            CmsResource onlineResource = null;
            CmsProject project = this.getCms().getRequestContext().getCurrentProject();
            try {
                this.getCms().getRequestContext().setCurrentProject(this.getCms().readProject(CmsProject.ONLINE_PROJECT_ID));
                onlineResource = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION);
                CmsListItem item = this.getList().newItem("" + onlineResource.getVersion());
                item.set(LIST_COLUMN_VERSION, new CmsVersionWrapper(-1 * onlineResource.getVersion()));
                item.set(LIST_COLUMN_DATE_PUBLISHED, "-");
                item.set(LIST_COLUMN_DATE_LAST_MODIFIED, this.getMessages().getDateTime(onlineResource.getDateLastModified()));
                item.set(LIST_COLUMN_FILE_TYPE, String.valueOf(onlineResource.getTypeId()));
                String user = onlineResource.getUserLastModified().toString();
                try {
                    user = CmsPrincipal.readPrincipalIncludingHistory(this.getCms(), onlineResource.getUserLastModified()).getName();
                }
                catch (CmsDbEntryNotFoundException e) {
                    // empty catch block
                }
                item.set(LIST_COLUMN_USER, user);
                item.set(LIST_COLUMN_SIZE, new Integer(onlineResource.getLength()).toString());
                item.set(LIST_COLUMN_RESOURCE_PATH, this.getCms().getSitePath(onlineResource));
                item.set(LIST_COLUMN_STRUCTURE_ID, onlineResource.getStructureId().toString());
                item.set(LIST_COLUMN_VERSION_ENABLE, new Boolean(true));
                result.add(item);
            }
            catch (CmsVfsResourceNotFoundException e) {
            }
            finally {
                this.getCms().getRequestContext().setCurrentProject(project);
            }
        }
        CmsResource offlineResource = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION);
        this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_SIZE).setVisible(offlineResource.isFile());
        this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ICON).setVisible(offlineResource.isFile());
        if (!offlineResource.getState().isUnchanged()) {
            CmsListItem item = this.getList().newItem("2147483647");
            item.set(LIST_COLUMN_VERSION, new CmsVersionWrapper(Integer.MAX_VALUE));
            item.set(LIST_COLUMN_DATE_PUBLISHED, "-");
            item.set(LIST_COLUMN_DATE_LAST_MODIFIED, this.getMessages().getDateTime(offlineResource.getDateLastModified()));
            item.set(LIST_COLUMN_FILE_TYPE, String.valueOf(offlineResource.getTypeId()));
            String user = offlineResource.getUserLastModified().toString();
            try {
                user = CmsPrincipal.readPrincipalIncludingHistory(this.getCms(), offlineResource.getUserLastModified()).getName();
            }
            catch (CmsDbEntryNotFoundException e) {
                // empty catch block
            }
            item.set(LIST_COLUMN_USER, user);
            item.set(LIST_COLUMN_SIZE, new Integer(offlineResource.getLength()).toString());
            item.set(LIST_COLUMN_RESOURCE_PATH, this.getCms().getSitePath(offlineResource));
            item.set(LIST_COLUMN_STRUCTURE_ID, offlineResource.getStructureId().toString());
            item.set(LIST_COLUMN_VERSION_ENABLE, new Boolean(true));
            result.add(item);
        }
        boolean comparable = result.size() > 1;
        this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_SEL1).setVisible(comparable);
        this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_SEL2).setVisible(comparable);
        this.getList().getMetadata().getMultiAction(LIST_MACTION_COMPARE).setVisible(comparable);
        return result;
    }

    protected void performRestoreOperation() throws CmsException {
        CmsUUID structureId = new CmsUUID(this.getSelectedItem().get(LIST_COLUMN_STRUCTURE_ID).toString());
        int version = Integer.parseInt(this.getSelectedItems().get(0).getId());
        if (version == Integer.MAX_VALUE) {
            return;
        }
        CmsResource res = this.getCms().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        this.checkLock(this.getCms().getSitePath(res));
        this.getCms().restoreResourceVersion(res.getStructureId(), version);
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition previewCol = new CmsListColumnDefinition(LIST_COLUMN_VIEW);
        previewCol.setName(Messages.get().container("GUI_HISTORY_COLS_VIEW_0"));
        previewCol.setWidth("20");
        previewCol.setVisible(false);
        previewCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        previewCol.setSorteable(false);
        CmsListColumnDefinition enableItemCol = new CmsListColumnDefinition(LIST_COLUMN_VERSION_ENABLE);
        enableItemCol.setSorteable(false);
        enableItemCol.setVisible(false);
        metadata.addColumn(enableItemCol);
        CmsListColumnDefinition restoreCol = new CmsListColumnDefinition(LIST_COLUMN_RESTORE);
        restoreCol.setName(Messages.get().container("GUI_HISTORY_COLS_RESTORE_0"));
        restoreCol.setWidth("20");
        restoreCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        restoreCol.setListItemComparator(new CmsListItemActionIconComparator());
        restoreCol.setSorteable(false);
        CmsListDirectAction restoreAction = new CmsListDirectAction(LIST_ACTION_RESTORE){

            @Override
            public String getIconPath() {
                Boolean isEnabled = (Boolean)this.getItem().get(CmsHistoryList.LIST_COLUMN_VERSION_ENABLE);
                if (isEnabled.booleanValue()) {
                    return "tools/ex_history/buttons/restore.png";
                }
                return "buttons/publish_in.png";
            }

            @Override
            public boolean isEnabled() {
                Boolean isEnabled = (Boolean)this.getItem().get(CmsHistoryList.LIST_COLUMN_VERSION_ENABLE);
                return isEnabled != false;
            }
        };
        restoreAction.setName(Messages.get().container("GUI_HISTORY_RESTORE_VERSION_0"));
        restoreAction.setConfirmationMessage(Messages.get().container("GUI_HISTORY_CONFIRMATION_0"));
        restoreCol.addDirectAction(restoreAction);
        metadata.addColumn(restoreCol);
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_HISTORY_COLS_VIEW_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setListItemComparator(new CmsListItemActionIconComparator());
        CmsListResourceIconAction fileAction = new CmsListResourceIconAction(LIST_ACTION_VIEW, LIST_COLUMN_FILE_TYPE, this.getCms()){

            @Override
            public String defButtonHtml(CmsObject cms, String id, String helpId, String name, String helpText, boolean enabled, String iconPath, String confirmationMessage, String onClick, boolean singleHelp) {
                StringBuffer jsCode = new StringBuffer(512);
                jsCode.append("window.open('");
                CmsVersionWrapper version = (CmsVersionWrapper)this.getItem().get(CmsHistoryList.LIST_COLUMN_VERSION);
                jsCode.append(OpenCms.getLinkManager().substituteLink(cms, CmsHistoryList.getHistoryLink(cms, new CmsUUID(this.getItem().get(CmsHistoryList.LIST_COLUMN_STRUCTURE_ID).toString()), version.toString())));
                jsCode.append("','version','scrollbars=yes, resizable=yes, width=800, height=600')");
                return super.defButtonHtml(cms, id, helpId, name, helpText, enabled, iconPath, confirmationMessage, jsCode.toString(), singleHelp);
            }

            @Override
            public String getIconPath() {
                Boolean isEnabled = (Boolean)this.getItem().get(CmsHistoryList.LIST_COLUMN_VERSION_ENABLE);
                if (!isEnabled.booleanValue()) {
                    return "filetypes/plain.gif";
                }
                return super.getIconPath();
            }

            @Override
            public boolean isEnabled() {
                Boolean isEnabled = (Boolean)this.getItem().get(CmsHistoryList.LIST_COLUMN_VERSION_ENABLE);
                return isEnabled != false;
            }
        };
        fileAction.setName(Messages.get().container("GUI_HISTORY_PREVIEW_0"));
        iconCol.addDirectAction(fileAction);
        metadata.addColumn(iconCol);
        iconCol.setPrintable(false);
        CmsListColumnDefinition versionCol = new CmsListColumnDefinition(LIST_COLUMN_VERSION);
        versionCol.setName(Messages.get().container("GUI_HISTORY_COLS_VERSION_0"));
        versionCol.setWidth("5%");
        versionCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        versionCol.setFormatter(new I_CmsListFormatter(){

            @Override
            public String format(Object data, Locale locale) {
                if (data == null || !(data instanceof CmsVersionWrapper)) {
                    return "";
                }
                CmsVersionWrapper version = (CmsVersionWrapper)data;
                return CmsHistoryList.getDisplayVersion(version.toString(), locale);
            }
        });
        metadata.addColumn(versionCol);
        CmsListColumnDefinition groupCol = new CmsListColumnDefinition(LIST_COLUMN_FILE_TYPE);
        groupCol.setVisible(false);
        metadata.addColumn(groupCol);
        CmsListColumnDefinition pathCol = new CmsListColumnDefinition(LIST_COLUMN_RESOURCE_PATH);
        pathCol.setName(Messages.get().container("GUI_HISTORY_COLS_RESOURCE_PATH_0"));
        pathCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        pathCol.setWidth("40%");
        metadata.addColumn(pathCol);
        CmsListColumnDefinition datePublishedCol = new CmsListColumnDefinition(LIST_COLUMN_DATE_PUBLISHED);
        datePublishedCol.setName(Messages.get().container("GUI_HISTORY_COLS_DATE_PUBLISHED_0"));
        datePublishedCol.setWidth("20%");
        datePublishedCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        metadata.addColumn(datePublishedCol);
        CmsListColumnDefinition nicenameCol = new CmsListColumnDefinition(LIST_COLUMN_DATE_LAST_MODIFIED);
        nicenameCol.setName(Messages.get().container("GUI_HISTORY_COLS_DATE_LAST_MODIFIED_0"));
        nicenameCol.setWidth("20%");
        nicenameCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        metadata.addColumn(nicenameCol);
        CmsListColumnDefinition userCol = new CmsListColumnDefinition(LIST_COLUMN_USER);
        userCol.setName(Messages.get().container("GUI_HISTORY_COLS_USER_0"));
        userCol.setWidth("30%");
        userCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        metadata.addColumn(userCol);
        CmsListColumnDefinition sizeCol = new CmsListColumnDefinition(LIST_COLUMN_SIZE);
        sizeCol.setName(Messages.get().container("GUI_HISTORY_COLS_SIZE_0"));
        sizeCol.setWidth("10%");
        sizeCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        metadata.addColumn(sizeCol);
        CmsListColumnDefinition radioSel1Col = new CmsListColumnDefinition(LIST_COLUMN_SEL1);
        radioSel1Col.setName(Messages.get().container("GUI_HISTORY_COLS_VERSION1_0"));
        radioSel1Col.setWidth("20");
        radioSel1Col.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        radioSel1Col.setSorteable(false);
        CmsListItemSelectionAction sel1Action = new CmsListItemSelectionAction(LIST_RACTION_SEL1, LIST_MACTION_COMPARE);
        sel1Action.setName(Messages.get().container("GUI_HISTORY_FIRST_VERSION_0"));
        sel1Action.setEnabled(true);
        radioSel1Col.addDirectAction(sel1Action);
        metadata.addColumn(radioSel1Col);
        CmsListColumnDefinition radioSel2Col = new CmsListColumnDefinition(LIST_COLUMN_SEL2);
        radioSel2Col.setName(Messages.get().container("GUI_HISTORY_COLS_VERSION2_0"));
        radioSel2Col.setWidth("20");
        radioSel2Col.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        radioSel2Col.setSorteable(false);
        CmsListItemSelectionAction sel2Action = new CmsListItemSelectionAction(LIST_RACTION_SEL2, LIST_MACTION_COMPARE);
        sel2Action.setName(Messages.get().container("GUI_HISTORY_SECOND_VERSION_0"));
        sel2Action.setEnabled(true);
        radioSel2Col.addDirectAction(sel2Action);
        metadata.addColumn(radioSel2Col);
        CmsListColumnDefinition publishTagCol = new CmsListColumnDefinition(LIST_COLUMN_PUBLISH_TAG);
        publishTagCol.setSorteable(false);
        publishTagCol.setVisible(false);
        metadata.addColumn(publishTagCol);
        CmsListColumnDefinition strIdCol = new CmsListColumnDefinition(LIST_COLUMN_STRUCTURE_ID);
        strIdCol.setSorteable(false);
        strIdCol.setVisible(false);
        metadata.addColumn(strIdCol);
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails indexDetails = new CmsListItemDetails(GUI_LIST_HISTORY_DETAIL_PROJECT_0);
        indexDetails.setAtColumn(LIST_COLUMN_VERSION);
        indexDetails.setVisible(false);
        indexDetails.setShowActionName(Messages.get().container("GUI_LIST_HISTORY_DETAIL_PROJECT_NAME_SHOW_0"));
        indexDetails.setShowActionHelpText(Messages.get().container("GUI_LIST_HISTORY_DETAIL_PROJECT_SHOW_HELP_0"));
        indexDetails.setHideActionName(Messages.get().container("GUI_LIST_HISTORY_DETAIL_PROJECT_NAME_HIDE_0"));
        indexDetails.setHideActionHelpText(Messages.get().container("GUI_LIST_HISTORY_DETAIL_PROJECT_HIDE_HELP_0"));
        indexDetails.setName(Messages.get().container("GUI_LIST_HISTORY_DETAIL_PROJECT_INFO_0"));
        indexDetails.setFormatter(new CmsListItemDetailsFormatter(Messages.get().container("GUI_LIST_HISTORY_DETAIL_PROJECT_INFO_0")));
        metadata.addItemDetails(indexDetails);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListRadioMultiAction compareAction = new CmsListRadioMultiAction(LIST_MACTION_COMPARE, Arrays.asList(LIST_RACTION_SEL1, LIST_RACTION_SEL2));
        compareAction.setName(Messages.get().container("GUI_HISTORY_COMPARE_0"));
        compareAction.setIconPath("tools/ex_history/buttons/compare.png");
        metadata.addMultiAction(compareAction);
    }

    private void fillDetailProject(CmsListItem item, String detailId) {
        StringBuffer html = new StringBuffer();
        Object tagIdObj = item.get(LIST_COLUMN_PUBLISH_TAG);
        if (tagIdObj != null) {
            int tagId = (Integer)tagIdObj;
            try {
                CmsHistoryProject project = this.getCms().readHistoryProject(tagId);
                html.append(project.getName()).append("<br/>").append(project.getDescription());
            }
            catch (CmsException cmse) {
                html.append(cmse.getMessageContainer().key(this.getLocale()));
            }
        }
        item.set(detailId, html.toString());
    }

    public static class CmsVersionWrapper
    implements Comparable<Object> {
        private Integer m_version;

        public CmsVersionWrapper(int version) {
            this.m_version = new Integer(version);
        }

        @Override
        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            if (o instanceof CmsVersionWrapper) {
                CmsVersionWrapper version = (CmsVersionWrapper)o;
                Integer v1 = this.m_version;
                Integer v2 = version.getVersion();
                if (v1 < 0) {
                    v1 = new Integer(-1 * v1);
                }
                if (v2 < 0) {
                    v2 = new Integer(-1 * v2);
                }
                return v1.compareTo(v2);
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CmsVersionWrapper) {
                CmsVersionWrapper version = (CmsVersionWrapper)obj;
                return this.getVersion().equals(version.getVersion());
            }
            return false;
        }

        public Integer getVersion() {
            return this.m_version;
        }

        public int hashCode() {
            return this.getVersion().hashCode();
        }

        public String toString() {
            return this.m_version.toString();
        }
    }
}

