/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors.directedit;

import org.opencms.i18n.CmsEncoder;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.directedit.CmsDirectEditDefaultProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.editors.directedit.CmsDirectEditParams;
import org.opencms.workplace.editors.directedit.CmsDirectEditResourceInfo;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;

public class CmsDirectEditTextButtonProvider
extends CmsDirectEditDefaultProvider {
    private String m_endHtml;

    @Override
    public String endDirectEditDisabled() {
        return "";
    }

    @Override
    public String endDirectEditEnabled() {
        String result = "";
        if (CmsStringUtil.isNotEmpty(this.m_endHtml)) {
            result = this.m_endHtml;
            this.m_endHtml = null;
        }
        return result;
    }

    @Override
    public boolean isManual(CmsDirectEditMode mode) {
        return mode == CmsDirectEditMode.MANUAL || this.m_mode == CmsDirectEditMode.MANUAL && mode == CmsDirectEditMode.TRUE;
    }

    @Override
    public I_CmsDirectEditProvider newInstance() {
        CmsDirectEditTextButtonProvider result = new CmsDirectEditTextButtonProvider();
        result.m_configurationParameters = this.m_configurationParameters;
        return result;
    }

    @Override
    public String startDirectEditDisabled(CmsDirectEditParams params, CmsDirectEditResourceInfo resourceInfo) {
        StringBuffer result = new StringBuffer(256);
        result.append("<span class=\"ocms_txt_dis\">");
        result.append(this.m_messages.key("GUI_DIRECTEDIT_TEXT_EDIT_0"));
        result.append("</span>");
        return result.toString();
    }

    @Override
    public String startDirectEditEnabled(CmsDirectEditParams params, CmsDirectEditResourceInfo resourceInfo) {
        String editId = this.getNextDirectEditId();
        StringBuffer result = new StringBuffer(256);
        String linkForNew = CmsEncoder.encode(params.getLinkForNew());
        result.append("<span class=\"ocms_txt_en\">");
        if (params.getButtonSelection().isShowEdit()) {
            result.append("[<a href=\"#\" class=\"ocms_txt\" onclick=\"javascript:submitOcms('").append(editId).append("', '").append("edit").append("');\">");
            result.append(this.m_messages.key("GUI_DIRECTEDIT_TEXT_EDIT_0"));
            result.append("</a>]");
        }
        if (params.getButtonSelection().isShowDelete()) {
            result.append("\n[<a href=\"#\" class=\"ocms_txt\" onclick=\"javascript:submitOcms('").append(editId).append("', '").append("delete").append("');\">");
            result.append(this.m_messages.key("GUI_DIRECTEDIT_TEXT_DELETE_0"));
            result.append("</a>]");
        }
        if (params.getButtonSelection().isShowNew()) {
            result.append("\n[<a href=\"#\" class=\"ocms_txt\" onclick=\"javascript:submitOcms('").append(editId).append("', '").append("new").append("', '").append(linkForNew).append("');\">");
            result.append(this.m_messages.key("GUI_DIRECTEDIT_TEXT_NEW_0"));
            result.append("</a>]");
        }
        result.append("</span>");
        StringBuffer endHtml = new StringBuffer(256);
        String editLocale = this.m_cms.getRequestContext().getLocale().toString();
        String uri = this.m_cms.getRequestContext().getUri();
        String linkForEdit = this.getLink(params.getLinkForEdit());
        endHtml.append("<form class=\"ocms_nomargin\" name=\"form_").append(editId).append("\" id=\"form_").append(editId).append("\" method=\"post\" action=\"").append(linkForEdit).append("\" target=\"_top\">\n");
        endHtml.append("<input type=\"hidden\" name=\"resource\" value=\"").append(params.getResourceName()).append("\"/>\n");
        endHtml.append("<input type=\"hidden\" name=\"directedit\" value=\"true\"/>\n");
        endHtml.append("<input type=\"hidden\" name=\"elementlanguage\" value=\"").append(editLocale).append("\"/>\n");
        endHtml.append("<input type=\"hidden\" name=\"elementname\" value=\"").append(params.getElement()).append("\"/>\n");
        endHtml.append("<input type=\"hidden\" name=\"backlink\" value=\"").append(uri).append("\"/>\n");
        endHtml.append("<input type=\"hidden\" name=\"newlink\"/>\n");
        endHtml.append("<input type=\"hidden\" name=\"closelink\"/>\n");
        endHtml.append("<input type=\"hidden\" name=\"redirect\" value=\"true\"/>\n");
        endHtml.append("<input type=\"hidden\" name=\"editortitle\"/>\n");
        endHtml.append("</form>");
        this.m_endHtml = endHtml.toString();
        return result.toString();
    }
}

