/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.help;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.help.Messages;

public class CmsHelpTemplateBean
extends CmsDialog {
    public static final String DEFAULT_HELPFILE = "index.html";
    public static final String HELPMAPPINGS_FILENAME = "mappings_${request.locale}.properties";
    public static final String MODULE_NAME = "org.opencms.workplace.help";
    public static final String PARAM_BUILDFRAME = "buildframe";
    public static final String PARAM_HELPRESOURCE = "helpresource";
    public static final String PARAM_HOMELINK = "homelink";
    public static final String PARAM_WORKPLACERESOURCE = "workplaceresource";
    public static final String PATH_HELP = "/system/workplace/locales/${request.locale}/help/";
    public static final String PROPERTY_VALUE_HELPSTART = "help.start";
    public static final String RFS_HELPMAPPINGS = "classes/" + "org.opencms.workplace.help".replace('.', '/') + "/" + "mappings_${request.locale}.properties";
    public static final String TEMPLATEPATH = "/system/modules/org.opencms.workplace.help/jsptemplates/";
    private static final Log LOG = CmsLog.getLog(CmsHelpTemplateBean.class);
    private CmsProject m_offlineProject;
    private CmsProject m_onlineProject;
    private String m_paramBuildframe;
    private String m_paramHelpresource;
    private String m_paramHomelink;
    private String m_paramWorkplaceresource;

    public CmsHelpTemplateBean(CmsJspActionElement jsp) {
        super(jsp);
        try {
            this.m_onlineProject = this.getCms().readProject(CmsProject.ONLINE_PROJECT_ID);
            this.m_offlineProject = jsp.getRequestContext().getCurrentProject();
        }
        catch (CmsException e) {
            this.m_onlineProject = this.getCms().getRequestContext().getCurrentProject();
        }
    }

    public CmsHelpTemplateBean(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static String buildOnlineHelpJavaScript(Locale locale) {
        StringBuffer result = new StringBuffer(16);
        result.append("function openOnlineHelp(wpUri) {\n");
        result.append("\tif (wpUri == null || wpUri == \"\") {\n");
        result.append("\t\tif (top.body.top.body.admin_content != null && top.body.top.body.admin_content.onlineHelpUriCustom != null) {\n");
        result.append("\t\t\twpUri = top.body.top.body.admin_content.onlineHelpUriCustom;\n");
        result.append("\t\t}\n");
        result.append("\t\telse{\n");
        result.append("\t\t\tif (top.body != null && top.body.explorer_body != null) {\n");
        result.append("\t\t\t\t// determine currently shown explorer item\n");
        result.append("\t\t\t\ttry {\n");
        result.append("\t\t\t\t\twpUri = top.body.explorer_body.explorer_files.location.pathname;\n");
        result.append("\t\t\t\t} catch (e) {}\n");
        result.append("\t\t\t} else if (top.body != null && top.body.admin_content != null) {\n");
        result.append("\t\t\t\t// determine currently shown administration item\n");
        result.append("\t\t\t\tvar parameters = \"\";\n");
        result.append("\t\t\t\ttry {\n");
        result.append("\t\t\t\t\tparameters = decodeURIComponent(top.body.admin_content.tool_title.location.search);\n");
        result.append("\t\t\t\t} catch (e) {\n");
        result.append("\t\t\t\t\ttry {\n");
        result.append("\t\t\t\t\t\tparameters = decodeURIComponent(top.body.admin_content.location.search);\n");
        result.append("\t\t\t\t\t} catch (e) {}\n");
        result.append("\t\t\t\t}\n");
        result.append("\t\t\t\tvar pathIndex = parameters.lastIndexOf(\"path=\");\n");
        result.append("\t\t\t\tif (pathIndex != -1) {\n");
        result.append("\t\t\t\t\tparameters = parameters.substring(pathIndex + 5);\n");
        result.append("\t\t\t\t\tif (parameters.indexOf(\"&\") != -1) {\n");
        result.append("\t\t\t\t\t\tparameters = parameters.substring(0, parameters.indexOf(\"&\"));\n");
        result.append("\t\t\t\t\t}\n");
        result.append("\t\t\t\t\twpUri = parameters + \"/\";\n");
        result.append("\t\t\t\t} else {\n");
        result.append("\t\t\t\t\twpUri = \"/administration/\"\n");
        result.append("\t\t\t\t}\n");
        result.append("\t\t\t} else if(top.body != null) {\n");
        result.append("\t\t\t\twpUri = top.body.location.pathname;\n");
        result.append("\t\t\t}\n");
        result.append("\t\t}\n");
        result.append("\t}\n");
        result.append("\tif (wpUri==null) {\n");
        result.append("\t\twpUri=\"/system/workplace/\";\n");
        result.append("\t}\n");
        result.append("\twindow.open(\"../locales/");
        result.append(locale);
        result.append("/help/index.html?").append(PARAM_BUILDFRAME).append("=true");
        result.append("&").append(PARAM_WORKPLACERESOURCE).append("=\" + wpUri, \"cmsonlinehelp\", ");
        result.append("\"toolbar=no,location=no,directories=no,status=yes,menubar=0,scrollbars=yes,resizable=yes,width=700,height=450\");\n");
        result.append("}\n");
        String s = result.toString();
        return s;
    }

    public String buildHtmlHelpEnd() {
        StringBuffer result = new StringBuffer(4);
        result.append("</body>\n");
        result.append("</html>");
        return result.toString();
    }

    public String buildHtmlHelpStart(String cssFile, boolean transitional) {
        StringBuffer result = new StringBuffer(8);
        if (transitional) {
            result.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        } else {
            result.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n");
        }
        result.append("<html>\n");
        result.append("<head>\n");
        result.append("\t<meta HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8");
        result.append("\">\n");
        result.append("\t<title>");
        if (CmsStringUtil.isNotEmpty(this.getParamHelpresource())) {
            result.append(this.getJsp().property("Title", this.getParamHelpresource(), this.key("GUI_HELP_FRAMESET_TITLE_0")));
        } else {
            result.append(this.key("GUI_HELP_FRAMESET_TITLE_0"));
        }
        result.append("</title>\n");
        result.append("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        result.append(CmsHelpTemplateBean.getStyleUri(this.getJsp(), cssFile)).append("\">\n");
        result.append("</head>\n");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String displayBody() {
        StringBuffer result = new StringBuffer(256);
        try {
            block10: {
                this.getJsp().getRequestContext().setCurrentProject(this.m_onlineProject);
                result.append(this.buildHtmlHelpStart("onlinehelp.css", true));
                result.append("<body>\n");
                result.append("<a name=\"top\"></a>\n");
                result.append("<table class=\"helpcontent\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n");
                result.append("<tr>\n");
                result.append("\t<td class=\"helpnav\">\n");
                result.append("\t\t<a class=\"navhelphead\" href=\"javascript:top.body.location.href=top.head.homeLink;\">");
                result.append(this.key("GUI_HELP_NAVIGATION_HEAD_0"));
                result.append("</a>\n");
                result.append(this.buildHtmlHelpNavigation());
                result.append("</td>\n");
                result.append("\t<td class=\"helpcontent\">\n");
                result.append("\t\t<h1>");
                result.append(this.getJsp().property("Title", this.getParamHelpresource(), this.key("GUI_HELP_FRAMESET_TITLE_0")));
                result.append("</h1>\n");
                result.append(this.getJsp().getContent(this.getParamHelpresource(), "body", this.getLocale()));
                try {
                    CmsProperty elements = this.getCms().readPropertyObject(this.getParamHelpresource(), "template-elements", false);
                    if (elements.isNullProperty()) break block10;
                    try {
                        this.getJsp().getCmsObject().readFile(elements.getValue());
                        String elementName = elements.getValue();
                        boolean export = false;
                        CmsProperty exportProp = this.getCms().readPropertyObject(elementName, "export", true);
                        if (!exportProp.isNullProperty()) {
                            export = Boolean.valueOf(exportProp.getValue(CmsStringUtil.FALSE));
                        }
                        if (!export) {
                            this.getJsp().getRequestContext().setCurrentProject(this.m_offlineProject);
                        }
                        result.append(this.getJsp().getContent(elements.getValue()));
                    }
                    catch (Throwable t) {
                        CmsVfsResourceNotFoundException e2 = new CmsVfsResourceNotFoundException(Messages.get().container("GUI_HELP_ERR_CONTENT_APPEND_2", this.getParamHelpresource(), elements.getValue(), "template-elements"), t);
                        throw e2;
                    }
                }
                catch (CmsException e1) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)e1);
                    }
                    result.append("<br>\n<div class=\"dialogerror\">");
                    result.append(e1.getMessageContainer().key(Locale.GERMAN));
                    result.append("</div>");
                }
            }
            result.append("\t</td>\n");
            result.append("</tr>\n");
            result.append("</table>\n");
            result.append(this.buildHtmlHelpEnd());
            String string = result.toString();
            return string;
        }
        finally {
            this.getJsp().getRequestContext().setCurrentProject(this.m_offlineProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String displayHead() {
        StringBuffer result = new StringBuffer(2048);
        int buttonStyle = this.getSettings().getUserSettings().getWorkplaceButtonStyle();
        try {
            this.getJsp().getRequestContext().setCurrentProject(this.m_onlineProject);
            String resourcePath = this.getJsp().link("/system/modules/org.opencms.workplace.help/resources/");
            result.append(this.buildHtmlHelpStart("workplace.css", false));
            result.append("<body class=\"buttons-head\" unselectable=\"on\">\n");
            result.append("<script type=\"text/javascript\" src=\"");
            result.append(this.getJsp().link("/system/modules/org.opencms.workplace.help/resources/search.js"));
            result.append("\"></script>\n");
            result.append("<script type=\"text/javascript\">\n<!--\n");
            result.append("\tvar homeLink = \"");
            result.append(this.getParamHomelink());
            result.append("\";\n\n");
            result.append("//-->\n</script>\n");
            String index = this.getJsp().property("search.index", "/system/modules/org.opencms.workplace.help/elements/search.jsp", "German online help", false);
            StringBuffer submitAction = new StringBuffer();
            submitAction.append("parseSearchQuery(document.forms['searchform'],'");
            submitAction.append(Messages.get().getBundle(this.getLocale()).key("GUI_HELP_ERR_SEARCH_WORD_LENGTH_1", new Integer(3))).append("');");
            result.append("<form style=\"margin: 0;\" name=\"searchform\" method=\"post\" action=\"");
            String searchLink = this.getJsp().link(new StringBuffer("/system/modules/org.opencms.workplace.help/elements/search.jsp?").append("__locale").append("=").append(this.getLocale()).toString());
            result.append(searchLink);
            result.append("\" target=\"body\"");
            result.append(" onsubmit=\"");
            result.append(submitAction.toString());
            result.append("\">\n");
            result.append("  <input type=\"hidden\" name=\"action\" value=\"search\" />\n");
            result.append("  <input type=\"hidden\" name=\"query\" value=\"\" />\n");
            result.append("  <input type=\"hidden\" name=\"index\" value=\"" + index + "\" />\n");
            result.append("  <input type=\"hidden\" name=\"searchPage\" value=\"1\" />\n");
            result.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
            result.append("<tr>\n");
            result.append("\t<td align=\"left\">\n");
            result.append(this.buttonBar(0));
            result.append(this.buttonBarStartTab(0, 5));
            result.append(this.button("javascript:history.back();", null, "back.png", "GUI_HELP_BUTTON_BACK_0", buttonStyle, resourcePath));
            result.append(this.button("javascript:history.forward();", null, "next.png", "GUI_HELP_BUTTON_NEXT_0", buttonStyle, resourcePath));
            result.append(this.button("javascript:top.body.location.href='" + this.getParamHomelink() + "';", null, "contents.png", "GUI_HELP_BUTTON_CONTENTS_0", buttonStyle, resourcePath));
            result.append("<td style=\"vertical-align: top;\">");
            result.append("<input type=\"text\" name=\"query2\" class=\"onlineform\" style=\"width: 120px\" value=\"");
            result.append("");
            result.append(" \">");
            result.append("</td>\n");
            result.append(this.button(new StringBuffer("javascript:").append(submitAction.toString()).toString(), null, null, "GUI_HELP_BUTTON_SEARCH_0", 2, null));
            result.append(this.buttonBar(1));
            result.append("</td>\n");
            result.append("\t<td align=\"right\" width=\"100%\">\n");
            result.append(this.buttonBar(0));
            result.append(this.buttonBarSeparator(5, 0));
            result.append(this.button("javascript:top.close();", null, "close", "GUI_HELP_BUTTON_CLOSE_0", buttonStyle, resourcePath));
            result.append(this.buttonBar(1));
            result.append("\t</td>\n");
            result.append("\t<td>&nbsp;</td>\n");
            result.append("<td>");
            result.append("<span style=\"display: block; width: 80px; height: 22px; background-image: url('");
            result.append(CmsHelpTemplateBean.getSkinUri());
            result.append("commons/workplace.png");
            result.append("'); \"></span>");
            result.append("</td>");
            result.append("</tr>\n");
            result.append("</table>\n");
            result.append("</form>\n");
            result.append(this.buildHtmlHelpEnd());
            String string = result.toString();
            return string;
        }
        finally {
            this.getJsp().getRequestContext().setCurrentProject(this.m_offlineProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String displayHelp() throws IOException {
        String result = "";
        try {
            this.getJsp().getRequestContext().setCurrentProject(this.m_onlineProject);
            if (this.isBuildFrameset()) {
                result = this.displayFrameset();
            } else {
                StringBuffer bodyLink = new StringBuffer(8);
                bodyLink.append(TEMPLATEPATH);
                bodyLink.append("help_body.jsp?");
                bodyLink.append(PARAM_HELPRESOURCE);
                bodyLink.append("=");
                bodyLink.append(this.getJsp().getRequestContext().getUri());
                bodyLink.append("&");
                bodyLink.append("__locale");
                bodyLink.append("=");
                bodyLink.append(this.getLocale());
                String bodyLinkWithParams = this.attachRequestString(bodyLink.toString());
                String redirectLink = this.getJsp().link(bodyLinkWithParams);
                this.getJsp().getResponse().sendRedirect(redirectLink);
            }
            String string = result;
            return string;
        }
        finally {
            this.getJsp().getRequestContext().setCurrentProject(this.m_onlineProject);
        }
    }

    public String getParamBuildframe() {
        return this.m_paramBuildframe;
    }

    public String getParamHelpresource() {
        if (this.m_paramHelpresource == null) {
            this.m_paramHelpresource = this.resolveMacros(PATH_HELP) + DEFAULT_HELPFILE;
        }
        return this.m_paramHelpresource;
    }

    public String getParamHomelink() {
        return this.m_paramHomelink;
    }

    public String getParamWorkplaceresource() {
        return this.m_paramWorkplaceresource;
    }

    public void setParamBuildframe(String buildframe) {
        this.m_paramBuildframe = buildframe;
    }

    public void setParamHelpresource(String helpresource) {
        this.m_paramHelpresource = helpresource;
    }

    public void setParamHomelink(String homelink) {
        this.m_paramHomelink = homelink;
    }

    public void setParamWorkplaceresource(String workplaceresource) {
        this.m_paramWorkplaceresource = workplaceresource;
    }

    protected String buildHtmlHelpNavigation() {
        StringBuffer result = new StringBuffer(512);
        String currentUri = this.getParamHelpresource();
        if (currentUri == null || currentUri.indexOf("/workplace/locales/") == -1) {
            currentUri = this.resolveMacros(PATH_HELP) + DEFAULT_HELPFILE;
        }
        int helpLevel = CmsResource.getPathLevel(PATH_HELP);
        List<CmsJspNavElement> navList = this.getJsp().getNavigation().getNavigationTreeForFolder(currentUri, helpLevel, 99);
        for (CmsJspNavElement nav : navList) {
            int level = nav.getNavTreeLevel() - (helpLevel - 1);
            if (nav.getResourceName().equals(currentUri) || nav.isFolderLink() && currentUri.equals(nav.getResourceName() + DEFAULT_HELPFILE)) {
                result.append("\t\t<span class=\"navhelpcurrent\" style=\"padding-left: ");
                result.append(level * 10);
                result.append("px; background-position: ");
                result.append((level - 1) * 10);
                result.append("px 1px;\">");
                result.append(nav.getNavText());
                result.append("</span><br style=\"clear:left\">\n");
                continue;
            }
            result.append("\t\t<a class=\"navhelp\" style=\"padding-left: ");
            result.append(level * 10);
            result.append("px; background-position: ");
            result.append((level - 1) * 10);
            result.append("px 1px;\" href=\"");
            if (nav.isFolderLink()) {
                result.append(this.getJsp().link("/system/modules/org.opencms.workplace.help/jsptemplates/help_body.jsp?helpresource=" + nav.getResourceName() + "index.html&" + "__locale" + "=" + this.getLocale()));
            } else {
                result.append(this.getJsp().link("/system/modules/org.opencms.workplace.help/jsptemplates/help_body.jsp?helpresource=" + nav.getResourceName() + "&" + "__locale" + "=" + this.getLocale()));
            }
            result.append("\">");
            result.append(nav.getNavText());
            result.append("</a><br style=\"clear:left\">\n");
        }
        return result.toString();
    }

    @Override
    protected void checkRole() throws CmsRoleViolationException {
        if (!OpenCms.getDefaultUsers().isUserExport(this.getCms().getRequestContext().getCurrentUser().getName())) {
            OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.WORKPLACE_USER);
        }
    }

    protected String displayFrameset() {
        StringBuffer result = new StringBuffer(8);
        result.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n");
        result.append("<html>\n");
        result.append("<head>\n");
        result.append("\t<title>");
        result.append(this.key("GUI_HELP_FRAMESET_TITLE_0"));
        result.append("</title>\n");
        result.append("<script type=\"text/javascript\">\n<!--\n");
        result.append("\t if (window.name == \"body\") {\n");
        result.append("\t\ttop.location.href = \"" + this.getJsp().link(this.getJsp().getRequestContext().getUri()) + "\";\n");
        result.append("\t}\n");
        result.append("//-->\n</script>\n");
        result.append("<meta HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\">\n");
        result.append("</head>\n\n");
        result.append("<frameset rows=\"24,*\" border=\"0\" frameborder=\"0\" framespacing=\"0\">\n");
        result.append("\t<frame name=\"head\" src=\"");
        StringBuffer headLink = new StringBuffer(8);
        headLink.append(TEMPLATEPATH);
        headLink.append("help_head.jsp?");
        headLink.append("__locale");
        headLink.append("=");
        headLink.append(this.getLocale());
        headLink.append("&");
        headLink.append(PARAM_HOMELINK);
        headLink.append("=");
        headLink.append(this.getParamHomelink());
        result.append(this.getJsp().link(this.attachRequestString(headLink.toString())));
        result.append("\" scrolling=\"no\" noresize>\n");
        result.append("\t<frame name=\"body\" src=\"");
        StringBuffer bodyLink = new StringBuffer(8);
        bodyLink.append(TEMPLATEPATH);
        bodyLink.append("help_body.jsp?");
        bodyLink.append(PARAM_HELPRESOURCE);
        bodyLink.append("=");
        bodyLink.append(this.getJsp().getRequestContext().getUri());
        bodyLink.append("&");
        bodyLink.append("__locale");
        bodyLink.append("=");
        bodyLink.append(this.getLocale());
        result.append(this.getJsp().link(bodyLink.toString()));
        result.append("\" scrolling=\"auto\" noresize>\n");
        result.append("</frameset>\n\n");
        result.append("<body></body>\n");
        result.append("</html>");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMappedHelpUri() {
        block13: {
            try {
                int xmlPageId;
                this.getJsp().getRequestContext().setCurrentProject(this.m_onlineProject);
                if (!CmsStringUtil.isNotEmpty(this.getParamWorkplaceresource())) break block13;
                String helpResource = null;
                String wpResource = this.getParamWorkplaceresource();
                try {
                    xmlPageId = OpenCms.getResourceManager().getResourceType(CmsResourceTypeXmlPage.getStaticTypeName()).getTypeId();
                }
                catch (CmsLoaderException e1) {
                    xmlPageId = CmsResourceTypeXmlPage.getStaticTypeId();
                }
                if (this.getCms().existsResource(this.resolveMacros(this.getParamWorkplaceresource()), CmsResourceFilter.requireType(xmlPageId))) {
                    helpResource = this.resolveMacros(this.getParamWorkplaceresource());
                    this.setParamHomelink(this.getJsp().link(helpResource));
                } else {
                    try {
                        String absolutePath = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(this.resolveMacros(RFS_HELPMAPPINGS));
                        CmsParameterConfiguration props = new CmsParameterConfiguration(absolutePath);
                        if (wpResource.startsWith(OpenCms.getSystemInfo().getOpenCmsContext())) {
                            wpResource = wpResource.substring(OpenCms.getSystemInfo().getOpenCmsContext().length());
                        }
                        while (wpResource != null && CmsStringUtil.isEmpty(helpResource)) {
                            helpResource = props.getString(wpResource, null);
                            wpResource = CmsResource.getParentFolder(wpResource);
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (CmsStringUtil.isEmpty(helpResource)) {
                        helpResource = DEFAULT_HELPFILE;
                    }
                    helpResource = this.resolveMacros(PATH_HELP) + helpResource;
                    if (!this.getCms().existsResource(helpResource, CmsResourceFilter.IGNORE_EXPIRATION)) {
                        helpResource = this.resolveMacros(PATH_HELP) + DEFAULT_HELPFILE;
                    }
                    this.setParamHomelink(this.getJsp().link(this.resolveMacros(PATH_HELP) + DEFAULT_HELPFILE));
                }
                this.getJsp().getRequestContext().setUri(helpResource);
            }
            finally {
                this.getJsp().getRequestContext().setCurrentProject(this.m_offlineProject);
            }
        }
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (this.isBuildFrameset()) {
            this.getMappedHelpUri();
        }
    }

    protected boolean isBuildFrameset() {
        return Boolean.valueOf(this.getParamBuildframe());
    }

    private String attachRequestString(String resourceName) {
        StringBuffer result = new StringBuffer(resourceName);
        boolean firstParam = true;
        if (resourceName.indexOf(63) == -1) {
            result.append('?');
        } else {
            firstParam = false;
        }
        Map params = this.getJsp().getRequest().getParameterMap();
        Iterator it = params.entrySet().iterator();
        String[] values = null;
        while (it.hasNext()) {
            if (values == null) {
                if (!firstParam) {
                    result.append('&');
                }
            } else {
                result.append("&");
            }
            Map.Entry entry = it.next();
            result.append(((String)entry.getKey()).toString()).append('=');
            values = (String[])entry.getValue();
            for (int i = 0; i < values.length; ++i) {
                result.append(values[i]);
                if (i + 1 >= values.length) continue;
                result.append(',');
            }
        }
        return result.toString();
    }
}

