/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.Comparator;
import java.util.Locale;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListItemComparator;

public class CmsListItemActionIconComparator
implements I_CmsListItemComparator {
    @Override
    public Comparator<CmsListItem> getComparator(final String columnId, Locale locale) {
        return new Comparator<CmsListItem>(){

            @Override
            public int compare(CmsListItem li1, CmsListItem li2) {
                if (li1 == li2) {
                    return 0;
                }
                CmsListColumnDefinition col = li1.getMetadata().getColumnDefinition(columnId);
                if (col.getDirectActions().size() > 0) {
                    String i1 = null;
                    String i2 = null;
                    for (I_CmsListDirectAction action : col.getDirectActions()) {
                        CmsListItem tmp = action.getItem();
                        action.setItem(li1);
                        if (action.isVisible()) {
                            i1 = action.getIconPath();
                        }
                        action.setItem(li2);
                        if (action.isVisible()) {
                            i2 = action.getIconPath();
                        }
                        action.setItem(tmp);
                    }
                    if (i1 != null) {
                        if (i2 == null) {
                            return 1;
                        }
                        return i1.compareTo(i2);
                    }
                    if (i2 != null) {
                        return -1;
                    }
                    return 0;
                }
                Object o1 = li1.get(columnId);
                Object o2 = li2.get(columnId);
                if (o1 != null) {
                    if (o2 == null) {
                        return 1;
                    }
                    return ((Comparable)o1).compareTo(o2);
                }
                if (o2 != null) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

