/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.db.CmsUserSettings;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.fields.CmsLuceneField;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCalendarWidget;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsMultiSelectWidget;
import org.opencms.widgets.CmsSelectOnChangeReloadWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.search.CmsSearchResultsList;
import org.opencms.workplace.search.CmsSearchWorkplaceBean;
import org.opencms.workplace.search.Messages;

public class CmsSearchDialog
extends CmsWidgetDialog {
    public static final String LABEL_FIELD_INFIX = "field.";
    public static final String PARAM_ACTION_VALUE_FOR_CHANGED_INDEX = "index";
    private static final String DIALOG_TYPE = "search";
    private static final String[] PAGES = new String[]{"page1"};
    private CmsSearchWorkplaceBean m_search;

    public CmsSearchDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsSearchDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    @Override
    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("action", new String[]{"listselectpage"});
            params.put("page", new String[]{"1"});
            params.put("root", new String[]{"explorer"});
            if (this.getSettings().getUserSettings().getWorkplaceSearchViewStyle() == CmsUserSettings.CmsSearchResultStyle.STYLE_EXPLORER) {
                this.getSettings().setExplorerPage(1);
                params.put("showexplorer", new String[]{Boolean.TRUE.toString()});
            } else {
                boolean withExcerpts;
                CmsSearchResultsList resultsList = new CmsSearchResultsList(this.getJsp());
                CmsListMetadata metadata = resultsList.getMetadata(CmsSearchResultsList.class.getName());
                boolean bl = withExcerpts = this.getSettings().getUserSettings().getWorkplaceSearchViewStyle() == CmsUserSettings.CmsSearchResultStyle.STYLE_LIST_WITH_EXCERPTS;
                if (metadata == null) {
                    if (!withExcerpts) {
                        params.put("action", new String[]{"listindependentaction"});
                        params.put("listaction", new String[]{"de"});
                    }
                } else {
                    metadata.getItemDetailDefinition("de").setVisible(withExcerpts);
                }
                params.put("showexplorer", new String[]{Boolean.FALSE.toString()});
            }
            this.getToolManager().jspForwardTool(this, "/search/results", params);
        }
        catch (Exception e) {
            errors.add(e);
        }
        this.setCommitErrors(errors);
    }

    public List<CmsLuceneField> getFields() {
        CmsSearchIndex index = this.getIndex();
        ArrayList<CmsLuceneField> result = new ArrayList<CmsLuceneField>();
        for (CmsLuceneField cmsLuceneField : index.getFieldConfiguration().getFields()) {
            if (!cmsLuceneField.isIndexed() || !cmsLuceneField.isDisplayed()) continue;
            result.add(cmsLuceneField);
        }
        return result;
    }

    @Override
    protected String createDialogHtml(String dialog) {
        CmsSearchIndex index = this.getIndex();
        if (index == null) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INDEX_INVALID_1", this.getSettings().getUserSettings().getWorkplaceSearchIndexName()));
        }
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.createWidgetBlockStart(this.key("GUI_SEARCH_QUERY_TITLE_0")));
            result.append(this.createDialogRowsHtml(0, 3));
            result.append(this.createWidgetBlockEnd());
            result.append(this.createWidgetBlockStart(this.key("GUI_SEARCH_FIELDS_TITLE_0")));
            result.append(this.createDialogRowsHtml(8, 8));
            result.append(this.createWidgetBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    @Override
    protected void defineWidgets() {
        this.initParams();
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "indexName", PAGES[0], new CmsSelectOnChangeReloadWidget(this.getSortNamesIndex())));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "query", PAGES[0], new CmsInputWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "sortOrder", PAGES[0], new CmsSelectWidget(this.getSortNamesConf())));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "restrictSearch", PAGES[0], new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "minDateCreated", PAGES[0], new CmsCalendarWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "maxDateCreated", PAGES[0], new CmsCalendarWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "minDateLastModified", PAGES[0], new CmsCalendarWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "maxDateLastModified", PAGES[0], new CmsCalendarWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "fields", PAGES[0], new CmsMultiSelectWidget(this.getFieldList(), true)));
    }

    @Override
    protected String[] getPageArray() {
        return PAGES;
    }

    @Override
    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(DIALOG_TYPE);
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_search);
    }

    private List<CmsSelectWidgetOption> getFieldList() {
        ArrayList<CmsSelectWidgetOption> retVal = new ArrayList<CmsSelectWidgetOption>();
        try {
            for (CmsLuceneField field : this.getFields()) {
                if (this.isInitialCall()) {
                    retVal.add(new CmsSelectWidgetOption(field.getName(), true, this.getMacroResolver().resolveMacros(field.getDisplayName())));
                    continue;
                }
                retVal.add(new CmsSelectWidgetOption(field.getName(), false, this.getMacroResolver().resolveMacros(field.getDisplayName())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private CmsSearchIndex getIndex() {
        CmsSearchIndex index = null;
        index = this.isInitialCall() ? OpenCms.getSearchManager().getIndex(this.getSettings().getUserSettings().getWorkplaceSearchIndexName()) : OpenCms.getSearchManager().getIndex(this.getJsp().getRequest().getParameter("indexName.0"));
        return index;
    }

    private List<CmsSelectWidgetOption> getSortNamesConf() {
        ArrayList<CmsSelectWidgetOption> retVal = new ArrayList<CmsSelectWidgetOption>();
        try {
            String[] names = CmsSearchParameters.SORT_NAMES;
            for (int i = 0; i < names.length; ++i) {
                retVal.add(new CmsSelectWidgetOption(names[i], i == 0, this.key("label." + names[i].toLowerCase())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private List<CmsSelectWidgetOption> getSortNamesIndex() {
        ArrayList<CmsSelectWidgetOption> retVal = new ArrayList<CmsSelectWidgetOption>();
        try {
            List<String> names = OpenCms.getSearchManager().getIndexNames();
            for (int i = 0; i < names.size(); ++i) {
                String indexName = names.get(i);
                String wpIndexName = this.getSettings().getUserSettings().getWorkplaceSearchIndexName();
                boolean isDefault = indexName.toLowerCase().equals(wpIndexName.toLowerCase());
                retVal.add(new CmsSelectWidgetOption(names.get(i), isDefault, names.get(i)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private void initParams() {
        Object o = CmsStringUtil.isEmpty(this.getParamAction()) || "initial".equals(this.getParamAction()) ? null : this.getDialogObject();
        if (!(o instanceof CmsSearchWorkplaceBean)) {
            String oldExplorerMode = this.getSettings().getExplorerMode();
            this.getSettings().setExplorerMode(null);
            String explorerResource = this.getSettings().getExplorerResource();
            this.getSettings().setExplorerMode(oldExplorerMode);
            this.m_search = new CmsSearchWorkplaceBean(explorerResource);
        } else {
            this.m_search = (CmsSearchWorkplaceBean)o;
        }
    }

    private boolean isInitialCall() {
        return (this.getJsp().getRequest().getParameter("action") == null || !this.getJsp().getRequest().getParameter("action").equals(PARAM_ACTION_VALUE_FOR_CHANGED_INDEX)) && this.getJsp().getRequest().getParameter("indexName.0") == null;
    }
}

