/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CmsIdentifiableObjectContainer<T> {
    private List<T> m_cache;
    private final List<T> m_objectList = new ArrayList<T>();
    private final Map<String, T> m_objectsById = new HashMap<String, T>();
    private final Map<String, List<T>> m_objectsListsById = new HashMap<String, List<T>>();
    private final List<CmsIdObjectElement<T>> m_orderedObjectList = new ArrayList<CmsIdObjectElement<T>>();
    private final boolean m_relativeOrdered;
    private final boolean m_uniqueIds;

    public CmsIdentifiableObjectContainer(boolean uniqueIds, boolean relativeOrdered) {
        this.m_uniqueIds = uniqueIds;
        this.m_relativeOrdered = relativeOrdered;
    }

    public void addIdentifiableObject(String id, T idObject) {
        this.m_cache = null;
        if (this.m_uniqueIds && this.m_objectsById.get(id) != null) {
            this.removeObject(id);
        }
        if (this.m_relativeOrdered) {
            float pos = 1.0f;
            if (!this.m_orderedObjectList.isEmpty()) {
                pos = this.m_orderedObjectList.get(this.m_orderedObjectList.size() - 1).getPosition() + 1.0f;
            }
            this.m_orderedObjectList.add(new CmsIdObjectElement<T>(idObject, pos));
        } else {
            this.m_objectList.add(idObject);
        }
        if (this.m_uniqueIds) {
            this.m_objectsById.put(id, idObject);
        } else {
            List<T> prevObj = this.m_objectsListsById.get(id);
            if (prevObj == null) {
                ArrayList<T> list = new ArrayList<T>();
                list.add(idObject);
                this.m_objectsListsById.put(id, list);
            } else {
                prevObj.add(idObject);
            }
        }
    }

    public void addIdentifiableObject(String id, T idObject, float position) {
        this.m_cache = null;
        if (this.m_uniqueIds && this.m_objectsById.get(id) != null) {
            this.removeObject(id);
        }
        if (this.m_relativeOrdered) {
            int pos = 0;
            for (CmsIdObjectElement<T> element : this.m_orderedObjectList) {
                if (element.getPosition() > position) break;
                ++pos;
            }
            this.m_orderedObjectList.add(pos, new CmsIdObjectElement<T>(idObject, position));
        } else {
            this.m_objectList.add((int)position, idObject);
        }
        if (this.m_uniqueIds) {
            this.m_objectsById.put(id, idObject);
        } else {
            List<T> prevObj = this.m_objectsListsById.get(id);
            if (prevObj == null) {
                ArrayList<T> list = new ArrayList<T>();
                list.add(idObject);
                this.m_objectsListsById.put(id, list);
            } else {
                prevObj.add(idObject);
            }
        }
    }

    public void clear() {
        this.m_cache = null;
        this.m_objectList.clear();
        this.m_objectsById.clear();
        this.m_orderedObjectList.clear();
        this.m_objectsListsById.clear();
    }

    public List<T> elementList() {
        if (this.m_cache != null) {
            return this.m_cache;
        }
        if (this.m_relativeOrdered) {
            ArrayList<T> objectList = new ArrayList<T>();
            for (CmsIdObjectElement<T> object : this.m_orderedObjectList) {
                objectList.add(object.getObject());
            }
            this.m_cache = Collections.unmodifiableList(objectList);
        } else {
            this.m_cache = Collections.unmodifiableList(this.m_objectList);
        }
        return this.m_cache;
    }

    public T getObject(String id) {
        if (!this.m_uniqueIds) {
            throw new UnsupportedOperationException("Not supported for not unique ids");
        }
        return this.m_objectsById.get(id);
    }

    public List<T> getObjectList(String id) {
        if (this.m_uniqueIds) {
            throw new UnsupportedOperationException("Not supported for unique ids");
        }
        return this.m_objectsListsById.get(id);
    }

    public synchronized void removeObject(String id) {
        this.m_cache = null;
        if (this.m_relativeOrdered) {
            if (this.m_uniqueIds) {
                T o = this.getObject(id);
                Iterator<CmsIdObjectElement<T>> itObjs = this.m_orderedObjectList.iterator();
                while (itObjs.hasNext()) {
                    CmsIdObjectElement<T> object = itObjs.next();
                    if (object.getObject() != o) continue;
                    itObjs.remove();
                    break;
                }
                this.m_objectsById.remove(id);
            } else {
                block1: for (T o : this.m_objectsListsById.get(id)) {
                    Iterator<CmsIdObjectElement<T>> itObjs = this.m_orderedObjectList.iterator();
                    while (itObjs.hasNext()) {
                        CmsIdObjectElement<T> object = itObjs.next();
                        if (object.getObject() != o) continue;
                        itObjs.remove();
                        continue block1;
                    }
                }
                this.m_orderedObjectList.remove(id);
            }
        } else {
            T o = this.getObject(id);
            this.m_objectList.remove(o);
            if (this.m_uniqueIds) {
                this.m_objectsById.remove(id);
            } else {
                this.m_objectsListsById.remove(id);
            }
        }
    }

    private static class CmsIdObjectElement<T> {
        private final T m_object;
        private final float m_position;

        public CmsIdObjectElement(T object, float position) {
            this.m_object = object;
            this.m_position = position;
        }

        public T getObject() {
            return this.m_object;
        }

        public float getPosition() {
            return this.m_position;
        }
    }
}

