/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;
import org.opencms.workplace.tools.CmsTool;
import org.opencms.workplace.tools.CmsToolMacroResolver;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.Messages;

public class CmsToolDialog
extends CmsWorkplace {
    public static final String PARAM_BASE = "base";
    public static final String PARAM_FORCE = "force";
    public static final String PARAM_PATH = "path";
    public static final String PARAM_ROOT = "root";
    public static final String PARAM_STYLE = "style";
    public static final String STYLE_NEW = "new";
    private String m_paramBase;
    private String m_paramForce;
    private String m_paramPath;
    private String m_paramRoot;
    private String m_paramStyle;
    public static final String PARAM_ADMIN_PROJECT = "adminProject";

    public CmsToolDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public String dialogScriptSubmit() {
        StringBuffer html = new StringBuffer(512);
        html.append("function submitAction(actionValue, theForm, formName) {\n");
        html.append("\tif (theForm == null) {\n");
        html.append("\t\ttheForm = document.forms[formName];\n");
        html.append("\t}\n");
        html.append("\ttry {\n");
        html.append("\t\ttheForm.").append("framename").append(".value = window.name;\n");
        html.append("\t} catch (e) {}\n");
        html.append("\tif (actionValue == 'ok') {\n");
        html.append("\t\tloadingOn();\n");
        html.append("\t\treturn true;\n");
        html.append("\t}\n");
        html.append("\ttheForm.action.value = actionValue;\n");
        html.append("\tsubmitForm(theForm);\n");
        html.append("\treturn true;\n");
        html.append("}\n");
        return html.toString();
    }

    public String dialogTitle() {
        StringBuffer html = new StringBuffer(512);
        String toolPath = this.getCurrentToolPath();
        String parentPath = this.getParentPath();
        String rootKey = this.getToolManager().getCurrentRoot(this).getKey();
        String upLevelLink = this.computeUpLevelLink();
        String parentName = this.getToolManager().resolveAdminTool(rootKey, parentPath).getHandler().getName();
        html.append(this.getToolManager().generateNavBar(toolPath, this));
        html.append("<div class='screenTitle'>\n");
        html.append("\t<table width='100%' cellspacing='0'>\n");
        html.append("\t\t<tr>\n");
        html.append("\t\t\t<td>\n");
        html.append(CmsEncoder.decode(CmsToolMacroResolver.resolveMacros(this.getAdminTool().getHandler().getName(), this)));
        html.append("\n\t\t\t</td>");
        if (!this.getParentPath().equals(toolPath)) {
            html.append("\t\t\t<td class='uplevel'>\n\t\t\t\t");
            html.append(A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, "id-up-level", Messages.get().getBundle(this.getLocale()).key("GUI_ADMIN_VIEW_UPLEVEL_0"), parentName, true, "admin/images/up.png", null, "openPage('" + upLevelLink + "');"));
            html.append("\n\t\t\t</td>\n");
        }
        html.append("\t\t</tr>\n");
        html.append("\t</table>\n");
        html.append("</div>\n");
        return CmsToolMacroResolver.resolveMacros(html.toString(), this);
    }

    public CmsTool getAdminTool() {
        return this.getToolManager().getCurrentTool(this);
    }

    public String getCurrentToolPath() {
        return this.getToolManager().getCurrentToolPath(this);
    }

    public String getParamBase() {
        return this.m_paramBase;
    }

    public String getParamForce() {
        return this.m_paramForce;
    }

    public String getParamPath() {
        return this.m_paramPath;
    }

    public String getParamRoot() {
        return this.m_paramRoot;
    }

    public String getParamStyle() {
        return this.m_paramStyle;
    }

    public String getParentPath() {
        return this.getToolManager().getParent(this, this.getCurrentToolPath());
    }

    public CmsToolManager getToolManager() {
        return OpenCms.getWorkplaceManager().getToolManager();
    }

    public String iconsBlockArea(int segment, String headline) {
        StringBuffer result = new StringBuffer(512);
        if (segment == 0) {
            result.append("<!-- icons block area start -->\n");
            result.append("<div class=\"dialogcontent\" unselectable=\"on\">");
            result.append("<fieldset class=\"dialogblock\">\n");
            result.append("<legend>");
            result.append("<span class=\"textbold");
            result.append("\" unselectable=\"on\">");
            result.append(headline);
            result.append("</span></legend>\n");
            result.append("\t\t<table class='toolsArea' width='100%' cellspacing='0' cellpadding='0' border='0'>\n");
            result.append("\t\t\t<tr><td>\n");
        } else {
            result.append("\t\t\t</td></tr>\n");
            result.append("\t\t</table>\n");
            result.append("</fieldset></div>\n");
            result.append("<p>&nbsp;</p>\n");
            result.append("<!-- icons block area end -->\n");
        }
        return result.toString();
    }

    public String iconsBlockAreaEnd() {
        return this.iconsBlockArea(1, null);
    }

    public String iconsBlockAreaStart(String headline) {
        return this.iconsBlockArea(0, headline);
    }

    public Map<String, String[]> initAdminTool() throws CmsRoleViolationException {
        HashMap<String, String[]> params = new HashMap<String, String[]>(this.getParameterMap());
        this.getToolManager().initParams(this);
        if (!this.useNewStyle()) {
            params.put(PARAM_STYLE, new String[]{STYLE_NEW});
            this.setParamStyle(STYLE_NEW);
        }
        try {
            CmsDialog wp = (CmsDialog)this;
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(wp.getParamCloseLink()) && !this.getToolManager().getBaseToolPath(this).equals(this.getToolManager().getCurrentToolPath(this))) {
                Map<String, String[]> args = this.getToolManager().resolveAdminTool(this.getParamRoot(), this.getParentPath()).getHandler().getParameters(wp);
                wp.setParamCloseLink(CmsToolManager.linkForToolPath(this.getJsp(), this.getParentPath(), args));
                params.put("closelink", new String[]{wp.getParamCloseLink()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.getToolManager().getCurrentTool(this).getHandler().isEnabled(this)) {
            throw new CmsRoleViolationException(Messages.get().container("ERR_ADMIN_INSUFFICIENT_RIGHTS_0"));
        }
        return params;
    }

    @Override
    public String pageBody(int segment, String className, String parameters) {
        if (!this.useNewStyle()) {
            return super.pageBody(segment, className, parameters);
        }
        Map<String, String> data = CmsStringUtil.extendAttribute(parameters, "onLoad", "bodyLoad();");
        String onLoad = data.get("value");
        String myPars = data.get("text");
        data = CmsStringUtil.extendAttribute(myPars, "onUnload", "bodyUnload();");
        String onUnload = data.get("value");
        myPars = data.get("text");
        if (segment == 0) {
            StringBuffer html = new StringBuffer(512);
            html.append("</head>\n");
            html.append("<body onLoad=");
            html.append(onLoad);
            html.append(" onUnload=");
            html.append(onUnload);
            html.append(CmsStringUtil.isNotEmpty(className) ? " class='" + className + "'" : "");
            html.append(CmsStringUtil.isNotEmpty(myPars) ? " " + myPars : "");
            html.append(">\n");
            html.append("\t<table border='0' cellspacing='0' cellpadding='0' id='loaderContainer' onClick='return false;'>\n");
            html.append("\t\t<tr><td id='loaderContainerH'><div id='loader'>\n");
            html.append("\t\t\t<table border='0' cellpadding='0' cellspacing='0' width='100%'><tr><td>\n");
            html.append("\t\t\t\t<p><img src='");
            html.append(CmsToolDialog.getSkinUri());
            html.append("commons/wait.gif");
            html.append("' height='32' width='32' alt=''/>\n");
            html.append("\t\t\t\t<strong>");
            html.append(Messages.get().getBundle(this.getLocale()).key("GUI_ADMIN_VIEW_LOADING_0"));
            html.append("</strong></p>\n");
            html.append("\t\t\t</td></tr></table>\n");
            html.append("\t\t</div></td></tr>\n");
            html.append("\t</table>\n");
            html.append("\t<table width='100%' cellspacing='0' cellpadding='0' border='0'><tr><td id='screenH'>\n");
            return html.toString();
        }
        StringBuffer html = new StringBuffer(128);
        html.append("\t</td></tr></table>\n");
        html.append("</body>");
        return html.toString();
    }

    @Override
    public String pageHtmlStyle(int segment, String title, String stylesheet) {
        if (!this.useNewStyle() || segment != 0) {
            return super.pageHtmlStyle(segment, title, stylesheet);
        }
        StringBuffer html = new StringBuffer(512);
        html.append("<!DOCTYPE html>\n");
        html.append("<html>\n");
        html.append("<head>\n");
        html.append("<meta http-equiv='Content-Type' content='text/html; charset=");
        html.append(this.getEncoding());
        html.append("' >\n");
        if (title != null) {
            html.append("<title>");
            html.append(title);
            html.append("</title>\n");
        } else {
            html.append("<title></title>\n");
        }
        html.append("<link rel='stylesheet' type='text/css' href='");
        html.append(CmsToolDialog.getStyleUri(this.getJsp()));
        html.append("new_admin.css'>\n");
        html.append("<script type='text/javascript' src='");
        html.append(CmsToolDialog.getSkinUri());
        html.append("admin/javascript/general.js'></script>\n");
        html.append("<script type='text/javascript' src='");
        html.append(this.getResourceUri());
        html.append("editors/xmlcontent/help.js'></script>\n\n");
        html.append("<script type='text/javascript'>\n");
        html.append("\tfunction bodyLoad() {\n");
        html.append("\t\tsetContext(\"");
        html.append(CmsStringUtil.escapeJavaScript(this.resolveMacros(this.getAdminTool().getHandler().getHelpText())));
        html.append("\");\n");
        html.append("\t\tsetActiveItemByName(\"");
        html.append(this.getCurrentToolPath());
        html.append("\");\n");
        html.append("\t\tloadingOff();\n");
        html.append("\t\ttry {\n");
        html.append("\t\t\tdocument.getElementById('loaderContainerH').height = wHeight();\n");
        html.append("\t\t} catch (e) {}\n");
        html.append("\t}\n");
        html.append("\tfunction bodyUnload() {\n");
        html.append("\t\tloadingOn();\n");
        html.append("\t}\n");
        html.append("</script>\n");
        return html.toString();
    }

    public void setParamBase(String paramBase) {
        this.m_paramBase = paramBase;
    }

    public void setParamForce(String paramForce) {
        this.m_paramForce = paramForce;
    }

    public void setParamPath(String paramPath) {
        this.m_paramPath = paramPath;
    }

    public void setParamRoot(String paramRoot) {
        this.m_paramRoot = paramRoot;
    }

    public void setParamStyle(String paramStyle) {
        this.m_paramStyle = paramStyle;
    }

    public boolean useNewStyle() {
        return this.getParamStyle() != null && this.getParamStyle().equals(STYLE_NEW);
    }

    protected String computeUpLevelLink() {
        String parentPath = this.getParentPath();
        String rootKey = this.getToolManager().getCurrentRoot(this).getKey();
        CmsTool parentTool = this.getToolManager().resolveAdminTool(rootKey, parentPath);
        String upLevelLink = CmsToolManager.linkForToolPath(this.getJsp(), parentPath, parentTool.getHandler().getParameters(this));
        upLevelLink = CmsRequestUtil.appendParameter(upLevelLink, PARAM_FORCE, Boolean.TRUE.toString());
        return upLevelLink;
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
    }
}

