/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerElementBean;

public class CmsContainerBean {
    private transient Map<CmsUUID, Boolean> m_containsElement;
    private boolean m_detailOnly;
    private transient List<CmsUUID> m_elementIds;
    private final List<CmsContainerElementBean> m_elements;
    private int m_maxElements;
    private final String m_name;
    private String m_param;
    private String m_parentInstanceId;
    private String m_type;
    private String m_width;

    public CmsContainerBean(String name, String type, String parentInstanceId, int maxElements, List<CmsContainerElementBean> elements) {
        this.m_name = name;
        this.m_type = type;
        this.m_parentInstanceId = parentInstanceId;
        this.m_maxElements = maxElements;
        this.m_elements = elements == null ? Collections.emptyList() : Collections.unmodifiableList(elements);
    }

    public CmsContainerBean(String name, String type, String parentInstanceId, List<CmsContainerElementBean> elements) {
        this(name, type, parentInstanceId, -1, elements);
    }

    public boolean containsElement(CmsUUID elementId) {
        return this.getElementIds().contains(elementId);
    }

    public Map<CmsUUID, Boolean> getContainsElement() {
        if (this.m_containsElement == null) {
            this.m_containsElement = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object input) {
                    return CmsContainerBean.this.containsElement((CmsUUID)input);
                }
            });
        }
        return this.m_containsElement;
    }

    public List<CmsUUID> getElementIds() {
        if (this.m_elementIds == null) {
            this.m_elementIds = new ArrayList<CmsUUID>(this.m_elements.size());
            for (CmsContainerElementBean element : this.m_elements) {
                this.m_elementIds.add(element.getId());
            }
        }
        return this.m_elementIds;
    }

    public List<CmsContainerElementBean> getElements() {
        return this.m_elements;
    }

    public int getMaxElements() {
        return this.m_maxElements;
    }

    public String getName() {
        return this.m_name;
    }

    public String getParam() {
        return this.m_param;
    }

    public String getParentInstanceId() {
        return this.m_parentInstanceId;
    }

    public String getType() {
        return this.m_type;
    }

    public String getWidth() {
        return this.m_width;
    }

    public boolean isDetailOnly() {
        return this.m_detailOnly;
    }

    public boolean isNestedContainer() {
        return CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_parentInstanceId);
    }

    public void setDetailOnly(boolean detailOnly) {
        this.m_detailOnly = detailOnly;
    }

    public void setMaxElements(int maxElements) {
        this.m_maxElements = maxElements;
    }

    public void setParam(String param) {
        this.m_param = param;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setWidth(String width) {
        this.m_width = width;
    }
}

