/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.loader.I_CmsFileNameGenerator;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsMappingResolutionContext {
    private static final Log LOG = CmsLog.getLog(CmsMappingResolutionContext.class);
    private CmsObject m_cms;
    private List<InternalUrlNameMappingEntry> m_urlNameMappingEntries = Lists.newArrayList();

    public void commitUrlNameMappings() throws CmsException {
        HashSet structureIds = Sets.newHashSet();
        for (InternalUrlNameMappingEntry entry : this.m_urlNameMappingEntries) {
            structureIds.add(entry.getStructureId());
        }
        boolean urlnameReplace = false;
        for (CmsUUID structureId : structureIds) {
            try {
                CmsResource resource = this.m_cms.readResource(structureId, CmsResourceFilter.ALL);
                CmsProperty prop = this.m_cms.readPropertyObject(resource, "urlname.replace", true);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(prop.getValue())) continue;
                urlnameReplace = Boolean.parseBoolean(prop.getValue());
            }
            catch (CmsException e) {
                LOG.error((Object)("Error while trying to read urlname.replace: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        I_CmsFileNameGenerator nameGen = OpenCms.getResourceManager().getNameGenerator();
        for (InternalUrlNameMappingEntry entry : this.m_urlNameMappingEntries) {
            Iterator<String> nameSeq = nameGen.getUrlNameSequence(entry.getName());
            this.m_cms.writeUrlNameMapping(nameSeq, entry.getStructureId(), entry.getLocale().toString(), urlnameReplace);
        }
    }

    public void finalizeMappings() throws CmsException {
        this.commitUrlNameMappings();
    }

    public void setCmsObject(CmsObject cms) {
        this.m_cms = cms;
    }

    void addUrlNameMapping(String name, Locale locale, CmsUUID structureId) {
        this.m_urlNameMappingEntries.add(new InternalUrlNameMappingEntry(structureId, name, locale));
    }

    class InternalUrlNameMappingEntry {
        private Locale m_locale;
        private String m_name;
        private CmsUUID m_structureId;

        public InternalUrlNameMappingEntry(CmsUUID structureId, String name, Locale locale) {
            this.m_name = name;
            this.m_structureId = structureId;
            this.m_locale = locale;
        }

        public Locale getLocale() {
            return this.m_locale;
        }

        public String getName() {
            return this.m_name;
        }

        public CmsUUID getStructureId() {
            return this.m_structureId;
        }
    }
}

