/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.inherited;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.I_CmsGlobalConfigurationCache;
import org.opencms.ade.containerpage.inherited.CmsContainerConfiguration;
import org.opencms.ade.containerpage.inherited.CmsContainerConfigurationGroup;
import org.opencms.ade.containerpage.inherited.CmsContainerConfigurationParser;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsUUID;

public class CmsContainerConfigurationCache
implements I_CmsGlobalConfigurationCache {
    public static final String INHERITANCE_CONFIG_FILE_NAME = ".inherited";
    public static final Log LOG = CmsLog.getLog(CmsContainerConfigurationCache.class);
    protected boolean m_initialized;
    private CmsObject m_cms;
    private Map<String, CmsContainerConfigurationGroup> m_configurationsByPath = new HashMap<String, CmsContainerConfigurationGroup>();
    private String m_name;
    private Map<String, CmsUUID> m_needToUpdate = new HashMap<String, CmsUUID>();

    public CmsContainerConfigurationCache(CmsObject cms, String name) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        this.m_name = name;
    }

    @Override
    public synchronized void clear() {
        this.m_initialized = false;
        this.m_needToUpdate.clear();
        this.m_configurationsByPath.clear();
    }

    public synchronized CmsContainerConfiguration getContainerConfiguration(String rootPath, String name) {
        this.readRemainingConfigurations();
        String key = this.getCacheKey(rootPath);
        if (this.m_configurationsByPath.containsKey(key)) {
            CmsContainerConfigurationGroup group = this.m_configurationsByPath.get(key);
            CmsContainerConfiguration result = group.getConfiguration(name);
            return result;
        }
        return null;
    }

    public synchronized void initialize() {
        this.m_initialized = false;
    }

    @Override
    public synchronized void remove(CmsPublishedResource resource) {
        this.remove(resource.getStructureId(), resource.getRootPath(), resource.getType());
    }

    @Override
    public synchronized void remove(CmsResource resource) {
        this.remove(resource.getStructureId(), resource.getRootPath(), resource.getTypeId());
    }

    @Override
    public synchronized void update(CmsPublishedResource resource) {
        this.update(resource.getStructureId(), resource.getRootPath(), resource.getType(), resource.getState());
    }

    @Override
    public synchronized void update(CmsResource resource) {
        this.update(resource.getStructureId(), resource.getRootPath(), resource.getTypeId(), resource.getState());
    }

    protected String getBasePath(String rootPath) {
        if (rootPath.endsWith(INHERITANCE_CONFIG_FILE_NAME)) {
            return rootPath.substring(0, rootPath.length() - INHERITANCE_CONFIG_FILE_NAME.length());
        }
        return rootPath;
    }

    protected String getCacheKey(String basePath) {
        assert (!basePath.endsWith(INHERITANCE_CONFIG_FILE_NAME));
        return CmsFileUtil.addTrailingSeparator(basePath);
    }

    protected boolean isContainerConfiguration(String rootPath, int type) {
        try {
            int expectedId = OpenCms.getResourceManager().getResourceType("inheritance_config").getTypeId();
            return type == expectedId && !CmsResource.isTemporaryFileName(rootPath) && rootPath.endsWith("/.inherited");
        }
        catch (CmsLoaderException e) {
            return false;
        }
    }

    protected void load(CmsResource configResource) {
        if (!this.isContainerConfiguration(configResource.getRootPath(), configResource.getTypeId())) {
            return;
        }
        String basePath = this.getBasePath(configResource.getRootPath());
        try {
            CmsFile file = this.m_cms.readFile(configResource);
            CmsContainerConfigurationParser parser = new CmsContainerConfigurationParser(this.m_cms);
            LOG.trace((Object)("inherited-container-cache " + this.m_name + " load"));
            parser.parse(file);
            CmsContainerConfigurationGroup group = new CmsContainerConfigurationGroup(parser.getParsedResults());
            this.m_configurationsByPath.put(this.getCacheKey(basePath), group);
            this.m_needToUpdate.remove(configResource.getRootPath());
        }
        catch (CmsException e) {
            this.m_configurationsByPath.remove(this.getCacheKey(basePath));
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            this.m_configurationsByPath.remove(this.getCacheKey(basePath));
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected synchronized void readRemainingConfigurations() {
        if (!this.m_initialized) {
            LOG.trace((Object)("inherited-container-cache " + this.m_name + " initialize"));
            this.m_configurationsByPath.clear();
            try {
                List<CmsResource> configurationResources = this.m_cms.readResources("/", CmsResourceFilter.DEFAULT.addRequireType(this.safeGetType()), true);
                for (CmsResource configResource : configurationResources) {
                    this.load(configResource);
                }
                this.m_initialized = true;
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            HashMap<String, CmsUUID> needToUpdate = new HashMap<String, CmsUUID>(this.m_needToUpdate);
            for (Map.Entry entry : needToUpdate.entrySet()) {
                String cacheKey;
                String rootPath = (String)entry.getKey();
                CmsUUID structureId = (CmsUUID)entry.getValue();
                CmsResource resource = null;
                try {
                    LOG.trace((Object)("inherited-container-cache " + this.m_name + " readSingleResource"));
                    resource = this.m_cms.readResource(structureId);
                    this.load(resource);
                }
                catch (CmsException e) {
                    cacheKey = this.getCacheKey(this.getBasePath(rootPath));
                    this.m_configurationsByPath.remove(cacheKey);
                }
                catch (RuntimeException e) {
                    cacheKey = this.getCacheKey(this.getBasePath(rootPath));
                    this.m_configurationsByPath.remove(cacheKey);
                }
            }
            this.m_needToUpdate.clear();
        }
    }

    protected synchronized void remove(CmsUUID structureId, String rootPath, int type) {
        if (!this.isContainerConfiguration(rootPath, type)) {
            return;
        }
        String basePath = this.getBasePath(rootPath);
        this.m_configurationsByPath.remove(basePath);
        this.m_needToUpdate.remove(rootPath);
    }

    protected int safeGetType() {
        try {
            return OpenCms.getResourceManager().getResourceType("inheritance_config").getTypeId();
        }
        catch (CmsLoaderException e) {
            return -1;
        }
    }

    protected synchronized void update(CmsUUID structureId, String rootPath, int type, CmsResourceState state) {
        if (!this.isContainerConfiguration(rootPath, type)) {
            return;
        }
        String basePath = this.getBasePath(rootPath);
        this.m_configurationsByPath.remove(basePath);
        this.m_needToUpdate.put(rootPath, structureId);
    }
}

