/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.shared;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opencms.ade.containerpage.shared.CmsContainerElement;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.ade.containerpage.shared.CmsInheritanceInfo;
import org.opencms.gwt.shared.CmsAdditionalInfoBean;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsContainerElementData
extends CmsContainerElement {
    private Map<String, String> m_contents;
    private String m_description;
    private String m_dndId;
    private Map<String, Map<String, CmsFormatterConfig>> m_formatters;
    private List<CmsInheritanceInfo> m_inheritanceInfos = new ArrayList<CmsInheritanceInfo>();
    private String m_inheritanceName;
    private String m_lastModifiedByUser;
    private long m_lastModifiedDate;
    private String m_navText;
    private Map<String, String> m_settings;
    private List<String> m_subItems = new ArrayList<String>();
    private String m_title;
    private Set<String> m_types;

    public Map<String, String> getContents() {
        return this.m_contents;
    }

    public Set<String> getCssResources(String containerName) {
        CmsFormatterConfig formatterConfig = this.getFormatterConfig(containerName);
        return formatterConfig != null ? formatterConfig.getCssResources() : Collections.emptySet();
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getDndId() {
        return this.m_dndId;
    }

    public List<CmsAdditionalInfoBean> getFormatedIndividualSettings(String containerId) {
        ArrayList<CmsAdditionalInfoBean> result = new ArrayList<CmsAdditionalInfoBean>();
        CmsFormatterConfig config = this.getFormatterConfig(containerId);
        if (this.m_settings != null && config != null) {
            for (Map.Entry<String, String> settingEntry : this.m_settings.entrySet()) {
                String settingKey = settingEntry.getKey();
                if (config.getSettingConfig().containsKey(settingEntry.getKey())) {
                    String niceName = config.getSettingConfig().get(settingEntry.getKey()).getNiceName();
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(config.getSettingConfig().get(settingEntry.getKey()).getNiceName())) {
                        settingKey = niceName;
                    }
                }
                result.add(new CmsAdditionalInfoBean(settingKey, settingEntry.getValue(), null));
            }
        }
        return result;
    }

    public CmsFormatterConfig getFormatterConfig(String containerName) {
        String formatterId = this.getSettings().get(CmsFormatterConfig.getSettingsKeyForContainer(containerName));
        CmsFormatterConfig formatterConfig = null;
        if (formatterId != null && this.getFormatters().containsKey(containerName) && this.getFormatters().get(containerName).containsKey(formatterId)) {
            formatterConfig = this.getFormatters().get(containerName).get(formatterId);
        } else if (this.getFormatters().containsKey(containerName) && !this.getFormatters().get(containerName).isEmpty()) {
            formatterConfig = this.getFormatters().get(containerName).values().iterator().next();
        }
        return formatterConfig;
    }

    public Map<String, Map<String, CmsFormatterConfig>> getFormatters() {
        return this.m_formatters;
    }

    public List<CmsInheritanceInfo> getInheritanceInfos() {
        if (this.isInheritContainer()) {
            return this.m_inheritanceInfos;
        }
        throw new UnsupportedOperationException("Only inherit containers have inheritance infos");
    }

    public String getInheritanceName() {
        return this.m_inheritanceName;
    }

    public String getLastModifiedByUser() {
        return this.m_lastModifiedByUser;
    }

    public long getLastModifiedDate() {
        return this.m_lastModifiedDate;
    }

    public String getNavText() {
        return this.m_navText;
    }

    public Map<String, CmsXmlContentProperty> getSettingConfig(String containerName) {
        CmsFormatterConfig formatterConfig = this.getFormatterConfig(containerName);
        return formatterConfig != null ? formatterConfig.getSettingConfig() : Collections.emptyMap();
    }

    public Map<String, String> getSettings() {
        return this.m_settings;
    }

    public List<String> getSubItems() {
        if (this.isGroupContainer()) {
            return this.m_subItems;
        }
        if (this.isInheritContainer()) {
            ArrayList<String> result = new ArrayList<String>();
            for (CmsInheritanceInfo info : this.m_inheritanceInfos) {
                if (!info.isVisible()) continue;
                result.add(info.getClientId());
            }
            return result;
        }
        throw new UnsupportedOperationException("Only group or inherit containers have sub-items");
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    public Set<String> getTypes() {
        return this.m_types;
    }

    public boolean hasAlternativeFormatters(String containerName) {
        return this.m_formatters.get(containerName) != null && this.m_formatters.get(containerName).size() > 1;
    }

    @Override
    public boolean hasSettings(String containerId) {
        CmsFormatterConfig config = this.getFormatterConfig(containerId);
        return config != null && (!config.getSettingConfig().isEmpty() || this.hasAlternativeFormatters(containerId));
    }

    public boolean isShowInContext(String currentContext) {
        if (this.m_settings == null || !this.m_settings.containsKey("templateContexts") || CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_settings.get("templateContexts"))) {
            return true;
        }
        return CmsStringUtil.splitAsList(this.m_settings.get("templateContexts"), "|").contains(currentContext);
    }

    public void setContents(Map<String, String> contents) {
        this.m_contents = contents;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setDndId(String dndId) {
        this.m_dndId = dndId;
    }

    public void setFormatters(Map<String, Map<String, CmsFormatterConfig>> formatters) {
        this.m_formatters = formatters;
    }

    public void setInheritanceInfos(List<CmsInheritanceInfo> inheritanceInfos) {
        this.m_inheritanceInfos = inheritanceInfos;
    }

    public void setInheritanceName(String inheritanceName) {
        this.m_inheritanceName = inheritanceName;
    }

    public void setLastModifiedByUser(String lastModifiedByUser) {
        this.m_lastModifiedByUser = lastModifiedByUser;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.m_lastModifiedDate = lastModifiedDate;
    }

    public void setNavText(String navText) {
        this.m_navText = navText;
    }

    public void setSettings(Map<String, String> settings) {
        this.m_settings = settings;
    }

    public void setSubItems(List<String> subItems) {
        this.m_subItems = subItems;
    }

    @Override
    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setTypes(Set<String> types) {
        this.m_types = types;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Title: ").append(this.getTitle()).append("  File: ").append(this.getSitePath()).append("  ClientId: ").append(this.getClientId());
        return result.toString();
    }
}

