/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.ade.contenteditor.ClientMessages;
import org.opencms.ade.contenteditor.CmsContentService;
import org.opencms.ade.contenteditor.Messages;
import org.opencms.ade.contenteditor.shared.CmsContentDefinition;
import org.opencms.ade.contenteditor.shared.CmsExternalWidgetConfiguration;
import org.opencms.ade.contenteditor.shared.rpc.I_CmsContentService;
import org.opencms.ade.galleries.CmsGalleryActionElement;
import org.opencms.ade.publish.CmsPublishActionElement;
import org.opencms.ade.upload.CmsUploadActionElement;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsContentEditorActionElement
extends CmsGwtActionElement {
    public static final String CMS_MODULE_NAME = "org.opencms.ade.contenteditor";
    public static final String GWT_MODULE_NAME = "contenteditor";

    public CmsContentEditorActionElement(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    @Override
    public String export() throws Exception {
        return ClientMessages.get().export(this.getRequest());
    }

    @Override
    public String exportAll() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.export());
        sb.append(new CmsGalleryActionElement(null, this.getRequest(), null).exportWidget());
        sb.append(new CmsUploadActionElement(this.getJspContext(), this.getRequest(), this.getResponse()).export());
        sb.append(this.export());
        sb.append(CmsContentEditorActionElement.createNoCacheScript(GWT_MODULE_NAME, OpenCms.getModuleManager().getModule(CMS_MODULE_NAME).getVersion().toString()));
        sb.append(new CmsPublishActionElement(this.getJspContext(), this.getRequest(), this.getResponse()).export());
        sb.append(this.getPrefetch());
        return sb.toString();
    }

    private void addExternalResourceTags(StringBuffer sb, CmsContentDefinition definition) {
        HashSet<String> includedScripts = new HashSet<String>();
        HashSet<String> includedStyles = new HashSet<String>();
        for (CmsExternalWidgetConfiguration configuration : definition.getExternalWidgetConfigurations()) {
            for (String css : configuration.getCssResourceLinks()) {
                if (includedStyles.contains(css)) continue;
                sb.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"").append(css).append("\"></link>");
                includedStyles.add(css);
            }
            for (String script : configuration.getJavaScriptResourceLinks()) {
                if (includedScripts.contains(script)) continue;
                sb.append("<script type=\"text/javascript\" src=\"").append(script).append("\"></script>");
                includedScripts.add(script);
            }
        }
    }

    private String getPrefetch() throws Exception {
        long timer = 0L;
        if (CmsContentService.LOG.isDebugEnabled()) {
            timer = System.currentTimeMillis();
        }
        CmsContentDefinition definition = CmsContentService.prefetch(this.getRequest());
        StringBuffer sb = new StringBuffer();
        String backlink = this.getRequest().getParameter("backlink");
        backlink = CmsStringUtil.isEmptyOrWhitespaceOnly(backlink) ? this.link("/system/workplace/views/workplace.jsp") : this.link(backlink);
        sb.append(CmsContentEditorActionElement.wrapScript("backlink", "='", backlink, "';\n"));
        String prefetchedData = CmsContentEditorActionElement.exportDictionary("com_alkacon_acacia_shared_ContentDefinition", I_CmsContentService.class.getMethod("prefetch", new Class[0]), definition);
        sb.append(prefetchedData);
        this.addExternalResourceTags(sb, definition);
        if (CmsContentService.LOG.isDebugEnabled()) {
            CmsContentService.LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_PREFETCHING_TIME_FOR_RESOURCE_2", definition.getSitePath(), "" + (System.currentTimeMillis() - timer)));
        }
        return sb.toString();
    }
}

