/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor.shared;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opencms.acacia.shared.CmsAttributeConfiguration;
import org.opencms.acacia.shared.CmsEntity;
import org.opencms.acacia.shared.CmsEntityAttribute;
import org.opencms.acacia.shared.CmsTabInfo;
import org.opencms.acacia.shared.CmsType;
import org.opencms.ade.contenteditor.shared.CmsComplexWidgetData;
import org.opencms.ade.contenteditor.shared.CmsExternalWidgetConfiguration;
import org.opencms.gwt.shared.CmsModelResourceInfo;
import org.opencms.util.CmsUUID;

public class CmsContentDefinition
extends org.opencms.acacia.shared.CmsContentDefinition {
    private static final String ENTITY_ID_PREFIX = "http://opencms.org/resources/";
    private boolean m_autoUnlock;
    private Map<String, String> m_availableLocales;
    private Map<String, CmsComplexWidgetData> m_complexWidgetData;
    private List<String> m_contentLocales;
    private boolean m_deleteOnCancel;
    private List<CmsExternalWidgetConfiguration> m_externalWidgetConfigurations;
    private boolean m_isDirectEdit;
    private List<CmsModelResourceInfo> m_modelInfos;
    private String m_newLink;
    private boolean m_performedAutocorrection;
    private CmsUUID m_referenceResourceId;
    private String m_resourceType;
    private String m_sitePath;
    private Collection<String> m_skipPaths;
    private List<String> m_synchronizations;
    private Map<String, String> m_syncValues;
    private String m_title;
    private Set<String> m_editorChangeScopes;

    public CmsContentDefinition(List<CmsModelResourceInfo> modelInfos, String newLink, CmsUUID referenceId, String locale) {
        super(null, null, null, null, null, true, locale);
        this.m_modelInfos = modelInfos;
        this.m_newLink = newLink;
        this.m_referenceResourceId = referenceId;
    }

    public CmsContentDefinition(String entityId, Map<String, CmsEntity> entities, Map<String, CmsAttributeConfiguration> configurations, Collection<CmsExternalWidgetConfiguration> externalWidgetConfigurations, Map<String, CmsComplexWidgetData> complexWidgetData, Map<String, CmsType> types, List<CmsTabInfo> tabInfos, String locale, List<String> contentLocales, Map<String, String> availableLocales, List<String> synchronizations, Map<String, String> syncValues, Collection<String> skipPaths, String title, String sitePath, String resourceType, boolean performedAutocorrection, boolean autoUnlock, Set<String> editorChangeScopes) {
        super(entityId, entities, configurations, types, tabInfos, true, locale);
        this.m_contentLocales = contentLocales;
        this.m_availableLocales = availableLocales;
        this.m_synchronizations = synchronizations;
        this.m_syncValues = syncValues;
        this.m_skipPaths = skipPaths;
        this.m_complexWidgetData = complexWidgetData;
        this.m_title = title;
        this.m_sitePath = sitePath;
        this.m_resourceType = resourceType;
        this.m_externalWidgetConfigurations = new ArrayList<CmsExternalWidgetConfiguration>(externalWidgetConfigurations);
        this.m_performedAutocorrection = performedAutocorrection;
        this.m_autoUnlock = autoUnlock;
        this.m_editorChangeScopes = editorChangeScopes;
    }

    protected CmsContentDefinition() {
    }

    public static CmsUUID entityIdToUuid(String entityId) {
        if (entityId.startsWith(ENTITY_ID_PREFIX)) {
            entityId = entityId.substring(entityId.lastIndexOf("/") + 1);
        }
        return new CmsUUID(entityId);
    }

    public static String getLocaleFromId(String entityId) {
        if (entityId.startsWith(ENTITY_ID_PREFIX)) {
            return entityId.substring(ENTITY_ID_PREFIX.length(), entityId.lastIndexOf("/"));
        }
        return null;
    }

    public static String getValueForPath(CmsEntity entity, String path) {
        CmsEntityAttribute attribute;
        String attributeName;
        String result = null;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.contains("/")) {
            attributeName = path.substring(0, path.indexOf("/"));
            path = path.substring(path.indexOf("/"));
        } else {
            attributeName = path;
            path = null;
        }
        int index = org.opencms.acacia.shared.CmsContentDefinition.extractIndex(attributeName);
        if (index > 0) {
            --index;
        }
        if (!((attribute = entity.getAttribute(attributeName = entity.getTypeName() + "/" + org.opencms.acacia.shared.CmsContentDefinition.removeIndex(attributeName))) == null || attribute.isComplexValue() && path == null)) {
            if (attribute.isSimpleValue()) {
                if (path == null && attribute.getValueCount() > 0) {
                    List<String> values = attribute.getSimpleValues();
                    result = values.get(index);
                }
            } else if (attribute.getValueCount() > index) {
                List<CmsEntity> values = attribute.getComplexValues();
                result = CmsContentDefinition.getValueForPath(values.get(index), path);
            }
        }
        return result;
    }

    public static void transferValues(CmsEntity original, CmsEntity target, List<String> transferAttributes, Map<String, CmsType> entityTypes, Map<String, CmsAttributeConfiguration> attributeConfigurations, boolean considerDefaults) {
        CmsType entityType = entityTypes.get(target.getTypeName());
        for (String attributeName : entityType.getAttributeNames()) {
            CmsEntityAttribute originalAttribute;
            CmsType attributeType = entityTypes.get(entityType.getAttributeTypeName(attributeName));
            if (transferAttributes.contains(attributeName)) {
                CmsEntityAttribute attribute;
                target.removeAttribute(attributeName);
                CmsEntityAttribute cmsEntityAttribute = attribute = original != null ? original.getAttribute(attributeName) : null;
                if (attribute != null) {
                    if (attributeType.isSimpleType()) {
                        for (String value : attribute.getSimpleValues()) {
                            target.addAttributeValue(attributeName, value);
                        }
                        if (!considerDefaults) continue;
                        for (int i = attribute.getValueCount(); i < entityType.getAttributeMinOccurrence(attributeName); ++i) {
                            target.addAttributeValue(attributeName, attributeConfigurations.get(attributeName).getDefaultValue());
                        }
                        continue;
                    }
                    for (CmsEntity value : attribute.getComplexValues()) {
                        target.addAttributeValue(attributeName, value);
                    }
                    if (!considerDefaults) continue;
                    for (int i = attribute.getValueCount(); i < entityType.getAttributeMinOccurrence(attributeName); ++i) {
                        target.addAttributeValue(attributeName, CmsContentDefinition.createDefaultValueEntity(attributeType, entityTypes, attributeConfigurations));
                    }
                    continue;
                }
                if (!considerDefaults) continue;
                for (int i = 0; i < entityType.getAttributeMinOccurrence(attributeName); ++i) {
                    if (attributeType.isSimpleType()) {
                        target.addAttributeValue(attributeName, attributeConfigurations.get(attributeName).getDefaultValue());
                        continue;
                    }
                    target.addAttributeValue(attributeName, CmsContentDefinition.createDefaultValueEntity(attributeType, entityTypes, attributeConfigurations));
                }
                continue;
            }
            if (attributeType.isSimpleType()) continue;
            CmsEntityAttribute targetAttribute = target.getAttribute(attributeName);
            CmsEntityAttribute cmsEntityAttribute = originalAttribute = original != null ? original.getAttribute(attributeName) : null;
            if (targetAttribute == null) continue;
            for (int i = 0; i < targetAttribute.getComplexValues().size(); ++i) {
                CmsEntity subTarget = targetAttribute.getComplexValues().get(i);
                CmsEntity subOriginal = originalAttribute != null && originalAttribute.getComplexValues().size() > i ? originalAttribute.getComplexValues().get(i) : null;
                CmsContentDefinition.transferValues(subOriginal, subTarget, transferAttributes, entityTypes, attributeConfigurations, considerDefaults);
            }
        }
    }

    public static String uuidToEntityId(CmsUUID uuid, String locale) {
        return ENTITY_ID_PREFIX + locale + "/" + uuid.toString();
    }

    protected static CmsEntity createDefaultValueEntity(CmsType entityType, Map<String, CmsType> entityTypes, Map<String, CmsAttributeConfiguration> attributeConfigurations) {
        CmsEntity result = new CmsEntity(null, entityType.getId());
        for (String attributeName : entityType.getAttributeNames()) {
            CmsType attributeType = entityTypes.get(entityType.getAttributeTypeName(attributeName));
            for (int i = 0; i < entityType.getAttributeMinOccurrence(attributeName); ++i) {
                if (attributeType.isSimpleType()) {
                    result.addAttributeValue(attributeName, attributeConfigurations.get(attributeName).getDefaultValue());
                    continue;
                }
                result.addAttributeValue(attributeName, CmsContentDefinition.createDefaultValueEntity(attributeType, entityTypes, attributeConfigurations));
            }
        }
        return result;
    }

    public Map<String, String> getAvailableLocales() {
        return this.m_availableLocales;
    }

    public Map<String, CmsComplexWidgetData> getComplexWidgetData() {
        return this.m_complexWidgetData;
    }

    public List<String> getContentLocales() {
        return this.m_contentLocales;
    }

    public Set<String> getEditorChangeScopes() {
        return this.m_editorChangeScopes;
    }

    public List<CmsExternalWidgetConfiguration> getExternalWidgetConfigurations() {
        return this.m_externalWidgetConfigurations;
    }

    public List<CmsModelResourceInfo> getModelInfos() {
        return this.m_modelInfos;
    }

    public String getNewLink() {
        return this.m_newLink;
    }

    public CmsUUID getReferenceResourceId() {
        return this.m_referenceResourceId;
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    public String getSitePath() {
        return this.m_sitePath;
    }

    public Collection<String> getSkipPaths() {
        return this.m_skipPaths;
    }

    public List<String> getSynchronizations() {
        return this.m_synchronizations;
    }

    public Map<String, String> getSyncValues() {
        return this.m_syncValues;
    }

    public String getTitle() {
        return this.m_title;
    }

    public boolean hasEditorChangeHandlers() {
        return this.m_editorChangeScopes != null && !this.m_editorChangeScopes.isEmpty();
    }

    public boolean hasSynchronizedElements() {
        return !this.m_synchronizations.isEmpty();
    }

    public boolean isAutoUnlock() {
        return this.m_autoUnlock;
    }

    public boolean isDeleteOnCancel() {
        return this.m_deleteOnCancel;
    }

    public boolean isDirectEdit() {
        return this.m_isDirectEdit;
    }

    public boolean isModelInfo() {
        return this.m_modelInfos != null;
    }

    public boolean isPerformedAutocorrection() {
        return this.m_performedAutocorrection;
    }

    public void setDeleteOnCancel(boolean deleteOnCancel) {
        this.m_deleteOnCancel = deleteOnCancel;
    }

    public void setDirectEdit(boolean isDirectEdit) {
        this.m_isDirectEdit = isDirectEdit;
    }
}

