/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.detailpage;

import java.util.List;
import java.util.Locale;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.util.CmsUUID;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsDetailPageConfigurationWriter {
    public static final String N_DETAIL_PAGE = "DetailPage";
    public static final String N_PAGE = "Page";
    public static final String N_TYPE = "Type";
    private CmsObject m_cms;
    private CmsXmlContent m_document;
    private CmsFile m_file;
    private CmsResource m_resource;

    public CmsDetailPageConfigurationWriter(CmsObject cms, CmsResource res) {
        this.m_cms = cms;
        this.m_resource = res;
    }

    public void updateAndSave(List<CmsDetailPageInfo> infos, CmsUUID newId) throws CmsException {
        this.getDocument();
        this.removeOldValues();
        this.writeDetailPageInfos(infos, newId);
        this.m_document.setAutoCorrectionEnabled(true);
        this.m_document.correctXmlStructure(this.m_cms);
        byte[] content = this.m_document.marshal();
        this.m_file.setContents(content);
        this.m_cms.writeFile(this.m_file);
    }

    private I_CmsXmlDocument getDocument() throws CmsException {
        if (this.m_document == null) {
            CmsXmlContent content;
            this.m_file = this.m_cms.readFile(this.m_resource);
            this.m_document = content = CmsXmlContentFactory.unmarshal(this.m_cms, this.m_file);
        }
        return this.m_document;
    }

    private Locale getLocale() throws CmsException {
        this.getDocument();
        List<Locale> locales = this.m_document.getLocales();
        if (locales.contains(Locale.ENGLISH) || locales.isEmpty()) {
            return Locale.ENGLISH;
        }
        return locales.get(0);
    }

    private void removeOldValues() throws CmsException {
        Locale locale = this.getLocale();
        I_CmsXmlContentValue value = this.m_document.getValue(N_DETAIL_PAGE, locale);
        do {
            if ((value = this.m_document.getValue(N_DETAIL_PAGE, locale)) == null) continue;
            this.m_document.removeValue(value.getPath(), locale, 0);
        } while (value != null);
    }

    private void writeDetailPageInfos(List<CmsDetailPageInfo> infos, CmsUUID newId) {
        int i = 0;
        for (CmsDetailPageInfo info : infos) {
            CmsUUID id = info.getId();
            if (id == null) {
                id = newId;
            }
            this.writeValue(info.getType(), id, i);
            ++i;
        }
    }

    private void writeValue(String type, CmsUUID id, int index) {
        Locale locale = CmsLocaleManager.getLocale("en");
        this.m_document.addValue(this.m_cms, N_DETAIL_PAGE, locale, index);
        String typePath = "DetailPage[" + (1 + index) + "]/" + N_TYPE;
        I_CmsXmlContentValue typeVal = this.m_document.getValue(typePath, locale);
        String pagePath = "DetailPage[" + (1 + index) + "]/" + N_PAGE;
        CmsXmlVfsFileValue pageVal = (CmsXmlVfsFileValue)this.m_document.getValue(pagePath, locale);
        typeVal.setStringValue(this.m_cms, type);
        pageVal.setIdValue(this.m_cms, id);
    }
}

