/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.detailpage;

import java.io.Serializable;
import org.opencms.util.CmsUUID;

public class CmsDetailPageInfo
implements Serializable {
    public static final String FUNCTION_PREFIX = "function@";
    private static final long serialVersionUID = 7714334294682534900L;
    private CmsUUID m_id;
    private String m_type;
    private String m_uri;

    public CmsDetailPageInfo(CmsUUID id, String uri, String type) {
        this.m_id = id;
        this.m_type = type;
        this.m_uri = uri;
    }

    protected CmsDetailPageInfo() {
    }

    public static String removeFunctionPrefix(String name) {
        return name.replaceFirst("^function@", "");
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof CmsDetailPageInfo) {
            CmsDetailPageInfo info = (CmsDetailPageInfo)obj;
            result = this.toString().equals(info.toString());
        }
        return result;
    }

    public String getDisplayType() {
        return this.m_type != null ? CmsDetailPageInfo.removeFunctionPrefix(this.m_type) : "";
    }

    public String getIconType() {
        if (this.m_type.startsWith(FUNCTION_PREFIX)) {
            return "function";
        }
        return this.m_type;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public String getType() {
        return this.m_type;
    }

    public String getUri() {
        return this.m_uri;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "" + this.m_type + ":" + this.m_id + this.m_uri;
    }
}

