/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.galleries.shared.CmsImageInfoBean;
import org.opencms.ade.galleries.shared.CmsResourceInfoBean;
import org.opencms.ade.galleries.shared.rpc.I_CmsPreviewService;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsImageScaler;
import org.opencms.loader.CmsTemplateLoaderFacade;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsPreviewService
extends CmsGwtService
implements I_CmsPreviewService {
    private static final Log LOG = CmsLog.getLog(CmsPreviewService.class);
    private static final long serialVersionUID = -8175522641937277445L;

    public static String getPreviewContent(HttpServletRequest request, HttpServletResponse response, CmsObject cms, CmsResource resource, Locale locale) {
        try {
            CmsADEConfigData adeConfig;
            CmsFormatterConfiguration formatters;
            I_CmsFormatterBean formatter;
            if (CmsResourceTypeXmlContent.isXmlContent(resource) && (formatter = (formatters = (adeConfig = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri())).getFormatters(cms, resource)).getPreviewFormatter()) != null) {
                CmsObject tempCms = OpenCms.initCmsObject(cms);
                tempCms.getRequestContext().setLocale(locale);
                CmsResource formatterResource = tempCms.readResource(formatter.getJspStructureId());
                request.setAttribute("__cmsObject", (Object)tempCms);
                CmsJspStandardContextBean standardContext = CmsJspStandardContextBean.getInstance((ServletRequest)request);
                CmsContainerElementBean element = new CmsContainerElementBean(resource.getStructureId(), formatter.getJspStructureId(), null, false);
                if (resource instanceof I_CmsHistoryResource && resource instanceof CmsFile) {
                    element.setHistoryFile((CmsFile)resource);
                }
                element.initResource(tempCms);
                CmsContainerBean containerBean = new CmsContainerBean("PREVIEW", "_PREVIEW_", null, 1, Collections.<CmsContainerElementBean>emptyList());
                containerBean.setWidth(String.valueOf(640));
                standardContext.setContainer(containerBean);
                standardContext.setElement(element);
                standardContext.setEdited(true);
                standardContext.setPage(new CmsContainerPageBean(Collections.singletonList(containerBean)));
                String encoding = response.getCharacterEncoding();
                CmsTemplateLoaderFacade loaderFacade = new CmsTemplateLoaderFacade(OpenCms.getResourceManager().getLoader(formatterResource), element.getResource(), formatterResource);
                CmsResource loaderRes = loaderFacade.getLoaderStartResource();
                return new String(loaderFacade.getLoader().dump(tempCms, loaderRes, null, locale, request, response), encoding).trim();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public CmsImageInfoBean getImageInfo(String resourcePath, String locale) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsImageInfoBean resInfo = new CmsImageInfoBean();
        try {
            int pos = resourcePath.indexOf("?");
            String resName = resourcePath;
            if (pos > -1) {
                resName = resourcePath.substring(0, pos);
            }
            CmsResource resource = this.readResourceFromCurrentOrRootSite(cms, resName);
            this.readResourceInfo(cms, resource, resInfo, locale);
            resInfo.setViewLink(CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getOpenCmsContext(), "/permalink/", resource.getStructureId().toString()));
            resInfo.setHash(resource.getStructureId().hashCode());
            CmsImageScaler scaler = new CmsImageScaler(cms, resource);
            int height = -1;
            int width = -1;
            if (scaler.isValid()) {
                height = scaler.getHeight();
                width = scaler.getWidth();
            }
            resInfo.setHeight(height);
            resInfo.setWidth(width);
            CmsProperty property = cms.readPropertyObject(resource, "Copyright", false);
            if (!property.isNullProperty()) {
                resInfo.setCopyright(property.getValue());
            }
        }
        catch (Exception e) {
            this.error(e);
        }
        return resInfo;
    }

    @Override
    public CmsResourceInfoBean getResourceInfo(String resourcePath, String locale) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsResourceInfoBean resInfo = new CmsResourceInfoBean();
        try {
            int pos = resourcePath.indexOf("?");
            String resName = resourcePath;
            if (pos > -1) {
                resName = resourcePath.substring(0, pos);
            }
            CmsResource resource = this.readResourceFromCurrentOrRootSite(cms, resName);
            this.readResourceInfo(cms, resource, resInfo, locale);
        }
        catch (CmsException e) {
            this.error(e);
        }
        return resInfo;
    }

    public void readResourceInfo(CmsObject cms, CmsResource resource, CmsResourceInfoBean resInfo, String locale) throws CmsException {
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        resInfo.setTitle(resource.getName());
        resInfo.setStructureId(resource.getStructureId());
        resInfo.setDescription(CmsWorkplaceMessages.getResourceTypeName(wpLocale, type.getTypeName()));
        resInfo.setResourcePath(cms.getSitePath(resource));
        resInfo.setResourceType(type.getTypeName());
        resInfo.setSize(resource.getLength() / 1024 + " kb");
        resInfo.setLastModified(new Date(resource.getDateLastModified()));
        resInfo.setNoEditReason(new CmsResourceUtil(cms, resource).getNoEditReason(wpLocale, true));
        CmsExplorerTypeSettings setting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
        List<String> properties = setting.getProperties();
        String reference = setting.getReference();
        while (properties.size() == 0 && !CmsStringUtil.isEmptyOrWhitespaceOnly(reference)) {
            setting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(reference);
            properties = setting.getProperties();
            reference = setting.getReference();
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (String propertyName : properties) {
            CmsProperty property = cms.readPropertyObject(resource, propertyName, false);
            if (!property.isNullProperty()) {
                props.put(property.getName(), property.getValue());
                continue;
            }
            props.put(propertyName, null);
        }
        resInfo.setProperties(props);
        resInfo.setPreviewContent(this.getPreviewContent(cms, resource, CmsLocaleManager.getLocale(locale)));
    }

    @Override
    public CmsImageInfoBean syncGetImageInfo(String resourcePath, String locale) throws CmsRpcException {
        return this.getImageInfo(resourcePath, locale);
    }

    @Override
    public CmsImageInfoBean updateImageProperties(String resourcePath, String locale, Map<String, String> properties) throws CmsRpcException {
        try {
            this.saveProperties(resourcePath, properties);
        }
        catch (CmsException e) {
            this.error(e);
        }
        return this.getImageInfo(resourcePath, locale);
    }

    @Override
    public CmsResourceInfoBean updateResourceProperties(String resourcePath, String locale, Map<String, String> properties) throws CmsRpcException {
        try {
            this.saveProperties(resourcePath, properties);
        }
        catch (CmsException e) {
            this.error(e);
        }
        return this.getResourceInfo(resourcePath, locale);
    }

    private String getPreviewContent(CmsObject cms, CmsResource resource, Locale locale) {
        return CmsPreviewService.getPreviewContent(this.getRequest(), this.getResponse(), cms, resource, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmsResource readResourceFromCurrentOrRootSite(CmsObject cms, String name) throws CmsException {
        CmsResource resource = null;
        try {
            resource = cms.readResource(name, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        catch (CmsVfsResourceNotFoundException e) {
            String originalSiteRoot = cms.getRequestContext().getSiteRoot();
            try {
                cms.getRequestContext().setSiteRoot("");
                resource = cms.readResource(name, CmsResourceFilter.IGNORE_EXPIRATION);
            }
            finally {
                cms.getRequestContext().setSiteRoot(originalSiteRoot);
            }
        }
        return resource;
    }

    private void saveProperties(String resourcePath, Map<String, String> properties) throws CmsException {
        CmsObject cms = this.getCmsObject();
        int pos = resourcePath.indexOf("?");
        String resName = resourcePath;
        if (pos > -1) {
            resName = resourcePath.substring(0, pos);
        }
        CmsResource resource = cms.readResource(resName);
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String propertyName = entry.getKey();
                String propertyValue = entry.getValue();
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(propertyValue)) {
                    propertyValue = "";
                }
                try {
                    CmsProperty currentProperty = cms.readPropertyObject(resource, propertyName, false);
                    if (currentProperty.isNullProperty()) {
                        currentProperty = new CmsProperty();
                        currentProperty.setName(propertyName);
                        if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                            currentProperty.setStructureValue(propertyValue);
                            currentProperty.setResourceValue(null);
                        } else {
                            currentProperty.setStructureValue(null);
                            currentProperty.setResourceValue(propertyValue);
                        }
                    } else if (currentProperty.getStructureValue() != null) {
                        currentProperty.setStructureValue(propertyValue);
                        currentProperty.setResourceValue(null);
                    } else {
                        currentProperty.setStructureValue(null);
                        currentProperty.setResourceValue(propertyValue);
                    }
                    CmsLock lock = cms.getLock(resource);
                    if (lock.isUnlocked()) {
                        cms.lockResource(resName);
                    }
                    cms.writePropertyObject(resName, currentProperty);
                    cms.unlockResource(resName);
                }
                catch (CmsException e) {
                    this.log(e.getLocalizedMessage());
                }
            }
        }
    }
}

