/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;
import org.opencms.ade.galleries.shared.I_CmsGalleryTreeEntry;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSitemapEntryBean
implements IsSerializable,
I_CmsGalleryTreeEntry<CmsSitemapEntryBean> {
    private List<CmsSitemapEntryBean> m_children;
    private boolean m_isFolder;
    private boolean m_isHiddenEntry;
    private boolean m_isNavLevel;
    private boolean m_isRoot;
    private String m_rootPath;
    private String m_sitePath;
    private String m_siteRoot;
    private CmsUUID m_structureId;
    private String m_title;
    private String m_type;

    public CmsSitemapEntryBean(String rootPath, String sitePath, CmsUUID structureId, String title, String type, boolean isFolder, boolean isRoot, boolean isHiddenEntry, boolean isNavLevel) {
        this.m_rootPath = rootPath;
        this.m_sitePath = sitePath;
        this.m_structureId = structureId;
        this.m_title = title;
        this.m_type = type;
        this.m_isFolder = isFolder;
        this.m_isRoot = isRoot;
        this.m_isHiddenEntry = isHiddenEntry;
        this.m_isNavLevel = isNavLevel;
    }

    protected CmsSitemapEntryBean() {
    }

    @Override
    public void addChild(CmsSitemapEntryBean child) {
        if (this.m_children == null) {
            this.m_children = new ArrayList<CmsSitemapEntryBean>();
        }
        this.m_children.add(child);
    }

    @Override
    public List<CmsSitemapEntryBean> getChildren() {
        return this.m_children;
    }

    public String getDisplayName() {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_title)) {
            return this.m_title;
        }
        if (this.m_isRoot) {
            return this.m_sitePath;
        }
        String fixedPath = this.m_sitePath.replaceFirst("/$", "");
        int lastSlash = fixedPath.lastIndexOf(47);
        if (lastSlash == -1) {
            return fixedPath;
        }
        return fixedPath.substring(lastSlash + 1);
    }

    public String getImageType() {
        if (this.m_isNavLevel) {
            return "navlevel";
        }
        return this.getType();
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public String getSitePath() {
        return this.m_sitePath;
    }

    public String getSiteRoot() {
        return this.m_siteRoot;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean hasChildren() {
        return this.m_children != null;
    }

    public boolean isFolder() {
        return this.m_isFolder;
    }

    public boolean isHiddenEntry() {
        return this.m_isHiddenEntry;
    }

    public boolean isRoot() {
        return this.m_isRoot;
    }

    public void setChildren(List<CmsSitemapEntryBean> children) {
        this.m_children = children;
    }

    public void setSiteRoot(String siteRoot) {
        this.m_siteRoot = siteRoot;
    }

    public String toString() {
        return "CmsSitemapEntryBean(rootpath=" + this.m_rootPath + ",sitepath=" + this.m_sitePath + ")";
    }
}

