/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.vm.AutoBeanFactorySource;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.CmsDefaultCollectorPublishListProvider;
import org.opencms.ade.publish.I_CmsPublishRelatedResourceProvider;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.Messages;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.collectors.I_CmsCollectorPublishListProvider;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.gwt.shared.I_CmsCollectorInfoFactory;
import org.opencms.gwt.shared.I_CmsContentLoadCollectorInfo;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

public class CmsCurrentPageProject
implements I_CmsVirtualProject {
    public static final CmsUUID ID = CmsUUID.getConstantUUID("currentpage");
    static final Log LOG = CmsLog.getLog(CmsCurrentPageProject.class);

    @Override
    public CmsProjectBean getProjectBean(CmsObject cms, Map<String, String> params) {
        String pageId = params.get("containerpage");
        String elementId = params.get("content");
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        String title = Messages.get().getBundle(locale).key("GUI_CURRENTPAGE_PROJECT_0");
        if (pageId == null && elementId == null) {
            return null;
        }
        CmsUUID structureIdForTitle = pageId != null ? new CmsUUID(pageId) : new CmsUUID(elementId);
        CmsProjectBean bean = new CmsProjectBean(ID, 0, title, title);
        bean.setRank(100);
        bean.setDefaultGroupName("");
        try {
            CmsResource titleResource = cms.readResource(structureIdForTitle, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsProperty titleProp = cms.readPropertyObject(titleResource, "Title", true);
            String rawName = titleProp.isNullProperty() ? cms.getSitePath(titleResource) : titleProp.getValue();
            bean.setDefaultGroupName(Messages.get().getBundle(locale).key("GUI_PAGE_1", rawName));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return bean;
    }

    @Override
    public CmsUUID getProjectId() {
        return ID;
    }

    @Override
    public I_CmsPublishRelatedResourceProvider getRelatedResourceProvider(final CmsObject cmsObject, final CmsPublishOptions options) {
        return new I_CmsPublishRelatedResourceProvider(){

            @Override
            public Set<CmsResource> getAdditionalRelatedResources(CmsObject cms, CmsResource res) {
                Map<String, String> params = options.getParameters();
                String pageId = options.getParameters().get("containerpage");
                String detailId = options.getParameters().get("detail");
                HashSet result = Sets.newHashSet();
                if (res.getStructureId().toString().equals(detailId)) {
                    String detailContentPagePath = CmsJspTagContainer.getDetailOnlyPageName(cms.getRequestContext().removeSiteRoot(res.getRootPath()));
                    try {
                        CmsResource detailContentPage = cms.readResource(detailContentPagePath, CmsResourceFilter.IGNORE_EXPIRATION);
                        result.add(detailContentPage);
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (res.getStructureId().toString().equals(pageId)) {
                    I_CmsCollectorInfoFactory collectorInfoFactory = (I_CmsCollectorInfoFactory)AutoBeanFactorySource.create(I_CmsCollectorInfoFactory.class);
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        if (!entry.getKey().startsWith("collectorInfo")) continue;
                        try {
                            AutoBean autoBean = AutoBeanCodex.decode((AutoBeanFactory)collectorInfoFactory, I_CmsContentLoadCollectorInfo.class, (String)entry.getValue());
                            I_CmsResourceCollector collector = OpenCms.getResourceManager().getContentCollector(((I_CmsContentLoadCollectorInfo)autoBean.as()).getCollectorName());
                            if (collector == null) continue;
                            I_CmsCollectorPublishListProvider publishListProvider = this.getCollectorPublishListProvider(collector);
                            result.addAll(publishListProvider.getPublishResources(cmsObject, (I_CmsContentLoadCollectorInfo)autoBean.as()));
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                return result;
            }

            public I_CmsCollectorPublishListProvider getCollectorPublishListProvider(I_CmsResourceCollector collector) {
                I_CmsCollectorPublishListProvider provider = null;
                provider = collector instanceof I_CmsCollectorPublishListProvider ? (I_CmsCollectorPublishListProvider)((Object)collector) : new CmsDefaultCollectorPublishListProvider();
                return provider;
            }
        };
    }

    @Override
    public List<CmsResource> getResources(CmsObject cms, Map<String, String> params, String workflowId) {
        String containerpageId = params.get("containerpage");
        String elementId = params.get("content");
        String detailId = params.get("detail");
        HashSet<CmsResource> resources = new HashSet<CmsResource>();
        for (String id : new String[]{containerpageId, elementId, detailId}) {
            if (!CmsUUID.isValidUUID(id)) continue;
            try {
                CmsResource resource = cms.readResource(new CmsUUID(id), CmsResourceFilter.ALL);
                resources.add(resource);
                CmsResource parent = cms.readParentFolder(resource.getStructureId());
                if (parent.getState().isUnchanged()) continue;
                resources.add(parent);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Lists.newArrayList(resources);
    }

    @Override
    public boolean isAutoSelectable() {
        return true;
    }
}

