/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.CmsDummyRelatedResourceProvider;
import org.opencms.ade.publish.I_CmsPublishRelatedResourceProvider;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.Messages;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsDirectPublishProject
implements I_CmsVirtualProject {
    public static final CmsUUID ID = CmsUUID.getConstantUUID("" + CmsDirectPublishProject.class);
    private static final Log LOG = CmsLog.getLog(CmsDirectPublishProject.class);

    @Override
    public CmsProjectBean getProjectBean(CmsObject cms, Map<String, String> params) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(params.get("files"))) {
            return null;
        }
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        String name = Messages.get().getBundle(locale).key("GUI_PROJECT_DIRECT_PUBLISH_0");
        CmsProjectBean bean = new CmsProjectBean(ID, 0, name, name);
        bean.setRank(150);
        bean.setDefaultGroupName(name);
        return bean;
    }

    @Override
    public CmsUUID getProjectId() {
        return ID;
    }

    @Override
    public I_CmsPublishRelatedResourceProvider getRelatedResourceProvider(CmsObject cmsObject, CmsPublishOptions options) {
        return CmsDummyRelatedResourceProvider.INSTANCE;
    }

    @Override
    public List<CmsResource> getResources(CmsObject cms, Map<String, String> params, String workflowId) throws CmsException {
        Set<String> paths = this.getPaths(params);
        boolean includeContents = this.shouldIncludeContents(params);
        HashSet result = Sets.newHashSet();
        for (String path : paths) {
            try {
                result.add(cms.readResource(path, CmsResourceFilter.ALL));
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (includeContents) {
            this.addSubResources(cms, result);
        }
        ArrayList<CmsResource> resultList = new ArrayList<CmsResource>();
        for (CmsResource res : result) {
            if (res.getState().isUnchanged()) continue;
            resultList.add(res);
        }
        return resultList;
    }

    @Override
    public boolean isAutoSelectable() {
        return true;
    }

    protected void addSubResources(CmsObject cms, Set<CmsResource> resources) throws CmsException {
        ArrayList<CmsResource> subResources = new ArrayList<CmsResource>();
        CmsObject rootCms = OpenCms.initCmsObject(cms);
        rootCms.getRequestContext().setSiteRoot("");
        for (CmsResource res : resources) {
            if (!res.isFolder()) continue;
            try {
                List<CmsResource> childrenOfCurrentResource = rootCms.readResources(res.getRootPath(), CmsResourceFilter.ALL, true);
                subResources.addAll(childrenOfCurrentResource);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        resources.addAll(subResources);
    }

    protected boolean shouldIncludeContents(Map<String, String> params) {
        String includeContentsStr = params.get("include_contents");
        boolean includeContents = false;
        try {
            includeContents = Boolean.parseBoolean(includeContentsStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        return includeContents;
    }

    private Set<String> getPaths(Map<String, String> params) {
        HashSet result = Sets.newHashSet();
        String paths = params.get("files");
        if (paths != null) {
            result.addAll(CmsStringUtil.splitAsList(paths, "|"));
        }
        return result;
    }
}

