/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.ade.configuration.CmsModelPageConfig;
import org.opencms.ade.sitemap.CmsVfsSitemapService;
import org.opencms.ade.sitemap.shared.CmsModelPageEntry;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsModelPageHelper {
    private static final Log LOG = CmsLog.getLog(CmsModelPageHelper.class);
    private CmsADEConfigData m_adeConfig;
    private CmsObject m_cms;
    private CmsResource m_rootResource;
    private String m_siteRoot;

    public CmsModelPageHelper(CmsObject cms, CmsResource rootResource) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        this.m_cms.getRequestContext().setSiteRoot("");
        this.m_rootResource = rootResource;
        this.m_adeConfig = OpenCms.getADEManager().lookupConfiguration(this.m_cms, rootResource.getRootPath());
        this.m_siteRoot = OpenCms.getSiteManager().getSiteRoot(rootResource.getRootPath());
        if (this.m_siteRoot == null) {
            this.m_siteRoot = "";
        }
    }

    public void addModelPageToSitemapConfiguration(CmsResource sitemapConfig, CmsResource modelPage, boolean disabled) throws CmsException {
        CmsFile sitemapConfigFile = this.m_cms.readFile(sitemapConfig);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, sitemapConfigFile);
        CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
        reader.parseConfiguration(this.m_adeConfig.getBasePath(), content);
        List<CmsModelPageConfig> modelPageConfigs = reader.getModelPageConfigs();
        int i = 0;
        boolean isDefault = false;
        for (CmsModelPageConfig config : modelPageConfigs) {
            if (config.getResource().getStructureId().equals(modelPage.getStructureId())) {
                isDefault = config.isDefault();
                break;
            }
            ++i;
        }
        if (i >= modelPageConfigs.size()) {
            content.addValue(this.m_cms, "ModelPage", Locale.ENGLISH, i);
        }
        String prefix = "ModelPage[" + (1 + i) + "]";
        content.getValue(prefix + "/" + "Page", Locale.ENGLISH).setStringValue(this.m_cms, modelPage.getRootPath());
        content.getValue(prefix + "/" + "Disabled", Locale.ENGLISH).setStringValue(this.m_cms, "" + disabled);
        content.getValue(prefix + "/" + "IsDefault", Locale.ENGLISH).setStringValue(this.m_cms, "" + isDefault);
        this.writeSitemapConfig(content, sitemapConfigFile);
    }

    public CmsResource createPageInModelFolder(String name, String description, CmsUUID copyId) throws CmsException {
        CmsResource modelFolder = this.ensureModelFolder(this.m_rootResource);
        String pattern = "templatemodel_%(number).html";
        String newFilePath = OpenCms.getResourceManager().getNameGenerator().getNewFileName(this.m_cms, CmsStringUtil.joinPaths(modelFolder.getRootPath(), pattern), 4);
        CmsProperty titleProp = new CmsProperty("Title", name, null);
        CmsProperty descriptionProp = new CmsProperty("Description", description, null);
        CmsResource newPage = null;
        if (copyId == null) {
            newPage = this.m_cms.createResource(newFilePath, this.getType(CmsResourceTypeXmlContainerPage.getStaticTypeName()), null, Arrays.asList(titleProp, descriptionProp));
        } else {
            CmsResource copyResource = this.m_cms.readResource(copyId);
            this.m_cms.copyResource(copyResource.getRootPath(), newFilePath);
            this.m_cms.writePropertyObject(newFilePath, titleProp);
            this.m_cms.writePropertyObject(newFilePath, descriptionProp);
            newPage = this.m_cms.readResource(newFilePath);
        }
        this.tryUnlock(newPage);
        return newPage;
    }

    public CmsResource ensureModelFolder(CmsResource rootResource) throws CmsException {
        String modelFolderPath = CmsStringUtil.joinPaths(this.m_adeConfig.getBasePath(), ".content/.templates");
        try {
            CmsFolder result = this.m_cms.readFolder(modelFolderPath);
            return result;
        }
        catch (CmsVfsResourceNotFoundException e) {
            CmsProperty searchExclude = new CmsProperty("search.exclude", "all", null);
            CmsResource result = this.m_cms.createResource(modelFolderPath, this.getType(CmsResourceTypeFolder.getStaticTypeName()), null, Arrays.asList(searchExclude));
            this.tryUnlock(result);
            return result;
        }
    }

    public List<CmsModelPageEntry> getModelPages() {
        ArrayList result = Lists.newArrayList();
        List<CmsModelPageConfig> modelPageConfigs = this.m_adeConfig.getModelPages();
        for (CmsModelPageConfig config : modelPageConfigs) {
            CmsUUID structureId = config.getResource().getStructureId();
            try {
                CmsResource modelPage = this.m_cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsModelPageEntry entry = this.createModelPageEntry(modelPage);
                if (entry == null) continue;
                result.add(entry);
            }
            catch (CmsVfsResourceNotFoundException e) {
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public void removeModelPage(CmsResource sitemapConfig, CmsUUID structureId) throws CmsException {
        CmsFile sitemapConfigFile = this.m_cms.readFile(sitemapConfig);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, sitemapConfigFile);
        CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
        reader.parseConfiguration(this.m_adeConfig.getBasePath(), content);
        List<CmsModelPageConfig> modelPageConfigs = reader.getModelPageConfigs();
        int i = 0;
        for (CmsModelPageConfig config : modelPageConfigs) {
            if (config.getResource().getStructureId().equals(structureId)) break;
            ++i;
        }
        if (i < modelPageConfigs.size()) {
            content.removeValue("ModelPage", Locale.ENGLISH, i);
        }
        this.writeSitemapConfig(content, sitemapConfigFile);
    }

    CmsModelPageEntry createModelPageEntry(CmsResource resource) {
        try {
            CmsModelPageEntry result = new CmsModelPageEntry();
            List<CmsProperty> properties = this.m_cms.readPropertyObjects(resource, false);
            HashMap clientProperties = Maps.newHashMap();
            for (CmsProperty prop : properties) {
                CmsClientProperty clientProp = CmsVfsSitemapService.createClientProperty(prop, false);
                clientProperties.put(prop.getName(), clientProp);
            }
            result.setOwnProperties(clientProperties);
            result.setRootPath(resource.getRootPath());
            if (resource.getRootPath().startsWith(this.m_siteRoot)) {
                CmsObject siteCms = OpenCms.initCmsObject(this.m_cms);
                siteCms.getRequestContext().setSiteRoot(this.m_siteRoot);
                result.setSitePath(siteCms.getSitePath(resource));
            }
            result.setResourceType(OpenCms.getResourceManager().getResourceType(resource).getTypeName());
            result.setStructureId(resource.getStructureId());
            CmsListInfoBean infoBean = CmsVfsService.getPageInfo(this.m_cms, resource);
            CmsProperty descProperty = this.m_cms.readPropertyObject(resource, "Description", false);
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(descProperty.getValue())) {
                infoBean.setSubTitle(descProperty.getValue());
            }
            result.setListInfoBean(infoBean);
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private int getType(String name) throws CmsLoaderException {
        return OpenCms.getResourceManager().getResourceType(name).getTypeId();
    }

    private void tryUnlock(CmsResource resource) {
        try {
            this.m_cms.unlockResource(resource);
        }
        catch (Exception unlockError) {
            LOG.debug((Object)unlockError.getLocalizedMessage(), (Throwable)unlockError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSitemapConfig(CmsXmlContent content, CmsFile sitemapConfigFile) throws CmsXmlException, CmsException {
        content.correctXmlStructure(this.m_cms);
        byte[] contentBytes = content.marshal();
        sitemapConfigFile.setContents(contentBytes);
        try {
            CmsLock lock = this.m_cms.getLock(sitemapConfigFile);
            if (lock.isUnlocked() || !lock.isOwnedBy(this.m_cms.getRequestContext().getCurrentUser())) {
                this.m_cms.lockResourceTemporary(sitemapConfigFile);
            }
            this.m_cms.writeFile(sitemapConfigFile);
        }
        finally {
            this.m_cms.unlockResource(sitemapConfigFile);
        }
    }
}

