/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cmis;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;

public class CmsObjectListLimiter<A>
implements Iterable<A>,
Iterator<A> {
    private List<A> m_baseList;
    private int m_max;
    private int m_next;

    public CmsObjectListLimiter(List<A> baseList, BigInteger maxItems, BigInteger skipCount) {
        this.m_baseList = baseList;
        int n = this.m_next = skipCount == null ? 0 : skipCount.intValue();
        if (this.m_next < 0) {
            this.m_next = 0;
        }
        int n2 = this.m_max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        if (this.m_max < 0) {
            this.m_max = Integer.MAX_VALUE;
        }
    }

    public boolean hasMore() {
        return this.m_next < this.m_baseList.size();
    }

    @Override
    public boolean hasNext() {
        return this.m_next < this.m_baseList.size() && this.m_max > 0;
    }

    @Override
    public Iterator<A> iterator() {
        return this;
    }

    @Override
    public A next() {
        A result = this.m_baseList.get(this.m_next);
        ++this.m_next;
        --this.m_max;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

