/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.db.CmsAlias;
import org.opencms.db.CmsAliasFilter;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.db.CmsRewriteAlias;
import org.opencms.db.CmsRewriteAliasFilter;
import org.opencms.db.CmsSqlManager;
import org.opencms.db.CmsSubscriptionFilter;
import org.opencms.db.CmsVisitedByFilter;
import org.opencms.db.I_CmsDbContextFactory;
import org.opencms.db.generic.Messages;
import org.opencms.db.log.CmsLogEntry;
import org.opencms.db.log.CmsLogFilter;
import org.opencms.db.urlname.CmsUrlNameMappingEntry;
import org.opencms.db.urlname.CmsUrlNameMappingFilter;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsUserSearchParameters;
import org.opencms.file.CmsVfsException;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryPrincipal;
import org.opencms.file.history.CmsHistoryProject;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.gwt.shared.alias.CmsAliasImportResult;
import org.opencms.gwt.shared.alias.CmsAliasMode;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockFilter;
import org.opencms.lock.CmsLockManager;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsMultiException;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishEngine;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsAccessControlList;
import org.opencms.security.CmsDefaultPermissionHandler;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionSetCustom;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.I_CmsPermissionHandler;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public final class CmsSecurityManager {
    private static final Log LOG = CmsLog.getLog(CmsSecurityManager.class);
    protected I_CmsDbContextFactory m_dbContextFactory;
    protected CmsDriverManager m_driverManager;
    private CmsLockManager m_lockManager;
    private I_CmsPermissionHandler m_permissionHandler;

    private CmsSecurityManager() {
    }

    public static CmsSecurityManager newInstance(CmsConfigurationManager configurationManager, I_CmsDbContextFactory runtimeInfoFactory, CmsPublishEngine publishEngine) throws CmsInitException {
        if (OpenCms.getRunLevel() > 2) {
            throw new CmsInitException(org.opencms.main.Messages.get().container("ERR_ALREADY_INITIALIZED_0"));
        }
        CmsSecurityManager securityManager = new CmsSecurityManager();
        securityManager.init(configurationManager, runtimeInfoFactory, publishEngine);
        return securityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlias(CmsRequestContext context, CmsAlias alias) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.addAlias(dbc, context.getCurrentProject(), alias);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DB_OPERATION_0"), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelationToResource(CmsRequestContext context, CmsResource resource, CmsResource target, CmsRelationType type, boolean importCase) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            this.m_driverManager.addRelationToResource(dbc, resource, target, type, importCase);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_ADD_RELATION_TO_RESOURCE_3", context.getSitePath(resource), context.getSitePath(target), type), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceToOrgUnit(CmsRequestContext context, CmsOrganizationalUnit orgUnit, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkRole(dbc, CmsRole.ADMINISTRATOR.forOrgUnit(orgUnit.getName()));
            this.m_driverManager.addResourceToOrgUnit(dbc, orgUnit, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_ADD_RESOURCE_TO_ORGUNIT_2", orgUnit.getName(), dbc.removeSiteRoot(resource.getRootPath())), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserToGroup(CmsRequestContext context, String username, String groupname, boolean readRoles) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            CmsRole role = CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(username));
            this.checkRoleForUserModification(dbc, username, role);
            this.m_driverManager.addUserToGroup(dbc, CmsOrganizationalUnit.removeLeadingSeparator(username), CmsOrganizationalUnit.removeLeadingSeparator(groupname), readRoles);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_ADD_USER_GROUP_FAILED_2", username, groupname), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeLock(CmsRequestContext context, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        this.checkOfflineProject(dbc);
        try {
            this.m_driverManager.changeLock(dbc, resource, CmsLockType.EXCLUSIVE);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_CHANGE_LOCK_OF_RESOURCE_2", context.getSitePath(resource), " - " + e.getMessage()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<CmsResource> changeResourcesInFolderWithProperty(CmsRequestContext context, CmsResource resource, String propertyDefinition, String oldValue, String newValue, boolean recursive) throws CmsException, CmsVfsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsResource> result = null;
        try {
            result = this.m_driverManager.changeResourcesInFolderWithProperty(dbc, resource, propertyDefinition, oldValue, newValue, recursive);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_CHANGE_RESOURCES_IN_FOLDER_WITH_PROP_4", new Object[]{propertyDefinition, oldValue, newValue, context.getSitePath(resource)}), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    public void checkManagerOfProjectRole(CmsDbContext dbc, CmsProject project) throws CmsRoleViolationException {
        boolean hasRole;
        block4: {
            hasRole = false;
            try {
                if (this.hasRole(dbc, dbc.currentUser(), CmsRole.ROOT_ADMIN)) {
                    return;
                }
                hasRole = this.m_driverManager.getAllManageableProjects(dbc, this.m_driverManager.readOrganizationalUnit(dbc, project.getOuFqn()), false).contains(project);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (!hasRole) {
            throw new CmsRoleViolationException(org.opencms.security.Messages.get().container("ERR_NOT_MANAGER_OF_PROJECT_2", dbc.currentUser().getName(), dbc.currentProject().getName()));
        }
    }

    public void checkOfflineProject(CmsDbContext dbc) throws CmsVfsException {
        if (dbc.currentProject().isOnlineProject()) {
            throw new CmsVfsException(org.opencms.file.Messages.get().container("ERR_NOT_ALLOWED_IN_ONLINE_PROJECT_0"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPermissions(CmsRequestContext context, CmsResource resource, CmsPermissionSet requiredPermissions, boolean checkLock, CmsResourceFilter filter) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkPermissions(dbc, resource, requiredPermissions, checkLock, filter);
        }
        finally {
            dbc.clear();
        }
    }

    public void checkPublishPermissions(CmsDbContext dbc, CmsPublishList publishList) throws CmsException, CmsMultiException {
        this.checkOfflineProject(dbc);
        if (!publishList.isDirectPublish()) {
            this.checkManagerOfProjectRole(dbc, dbc.getRequestContext().getCurrentProject());
        } else {
            CmsMultiException resourceIssues = new CmsMultiException();
            CmsMultiException permissionIssues = new CmsMultiException();
            Iterator<CmsResource> it = publishList.getDirectPublishResources().iterator();
            ArrayList<String> parentFolders = new ArrayList<String>();
            while (it.hasNext()) {
                CmsResource res = it.next();
                String parentFolder = CmsResource.getParentFolder(res.getRootPath());
                if (parentFolder != null && !parentFolders.contains(parentFolder)) {
                    CmsResource parent = this.readResource(dbc, parentFolder, CmsResourceFilter.ALL);
                    if (!(!parent.getState().isDeleted() || publishList.isUserPublishList() && publishList.getDeletedFolderList().contains(parent))) {
                        resourceIssues.addException(new CmsVfsException(org.opencms.db.Messages.get().container("ERR_DIRECT_PUBLISH_PARENT_DELETED_2", dbc.getRequestContext().removeSiteRoot(res.getRootPath()), parentFolder)));
                    }
                    if (!(!parent.getState().isNew() || publishList.isUserPublishList() && publishList.getFolderList().contains(parent))) {
                        resourceIssues.addException(new CmsVfsException(org.opencms.db.Messages.get().container("ERR_DIRECT_PUBLISH_PARENT_NEW_2", dbc.removeSiteRoot(res.getRootPath()), parentFolder)));
                    }
                    parentFolders.add(parentFolder);
                }
                if (I_CmsPermissionHandler.PERM_ALLOWED == this.hasPermissions(dbc.getRequestContext(), res, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, true, CmsResourceFilter.ALL)) continue;
                permissionIssues.addException(new CmsSecurityException(org.opencms.db.Messages.get().container("ERR_DIRECT_PUBLISH_NO_PERMISSIONS_1", dbc.removeSiteRoot(res.getRootPath()))));
            }
            if (resourceIssues.hasExceptions() || permissionIssues.hasExceptions()) {
                resourceIssues.addExceptions(permissionIssues.getExceptions());
                throw resourceIssues;
            }
        }
    }

    public void checkRole(CmsDbContext dbc, CmsRole role) throws CmsRoleViolationException {
        if (!this.hasRole(dbc, dbc.currentUser(), role)) {
            if (role.getOuFqn() != null) {
                throw role.createRoleViolationExceptionForOrgUnit(dbc.getRequestContext(), role.getOuFqn());
            }
            throw role.createRoleViolationException(dbc.getRequestContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRole(CmsRequestContext context, CmsRole role) throws CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkRole(dbc, role);
        }
        finally {
            dbc.clear();
        }
    }

    public void checkRoleForResource(CmsDbContext dbc, CmsRole role, CmsResource resource) throws CmsRoleViolationException {
        if (!this.hasRoleForResource(dbc, dbc.currentUser(), role, resource)) {
            throw role.createRoleViolationExceptionForResource(dbc.getRequestContext(), resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRoleForResource(CmsRequestContext context, CmsRole role, CmsResource resource) throws CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkRoleForResource(dbc, role, resource);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chflags(CmsRequestContext context, CmsResource resource, int flags) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            this.m_driverManager.chflags(dbc, resource, flags);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_CHANGE_RESOURCE_FLAGS_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chtype(CmsRequestContext context, CmsResource resource, int type) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            if (CmsResourceTypeJsp.isJspTypeId(type)) {
                this.checkRoleForResource(dbc, CmsRole.DEVELOPER, resource);
            }
            this.m_driverManager.chtype(dbc, resource, type);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_CHANGE_RESOURCE_TYPE_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAccessControlEntries(CmsRequestContext context, CmsResource source, CmsResource destination) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, source, CmsPermissionSet.ACCESS_READ, true, CmsResourceFilter.ALL);
            this.checkPermissions(dbc, destination, CmsPermissionSet.ACCESS_CONTROL, true, CmsResourceFilter.ALL);
            this.m_driverManager.copyAccessControlEntries(dbc, source, destination, true);
        }
        catch (Exception e) {
            CmsRequestContext rc = context;
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_COPY_ACE_2", rc.removeSiteRoot(source.getRootPath()), rc.removeSiteRoot(destination.getRootPath())), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResource(CmsRequestContext context, CmsResource source, String destination, CmsResource.CmsResourceCopyMode siblingMode) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, source, CmsPermissionSet.ACCESS_READ, true, CmsResourceFilter.ALL);
            if (source.isFolder() && destination.startsWith(source.getRootPath())) {
                throw new CmsVfsException(org.opencms.db.Messages.get().container("ERR_RECURSIVE_INCLUSION_2", dbc.removeSiteRoot(source.getRootPath()), dbc.removeSiteRoot(destination)));
            }
            this.m_driverManager.copyResource(dbc, source, destination, siblingMode);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_COPY_RESOURCE_2", dbc.removeSiteRoot(source.getRootPath()), dbc.removeSiteRoot(destination)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResourceToProject(CmsRequestContext context, CmsResource resource) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkManagerOfProjectRole(dbc, context.getCurrentProject());
            this.m_driverManager.copyResourceToProject(dbc, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_COPY_RESOURCE_TO_PROJECT_2", context.getSitePath(resource), context.getCurrentProject().getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countLockedResources(CmsRequestContext context, CmsUUID id) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsProject project = null;
        int result = 0;
        try {
            project = this.m_driverManager.readProject(dbc, id);
            this.checkManagerOfProjectRole(dbc, project);
            result = this.m_driverManager.countLockedResources(project);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_COUNT_LOCKED_RESOURCES_PROJECT_2", project == null ? "<failed to read>" : project.getName(), id), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countUsers(CmsRequestContext requestContext, CmsUserSearchParameters searchParams) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(requestContext);
        try {
            long l = this.m_driverManager.countUsers(dbc, searchParams);
            return l;
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_COUNT_USERS_0"), e);
            long l = -1L;
            return l;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsGroup createGroup(CmsRequestContext context, String name, String description, int flags, String parent) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsGroup result = null;
        try {
            this.checkRole(dbc, CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(name)));
            result = this.m_driverManager.createGroup(dbc, new CmsUUID(), name, description, flags, parent);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_CREATE_GROUP_1", name), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsOrganizationalUnit createOrganizationalUnit(CmsRequestContext context, String ouFqn, String description, int flags, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsOrganizationalUnit result = null;
        try {
            this.checkRole(dbc, CmsRole.ADMINISTRATOR.forOrgUnit(this.getParentOrganizationalUnit(ouFqn)));
            this.checkOfflineProject(dbc);
            result = this.m_driverManager.createOrganizationalUnit(dbc, CmsOrganizationalUnit.removeLeadingSeparator(ouFqn), description, flags, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_CREATE_ORGUNIT_1", ouFqn), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsProject createProject(CmsRequestContext context, String name, String description, String groupname, String managergroupname, CmsProject.CmsProjectType projecttype) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsProject result = null;
        try {
            this.checkRole(dbc, CmsRole.PROJECT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(name)));
            result = this.m_driverManager.createProject(dbc, CmsOrganizationalUnit.removeLeadingSeparator(name), description, CmsOrganizationalUnit.removeLeadingSeparator(groupname), CmsOrganizationalUnit.removeLeadingSeparator(managergroupname), projecttype);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_CREATE_PROJECT_1", name), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPropertyDefinition createPropertyDefinition(CmsRequestContext context, String name) throws CmsException, CmsSecurityException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsPropertyDefinition result = null;
        try {
            this.checkOfflineProject(dbc);
            this.checkRole(dbc, CmsRole.WORKPLACE_MANAGER.forOrgUnit(null));
            result = this.m_driverManager.createPropertyDefinition(dbc, name);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_CREATE_PROPDEF_1", name), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsResource createResource(CmsRequestContext context, String resourcePath, CmsResource resource, byte[] content, List<CmsProperty> properties) throws CmsVfsResourceAlreadyExistsException, CmsVfsException, CmsException {
        if (this.existsResource(context, resourcePath, CmsResourceFilter.IGNORE_EXPIRATION)) {
            throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1", resource.getRootPath()));
        }
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsResource newResource = null;
        try {
            this.checkOfflineProject(dbc);
            newResource = this.m_driverManager.createResource(dbc, resourcePath, resource, content, properties, false);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_IMPORT_RESOURCE_2", context.getSitePath(resource), resourcePath), e);
        }
        finally {
            dbc.clear();
        }
        return newResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CmsResource createResource(CmsRequestContext context, String resourcename, int type, byte[] content, List<CmsProperty> properties) throws CmsException {
        String checkExistsPath;
        String string = checkExistsPath = "/".equals(resourcename) ? "/" : CmsFileUtil.removeTrailingSeparator(resourcename);
        if (this.existsResource(context, checkExistsPath, CmsResourceFilter.ALL)) {
            throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1", resourcename));
        }
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsResource newResource = null;
        try {
            this.checkOfflineProject(dbc);
            newResource = this.m_driverManager.createResource(dbc, resourcename, type, content, properties);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_CREATE_RESOURCE_1", resourcename), e);
        }
        finally {
            dbc.clear();
        }
        return newResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsResource createSibling(CmsRequestContext context, CmsResource source, String destination, List<CmsProperty> properties) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsResource sibling = null;
        try {
            this.checkOfflineProject(dbc);
            sibling = this.m_driverManager.createSibling(dbc, source, destination, properties);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_CREATE_SIBLING_1", context.removeSiteRoot(source.getRootPath())), e);
        }
        finally {
            dbc.clear();
        }
        return sibling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsProject createTempfileProject(CmsRequestContext context) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsProject result = null;
        try {
            this.checkRole(dbc, CmsRole.PROJECT_MANAGER.forOrgUnit(null));
            result = this.m_driverManager.createTempfileProject(dbc);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_CREATE_TEMPFILE_PROJECT_0"), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsUser createUser(CmsRequestContext context, String name, String password, String description, Map<String, Object> additionalInfos) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsUser result = null;
        try {
            this.checkRole(dbc, CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(name)));
            result = this.m_driverManager.createUser(dbc, CmsOrganizationalUnit.removeLeadingSeparator(name), password, description, additionalInfos);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_CREATE_USER_1", name), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAliases(CmsRequestContext context, CmsAliasFilter filter) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.deleteAliases(dbc, context.getCurrentProject(), filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DB_OPERATION_0"), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllStaticExportPublishedResources(CmsRequestContext context, int linkType) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.deleteAllStaticExportPublishedResources(dbc, linkType);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DELETE_STATEXP_PUBLISHED_RESOURCES_0"), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroup(CmsRequestContext context, CmsUUID groupId, CmsUUID replacementId) throws CmsException, CmsRoleViolationException, CmsSecurityException {
        CmsGroup group = this.readGroup(context, groupId);
        if (group.isRole()) {
            throw new CmsSecurityException(org.opencms.db.Messages.get().container("ERR_DELETE_ROLE_GROUP_1", group.getName()));
        }
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkRole(dbc, CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(group.getName())));
            this.checkProjectForDeletePrincipal(dbc);
            this.m_driverManager.deleteGroup(dbc, group, replacementId);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DELETE_GROUP_1", group.getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroup(CmsRequestContext context, String name) throws CmsException, CmsRoleViolationException, CmsSecurityException {
        CmsGroup group = this.readGroup(context, name);
        if (group.isRole()) {
            throw new CmsSecurityException(org.opencms.db.Messages.get().container("ERR_DELETE_ROLE_GROUP_1", name));
        }
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkRole(dbc, CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(name)));
            this.checkProjectForDeletePrincipal(dbc);
            this.m_driverManager.deleteGroup(dbc, group, null);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DELETE_GROUP_1", name), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteHistoricalVersions(CmsRequestContext context, int versionsToKeep, int versionsDeleted, long timeDeleted, I_CmsReport report) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            CmsFolder root = this.readFolder(dbc, "/", CmsResourceFilter.ALL);
            this.checkRole(dbc, CmsRole.WORKPLACE_MANAGER.forOrgUnit(null));
            this.checkPermissions(dbc, (CmsResource)root, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
            this.m_driverManager.deleteHistoricalVersions(dbc, versionsToKeep, versionsDeleted, timeDeleted, report);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DELETE_HISTORY_4", new Object[]{"/", new Integer(versionsToKeep), new Integer(versionsDeleted), new Date(timeDeleted)}), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLogEntries(CmsRequestContext context, CmsLogFilter filter) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkRole(dbc, CmsRole.WORKPLACE_MANAGER);
            this.m_driverManager.deleteLogEntries(dbc, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DELETE_LOG_0"), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOrganizationalUnit(CmsRequestContext context, CmsOrganizationalUnit organizationalUnit) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            if (organizationalUnit.getParentFqn() == null) {
                throw new CmsDataAccessException(org.opencms.security.Messages.get().container("ERR_ORGUNIT_ROOT_EDITION_0"));
            }
            this.checkRole(dbc, CmsRole.ADMINISTRATOR.forOrgUnit(this.getParentOrganizationalUnit(organizationalUnit.getName())));
            this.checkOfflineProject(dbc);
            this.m_driverManager.deleteOrganizationalUnit(dbc, organizationalUnit);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DELETE_ORGUNIT_1", organizationalUnit.getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProject(CmsRequestContext context, CmsUUID projectId) throws CmsException, CmsRoleViolationException {
        if (projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
            throw new CmsVfsException(org.opencms.file.Messages.get().container("ERR_NOT_ALLOWED_IN_ONLINE_PROJECT_0"));
        }
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsProject deleteProject = null;
        try {
            deleteProject = this.m_driverManager.readProject(dbc, projectId);
            this.checkManagerOfProjectRole(dbc, deleteProject);
            this.m_driverManager.deleteProject(dbc, deleteProject);
        }
        catch (Exception e) {
            String projectName = deleteProject == null ? String.valueOf(projectId) : deleteProject.getName();
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DELETE_PROJECT_1", projectName), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePropertyDefinition(CmsRequestContext context, String name) throws CmsException, CmsSecurityException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkRole(dbc, CmsRole.WORKPLACE_MANAGER.forOrgUnit(null));
            this.m_driverManager.deletePropertyDefinition(dbc, name);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DELETE_PROPERTY_1", name), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRelationsForResource(CmsRequestContext context, CmsResource resource, CmsRelationFilter filter) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            this.m_driverManager.deleteRelationsForResource(dbc, resource, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DELETE_RELATIONS_1", dbc.removeSiteRoot(resource.getRootPath())), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource(CmsRequestContext context, CmsResource resource, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            this.checkSystemLocks(dbc, resource);
            if (resource.isFolder()) {
                dbc.getRequestContext().setAttribute("CHECK_PERMISSIONS", Boolean.TRUE);
                try {
                    this.m_driverManager.getVfsDriver(dbc).removeFolder(dbc, dbc.currentProject(), resource);
                }
                catch (CmsDataAccessException e) {
                    if (e.getCause() instanceof CmsPermissionViolationException) {
                        throw (CmsPermissionViolationException)e.getCause();
                    }
                    throw e;
                }
                dbc.getRequestContext().removeAttribute("CHECK_PERMISSIONS");
            }
            this.deleteResource(dbc, resource, siblingMode);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DELETE_RESOURCE_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStaticExportPublishedResource(CmsRequestContext context, String resourceName, int linkType, String linkParameter) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.deleteStaticExportPublishedResource(dbc, resourceName, linkType, linkParameter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DELETE_STATEXP_PUBLISHES_RESOURCE_1", resourceName), e);
        }
        finally {
            dbc.clear();
        }
    }

    public void deleteUser(CmsRequestContext context, CmsUUID userId) throws CmsException {
        CmsUser user = this.readUser(context, userId);
        this.deleteUser(context, user, null);
    }

    public void deleteUser(CmsRequestContext context, CmsUUID userId, CmsUUID replacementId) throws CmsException {
        CmsUser user = this.readUser(context, userId);
        CmsUser replacementUser = null;
        if (replacementId != null && !replacementId.isNullUUID()) {
            replacementUser = this.readUser(context, replacementId);
        }
        this.deleteUser(context, user, replacementUser);
    }

    public void deleteUser(CmsRequestContext context, String username) throws CmsException {
        CmsUser user = this.readUser(context, username);
        this.deleteUser(context, user, null);
    }

    public synchronized void destroy() throws Throwable {
        block6: {
            try {
                block7: {
                    if (this.m_driverManager == null) break block6;
                    if (this.m_driverManager.getLockManager() != null) {
                        try {
                            this.writeLocks();
                        }
                        catch (Throwable t) {
                            if (!LOG.isErrorEnabled()) break block7;
                            LOG.error((Object)org.opencms.lock.Messages.get().getBundle().key("ERR_WRITE_LOCKS_FINAL_0"), t);
                        }
                    }
                }
                this.m_driverManager.destroy();
            }
            catch (Throwable t) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_ERR_DRIVER_MANAGER_CLOSE_0"), t);
            }
        }
        this.m_driverManager = null;
        this.m_dbContextFactory = null;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_SECURITY_MANAGER_SHUTDOWN_1", this.getClass().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsResource(CmsRequestContext context, CmsUUID structureId, CmsResourceFilter filter) {
        boolean result = false;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.readResource(dbc, structureId, filter);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsResource(CmsRequestContext context, String resourcePath, CmsResourceFilter filter) {
        boolean result = false;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.readResource(dbc, resourcePath, filter);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPublishList fillPublishList(CmsRequestContext context, CmsPublishList publishList) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.fillPublishList(dbc, publishList);
            this.checkPublishPermissions(dbc, publishList);
        }
        catch (Exception e) {
            if (publishList.isDirectPublish()) {
                dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_PUBLISH_LIST_DIRECT_1", CmsFileUtil.formatResourceNames(context, publishList.getDirectPublishResources())), e);
            } else {
                dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_PUBLISH_LIST_PROJECT_1", context.getCurrentProject().getName()), e);
            }
        }
        finally {
            dbc.clear();
        }
        return publishList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsAccessControlEntry> getAccessControlEntries(CmsRequestContext context, CmsResource resource, boolean getInherited) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsAccessControlEntry> result = null;
        try {
            result = this.m_driverManager.getAccessControlEntries(dbc, resource, getInherited);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_ACL_ENTRIES_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsAccessControlList getAccessControlList(CmsRequestContext context, CmsResource resource, boolean inheritedOnly) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsAccessControlList result = null;
        try {
            result = this.m_driverManager.getAccessControlList(dbc, resource, inheritedOnly);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_ACL_ENTRIES_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsAlias> getAliasesForSite(CmsRequestContext requestContext, String siteRoot) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(requestContext);
        try {
            List<CmsAlias> aliases;
            List<CmsAlias> list = aliases = this.m_driverManager.readAliasesBySite(dbc, requestContext.getCurrentProject(), siteRoot);
            return list;
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DB_OPERATION_0"), e);
            List<CmsAlias> list = null;
            return list;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsAccessControlEntry> getAllAccessControlEntries(CmsRequestContext context) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsAccessControlEntry> result = null;
        try {
            result = this.m_driverManager.getAllAccessControlEntries(dbc);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_ACL_ENTRIES_1", "<all resources>"), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsProject> getAllAccessibleProjects(CmsRequestContext context, CmsOrganizationalUnit orgUnit, boolean includeSubOus) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsProject> result = null;
        try {
            result = this.m_driverManager.getAllAccessibleProjects(dbc, orgUnit, includeSubOus);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_ALL_ACCESSIBLE_PROJECTS_1", dbc.currentUser().getName()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsHistoryProject> getAllHistoricalProjects(CmsRequestContext context) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsHistoryProject> result = null;
        try {
            result = this.m_driverManager.getAllHistoricalProjects(dbc);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_ALL_ACCESSIBLE_PROJECTS_1", dbc.currentUser().getName()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsProject> getAllManageableProjects(CmsRequestContext context, CmsOrganizationalUnit orgUnit, boolean includeSubOus) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsProject> result = null;
        try {
            result = this.m_driverManager.getAllManageableProjects(dbc, orgUnit, includeSubOus);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_ALL_MANAGEABLE_PROJECTS_1", dbc.currentUser().getName()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsGroup> getChildren(CmsRequestContext context, String groupname, boolean includeSubChildren) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsGroup> result = null;
        try {
            result = this.m_driverManager.getChildren(dbc, this.m_driverManager.readGroup(dbc, CmsOrganizationalUnit.removeLeadingSeparator(groupname)), includeSubChildren);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_CHILD_GROUPS_TRANSITIVE_1", groupname), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDateLastVisitedBy(CmsRequestContext context, String poolName, CmsUser user, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        long result = 0L;
        try {
            result = this.m_driverManager.getDateLastVisitedBy(dbc, poolName, user, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_DATE_LASTVISITED_2", user.getName(), context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsGroup> getGroups(CmsRequestContext context, CmsOrganizationalUnit orgUnit, boolean includeSubOus, boolean readRoles) throws CmsException {
        List<CmsGroup> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.getGroups(dbc, orgUnit, includeSubOus, readRoles);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_ORGUNIT_GROUPS_1", orgUnit.getName()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsGroup> getGroupsOfUser(CmsRequestContext context, String username, String ouFqn, boolean includeChildOus, boolean readRoles, boolean directGroupsOnly, String remoteAddress) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsGroup> result = null;
        try {
            result = this.m_driverManager.getGroupsOfUser(dbc, CmsOrganizationalUnit.removeLeadingSeparator(username), CmsOrganizationalUnit.removeLeadingSeparator(ouFqn), includeChildOus, readRoles, directGroupsOnly, remoteAddress);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_GROUPS_OF_USER_2", username, remoteAddress), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsLock getLock(CmsRequestContext context, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsLock result = null;
        try {
            result = this.m_driverManager.getLock(dbc, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_LOCK_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLockedResources(CmsRequestContext context, CmsResource resource, CmsLockFilter filter) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<String> result = null;
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_READ, false, CmsResourceFilter.ALL);
            result = this.m_driverManager.getLockedResources(dbc, resource, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_COUNT_LOCKED_RESOURCES_FOLDER_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> getLockedResourcesObjects(CmsRequestContext context, CmsResource resource, CmsLockFilter filter) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsResource> result = null;
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_READ, false, CmsResourceFilter.ALL);
            result = this.m_driverManager.getLockedResourcesObjects(dbc, resource, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_COUNT_LOCKED_RESOURCES_FOLDER_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> getLockedResourcesObjectsWithCache(CmsRequestContext context, CmsResource resource, CmsLockFilter filter, Map<String, CmsResource> cache) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsResource> result = null;
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_READ, false, CmsResourceFilter.ALL);
            result = this.m_driverManager.getLockedResourcesObjectsWithCache(dbc, resource, filter, cache);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_COUNT_LOCKED_RESOURCES_FOLDER_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    public CmsLockManager getLockManager() {
        return this.m_lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsLogEntry> getLogEntries(CmsRequestContext context, CmsLogFilter filter) throws CmsException {
        List<CmsLogEntry> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.getLogEntries(dbc, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_LOG_ENTRIES_0"), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> getManageableResources(CmsRequestContext context, CmsRole role) throws CmsException {
        List<CmsResource> resources;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            resources = this.getManageableResources(dbc, role);
        }
        finally {
            dbc.clear();
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsOrganizationalUnit> getOrganizationalUnits(CmsRequestContext context, CmsOrganizationalUnit parent, boolean includeChildren) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsOrganizationalUnit> result = null;
        try {
            result = this.m_driverManager.getOrganizationalUnits(dbc, parent, includeChildren);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_ORGUNITS_1", parent.getName()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsOrganizationalUnit> getOrgUnitsForRole(CmsRequestContext requestContext, CmsRole role, boolean includeSubOus) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(requestContext);
        List<CmsOrganizationalUnit> result = null;
        try {
            result = this.m_driverManager.getOrgUnitsForRole(dbc, role, includeSubOus);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_ORGUNITS_ROLE_1", role.getName(requestContext.getLocale())), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsGroup getParent(CmsRequestContext context, String groupname) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsGroup result = null;
        try {
            result = this.m_driverManager.getParent(dbc, CmsOrganizationalUnit.removeLeadingSeparator(groupname));
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_PARENT_GROUP_1", groupname), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPermissionSetCustom getPermissions(CmsRequestContext context, CmsResource resource, CmsUser user) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsPermissionSetCustom result = null;
        try {
            result = this.m_driverManager.getPermissions(dbc, resource, user);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_PERMISSIONS_2", user.getName(), context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsUUID getProjectId(CmsRequestContext context, int id) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsUUID result = null;
        try {
            result = this.m_driverManager.getProjectId(dbc, id);
        }
        catch (CmsException e) {
            dbc.report(null, e.getMessageContainer(), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPublishList getRelatedResourcesToPublish(CmsRequestContext context, CmsPublishList publishList, CmsRelationFilter filter) throws CmsException {
        if (!publishList.isDirectPublish()) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_GET_RELATED_RESOURCES_PUBLISH_PROJECT_0"));
        }
        CmsPublishList ret = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            ret = this.m_driverManager.getRelatedResourcesToPublish(dbc, publishList, filter);
            this.checkPublishPermissions(dbc, ret);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_RELATED_RESOURCES_PUBLISH_DIRECT_1", CmsFileUtil.formatResourceNames(context, publishList.getDirectPublishResources())), e);
        }
        finally {
            dbc.clear();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsRelation> getRelationsForResource(CmsRequestContext context, CmsResource resource, CmsRelationFilter filter) throws CmsException {
        List<CmsRelation> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            if (resource != null) {
                this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_VIEW, false, CmsResourceFilter.ALL);
            }
            result = this.m_driverManager.getRelationsForResource(dbc, resource, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_RELATIONS_1", resource != null ? context.removeSiteRoot(resource.getRootPath()) : "null"), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> getResourcesForOrganizationalUnit(CmsRequestContext context, CmsOrganizationalUnit orgUnit) throws CmsException {
        List<CmsResource> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.getResourcesForOrganizationalUnit(dbc, orgUnit);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_ORGUNIT_RESOURCES_1", orgUnit.getName()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CmsResource> getResourcesForPrincipal(CmsRequestContext context, CmsUUID principalId, CmsPermissionSet permissions, boolean includeAttr) throws CmsException {
        Set<CmsResource> dependencies;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            dependencies = this.m_driverManager.getResourcesForPrincipal(dbc, dbc.currentProject(), principalId, permissions, includeAttr);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_RESOURCES_FOR_PRINCIPAL_LOG_1", principalId), e);
            dependencies = new HashSet<CmsResource>();
        }
        finally {
            dbc.clear();
        }
        return dependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsRewriteAlias> getRewriteAliases(CmsRequestContext requestContext, CmsRewriteAliasFilter filter) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(requestContext);
        try {
            List<CmsRewriteAlias> list = this.m_driverManager.getRewriteAliases(dbc, filter);
            return list;
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DB_OPERATION_0"), e);
            List<CmsRewriteAlias> list = null;
            return list;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CmsGroup> getRoleGroups(CmsRequestContext context, CmsRole role, boolean directUsersOnly) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            Set<CmsGroup> set = this.m_driverManager.getRoleGroups(dbc, role.getGroupName(), directUsersOnly);
            return set;
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_ROLE_GROUPS_1", role.toString()), e);
            Set<CmsGroup> set = null;
            return set;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsRole> getRolesForResource(CmsRequestContext context, CmsUser user, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsRole> result = null;
        try {
            result = this.m_driverManager.getRolesForResource(dbc, user, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_ROLES_FOR_RESOURCE_2", user.getName(), context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    public CmsSqlManager getSqlManager() {
        return this.m_driverManager.getSqlManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsUser> getUsers(CmsRequestContext context, CmsOrganizationalUnit orgUnit, boolean recursive) throws CmsException {
        List<CmsUser> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.getUsers(dbc, orgUnit, recursive);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_ORGUNIT_USERS_1", orgUnit.getName()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsUser> getUsersOfGroup(CmsRequestContext context, String groupname, boolean includeOtherOuUsers, boolean directUsersOnly, boolean readRoles) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsUser> result = null;
        try {
            result = this.m_driverManager.getUsersOfGroup(dbc, CmsOrganizationalUnit.removeLeadingSeparator(groupname), includeOtherOuUsers, directUsersOnly, readRoles);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_GET_USERS_OF_GROUP_1", groupname), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> getUsersPubList(CmsRequestContext context) throws CmsException {
        List<CmsResource> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.getUsersPubList(dbc, context.getCurrentUser().getId());
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_USER_PUBLIST_1", context.getCurrentUser().getName()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsUser> getUsersWithoutAdditionalInfo(CmsRequestContext context, CmsOrganizationalUnit orgUnit, boolean recursive) throws CmsException {
        List<CmsUser> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.getUsersWithoutAdditionalInfo(dbc, orgUnit, recursive);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_ORGUNIT_USERS_1", orgUnit.getName()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I_CmsPermissionHandler.CmsPermissionCheckResult hasPermissions(CmsRequestContext context, CmsResource resource, CmsPermissionSet requiredPermissions, boolean checkLock, CmsResourceFilter filter) throws CmsException {
        I_CmsPermissionHandler.CmsPermissionCheckResult result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.hasPermissions(dbc, resource, requiredPermissions, checkLock, filter);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    public boolean hasRole(CmsDbContext dbc, CmsUser user, CmsRole role) {
        Object val;
        String info;
        Object prop;
        List<CmsGroup> roles;
        String key = user.getName().toString() + role.getGroupName() + role.getOuFqn();
        Boolean result = OpenCms.getMemoryMonitor().getCachedRole(key);
        if (result != null) {
            return result;
        }
        try {
            roles = this.m_driverManager.getGroupsOfUser(dbc, user.getName(), "", true, true, false, dbc.getRequestContext().getRemoteAddress());
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
        boolean hasRole = this.hasRole(role, roles);
        if (!(!hasRole || !CmsRole.CATEGORY_EDITOR.equals(role) && !CmsRole.GALLERY_EDITOR.equals(role) || (prop = OpenCms.getRuntimeProperty(info = "confirm.role." + role.getRoleName())) == null || !Boolean.valueOf(prop.toString()).booleanValue() || (val = user.getAdditionalInfo(info)) != null && Boolean.valueOf(val.toString()).booleanValue() || !this.hasRole(CmsRole.WORKPLACE_USER, roles) || this.hasRole(CmsRole.DEVELOPER, roles) || this.hasRole(CmsRole.PROJECT_MANAGER, roles) || this.hasRole(CmsRole.ACCOUNT_MANAGER, roles))) {
            hasRole = false;
        }
        result = hasRole;
        OpenCms.getMemoryMonitor().cacheRole(key, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRole(CmsRequestContext context, CmsUser user, CmsRole role) {
        boolean result;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.hasRole(dbc, user, role);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    public boolean hasRoleForResource(CmsDbContext dbc, CmsUser user, CmsRole role, CmsResource resource) {
        ArrayList<CmsGroup> roles;
        if (user.isGuestUser()) {
            return false;
        }
        String key = user.getId().toString() + role.getGroupName() + resource.getRootPath();
        Boolean result = OpenCms.getMemoryMonitor().getCachedRole(key);
        if (result != null) {
            return result;
        }
        try {
            roles = new ArrayList<CmsGroup>(this.m_driverManager.getGroupsOfUser(dbc, user.getName(), "", true, true, false, dbc.getRequestContext().getRemoteAddress()));
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
        if (!this.hasRole(role.forOrgUnit(null), roles)) {
            result = Boolean.FALSE;
        }
        Iterator it = roles.iterator();
        while (result == null && it.hasNext()) {
            CmsGroup group = (CmsGroup)it.next();
            CmsRole givenRole = CmsRole.valueOf(group);
            if (!this.hasRole(role.forOrgUnit(null), Collections.singletonList(group))) continue;
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(givenRole.getOuFqn())) {
                try {
                    CmsOrganizationalUnit orgUnit = this.m_driverManager.readOrganizationalUnit(dbc, givenRole.getOuFqn());
                    for (CmsResource givenResource : this.m_driverManager.getResourcesForOrganizationalUnit(dbc, orgUnit)) {
                        if (!resource.getRootPath().startsWith(givenResource.getRootPath())) continue;
                        result = Boolean.TRUE;
                    }
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                continue;
            }
            result = Boolean.TRUE;
        }
        if (result == null) {
            result = Boolean.FALSE;
        }
        OpenCms.getMemoryMonitor().cacheRole(key, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRoleForResource(CmsRequestContext context, CmsUser user, CmsRole role, CmsResource resource) {
        boolean result;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.hasRoleForResource(dbc, user, role, resource);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAccessControlEntries(CmsRequestContext context, CmsResource resource, List<CmsAccessControlEntry> acEntries) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_CONTROL, true, CmsResourceFilter.ALL);
            this.m_driverManager.importAccessControlEntries(dbc, resource, acEntries);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_IMPORT_ACL_ENTRIES_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsResource importResource(CmsRequestContext context, String resourcePath, CmsResource resource, byte[] content, List<CmsProperty> properties, boolean importCase) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsResource newResource = null;
        try {
            this.checkOfflineProject(dbc);
            newResource = this.m_driverManager.createResource(dbc, resourcePath, resource, content, properties, importCase);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_IMPORT_RESOURCE_2", context.getSitePath(resource), resourcePath), e);
        }
        finally {
            dbc.clear();
        }
        return newResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsAliasImportResult importRewriteAlias(CmsRequestContext requestContext, String siteRoot, String source, String target, CmsAliasMode mode) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(requestContext);
        try {
            CmsAliasImportResult cmsAliasImportResult = this.m_driverManager.importRewriteAlias(dbc, siteRoot, source, target, mode);
            return cmsAliasImportResult;
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DB_OPERATION_0"), e);
            CmsAliasImportResult cmsAliasImportResult = null;
            return cmsAliasImportResult;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsUser importUser(CmsRequestContext context, String id, String name, String password, String firstname, String lastname, String email, int flags, long dateCreated, Map<String, Object> additionalInfos) throws CmsException, CmsRoleViolationException {
        CmsUser newUser = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkRole(dbc, CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(name)));
            newUser = this.m_driverManager.importUser(dbc, id, CmsOrganizationalUnit.removeLeadingSeparator(name), password, firstname, lastname, email, flags, dateCreated, additionalInfos);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_IMPORT_USER_7", new Object[]{id, name, firstname, lastname, email, new Integer(flags), new Date(dateCreated), additionalInfos}), e);
        }
        finally {
            dbc.clear();
        }
        return newUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementCounter(CmsRequestContext context, String name) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            int n = this.m_driverManager.incrementCounter(dbc, name);
            return n;
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_INCREMENT_COUNTER_1", name), e);
            int n = -1;
            return n;
        }
        finally {
            dbc.clear();
        }
    }

    public void init(CmsConfigurationManager configurationManager, I_CmsDbContextFactory dbContextFactory, CmsPublishEngine publishEngine) throws CmsInitException {
        if (dbContextFactory == null) {
            throw new CmsInitException(org.opencms.main.Messages.get().container("ERR_CRITICAL_NO_DB_CONTEXT_0"));
        }
        this.m_dbContextFactory = dbContextFactory;
        CmsSystemConfiguration systemConfiguration = (CmsSystemConfiguration)configurationManager.getConfiguration(CmsSystemConfiguration.class);
        this.m_driverManager = CmsDriverManager.newInstance(configurationManager, this, dbContextFactory, publishEngine);
        try {
            this.m_driverManager.init(configurationManager, dbContextFactory);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_START_PHASE4_OK_0"));
            }
        }
        catch (Exception exc) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("LOG_ERR_DRIVER_MANAGER_START_0");
            if (LOG.isFatalEnabled()) {
                LOG.fatal((Object)message.key(), (Throwable)exc);
            }
            throw new CmsInitException(message, (Throwable)exc);
        }
        this.m_lockManager = this.m_driverManager.getLockManager();
        String permHandlerClassName = systemConfiguration.getPermissionHandler();
        if (permHandlerClassName == null) {
            this.m_permissionHandler = new CmsDefaultPermissionHandler();
        } else {
            try {
                this.m_permissionHandler = (I_CmsPermissionHandler)Class.forName(permHandlerClassName).newInstance();
            }
            catch (Exception e) {
                throw new CmsInitException(org.opencms.main.Messages.get().container("ERR_CRITICAL_CLASS_CREATION_1", permHandlerClassName), (Throwable)e);
            }
        }
        this.m_permissionHandler.init(this.m_driverManager, systemConfiguration);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_SECURITY_MANAGER_INIT_0"));
        }
    }

    public void initializeOrgUnit(CmsRequestContext context, CmsOrganizationalUnit ou) {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        this.m_driverManager.initOrgUnit(dbc, ou);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInsideCurrentProject(CmsRequestContext context, String resourcename) {
        boolean result = false;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.isInsideCurrentProject(dbc, resourcename);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    public boolean isManagerOfProject(CmsRequestContext context) {
        try {
            return this.getAllManageableProjects(context, this.readOrganizationalUnit(context, context.getCurrentProject().getOuFqn()), false).contains(context.getCurrentProject());
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public boolean isSubscriptionDriverAvailable() {
        return this.m_driverManager.isSubscriptionDriverAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockResource(CmsRequestContext context, CmsResource resource, CmsLockType type) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
            this.m_driverManager.lockResource(dbc, resource, type);
        }
        catch (Exception e) {
            CmsMessageContainer messageContainer = e instanceof CmsLockException ? ((CmsLockException)e).getMessageContainer() : org.opencms.db.Messages.get().container("ERR_LOCK_RESOURCE_2", context.getSitePath(resource), type.toString());
            dbc.report(null, messageContainer, e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsUser loginUser(CmsRequestContext context, String username, String password, String remoteAddress) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsUser result = null;
        try {
            result = this.m_driverManager.loginUser(dbc, CmsOrganizationalUnit.removeLeadingSeparator(username), password, remoteAddress);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I_CmsPrincipal lookupPrincipal(CmsRequestContext context, CmsUUID principalId) {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        I_CmsPrincipal result = null;
        try {
            result = this.m_driverManager.lookupPrincipal(dbc, principalId);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I_CmsPrincipal lookupPrincipal(CmsRequestContext context, String principalName) {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        I_CmsPrincipal result = null;
        try {
            result = this.m_driverManager.lookupPrincipal(dbc, CmsOrganizationalUnit.removeLeadingSeparator(principalName));
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markResourceAsVisitedBy(CmsRequestContext context, String poolName, CmsResource resource, CmsUser user) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.markResourceAsVisitedBy(dbc, poolName, resource, user);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_MARK_RESOURCE_AS_VISITED_2", context.getSitePath(resource), user.getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPublishList mergePublishLists(CmsRequestContext context, CmsPublishList pubList1, CmsPublishList pubList2) throws CmsException {
        CmsPublishList ret = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            HashSet<CmsResource> publishResources = new HashSet<CmsResource>(pubList1.getAllResources());
            publishResources.addAll(pubList2.getAllResources());
            ret = new CmsPublishList(pubList1.getDirectPublishResources(), pubList1.isPublishSiblings(), pubList1.isPublishSubResources());
            ret.addAll(publishResources, false);
            if (pubList1.isUserPublishList()) {
                ret.setUserPublishList(true);
            }
            ret.initialize();
            this.checkPublishPermissions(dbc, ret);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_MERGING_PUBLISH_LISTS_0"), e);
        }
        finally {
            dbc.clear();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveResource(CmsRequestContext context, CmsResource source, String destination) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.readResource(context, CmsResource.getParentFolder(destination), CmsResourceFilter.IGNORE_EXPIRATION);
            this.checkPermissions(dbc, source, CmsPermissionSet.ACCESS_READ, true, CmsResourceFilter.ALL);
            this.checkPermissions(dbc, source, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            this.checkSystemLocks(dbc, source);
            if (source.isFolder()) {
                dbc.getRequestContext().setAttribute("CHECK_PERMISSIONS", Boolean.TRUE);
                try {
                    this.m_driverManager.getVfsDriver(dbc).moveResource(dbc, dbc.currentProject().getUuid(), source, destination);
                }
                catch (CmsDataAccessException e) {
                    if (e.getCause() instanceof CmsPermissionViolationException) {
                        throw (CmsPermissionViolationException)e.getCause();
                    }
                    throw e;
                }
                dbc.getRequestContext().removeAttribute("CHECK_PERMISSIONS");
            }
            this.moveResource(dbc, source, destination);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_MOVE_RESOURCE_2", dbc.removeSiteRoot(source.getRootPath()), dbc.removeSiteRoot(destination)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String moveToLostAndFound(CmsRequestContext context, CmsResource resource, boolean returnNameOnly) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        String result = null;
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_READ, true, CmsResourceFilter.ALL);
            if (!returnNameOnly) {
                this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            }
            result = this.m_driverManager.moveToLostAndFound(dbc, resource, returnNameOnly);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_MOVE_TO_LOST_AND_FOUND_1", dbc.removeSiteRoot(resource.getRootPath())), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsUUID publishProject(CmsObject cms, CmsPublishList publishList, I_CmsReport report) throws CmsException {
        CmsRequestContext context = cms.getRequestContext();
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkPublishPermissions(dbc, publishList);
            this.m_driverManager.publishProject(cms, dbc, publishList, report);
        }
        finally {
            dbc.clear();
        }
        return publishList.getPublishHistoryId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsAlias readAliasByPath(CmsRequestContext context, String siteRoot, String path) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            CmsAlias alias;
            CmsAlias cmsAlias = alias = this.m_driverManager.readAliasByPath(dbc, context.getCurrentProject(), siteRoot, path);
            return cmsAlias;
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DB_OPERATION_0"), e);
            CmsAlias cmsAlias = null;
            return cmsAlias;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsAlias> readAliasesById(CmsRequestContext context, CmsUUID structureId) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            List<CmsAlias> aliases;
            List<CmsAlias> list = aliases = this.m_driverManager.readAliasesByStructureId(dbc, context.getCurrentProject(), structureId);
            return list;
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DB_OPERATION_0"), e);
            List<CmsAlias> list = null;
            return list;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<I_CmsHistoryResource> readAllAvailableVersions(CmsRequestContext context, CmsResource resource) throws CmsException {
        List<I_CmsHistoryResource> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readAllAvailableVersions(dbc, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_ALL_HISTORY_FILE_HEADERS_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsPropertyDefinition> readAllPropertyDefinitions(CmsRequestContext context) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsPropertyDefinition> result = null;
        try {
            result = this.m_driverManager.readAllPropertyDefinitions(dbc);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_ALL_PROPDEF_0"), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> readAllSubscribedResources(CmsRequestContext context, String poolName, CmsPrincipal principal) throws CmsException {
        List<CmsResource> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readAllSubscribedResources(dbc, poolName, principal);
        }
        catch (Exception e) {
            if (principal instanceof CmsUser) {
                dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_SUBSCRIBED_RESOURCES_ALL_USER_1", principal.getName()), e);
            } else {
                dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_SUBSCRIBED_RESOURCES_ALL_GROUP_1", principal.getName()), e);
            }
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readAllUrlNameMappingEntries(CmsRequestContext context, CmsUUID id) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            List<CmsUrlNameMappingEntry> entries = this.m_driverManager.readUrlNameMappingEntries(dbc, context.getCurrentProject().isOnlineProject(), CmsUrlNameMappingFilter.ALL.filterStructureId(id));
            ArrayList<String> result = new ArrayList<String>();
            for (CmsUrlNameMappingEntry entry : entries) {
                result.add(entry.getName());
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_READ_NEWEST_URLNAME_FOR_ID_1", id.toString());
            dbc.report(null, message, e);
            List<String> list = null;
            return list;
        }
        finally {
            dbc.clear();
        }
    }

    public CmsFolder readAncestor(CmsRequestContext context, CmsResource resource, CmsResourceFilter filter) throws CmsException {
        String path = CmsResource.getFolderPath(resource.getRootPath());
        do {
            if (!this.existsResource(context, path, filter)) continue;
            return this.readFolder(context, path, filter);
        } while (!CmsStringUtil.isEmpty(path = CmsResource.getParentFolder(path)) && path.startsWith(context.getSiteRoot()));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readBestUrlName(CmsRequestContext context, CmsUUID id, Locale locale, List<Locale> defaultLocales) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            String string = this.m_driverManager.readBestUrlName(dbc, id, locale, defaultLocales);
            return string;
        }
        catch (Exception e) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_READ_NEWEST_URLNAME_FOR_ID_1", id.toString());
            dbc.report(null, message, e);
            String string = null;
            return string;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> readChildResources(CmsRequestContext context, CmsResource resource, CmsResourceFilter filter, boolean getFolders, boolean getFiles) throws CmsException, CmsSecurityException {
        List<CmsResource> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_READ, true, CmsResourceFilter.ALL);
            result = this.m_driverManager.readChildResources(dbc, resource, filter, getFolders, getFiles, true);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_CHILD_RESOURCES_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsResource readDefaultFile(CmsRequestContext context, CmsResource resource, CmsResourceFilter resourceFilter) throws CmsSecurityException {
        CmsResource result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readDefaultFile(dbc, resource, resourceFilter);
            if (result != null) {
                this.checkPermissions(dbc, result, CmsPermissionSet.ACCESS_READ, true, resourceFilter);
            }
        }
        catch (CmsSecurityException se) {
            throw se;
        }
        catch (CmsException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<I_CmsHistoryResource> readDeletedResources(CmsRequestContext context, CmsResource resource, boolean readTree) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<I_CmsHistoryResource> result = null;
        try {
            boolean isVfsManager = this.hasRoleForResource(dbc, dbc.currentUser(), CmsRole.VFS_MANAGER, resource);
            result = this.m_driverManager.readDeletedResources(dbc, resource, readTree, isVfsManager);
        }
        catch (CmsException e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READING_DELETED_RESOURCES_1", dbc.removeSiteRoot(resource.getRootPath())), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsFile readFile(CmsRequestContext context, CmsResource resource) throws CmsException {
        CmsFile result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readFile(dbc, resource);
        }
        catch (Exception e) {
            if (resource instanceof I_CmsHistoryResource) {
                dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_FILE_HISTORY_2", context.getSitePath(resource), new Integer(resource.getVersion())), e);
            } else {
                dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_FILE_1", context.getSitePath(resource)), e);
            }
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsFolder readFolder(CmsRequestContext context, String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsFolder result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.readFolder(dbc, resourcename, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_FOLDER_2", resourcename, filter), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsGroup readGroup(CmsRequestContext context, CmsProject project) {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsGroup result = null;
        try {
            result = this.m_driverManager.readGroup(dbc, project);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsGroup readGroup(CmsRequestContext context, CmsUUID groupId) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsGroup result = null;
        try {
            result = this.m_driverManager.readGroup(dbc, groupId);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_GROUP_FOR_ID_1", groupId.toString()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsGroup readGroup(CmsRequestContext context, String groupname) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsGroup result = null;
        try {
            result = this.m_driverManager.readGroup(dbc, CmsOrganizationalUnit.removeLeadingSeparator(groupname));
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_GROUP_FOR_NAME_1", groupname), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsHistoryPrincipal readHistoricalPrincipal(CmsRequestContext context, CmsUUID principalId) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsHistoryPrincipal result = null;
        try {
            result = this.m_driverManager.readHistoricalPrincipal(dbc, principalId);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_HISTORY_PRINCIPAL_1", principalId), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsHistoryProject readHistoryProject(CmsRequestContext context, CmsUUID projectId) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsHistoryProject result = null;
        try {
            result = this.m_driverManager.readHistoryProject(dbc, projectId);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_HISTORY_PROJECT_2", projectId, dbc.currentProject().getName()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsHistoryProject readHistoryProject(CmsRequestContext context, int publishTag) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsHistoryProject result = null;
        try {
            result = this.m_driverManager.readHistoryProject(dbc, publishTag);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_HISTORY_PROJECT_2", new Integer(publishTag), dbc.currentProject().getName()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsProperty> readHistoryPropertyObjects(CmsRequestContext context, I_CmsHistoryResource resource) throws CmsException {
        List<CmsProperty> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readHistoryPropertyObjects(dbc, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_PROPS_FOR_RESOURCE_1", context.getSitePath((CmsResource)((Object)resource))), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsUUID readIdForUrlName(CmsRequestContext context, String name) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            CmsUUID cmsUUID = this.m_driverManager.readIdForUrlName(dbc, name);
            return cmsUUID;
        }
        catch (Exception e) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_READ_ID_FOR_URLNAME_1", name);
            dbc.report(null, message, e);
            CmsUUID cmsUUID = null;
            return cmsUUID;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readLocks() throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext();
        try {
            this.m_driverManager.readLocks(dbc);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsGroup readManagerGroup(CmsRequestContext context, CmsProject project) {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsGroup result = null;
        try {
            result = this.m_driverManager.readManagerGroup(dbc, project);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsOrganizationalUnit readOrganizationalUnit(CmsRequestContext context, String ouFqn) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsOrganizationalUnit result = null;
        try {
            result = this.m_driverManager.readOrganizationalUnit(dbc, CmsOrganizationalUnit.removeLeadingSeparator(ouFqn));
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_ORGUNIT_1", ouFqn), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsUser readOwner(CmsRequestContext context, CmsProject project) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsUser result = null;
        try {
            result = this.m_driverManager.readOwner(dbc, project);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_OWNER_FOR_PROJECT_2", project.getName(), project.getUuid()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsResource readParentFolder(CmsRequestContext context, CmsUUID structureId) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsResource result = null;
        try {
            result = this.m_driverManager.readParentFolder(dbc, structureId);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_PARENT_FOLDER_2", dbc.currentProject().getName(), structureId), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> readPath(CmsRequestContext context, String path, CmsResourceFilter filter) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsResource> result = null;
        try {
            result = this.m_driverManager.readPath(dbc, path, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_PATH_2", dbc.currentProject().getName(), path), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsProject readProject(CmsUUID id) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext();
        CmsProject result = null;
        try {
            result = this.m_driverManager.readProject(dbc, id);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_PROJECT_FOR_ID_1", id), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsProject readProject(String name) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext();
        CmsProject result = null;
        try {
            result = this.m_driverManager.readProject(dbc, CmsOrganizationalUnit.removeLeadingSeparator(name));
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_PROJECT_FOR_NAME_1", name), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readProjectResources(CmsRequestContext context, CmsProject project) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<String> result = null;
        try {
            result = this.m_driverManager.readProjectResources(dbc, project);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_PROJECT_RESOURCES_2", project.getName(), project.getUuid()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> readProjectView(CmsRequestContext context, CmsUUID projectId, CmsResourceState state) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsResource> result = null;
        try {
            result = this.m_driverManager.readProjectView(dbc, projectId, state);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_PROJECT_VIEW_1", projectId), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPropertyDefinition readPropertyDefinition(CmsRequestContext context, String name) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsPropertyDefinition result = null;
        try {
            result = this.m_driverManager.readPropertyDefinition(dbc, name);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_PROPDEF_1", name), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsProperty readPropertyObject(CmsRequestContext context, CmsResource resource, String key, boolean search) throws CmsException {
        CmsProperty result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readPropertyObject(dbc, resource, key, search);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_PROP_FOR_RESOURCE_2", key, context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsProperty> readPropertyObjects(CmsRequestContext context, CmsResource resource, boolean search) throws CmsException {
        List<CmsProperty> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readPropertyObjects(dbc, resource, search);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_PROPS_FOR_RESOURCE_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsPublishedResource> readPublishedResources(CmsRequestContext context, CmsUUID publishHistoryId) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsPublishedResource> result = null;
        try {
            result = this.m_driverManager.readPublishedResources(dbc, publishHistoryId);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_PUBLISHED_RESOURCES_FOR_ID_1", publishHistoryId.toString()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I_CmsHistoryResource readResource(CmsRequestContext context, CmsResource resource, int version) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        I_CmsHistoryResource result = null;
        try {
            result = this.m_driverManager.readResource(dbc, resource, version);
        }
        catch (CmsException e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READING_RESOURCE_VERSION_2", dbc.removeSiteRoot(resource.getRootPath()), new Integer(version)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsResource readResource(CmsRequestContext context, CmsUUID structureID, CmsResourceFilter filter) throws CmsException {
        CmsResource result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.readResource(dbc, structureID, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_RESOURCE_FOR_ID_1", structureID), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsResource readResource(CmsRequestContext context, String resourcePath, CmsResourceFilter filter) throws CmsException {
        CmsResource result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.readResource(dbc, resourcePath, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_RESOURCE_1", dbc.removeSiteRoot(resourcePath)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> readResources(CmsRequestContext context, CmsResource parent, CmsResourceFilter filter, boolean readTree) throws CmsException, CmsSecurityException {
        List<CmsResource> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkPermissions(dbc, parent, CmsPermissionSet.ACCESS_READ, true, CmsResourceFilter.ALL);
            result = this.m_driverManager.readResources(dbc, parent, filter, readTree);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_RESOURCES_1", context.removeSiteRoot(parent.getRootPath())), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> readResourcesVisitedBy(CmsRequestContext context, String poolName, CmsVisitedByFilter filter) throws CmsException {
        List<CmsResource> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readResourcesVisitedBy(dbc, poolName, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_VISITED_RESOURCES_1", filter.toString()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> readResourcesWithProperty(CmsRequestContext context, CmsResource folder, String propertyDefinition, String value, CmsResourceFilter filter) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<CmsResource> result = null;
        try {
            result = this.m_driverManager.readResourcesWithProperty(dbc, folder, propertyDefinition, value, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_RESOURCES_FOR_PROP_VALUE_3", context.removeSiteRoot(folder.getRootPath()), propertyDefinition, value), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<I_CmsPrincipal> readResponsiblePrincipals(CmsRequestContext context, CmsResource resource) throws CmsException {
        Set<I_CmsPrincipal> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readResponsiblePrincipals(dbc, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_RESPONSIBLE_USERS_1", resource.getRootPath()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CmsUser> readResponsibleUsers(CmsRequestContext context, CmsResource resource) throws CmsException {
        Set<CmsUser> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readResponsibleUsers(dbc, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_RESPONSIBLE_USERS_1", resource.getRootPath()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> readSiblings(CmsRequestContext context, CmsResource resource, CmsResourceFilter filter) throws CmsException {
        List<CmsResource> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readSiblings(dbc, resource, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_SIBLINGS_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readStaticExportPublishedResourceParameters(CmsRequestContext context, String rfsName) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        String result = null;
        try {
            result = this.m_driverManager.readStaticExportPublishedResourceParameters(dbc, rfsName);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_STATEXP_PUBLISHED_RESOURCE_PARAMS_1", rfsName), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readStaticExportResources(CmsRequestContext context, int parameterResources, long timestamp) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        List<String> result = null;
        try {
            result = this.m_driverManager.readStaticExportResources(dbc, parameterResources, timestamp);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_STATEXP_RESOURCES_1", new Date(timestamp)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<I_CmsHistoryResource> readSubscribedDeletedResources(CmsRequestContext context, String poolName, CmsUser user, List<CmsGroup> groups, CmsResource parent, boolean includeSubFolders, long deletedFrom) throws CmsException {
        List<I_CmsHistoryResource> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readSubscribedDeletedResources(dbc, poolName, user, groups, parent, includeSubFolders, deletedFrom);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_SUBSCRIBED_DELETED_RESOURCES_1", user.getName()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> readSubscribedResources(CmsRequestContext context, String poolName, CmsSubscriptionFilter filter) throws CmsException {
        List<CmsResource> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.readSubscribedResources(dbc, poolName, filter);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_SUBSCRIBED_RESOURCES_1", filter.toString()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsUrlNameMappingEntry> readUrlNameMappings(CmsRequestContext context, CmsUrlNameMappingFilter filter) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            List<CmsUrlNameMappingEntry> list = this.m_driverManager.readUrlNameMappings(dbc, filter);
            return list;
        }
        catch (Exception e) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_DB_OPERATION_1", e.getLocalizedMessage());
            dbc.report(null, message, e);
            List<CmsUrlNameMappingEntry> list = null;
            return list;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readUrlNamesForAllLocales(CmsRequestContext context, CmsUUID id) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            List<String> list = this.m_driverManager.readUrlNamesForAllLocales(dbc, id);
            return list;
        }
        catch (Exception e) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_READ_NEWEST_URLNAME_FOR_ID_1", id.toString());
            dbc.report(null, message, e);
            List<String> list = null;
            return list;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsUser readUser(CmsRequestContext context, CmsUUID id) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsUser result = null;
        try {
            result = this.m_driverManager.readUser(dbc, id);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_USER_FOR_ID_1", id.toString()), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsUser readUser(CmsRequestContext context, String username) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsUser result = null;
        try {
            result = this.m_driverManager.readUser(dbc, CmsOrganizationalUnit.removeLeadingSeparator(username));
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_USER_FOR_NAME_1", username), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsUser readUser(CmsRequestContext context, String username, String password) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsUser result = null;
        try {
            result = this.m_driverManager.readUser(dbc, CmsOrganizationalUnit.removeLeadingSeparator(username), password);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_READ_USER_FOR_NAME_1", username), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessControlEntry(CmsRequestContext context, CmsResource resource, CmsUUID principal) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_CONTROL, true, CmsResourceFilter.ALL);
            this.m_driverManager.removeAccessControlEntry(dbc, resource, principal);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_REMOVE_ACL_ENTRY_2", context.getSitePath(resource), principal.toString()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceFromOrgUnit(CmsRequestContext context, CmsOrganizationalUnit orgUnit, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkRole(dbc, CmsRole.ADMINISTRATOR.forOrgUnit(orgUnit.getName()));
            this.checkOfflineProject(dbc);
            this.m_driverManager.removeResourceFromOrgUnit(dbc, orgUnit, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_REMOVE_RESOURCE_FROM_ORGUNIT_2", orgUnit.getName(), dbc.removeSiteRoot(resource.getRootPath())), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceFromProject(CmsRequestContext context, CmsResource resource) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkManagerOfProjectRole(dbc, context.getCurrentProject());
            this.m_driverManager.removeResourceFromProject(dbc, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_COPY_RESOURCE_TO_PROJECT_2", context.getSitePath(resource), context.getCurrentProject().getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceFromUsersPubList(CmsRequestContext context, Collection<CmsUUID> structureIds) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.removeResourceFromUsersPubList(dbc, context.getCurrentUser().getId(), structureIds);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_REMOVE_RESOURCE_FROM_PUBLIST_2", context.getCurrentUser().getName(), structureIds), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserFromGroup(CmsRequestContext context, String username, String groupname, boolean readRoles) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            CmsRole role = CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(groupname));
            this.checkRoleForUserModification(dbc, username, role);
            this.m_driverManager.removeUserFromGroup(dbc, CmsOrganizationalUnit.removeLeadingSeparator(username), CmsOrganizationalUnit.removeLeadingSeparator(groupname), readRoles);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_REMOVE_USER_FROM_GROUP_2", username, groupname), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceResource(CmsRequestContext context, CmsResource resource, int type, byte[] content, List<CmsProperty> properties) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            if (CmsResourceTypeJsp.isJspTypeId(type)) {
                this.checkRoleForResource(dbc, CmsRole.DEVELOPER, resource);
            }
            this.m_driverManager.replaceResource(dbc, resource, type, content, properties);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_REPLACE_RESOURCE_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPassword(CmsRequestContext context, String username, String oldPassword, String newPassword) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.resetPassword(dbc, CmsOrganizationalUnit.removeLeadingSeparator(username), oldPassword, newPassword);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_RESET_PASSWORD_1", username), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resourceOriginalPath(CmsRequestContext context, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        String result = null;
        try {
            this.checkOfflineProject(dbc);
            result = this.m_driverManager.getVfsDriver(dbc).readResource(dbc, CmsProject.ONLINE_PROJECT_ID, resource.getStructureId(), true).getRootPath();
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_TEST_MOVED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreDeletedResource(CmsRequestContext context, CmsUUID structureId) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.m_driverManager.restoreDeletedResource(dbc, structureId);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_RESTORE_DELETED_RESOURCE_1", structureId), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreResource(CmsRequestContext context, CmsResource resource, int version) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            this.m_driverManager.restoreResource(dbc, resource, version);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_RESTORE_RESOURCE_2", context.getSitePath(resource), new Integer(version)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAliases(CmsRequestContext context, CmsResource resource, List<CmsAlias> aliases) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            if (aliases.size() > 0 && !resource.getStructureId().equals(aliases.get(0).getStructureId())) {
                throw new IllegalArgumentException("Resource does not match aliases!");
            }
            this.checkPermissions(context, resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
            this.m_driverManager.saveAliases(dbc, context.getCurrentProject(), resource.getStructureId(), aliases);
            HashMap<String, Object> eventData = new HashMap<String, Object>();
            eventData.put("resource", resource);
            eventData.put("change", new Integer(8));
            OpenCms.fireCmsEvent(new CmsEvent(11, eventData));
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DB_OPERATION_0"), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRewriteAliases(CmsRequestContext requestContext, String siteRoot, List<CmsRewriteAlias> newAliases) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(requestContext);
        try {
            this.m_driverManager.saveRewriteAliases(dbc, siteRoot, newAliases);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DB_OPERATION_0"), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsUser> searchUsers(CmsRequestContext requestContext, CmsUserSearchParameters searchParams) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(requestContext);
        try {
            List<CmsUser> list = this.m_driverManager.searchUsers(dbc, searchParams);
            return list;
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_SEARCH_USERS_0"), e);
            List<CmsUser> list = null;
            return list;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDateExpired(CmsRequestContext context, CmsResource resource, long dateExpired) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.IGNORE_EXPIRATION);
            this.m_driverManager.setDateExpired(dbc, resource, dateExpired);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_SET_DATE_EXPIRED_2", new Object[]{new Date(dateExpired), context.getSitePath(resource)}), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDateLastModified(CmsRequestContext context, CmsResource resource, long dateLastModified) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.IGNORE_EXPIRATION);
            this.m_driverManager.setDateLastModified(dbc, resource, dateLastModified);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_SET_DATE_LAST_MODIFIED_2", new Object[]{new Date(dateLastModified), context.getSitePath(resource)}), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDateReleased(CmsRequestContext context, CmsResource resource, long dateReleased) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.IGNORE_EXPIRATION);
            this.m_driverManager.setDateReleased(dbc, resource, dateReleased);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_SET_DATE_RELEASED_2", new Object[]{new Date(dateReleased), context.getSitePath(resource)}), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentGroup(CmsRequestContext context, String groupName, String parentGroupName) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkRole(dbc, CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(groupName)));
            this.m_driverManager.setParentGroup(dbc, CmsOrganizationalUnit.removeLeadingSeparator(groupName), CmsOrganizationalUnit.removeLeadingSeparator(parentGroupName));
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_SET_PARENT_GROUP_2", parentGroupName, groupName), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(CmsRequestContext context, String username, String newPassword) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            CmsRole role = CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(username));
            this.checkRoleForUserModification(dbc, username, role);
            this.m_driverManager.setPassword(dbc, CmsOrganizationalUnit.removeLeadingSeparator(username), newPassword);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_SET_PASSWORD_1", username), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscribedResourceAsDeleted(CmsRequestContext context, String poolName, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.setSubscribedResourceAsDeleted(dbc, poolName, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_SET_SUBSCRIBED_RESOURCE_AS_DELETED_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsersOrganizationalUnit(CmsRequestContext context, CmsOrganizationalUnit orgUnit, CmsUser user) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkRole(dbc, CmsRole.ADMINISTRATOR.forOrgUnit(orgUnit.getName()));
            this.checkOfflineProject(dbc);
            this.m_driverManager.setUsersOrganizationalUnit(dbc, orgUnit, user);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_SET_USERS_ORGUNIT_2", orgUnit.getName(), user.getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeResourceFor(CmsRequestContext context, String poolName, CmsPrincipal principal, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.subscribeResourceFor(dbc, poolName, principal, resource);
        }
        catch (Exception e) {
            if (principal instanceof CmsUser) {
                dbc.report(null, org.opencms.db.Messages.get().container("ERR_SUBSCRIBE_RESOURCE_FOR_USER_2", context.getSitePath(resource), principal.getName()), e);
            } else {
                dbc.report(null, org.opencms.db.Messages.get().container("ERR_SUBSCRIBE_RESOURCE_FOR_GROUP_2", context.getSitePath(resource), principal.getName()), e);
            }
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undelete(CmsRequestContext context, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            this.checkSystemLocks(dbc, resource);
            this.m_driverManager.undelete(dbc, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_UNDELETE_FOR_RESOURCE_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoChanges(CmsRequestContext context, CmsResource resource, CmsResource.CmsResourceUndoMode mode) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            this.checkSystemLocks(dbc, resource);
            this.m_driverManager.undoChanges(dbc, resource, mode);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_UNDO_CHANGES_FOR_RESOURCE_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockProject(CmsRequestContext context, CmsUUID projectId) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsProject project = this.m_driverManager.readProject(dbc, projectId);
        try {
            this.checkManagerOfProjectRole(dbc, project);
            this.m_driverManager.unlockProject(project);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_UNLOCK_PROJECT_2", projectId, dbc.currentUser().getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockResource(CmsRequestContext context, CmsResource resource) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            this.m_driverManager.unlockResource(dbc, resource, false, false);
        }
        catch (CmsException e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_UNLOCK_RESOURCE_3", context.getSitePath(resource), dbc.currentUser().getName(), e.getLocalizedMessage(dbc.getRequestContext().getLocale())), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeAllDeletedResources(CmsRequestContext context, String poolName, long deletedTo) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.unsubscribeAllDeletedResources(dbc, poolName, deletedTo);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_UNSUBSCRIBE_ALL_DELETED_RESOURCES_USER_0"), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeAllResourcesFor(CmsRequestContext context, String poolName, CmsPrincipal principal) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.unsubscribeAllResourcesFor(dbc, poolName, principal);
        }
        catch (Exception e) {
            if (principal instanceof CmsUser) {
                dbc.report(null, org.opencms.db.Messages.get().container("ERR_UNSUBSCRIBE_ALL_RESOURCES_USER_1", principal.getName()), e);
            } else {
                dbc.report(null, org.opencms.db.Messages.get().container("ERR_UNSUBSCRIBE_ALL_RESOURCES_GROUP_1", principal.getName()), e);
            }
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeResourceFor(CmsRequestContext context, String poolName, CmsPrincipal principal, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.unsubscribeResourceFor(dbc, poolName, principal, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_UNSUBSCRIBE_RESOURCE_FOR_GROUP_2", context.getSitePath(resource), principal.getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeResourceForAll(CmsRequestContext context, String poolName, CmsResource resource) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.unsubscribeResourceForAll(dbc, poolName, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_UNSUBSCRIBE_RESOURCE_ALL_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLog() throws CmsException {
        if (this.m_dbContextFactory == null) {
            return;
        }
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext();
        try {
            this.m_driverManager.updateLog(dbc);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRelationsForResource(CmsRequestContext context, CmsResource resource, List<CmsLink> relations) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.updateRelationsForResource(dbc, resource, relations);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_UPDATE_RELATIONS_1", dbc.removeSiteRoot(resource.getRootPath())), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean userInGroup(CmsRequestContext context, String username, String groupname) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        boolean result = false;
        try {
            result = this.m_driverManager.userInGroup(dbc, CmsOrganizationalUnit.removeLeadingSeparator(username), CmsOrganizationalUnit.removeLeadingSeparator(groupname), false);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_USER_IN_GROUP_2", username, groupname), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    public void validatePassword(String password) throws CmsSecurityException {
        this.m_driverManager.validatePassword(password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<CmsRelation>> validateRelations(CmsRequestContext context, CmsPublishList publishList, I_CmsReport report) throws Exception {
        Map<String, List<CmsRelation>> result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            result = this.m_driverManager.validateRelations(dbc, publishList, report);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_VALIDATE_RELATIONS_0"), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAccessControlEntry(CmsRequestContext context, CmsResource resource, CmsAccessControlEntry ace) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_CONTROL, true, CmsResourceFilter.ALL);
            if (ace.getPrincipal().equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID)) {
                this.checkRoleForResource(dbc, CmsRole.VFS_MANAGER, resource);
            }
            this.m_driverManager.writeAccessControlEntry(dbc, resource, ace);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_WRITE_ACL_ENTRY_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsFile writeFile(CmsRequestContext context, CmsFile resource) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        CmsFile result = null;
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, (CmsResource)resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            result = this.m_driverManager.writeFile(dbc, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_WRITE_FILE_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGroup(CmsRequestContext context, CmsGroup group) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkRole(dbc, CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(group.getName())));
            this.m_driverManager.writeGroup(dbc, group);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_WRITE_GROUP_1", group.getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHistoryProject(CmsRequestContext context, int publishTag, long publishDate) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.writeHistoryProject(dbc, publishTag, publishDate);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_HISTORY_PROJECT_4", new Object[]{new Integer(publishTag), dbc.currentProject().getName(), dbc.currentProject().getUuid(), new Long(publishDate)}), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLocks() throws CmsException {
        if (this.m_dbContextFactory == null) {
            return;
        }
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext();
        try {
            this.m_driverManager.writeLocks(dbc);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOrganizationalUnit(CmsRequestContext context, CmsOrganizationalUnit organizationalUnit) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkRole(dbc, CmsRole.ADMINISTRATOR.forOrgUnit(organizationalUnit.getName()));
            this.checkOfflineProject(dbc);
            this.m_driverManager.writeOrganizationalUnit(dbc, organizationalUnit);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_WRITE_ORGUNIT_1", organizationalUnit.getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProject(CmsRequestContext context, CmsProject project) throws CmsRoleViolationException, CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkManagerOfProjectRole(dbc, project);
            this.m_driverManager.writeProject(dbc, project);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_WRITE_PROJECT_1", project.getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePropertyObject(CmsRequestContext context, CmsResource resource, CmsProperty property) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.IGNORE_EXPIRATION);
            this.m_driverManager.writePropertyObject(dbc, resource, property);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_WRITE_PROP_2", property.getName(), context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePropertyObjects(CmsRequestContext context, CmsResource resource, List<CmsProperty> properties) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.IGNORE_EXPIRATION);
            this.m_driverManager.writePropertyObjects(dbc, resource, properties, true);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_WRITE_PROPS_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResource(CmsRequestContext context, CmsResource resource) throws CmsException, CmsSecurityException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            this.m_driverManager.writeResource(dbc, resource);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_WRITE_RESOURCE_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResourceProjectLastModified(CmsRequestContext context, CmsResource resource, CmsProject project) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.checkOfflineProject(dbc);
            this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            this.m_driverManager.writeProjectLastModified(dbc, resource, project.getUuid());
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_WRITE_RESOURCE_1", context.getSitePath(resource)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStaticExportPublishedResource(CmsRequestContext context, String resourceName, int linkType, String linkParameter, long timestamp) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            this.m_driverManager.writeStaticExportPublishedResource(dbc, resourceName, linkType, linkParameter, timestamp);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_WRITE_STATEXP_PUBLISHED_RESOURCES_3", resourceName, linkParameter, new Date(timestamp)), e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeUrlNameMapping(CmsRequestContext context, Iterator<String> nameSeq, CmsUUID structureId, String locale, boolean replaceOnPublish) throws CmsException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            String string = this.m_driverManager.writeUrlNameMapping(dbc, nameSeq, structureId, locale, replaceOnPublish);
            return string;
        }
        catch (Exception e) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_ADD_URLNAME_MAPPING_2", nameSeq.toString(), structureId.toString());
            dbc.report(null, message, e);
            String string = null;
            return string;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUser(CmsRequestContext context, CmsUser user) throws CmsException, CmsRoleViolationException {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            CmsRole role = CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(user.getName()));
            this.checkRoleForUserModification(dbc, user.getName(), role);
            this.m_driverManager.writeUser(dbc, user);
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_WRITE_USER_1", user.getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    protected void checkPermissions(CmsDbContext dbc, CmsResource resource, CmsPermissionSet requiredPermissions, boolean checkLock, CmsResourceFilter filter) throws CmsException, CmsSecurityException {
        I_CmsPermissionHandler.CmsPermissionCheckResult permissions = this.hasPermissions(dbc, resource, requiredPermissions, checkLock, filter);
        if (!permissions.isAllowed()) {
            this.checkPermissions(dbc.getRequestContext(), resource, requiredPermissions, permissions);
        }
    }

    protected void checkPermissions(CmsRequestContext context, CmsResource resource, CmsPermissionSet requiredPermissions, I_CmsPermissionHandler.CmsPermissionCheckResult permissions) throws CmsSecurityException, CmsLockException, CmsVfsResourceNotFoundException {
        if (permissions == I_CmsPermissionHandler.PERM_FILTERED) {
            throw new CmsVfsResourceNotFoundException(org.opencms.db.Messages.get().container("ERR_PERM_FILTERED_1", context.getSitePath(resource)));
        }
        if (permissions == I_CmsPermissionHandler.PERM_DENIED) {
            throw new CmsPermissionViolationException(org.opencms.db.Messages.get().container("ERR_PERM_DENIED_2", context.getSitePath(resource), requiredPermissions.getPermissionString()));
        }
        if (permissions == I_CmsPermissionHandler.PERM_NOTLOCKED) {
            throw new CmsLockException(org.opencms.db.Messages.get().container("ERR_PERM_NOTLOCKED_2", context.getSitePath(resource), context.getCurrentUser().getName()));
        }
    }

    protected void checkRoleForUserModification(CmsDbContext dbc, String username, CmsRole role) throws CmsDataAccessException, CmsRoleViolationException {
        CmsUser userToModify = this.m_driverManager.readUser(dbc, CmsOrganizationalUnit.removeLeadingSeparator(username));
        if (dbc.currentUser().equals(userToModify)) {
            return;
        }
        if (this.hasRole(dbc, dbc.currentUser(), CmsRole.ROOT_ADMIN)) {
            return;
        }
        if (this.hasRole(dbc, userToModify, CmsRole.ADMINISTRATOR)) {
            this.checkRole(dbc, CmsRole.ADMINISTRATOR);
        } else {
            this.checkRole(dbc, role);
        }
    }

    protected void checkSystemLocks(CmsDbContext dbc, CmsResource resource) throws CmsException {
        if (this.m_lockManager.hasSystemLocks(dbc, resource)) {
            throw new CmsLockException(org.opencms.db.Messages.get().container("ERR_RESOURCE_SYSTEM_LOCKED_1", dbc.removeSiteRoot(resource.getRootPath())));
        }
    }

    protected void deleteResource(CmsDbContext dbc, CmsResource resource, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        if (resource.isFolder()) {
            List<CmsResource> resources = this.m_driverManager.readChildResources(dbc, resource, CmsResourceFilter.IGNORE_EXPIRATION, true, true, false);
            HashSet<CmsUUID> deletedResources = new HashSet<CmsUUID>();
            for (int i = 0; i < resources.size(); ++i) {
                CmsResource childResource = resources.get(i);
                if (siblingMode == CmsResource.DELETE_REMOVE_SIBLINGS && deletedResources.contains(childResource.getResourceId())) continue;
                if (childResource.isFolder()) {
                    this.deleteResource(dbc, childResource, siblingMode);
                } else {
                    this.m_driverManager.deleteResource(dbc, childResource, siblingMode);
                }
                deletedResources.add(childResource.getResourceId());
            }
            deletedResources.clear();
        }
        this.m_driverManager.deleteResource(dbc, resource, siblingMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteUser(CmsRequestContext context, CmsUser user, CmsUser replacement) throws CmsException, CmsSecurityException, CmsRoleViolationException {
        if (OpenCms.getDefaultUsers().isDefaultUser(user.getName())) {
            throw new CmsSecurityException(org.opencms.security.Messages.get().container("ERR_CANT_DELETE_DEFAULT_USER_1", user.getName()));
        }
        if (context.getCurrentUser().equals(user)) {
            throw new CmsSecurityException(org.opencms.db.Messages.get().container("ERR_USER_CANT_DELETE_ITSELF_USER_0"));
        }
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(context);
        try {
            CmsRole role = CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParentOrganizationalUnit(user.getName()));
            this.checkRoleForUserModification(dbc, user.getName(), role);
            this.checkProjectForDeletePrincipal(dbc);
            if (replacement == null) {
                this.m_driverManager.deleteUser(dbc, context.getCurrentProject(), user.getName(), null);
            } else {
                this.m_driverManager.deleteUser(dbc, context.getCurrentProject(), user.getName(), replacement.getName());
            }
        }
        catch (Exception e) {
            dbc.report(null, org.opencms.db.Messages.get().container("ERR_DELETE_USER_1", user.getName()), e);
        }
        finally {
            dbc.clear();
        }
    }

    protected List<CmsResource> getManageableResources(CmsDbContext dbc, CmsRole role) throws CmsException {
        CmsOrganizationalUnit ou = this.m_driverManager.readOrganizationalUnit(dbc, role.getOuFqn());
        if (this.hasRole(dbc, dbc.currentUser(), role)) {
            return this.m_driverManager.getResourcesForOrganizationalUnit(dbc, ou);
        }
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        for (CmsOrganizationalUnit orgUnit : this.m_driverManager.getOrganizationalUnits(dbc, ou, false)) {
            resources.addAll(this.getManageableResources(dbc, role.forOrgUnit(orgUnit.getName())));
        }
        return resources;
    }

    protected String getParentOrganizationalUnit(String fqn) {
        String ouFqn = CmsOrganizationalUnit.getParentFqn(CmsOrganizationalUnit.removeLeadingSeparator(fqn));
        if (ouFqn == null) {
            ouFqn = "";
        }
        return ouFqn;
    }

    protected I_CmsPermissionHandler.CmsPermissionCheckResult hasPermissions(CmsDbContext dbc, CmsResource resource, CmsPermissionSet requiredPermissions, boolean checkLock, CmsResourceFilter filter) throws CmsException {
        return this.m_permissionHandler.hasPermissions(dbc, resource, requiredPermissions, checkLock, filter);
    }

    protected boolean hasRole(CmsRole role, List<CmsGroup> roles) {
        for (CmsGroup group : roles) {
            String groupName = group.getName();
            for (String distictGroupName : role.getDistinctGroupNames()) {
                if (distictGroupName.startsWith("/")) {
                    if (!groupName.equals(distictGroupName.substring(1))) continue;
                    return true;
                }
                if (!groupName.endsWith("/" + distictGroupName) && !groupName.equals(distictGroupName)) continue;
                if (role.getOuFqn() == null) {
                    return true;
                }
                String groupFqn = CmsOrganizationalUnit.getParentFqn(groupName);
                if (!role.getOuFqn().startsWith(groupFqn)) continue;
                return true;
            }
        }
        return false;
    }

    protected void moveResource(CmsDbContext dbc, CmsResource source, String destination) throws CmsException {
        List<CmsResource> resources;
        block6: {
            resources = null;
            if (source.isFolder()) {
                if (!CmsResource.isFolder(destination)) {
                    destination = destination.concat("/");
                }
                resources = this.m_driverManager.readChildResources(dbc, source, CmsResourceFilter.ALL, true, true, false);
            }
            this.m_driverManager.moveResource(dbc, source, destination, false);
            CmsResource destinationResource = this.m_driverManager.readResource(dbc, destination, CmsResourceFilter.ALL);
            try {
                this.m_driverManager.lockResource(dbc, destinationResource, CmsLockType.EXCLUSIVE);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block6;
                LOG.warn((Object)e);
            }
        }
        if (resources != null) {
            for (int i = 0; i < resources.size(); ++i) {
                CmsResource childResource = resources.get(i);
                String childDestination = destination.concat(childResource.getName());
                this.moveResource(dbc, childResource, childDestination);
            }
        }
    }

    protected CmsFolder readFolder(CmsDbContext dbc, String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(dbc, resourcename, filter);
        return this.m_driverManager.convertResourceToFolder(resource);
    }

    protected CmsResource readResource(CmsDbContext dbc, CmsUUID structureID, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.m_driverManager.readResource(dbc, structureID, filter);
        this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_READ, true, filter);
        return resource;
    }

    protected CmsResource readResource(CmsDbContext dbc, String resourcePath, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.m_driverManager.readResource(dbc, resourcePath, filter);
        this.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_READ, true, filter);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProjectForDeletePrincipal(CmsDbContext dbc) throws CmsDataAccessException {
        CmsProject currentProject = dbc.currentProject();
        if (currentProject.isOnlineProject()) {
            try {
                List<CmsProject> projects = this.m_driverManager.getProjectDriver(dbc).readProjects(dbc, "");
                for (CmsProject project : projects) {
                    if (project.isOnlineProject()) continue;
                    CmsResource root = null;
                    try {
                        dbc.setProjectId(project.getUuid());
                        root = this.m_driverManager.readResource(dbc, "/", CmsResourceFilter.ALL);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (root == null) continue;
                    throw new CmsVfsException(org.opencms.file.Messages.get().container("ERR_NOT_ALLOWED_IN_ONLINE_PROJECT_0"));
                }
            }
            finally {
                dbc.setProjectId(currentProject.getUuid());
            }
        }
    }
}

