/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import org.opencms.util.A_CmsModeIntEnumeration;

public final class CmsSubscriptionReadMode
extends A_CmsModeIntEnumeration {
    public static final String MODE_NAME_ALL = "all";
    public static final String MODE_NAME_UNVISITED = "unvisited";
    public static final String MODE_NAME_VISITED = "visited";
    public static final CmsSubscriptionReadMode ALL = new CmsSubscriptionReadMode(1);
    public static final CmsSubscriptionReadMode UNVISITED = new CmsSubscriptionReadMode(2);
    public static final CmsSubscriptionReadMode VISITED = new CmsSubscriptionReadMode(3);
    private static final long serialVersionUID = 7547476104782346902L;

    private CmsSubscriptionReadMode(int mode) {
        super(mode);
    }

    public static CmsSubscriptionReadMode modeForName(String modeName) {
        if (MODE_NAME_ALL.equals(modeName)) {
            return ALL;
        }
        if (MODE_NAME_VISITED.equals(modeName)) {
            return VISITED;
        }
        return UNVISITED;
    }

    public static CmsSubscriptionReadMode valueOf(int type) {
        switch (type) {
            case 1: {
                return ALL;
            }
            case 2: {
                return UNVISITED;
            }
            case 3: {
                return VISITED;
            }
        }
        return UNVISITED;
    }

    public boolean isAll() {
        return this.getMode() == ALL.getMode();
    }

    public boolean isUnVisited() {
        return this.getMode() == UNVISITED.getMode();
    }

    public boolean isVisited() {
        return this.getMode() == VISITED.getMode();
    }

    @Override
    public String toString() {
        switch (this.getMode()) {
            case 1: {
                return MODE_NAME_ALL;
            }
            case 2: {
                return MODE_NAME_UNVISITED;
            }
            case 3: {
                return MODE_NAME_VISITED;
            }
        }
        return MODE_NAME_UNVISITED;
    }

    protected Object clone() {
        return new CmsSubscriptionReadMode(this.getMode());
    }
}

