/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.jpa;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryAlreadyExistsException;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbIoException;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsVisitEntryFilter;
import org.opencms.db.I_CmsUserDriver;
import org.opencms.db.Messages;
import org.opencms.db.generic.CmsUserQueryBuilder;
import org.opencms.db.jpa.CmsJpaUserQueryBuilder;
import org.opencms.db.jpa.CmsSqlManager;
import org.opencms.db.jpa.persistence.CmsDAOGroupUsers;
import org.opencms.db.jpa.persistence.CmsDAOGroups;
import org.opencms.db.jpa.persistence.CmsDAOOfflineAccessControl;
import org.opencms.db.jpa.persistence.CmsDAOOnlineAccessControl;
import org.opencms.db.jpa.persistence.CmsDAOUserData;
import org.opencms.db.jpa.persistence.CmsDAOUsers;
import org.opencms.db.jpa.persistence.I_CmsDAOAccessControl;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsUserSearchParameters;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPasswordEncryptionException;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsUserDriver
implements I_CmsUserDriver {
    public static final String ORGUNIT_BASE_FOLDER = "/system/orgunits/";
    public static final String REQ_ATTR_DONT_DIGEST_PASSWORD = "DONT_DIGEST_PASSWORD";
    private static final String ATTRIBUTE_USERADDINFO = "A_USERADDINFO";
    private static final String ATTRIBUTE_USERADDINFO_VALUE_DELETE = "delete";
    private static final String ATTRIBUTE_USERADDINFO_VALUE_INSERT = "insert";
    private static final String ATTRIBUTE_USERADDINFO_VALUE_UPDATE = "update";
    private static final String C_ACCESS_READ_ENTRIES_0 = "C_ACCESS_READ_ENTRIES_0";
    private static final String C_ACCESS_READ_ENTRIES_1 = "C_ACCESS_READ_ENTRIES_1";
    private static final String C_ACCESS_READ_ENTRY_2 = "C_ACCESS_READ_ENTRY_2";
    private static final String C_ACCESS_REMOVE_2 = "C_ACCESS_REMOVE_2";
    private static final String C_ACCESS_REMOVE_ALL_1 = "C_ACCESS_REMOVE_ALL_1";
    private static final String C_ACCESS_REMOVE_ALL_FOR_PRINCIPAL_1 = "C_ACCESS_REMOVE_ALL_FOR_PRINCIPAL_1";
    private static final String C_ACCESS_UPDATE_5 = "C_ACCESS_UPDATE_5";
    private static final String C_GROUPS_CHECK_BY_NAME_2 = "C_GROUPS_CHECK_BY_NAME_2";
    private static final String C_GROUPS_DELETE_GROUP_2 = "C_GROUPS_DELETE_GROUP_2";
    private static final String C_GROUPS_GET_ALL_USERS_OF_GROUP_2 = "C_GROUPS_GET_ALL_USERS_OF_GROUP_2";
    private static final String C_GROUPS_GET_CHILD_1 = "C_GROUPS_GET_CHILD_1";
    private static final String C_GROUPS_GET_GROUPS_0 = "C_GROUPS_GET_GROUPS_0";
    private static final String C_GROUPS_GET_GROUPS_OF_USER_1 = "C_GROUPS_GET_GROUPS_OF_USER_1";
    private static final String C_GROUPS_GET_USERS_OF_GROUP_2 = "C_GROUPS_GET_USERS_OF_GROUP_2";
    private static final String C_GROUPS_GROUP_OU_EQUALS_1 = "C_GROUPS_GROUP_OU_EQUALS_1";
    private static final String C_GROUPS_GROUP_OU_LIKE_1 = "C_GROUPS_GROUP_OU_LIKE_1";
    private static final String C_GROUPS_ORDER_0 = "C_GROUPS_ORDER_0";
    private static final String C_GROUPS_READ_BY_NAME_2 = "C_GROUPS_READ_BY_NAME_2";
    private static final String C_GROUPS_SELECT_GROUPS_1 = "C_GROUPS_SELECT_GROUPS_1";
    private static final String C_GROUPS_SELECT_ROLES_1 = "C_GROUPS_SELECT_ROLES_1";
    private static final String C_GROUPS_USER_IN_GROUP_2 = "C_GROUPS_USER_IN_GROUP_2";
    private static final String C_GROUPS_WRITE_GROUP_4 = "C_GROUPS_WRITE_GROUP_4";
    private static final String C_USERDATA_DELETE_2 = "C_USERDATA_DELETE_2";
    private static final String C_USERDATA_READ_1 = "C_USERDATA_READ_1";
    private static final String C_USERDATA_UPDATE_4 = "C_USERDATA_UPDATE_4";
    private static final String C_USERS_CHECK_BY_NAME_2 = "C_USERS_CHECK_BY_NAME_2";
    private static final String C_USERS_DELETE_2 = "C_USERS_DELETE_2";
    private static final String C_USERS_GET_USERS_FOR_ORGUNIT_1 = "C_USERS_GET_USERS_FOR_ORGUNIT_1";
    private static final String C_USERS_GET_WEBUSERS_FOR_ORGUNIT_1 = "C_USERS_GET_WEBUSERS_FOR_ORGUNIT_1";
    private static final String C_USERS_READ_BY_NAME_2 = "C_USERS_READ_BY_NAME_2";
    private static final String C_USERS_READ_WITH_PWD_3 = "C_USERS_READ_WITH_PWD_3";
    private static final String C_USERS_SET_ORGUNIT_2 = "C_USERS_SET_ORGUNIT_2";
    private static final String C_USERS_SET_PWD_3 = "C_USERS_SET_PWD_3";
    private static final String C_USERS_WRITE_2 = "C_USERS_WRITE_2";
    private static final String C_USERS_WRITE_6 = "C_USERS_WRITE_6";
    private static final Log LOG = CmsLog.getLog(CmsUserDriver.class);
    private static final String OFFLINE_PROJECT_NAME = "Offline";
    private static final String ORGUNIT_PROPERTY_DESCRIPTION = "Description";
    private static final String ORGUNIT_PROPERTY_PROJECTID = "Keywords";
    protected MessageDigest m_digest;
    protected String m_digestAlgorithm;
    protected String m_digestFileEncoding;
    protected CmsDriverManager m_driverManager;
    protected CmsSqlManager m_sqlManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResourceToOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, CmsResource resource) throws CmsDataAccessException {
        try {
            if (resource.isFile()) {
                throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_ORGUNIT_RESOURCE_IS_NOT_FOLDER_2", orgUnit.getName(), dbc.removeSiteRoot(resource.getRootPath())));
            }
            CmsResource ouResource = this.m_driverManager.readResource(dbc, ORGUNIT_BASE_FOLDER + orgUnit.getName(), CmsResourceFilter.ALL);
            ArrayList<String> vfsPaths = new ArrayList<String>(this.internalResourcesForOrgUnit(dbc, ouResource));
            if (orgUnit.getParentFqn() != null) {
                CmsOrganizationalUnit parentOu = this.m_driverManager.readOrganizationalUnit(dbc, orgUnit.getParentFqn());
                this.internalValidateResourceForOrgUnit(dbc, parentOu, resource.getRootPath());
            } else if (!vfsPaths.isEmpty()) {
                throw new CmsDataAccessException(org.opencms.security.Messages.get().container("ERR_ORGUNIT_ROOT_EDITION_0"));
            }
            CmsRelation relation = new CmsRelation(ouResource, resource, CmsRelationType.OU_RESOURCE);
            this.m_driverManager.getVfsDriver(dbc).createRelation(dbc, dbc.currentProject().getUuid(), relation);
            this.m_driverManager.getVfsDriver(dbc).createRelation(dbc, CmsProject.ONLINE_PROJECT_ID, relation);
            try {
                CmsProject project = this.m_driverManager.readProject(dbc, orgUnit.getProjectId());
                this.m_driverManager.getProjectDriver(dbc).createProjectResource(dbc, orgUnit.getProjectId(), resource.getRootPath());
                OpenCms.fireCmsEvent(18, Collections.singletonMap("project", project));
            }
            catch (CmsDbEntryNotFoundException e) {
            }
            finally {
                HashMap<String, Object> data = new HashMap<String, Object>(2);
                data.put("resource", ouResource);
                data.put("change", new Integer(8));
                OpenCms.fireCmsEvent(new CmsEvent(11, data));
            }
        }
        catch (CmsException e) {
            throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
        }
    }

    @Override
    public long countUsers(CmsDbContext dbc, CmsUserSearchParameters searchParams) throws CmsDataAccessException {
        long userCount = -1L;
        try {
            CmsJpaUserQueryBuilder builder = new CmsJpaUserQueryBuilder();
            CmsPair<String, List<Object>> queryData = ((CmsUserQueryBuilder)builder).createUserQuery(searchParams, true);
            Query q = this.m_sqlManager.createQueryWithParametersFromJPQL(dbc, queryData.getFirst(), queryData.getSecond());
            Number number = (Number)q.getSingleResult();
            userCount = number.intValue();
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return userCount;
    }

    @Override
    public void createAccessControlEntry(CmsDbContext dbc, CmsProject project, CmsUUID resource, CmsUUID principal, int allowed, int denied, int flags) throws CmsDataAccessException {
        try {
            PersistenceCapable pac = CmsProject.isOnlineProject(project.getUuid()) ? new CmsDAOOnlineAccessControl() : new CmsDAOOfflineAccessControl();
            pac.setResourceId(resource.toString());
            pac.setPrincipalId(principal.toString());
            pac.setAccessAllowed(allowed);
            pac.setAccessDenied(denied);
            pac.setAccessFlags(flags);
            this.m_sqlManager.persist(dbc, pac);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public CmsGroup createGroup(CmsDbContext dbc, CmsUUID groupId, String groupFqn, String description, int flags, String parentGroupFqn) throws CmsDataAccessException {
        CmsUUID parentId = CmsUUID.getNullUUID();
        CmsGroup group = null;
        if (this.existsGroup(dbc, groupFqn)) {
            CmsMessageContainer message = org.opencms.db.generic.Messages.get().container("ERR_GROUP_WITH_NAME_ALREADY_EXISTS_1", groupFqn);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)message.key());
            }
            throw new CmsDbEntryAlreadyExistsException(message);
        }
        try {
            if (CmsStringUtil.isNotEmpty(parentGroupFqn)) {
                parentId = this.readGroup(dbc, parentGroupFqn).getId();
            }
            CmsDAOGroups g = new CmsDAOGroups();
            g.setGroupId(groupId.toString());
            g.setParentGroupId(parentId.toString());
            g.setGroupName(CmsOrganizationalUnit.getSimpleName(groupFqn));
            g.setGroupDescription(this.m_sqlManager.validateEmpty(description));
            g.setGroupFlags(flags);
            g.setGroupOu("/" + CmsOrganizationalUnit.getParentFqn(groupFqn));
            this.m_sqlManager.persist(dbc, g);
            group = new CmsGroup(groupId, parentId, groupFqn, description, flags);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return group;
    }

    @Override
    public CmsOrganizationalUnit createOrganizationalUnit(CmsDbContext dbc, String name, String description, int flags, CmsOrganizationalUnit parent, String associatedResource) throws CmsDataAccessException {
        if (parent == null && !name.equals("")) {
            throw new CmsDataAccessException(Messages.get().container("ERR_PARENT_ORGUNIT_NULL_0"));
        }
        try {
            CmsResource parentFolder = this.internalOrgUnitFolder(dbc, parent);
            CmsFolder resource = null;
            if ((flags & 8) == 0 || associatedResource != null) {
                resource = this.m_driverManager.readFolder(dbc, associatedResource, CmsResourceFilter.ALL);
            }
            String ouPath = ORGUNIT_BASE_FOLDER;
            if (parentFolder != null && resource != null) {
                this.internalValidateResourceForOrgUnit(dbc, this.internalCreateOrgUnitFromResource(dbc, parentFolder), resource.getRootPath());
            }
            if (parentFolder != null && !(ouPath = parentFolder.getRootPath()).endsWith("/")) {
                ouPath = ouPath + "/";
            }
            CmsResource ouFolder = this.internalCreateResourceForOrgUnit(dbc, ouPath + name, flags);
            this.internalWriteOrgUnitProperty(dbc, ouFolder, new CmsProperty(ORGUNIT_PROPERTY_DESCRIPTION, description, null));
            CmsOrganizationalUnit ou = this.internalCreateOrgUnitFromResource(dbc, ouFolder);
            if (ou.getParentFqn() != null) {
                Locale locale = CmsLocaleManager.getDefaultLocale();
                if (dbc.getRequestContext() != null) {
                    locale = dbc.getRequestContext().getLocale();
                }
                this.internalCreateDefaultGroups(dbc, ou.getName(), ou.getDisplayName(locale), ou.hasFlagWebuser());
                if (!ou.hasFlagWebuser()) {
                    CmsProject project = this.m_driverManager.createProject(dbc, ou.getName() + OFFLINE_PROJECT_NAME, "", ou.getName() + OpenCms.getDefaultUsers().getGroupUsers(), ou.getName() + OpenCms.getDefaultUsers().getGroupUsers(), CmsProject.PROJECT_TYPE_NORMAL);
                    this.internalWriteOrgUnitProperty(dbc, ouFolder, new CmsProperty(ORGUNIT_PROPERTY_PROJECTID, project.getUuid().toString(), null));
                } else {
                    this.internalWriteOrgUnitProperty(dbc, ouFolder, new CmsProperty(ORGUNIT_PROPERTY_PROJECTID, CmsUUID.getNullUUID().toString(), null));
                }
            } else {
                this.internalWriteOrgUnitProperty(dbc, ouFolder, new CmsProperty(ORGUNIT_PROPERTY_PROJECTID, CmsUUID.getNullUUID().toString(), null));
            }
            ou = this.internalCreateOrgUnitFromResource(dbc, ouFolder);
            if (resource != null) {
                this.m_driverManager.addResourceToOrgUnit(dbc, ou, resource);
            }
            OpenCms.fireCmsEvent(17, null);
            return ou;
        }
        catch (CmsException e) {
            throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createRootOrganizationalUnit(CmsDbContext dbc) {
        try {
            this.readOrganizationalUnit(dbc, "");
        }
        catch (CmsException e) {
            try {
                CmsProject onlineProject;
                CmsProject setupProject = onlineProject = dbc.currentProject();
                try {
                    setupProject = this.m_driverManager.readProject(dbc, "_setupProject");
                }
                catch (CmsException exc) {
                    try {
                        setupProject = this.m_driverManager.readProject(dbc, OFFLINE_PROJECT_NAME);
                    }
                    catch (CmsException exc2) {
                        // empty catch block
                    }
                }
                dbc.getRequestContext().setCurrentProject(setupProject);
                try {
                    this.createOrganizationalUnit(dbc, "", CmsMacroResolver.localizedKeyMacro("GUI_ORGUNIT_ROOT_DESCRIPTION_0", null), 0, null, "/");
                }
                finally {
                    dbc.getRequestContext().setCurrentProject(onlineProject);
                }
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)org.opencms.db.generic.Messages.get().getBundle().key("INIT_ROOT_ORGUNIT_DEFAULTS_INITIALIZED_0"));
                }
            }
            catch (CmsException exc) {
                if (CmsLog.INIT.isErrorEnabled()) {
                    CmsLog.INIT.error((Object)org.opencms.db.generic.Messages.get().getBundle().key("INIT_ROOT_ORGUNIT_INITIALIZATION_FAILED_0"), (Throwable)exc);
                }
                throw new CmsInitException(org.opencms.db.generic.Messages.get().container("ERR_INITIALIZING_USER_DRIVER_0"), (Throwable)exc);
            }
        }
    }

    @Override
    public CmsUser createUser(CmsDbContext dbc, CmsUUID id, String userFqn, String password, String firstname, String lastname, String email, long lastlogin, int flags, long dateCreated, Map<String, Object> additionalInfos) throws CmsDataAccessException {
        if (this.existsUser(dbc, userFqn)) {
            CmsMessageContainer message = org.opencms.db.generic.Messages.get().container("ERR_USER_WITH_NAME_ALREADY_EXISTS_1", userFqn);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)message.key());
            }
            throw new CmsDbEntryAlreadyExistsException(message);
        }
        try {
            CmsDAOUsers u = new CmsDAOUsers();
            u.setUserId(id.toString());
            u.setUserName(CmsOrganizationalUnit.getSimpleName(userFqn));
            u.setUserPassword(password);
            u.setUserFirstName(this.m_sqlManager.validateEmpty(firstname));
            u.setUserLastName(this.m_sqlManager.validateEmpty(lastname));
            u.setUserEmail(this.m_sqlManager.validateEmpty(email));
            u.setUserLastLogin(lastlogin);
            u.setUserFlags(flags);
            u.setUserOu("/" + CmsOrganizationalUnit.getParentFqn(userFqn));
            u.setUserDateCreated(dateCreated == 0L ? System.currentTimeMillis() : dateCreated);
            this.m_sqlManager.persist(dbc, u);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        this.internalWriteUserInfos(dbc, id, additionalInfos);
        return this.readUser(dbc, id);
    }

    @Override
    public void createUserInGroup(CmsDbContext dbc, CmsUUID userId, CmsUUID groupId) throws CmsDataAccessException {
        if (!this.internalValidateUserInGroup(dbc, userId, groupId)) {
            try {
                CmsDAOGroupUsers gu = new CmsDAOGroupUsers();
                gu.setGroupId(groupId.toString());
                gu.setUserId(userId.toString());
                gu.setGroupUserFlags(0);
                this.m_sqlManager.persist(dbc, gu);
            }
            catch (PersistenceException e) {
                throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
            }
        }
    }

    public void deleteAccessControlEntries(CmsDbContext dbc, CmsProject project, CmsUUID resource) throws CmsDataAccessException {
        this.removeAccessControlEntries(dbc, project, resource);
    }

    @Override
    public void deleteGroup(CmsDbContext dbc, String groupFqn) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_GROUPS_DELETE_GROUP_2);
            q.setParameter(1, (Object)CmsOrganizationalUnit.getSimpleName(groupFqn));
            q.setParameter(2, (Object)("/" + CmsOrganizationalUnit.getParentFqn(groupFqn)));
            List res = q.getResultList();
            for (CmsDAOGroups g : res) {
                this.m_sqlManager.remove(dbc, g);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deleteOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit organizationalUnit) throws CmsDataAccessException {
        try {
            CmsResource resource = this.m_driverManager.readResource(dbc, ORGUNIT_BASE_FOLDER + organizationalUnit.getName(), CmsResourceFilter.DEFAULT);
            this.internalDeleteOrgUnitResource(dbc, resource);
            if (organizationalUnit.getProjectId() != null) {
                try {
                    this.m_driverManager.deleteProject(dbc, this.m_driverManager.readProject(dbc, organizationalUnit.getProjectId()));
                }
                catch (CmsDbEntryNotFoundException e) {}
            }
        }
        catch (CmsException e) {
            throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
        }
    }

    @Override
    public void deleteUser(CmsDbContext dbc, String userFqn) throws CmsDataAccessException {
        CmsUser user = this.readUser(dbc, userFqn);
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_USERS_DELETE_2);
            q.setParameter(1, (Object)CmsOrganizationalUnit.getSimpleName(userFqn));
            q.setParameter(2, (Object)("/" + CmsOrganizationalUnit.getParentFqn(userFqn)));
            List res = q.getResultList();
            for (CmsDAOUsers u : res) {
                this.m_sqlManager.remove(dbc, u);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        this.deleteUserInfos(dbc, user.getId());
        if (OpenCms.getSubscriptionManager().isEnabled()) {
            CmsVisitEntryFilter filter = CmsVisitEntryFilter.ALL.filterUser(user.getId());
            this.m_driverManager.getSubscriptionDriver().deleteVisits(dbc, OpenCms.getSubscriptionManager().getPoolName(), filter);
            this.m_driverManager.getSubscriptionDriver().unsubscribeAllResourcesFor(dbc, OpenCms.getSubscriptionManager().getPoolName(), user);
        }
    }

    @Override
    public void deleteUserInfos(CmsDbContext dbc, CmsUUID userId) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_USERDATA_READ_1);
            q.setParameter(1, (Object)userId.toString());
            List res = q.getResultList();
            for (CmsDAOUserData ud : res) {
                this.m_sqlManager.remove(dbc, ud);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deleteUserInGroup(CmsDbContext dbc, CmsUUID userId, CmsUUID groupId) throws CmsDataAccessException {
        try {
            CmsDAOGroupUsers.CmsDAOGroupUsersPK pk = new CmsDAOGroupUsers.CmsDAOGroupUsersPK();
            pk.setGroupId(groupId.toString());
            pk.setUserId(userId.toString());
            CmsDAOGroupUsers gu = this.m_sqlManager.find(dbc, CmsDAOGroupUsers.class, pk);
            if (gu != null) {
                this.m_sqlManager.remove(dbc, gu);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void destroy() throws Throwable {
        this.m_sqlManager = null;
        this.m_driverManager = null;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.db.generic.Messages.get().getBundle().key("INIT_SHUTDOWN_DRIVER_1", this.getClass().getName()));
        }
    }

    @Override
    public boolean existsGroup(CmsDbContext dbc, String groupFqn) throws CmsDataAccessException {
        boolean result = false;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_GROUPS_CHECK_BY_NAME_2);
            q.setParameter(1, (Object)CmsOrganizationalUnit.getSimpleName(groupFqn));
            q.setParameter(2, (Object)("/" + CmsOrganizationalUnit.getParentFqn(groupFqn)));
            int count = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            if (count > 0) {
                result = true;
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean existsUser(CmsDbContext dbc, String userFqn) throws CmsDataAccessException {
        boolean result = false;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_USERS_CHECK_BY_NAME_2);
            q.setParameter(1, (Object)CmsOrganizationalUnit.getSimpleName(userFqn));
            q.setParameter(2, (Object)("/" + CmsOrganizationalUnit.getParentFqn(userFqn)));
            int count = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            if (count > 0) {
                result = true;
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return result;
    }

    @Override
    public void fillDefaults(CmsDbContext dbc) throws CmsInitException {
        try {
            this.internalCreateDefaultGroups(dbc, "", "", false);
        }
        catch (CmsException e) {
            if (CmsLog.INIT.isErrorEnabled()) {
                CmsLog.INIT.error((Object)org.opencms.db.generic.Messages.get().getBundle().key("INIT_DEFAULT_USERS_CREATION_FAILED_0"), (Throwable)e);
            }
            throw new CmsInitException(org.opencms.db.generic.Messages.get().container("ERR_INITIALIZING_USER_DRIVER_0"), (Throwable)e);
        }
    }

    @Override
    public List<CmsGroup> getGroups(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, boolean includeSubOus, boolean readRoles) throws CmsDataAccessException {
        String sqlQuery = this.createRoleQuery(C_GROUPS_GET_GROUPS_0, includeSubOus, readRoles);
        String ouFqn = "/" + orgUnit.getName();
        if (includeSubOus) {
            ouFqn = ouFqn + "%";
        }
        ArrayList<CmsGroup> groups = new ArrayList<CmsGroup>();
        try {
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, sqlQuery);
            q.setParameter(1, (Object)ouFqn);
            q.setParameter(2, (Object)0x100000);
            List res = q.getResultList();
            for (CmsDAOGroups g : res) {
                groups.add(this.internalCreateGroup(g));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return groups;
    }

    @Override
    public List<CmsOrganizationalUnit> getOrganizationalUnits(CmsDbContext dbc, CmsOrganizationalUnit parent, boolean includeChildren) throws CmsDataAccessException {
        ArrayList<CmsOrganizationalUnit> orgUnits = new ArrayList<CmsOrganizationalUnit>();
        try {
            CmsResource parentFolder = this.internalOrgUnitFolder(dbc, parent);
            for (CmsResource resource : this.m_driverManager.readResources(dbc, parentFolder, CmsResourceFilter.DEFAULT, includeChildren)) {
                orgUnits.add(this.internalCreateOrgUnitFromResource(dbc, resource));
            }
        }
        catch (CmsException e) {
            throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
        }
        return orgUnits;
    }

    @Override
    public List<CmsResource> getResourcesForOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit) throws CmsDataAccessException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        try {
            CmsResource ouResource = this.m_driverManager.readResource(dbc, ORGUNIT_BASE_FOLDER + orgUnit.getName(), CmsResourceFilter.ALL);
            for (String path : this.internalResourcesForOrgUnit(dbc, ouResource)) {
                try {
                    result.add(this.m_driverManager.readResource(dbc, path, CmsResourceFilter.ALL));
                }
                catch (CmsVfsResourceNotFoundException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        catch (CmsException e) {
            throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
        }
        return result;
    }

    @Override
    public CmsSqlManager getSqlManager() {
        return this.m_sqlManager;
    }

    @Override
    public List<CmsUser> getUsers(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, boolean recursive) throws CmsDataAccessException {
        ArrayList<CmsUser> users = new ArrayList<CmsUser>();
        try {
            Query q = orgUnit.hasFlagWebuser() ? this.m_sqlManager.createQuery(dbc, C_USERS_GET_WEBUSERS_FOR_ORGUNIT_1) : this.m_sqlManager.createQuery(dbc, C_USERS_GET_USERS_FOR_ORGUNIT_1);
            String param = "/" + orgUnit.getName();
            if (recursive) {
                param = param + "%";
            }
            q.setParameter(1, (Object)param);
            List res = q.getResultList();
            for (CmsDAOUsers u : res) {
                users.add(this.internalCreateUser(dbc, u));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return users;
    }

    @Override
    public List<CmsUser> getUsersWithoutAdditionalInfo(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, boolean recursive) throws CmsDataAccessException {
        return this.getUsers(dbc, orgUnit, recursive);
    }

    @Override
    public void init(CmsDbContext dbc, CmsConfigurationManager configurationManager, List<String> successiveDrivers, CmsDriverManager driverManager) {
        block7: {
            CmsParameterConfiguration config = configurationManager.getConfiguration();
            String poolUrl = config.get("db.user.pool");
            String classname = config.get("db.user.sqlmanager");
            this.m_sqlManager = this.initSqlManager(classname);
            this.m_driverManager = driverManager;
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.generic.Messages.get().getBundle().key("INIT_ASSIGNED_POOL_1", poolUrl));
            }
            this.m_digestAlgorithm = config.getString("db.user.digest.type", "MD5");
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.generic.Messages.get().getBundle().key("INIT_DIGEST_ALGORITHM_1", this.m_digestAlgorithm));
            }
            this.m_digestFileEncoding = config.getString("db.user.digest.encoding", "UTF-8");
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.generic.Messages.get().getBundle().key("INIT_DIGEST_ENCODING_1", this.m_digestFileEncoding));
            }
            try {
                this.m_digest = MessageDigest.getInstance(this.m_digestAlgorithm);
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)org.opencms.db.generic.Messages.get().getBundle().key("INIT_DIGEST_ENC_3", this.m_digest.getAlgorithm(), this.m_digest.getProvider().getName(), String.valueOf(this.m_digest.getProvider().getVersion())));
                }
            }
            catch (NoSuchAlgorithmException e) {
                if (!CmsLog.INIT.isInfoEnabled()) break block7;
                CmsLog.INIT.info((Object)org.opencms.db.generic.Messages.get().getBundle().key("INIT_SET_DIGEST_ERROR_0"), (Throwable)e);
            }
        }
        if (successiveDrivers != null && !successiveDrivers.isEmpty() && LOG.isWarnEnabled()) {
            LOG.warn((Object)org.opencms.db.generic.Messages.get().getBundle().key("LOG_SUCCESSIVE_DRIVERS_UNSUPPORTED_1", this.getClass().getName()));
        }
    }

    @Override
    public CmsSqlManager initSqlManager(String classname) {
        return CmsSqlManager.getInstance(classname);
    }

    @Override
    public void publishAccessControlEntries(CmsDbContext dbc, CmsProject offlineProject, CmsProject onlineProject, CmsUUID offlineId, CmsUUID onlineId) throws CmsDataAccessException {
        this.m_driverManager.getUserDriver(dbc).removeAccessControlEntries(dbc, onlineProject, onlineId);
        CmsUUID dbcProjectId = dbc.getProjectId();
        if (dbcProjectId != null && !dbc.getProjectId().isNullUUID()) {
            dbc.setProjectId(offlineProject.getUuid());
        } else {
            dbc.setProjectId(CmsUUID.getNullUUID());
        }
        List<CmsAccessControlEntry> aces = this.m_driverManager.getUserDriver(dbc).readAccessControlEntries(dbc, offlineProject, offlineId, false);
        dbc.setProjectId(dbcProjectId);
        for (CmsAccessControlEntry ace : aces) {
            this.m_driverManager.getUserDriver(dbc).writeAccessControlEntry(dbc, onlineProject, ace);
        }
    }

    @Override
    public List<CmsAccessControlEntry> readAccessControlEntries(CmsDbContext dbc, CmsProject project, CmsUUID resource, boolean inheritedOnly) throws CmsDataAccessException {
        ArrayList<CmsAccessControlEntry> aceList = new ArrayList<CmsAccessControlEntry>();
        try {
            Query q;
            if (resource.equals(CmsAccessControlEntry.PRINCIPAL_READALL_ID)) {
                q = this.m_sqlManager.createQuery(dbc, project, C_ACCESS_READ_ENTRIES_0);
            } else {
                q = this.m_sqlManager.createQuery(dbc, project, C_ACCESS_READ_ENTRIES_1);
                String resId = resource.toString();
                q.setParameter(1, (Object)resId);
            }
            List res = q.getResultList();
            for (I_CmsDAOAccessControl ac : res) {
                CmsAccessControlEntry ace = this.internalCreateAce(ac);
                if (inheritedOnly && !ace.isInheriting()) continue;
                if (inheritedOnly && ace.isInheriting()) {
                    ace.setFlags(8);
                }
                aceList.add(ace);
            }
            return aceList;
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public CmsAccessControlEntry readAccessControlEntry(CmsDbContext dbc, CmsProject project, CmsUUID resource, CmsUUID principal) throws CmsDataAccessException {
        CmsAccessControlEntry ace = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, project, C_ACCESS_READ_ENTRY_2);
            q.setParameter(1, (Object)resource.toString());
            q.setParameter(2, (Object)principal.toString());
            try {
                I_CmsDAOAccessControl ac = (I_CmsDAOAccessControl)q.getSingleResult();
                ace = this.internalCreateAce(ac);
            }
            catch (NoResultException e) {
                throw new CmsDbEntryNotFoundException(org.opencms.db.generic.Messages.get().container("ERR_NO_ACE_FOUND_2", resource, principal));
            }
            return ace;
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public List<CmsGroup> readChildGroups(CmsDbContext dbc, String parentGroupFqn) throws CmsDataAccessException {
        ArrayList<CmsGroup> children = new ArrayList<CmsGroup>();
        try {
            CmsGroup parent = this.m_driverManager.getUserDriver(dbc).readGroup(dbc, parentGroupFqn);
            if (parent != null) {
                Query q = this.m_sqlManager.createQuery(dbc, C_GROUPS_GET_CHILD_1);
                q.setParameter(1, (Object)parent.getId().toString());
                List res = q.getResultList();
                for (CmsDAOGroups g : res) {
                    children.add(this.internalCreateGroup(g));
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return children;
    }

    @Override
    public CmsGroup readGroup(CmsDbContext dbc, CmsUUID groupId) throws CmsDataAccessException {
        CmsGroup group = null;
        try {
            CmsDAOGroups g = this.m_sqlManager.find(dbc, CmsDAOGroups.class, groupId.toString());
            if (g == null) {
                CmsMessageContainer message = org.opencms.db.generic.Messages.get().container("ERR_NO_GROUP_WITH_ID_1", groupId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key());
                }
                throw new CmsDbEntryNotFoundException(message);
            }
            group = this.internalCreateGroup(g);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return group;
    }

    @Override
    public CmsGroup readGroup(CmsDbContext dbc, String groupFqn) throws CmsDataAccessException {
        CmsGroup group = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_GROUPS_READ_BY_NAME_2);
            q.setParameter(1, (Object)CmsOrganizationalUnit.getSimpleName(groupFqn));
            q.setParameter(2, (Object)("/" + CmsOrganizationalUnit.getParentFqn(groupFqn)));
            try {
                CmsDAOGroups g = (CmsDAOGroups)q.getSingleResult();
                group = this.internalCreateGroup(g);
            }
            catch (NoResultException e) {
                CmsMessageContainer message = Messages.get().container("ERR_UNKNOWN_GROUP_1", groupFqn);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), (Throwable)new Exception());
                }
                throw new CmsDbEntryNotFoundException(message);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return group;
    }

    @Override
    public List<CmsGroup> readGroupsOfUser(CmsDbContext dbc, CmsUUID userId, String ouFqn, boolean includeChildOus, String remoteAddress, boolean readRoles) throws CmsDataAccessException {
        String sqlQuery = this.createRoleQuery(C_GROUPS_GET_GROUPS_OF_USER_1, includeChildOus, readRoles);
        String ouFqnParam = "/" + ouFqn;
        if (includeChildOus) {
            ouFqnParam = ouFqnParam + "%";
        }
        ArrayList<CmsGroup> groups = new ArrayList<CmsGroup>();
        try {
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, sqlQuery);
            q.setParameter(1, (Object)userId.toString());
            q.setParameter(2, (Object)ouFqnParam);
            q.setParameter(3, (Object)0x100000);
            List res = q.getResultList();
            for (Object[] o : res) {
                groups.add(this.internalCreateGroup((CmsDAOGroups)o[0]));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return groups;
    }

    @Override
    public CmsOrganizationalUnit readOrganizationalUnit(CmsDbContext dbc, String ouFqn) throws CmsDataAccessException {
        try {
            CmsResource resource = this.m_driverManager.readResource(dbc, ORGUNIT_BASE_FOLDER + ouFqn, CmsResourceFilter.DEFAULT);
            return this.internalCreateOrgUnitFromResource(dbc, resource);
        }
        catch (CmsVfsResourceNotFoundException e) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.generic.Messages.get().container("ERR_READ_ORGUNIT_1", ouFqn), (Throwable)e);
        }
        catch (CmsException e) {
            throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
        }
    }

    @Override
    public CmsUser readUser(CmsDbContext dbc, CmsUUID id) throws CmsDataAccessException {
        CmsUser user = null;
        try {
            CmsDAOUsers u = this.m_sqlManager.find(dbc, CmsDAOUsers.class, id.toString());
            if (u == null) {
                CmsMessageContainer message = org.opencms.db.generic.Messages.get().container("ERR_NO_USER_WITH_ID_1", id);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key());
                }
                throw new CmsDbEntryNotFoundException(message);
            }
            user = this.internalCreateUser(dbc, u);
            return user;
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public CmsUser readUser(CmsDbContext dbc, String userFqn) throws CmsDataAccessException {
        CmsUser user = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_USERS_READ_BY_NAME_2);
            q.setParameter(1, (Object)CmsOrganizationalUnit.getSimpleName(userFqn));
            q.setParameter(2, (Object)("/" + CmsOrganizationalUnit.getParentFqn(userFqn)));
            try {
                CmsDAOUsers u = (CmsDAOUsers)q.getSingleResult();
                user = this.internalCreateUser(dbc, u);
            }
            catch (NoResultException e) {
                CmsMessageContainer message = Messages.get().container("ERR_UNKNOWN_USER_1", userFqn);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key());
                }
                throw new CmsDbEntryNotFoundException(message);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return user;
    }

    @Override
    public CmsUser readUser(CmsDbContext dbc, String userFqn, String password, String remoteAddress) throws CmsDataAccessException, CmsPasswordEncryptionException {
        CmsUser user = this.readUser(dbc, userFqn);
        if (OpenCms.getPasswordHandler().checkPassword(password, user.getPassword(), true)) {
            return user;
        }
        CmsMessageContainer message = Messages.get().container("ERR_UNKNOWN_USER_1", userFqn);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)message.key());
        }
        throw new CmsDbEntryNotFoundException(message);
    }

    @Override
    public Map<String, Object> readUserInfos(CmsDbContext dbc, CmsUUID userId) throws CmsDataAccessException {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_USERDATA_READ_1);
            q.setParameter(1, (Object)userId.toString());
            List res = q.getResultList();
            for (CmsDAOUserData ud : res) {
                String key = ud.getDataKey();
                String type = ud.getDataType();
                byte[] value = ud.getDataValue();
                Object data = null;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)org.opencms.db.generic.Messages.get().getBundle().key("LOG_DBG_READUSERINFO_2", key, type));
                        if (value != null) {
                            try {
                                LOG.debug((Object)org.opencms.db.generic.Messages.get().getBundle().key("LOG_DBG_READUSERINFO_VALUE_1", new String(value)));
                            }
                            catch (Exception e) {}
                        } else {
                            LOG.debug((Object)org.opencms.db.generic.Messages.get().getBundle().key("LOG_DBG_READUSERINFO_VALUE_1", null));
                        }
                    }
                    data = CmsDataTypeUtil.dataDeserialize(value, type);
                }
                catch (Exception e) {
                    LOG.warn((Object)org.opencms.db.generic.Messages.get().container("ERR_READING_ADDITIONAL_INFO_1", userId.toString()).key(), (Throwable)e);
                }
                if (key == null) continue;
                infos.put(key, data);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return infos;
    }

    @Override
    public List<CmsUser> readUsersOfGroup(CmsDbContext dbc, String groupFqn, boolean includeOtherOuUsers) throws CmsDataAccessException {
        String sqlQuery = C_GROUPS_GET_USERS_OF_GROUP_2;
        if (includeOtherOuUsers) {
            sqlQuery = C_GROUPS_GET_ALL_USERS_OF_GROUP_2;
        }
        ArrayList<CmsUser> users = new ArrayList<CmsUser>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, sqlQuery);
            q.setParameter(1, (Object)CmsOrganizationalUnit.getSimpleName(groupFqn));
            q.setParameter(2, (Object)("/" + CmsOrganizationalUnit.getParentFqn(groupFqn)));
            List res = q.getResultList();
            for (CmsDAOUsers u : res) {
                users.add(this.internalCreateUser(dbc, u));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return users;
    }

    @Override
    public void removeAccessControlEntries(CmsDbContext dbc, CmsProject project, CmsUUID resource) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, project, C_ACCESS_REMOVE_ALL_1);
            q.setParameter(1, (Object)resource.toString());
            List res = q.getResultList();
            for (I_CmsDAOAccessControl ac : res) {
                this.m_sqlManager.remove(dbc, ac);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void removeAccessControlEntriesForPrincipal(CmsDbContext dbc, CmsProject project, CmsProject onlineProject, CmsUUID principal) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, onlineProject, C_ACCESS_REMOVE_ALL_FOR_PRINCIPAL_1);
            q.setParameter(1, (Object)principal.toString());
            List res = q.getResultList();
            for (I_CmsDAOAccessControl ac : res) {
                this.m_sqlManager.remove(dbc, ac);
            }
            q = this.m_sqlManager.createQuery(dbc, project, C_ACCESS_REMOVE_ALL_FOR_PRINCIPAL_1);
            q.setParameter(1, (Object)principal.toString());
            List res1 = q.getResultList();
            for (I_CmsDAOAccessControl ac : res1) {
                this.m_sqlManager.remove(dbc, ac);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void removeAccessControlEntry(CmsDbContext dbc, CmsProject project, CmsUUID resource, CmsUUID principal) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, project, C_ACCESS_REMOVE_2);
            q.setParameter(1, (Object)resource.toString());
            q.setParameter(2, (Object)principal.toString());
            List res = q.getResultList();
            for (I_CmsDAOAccessControl ac : res) {
                this.m_sqlManager.remove(dbc, ac);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResourceFromOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, CmsResource resource) throws CmsDataAccessException {
        if (orgUnit.getParentFqn() == null) {
            throw new CmsDataAccessException(org.opencms.security.Messages.get().container("ERR_ORGUNIT_ROOT_EDITION_0"));
        }
        try {
            CmsResource ouResource = this.m_driverManager.readResource(dbc, ORGUNIT_BASE_FOLDER + orgUnit.getName(), CmsResourceFilter.ALL);
            ArrayList<String> vfsPaths = new ArrayList<String>(this.internalResourcesForOrgUnit(dbc, ouResource));
            if (!vfsPaths.contains(resource.getRootPath())) {
                throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_ORGUNIT_DOESNOT_CONTAINS_RESOURCE_2", orgUnit.getName(), dbc.removeSiteRoot(resource.getRootPath())));
            }
            if (vfsPaths.size() == 1 && !orgUnit.hasFlagWebuser()) {
                throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_ORGUNIT_REMOVE_LAST_RESOURCE_2", orgUnit.getName(), dbc.removeSiteRoot(resource.getRootPath())));
            }
            CmsRelationFilter filter = CmsRelationFilter.TARGETS.filterPath(resource.getRootPath());
            this.m_driverManager.getVfsDriver(dbc).deleteRelations(dbc, dbc.currentProject().getUuid(), ouResource, filter);
            this.m_driverManager.getVfsDriver(dbc).deleteRelations(dbc, CmsProject.ONLINE_PROJECT_ID, ouResource, filter);
            try {
                CmsProject project = this.m_driverManager.readProject(dbc, orgUnit.getProjectId());
                this.m_driverManager.getProjectDriver(dbc).deleteProjectResource(dbc, orgUnit.getProjectId(), resource.getRootPath());
                OpenCms.fireCmsEvent(18, Collections.singletonMap("project", project));
            }
            catch (CmsDbEntryNotFoundException e) {
            }
            finally {
                HashMap<String, Object> data = new HashMap<String, Object>(2);
                data.put("resource", ouResource);
                data.put("change", new Integer(8));
                OpenCms.fireCmsEvent(new CmsEvent(11, data));
            }
        }
        catch (CmsException e) {
            throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
        }
    }

    @Override
    public List<CmsUser> searchUsers(CmsDbContext dbc, CmsUserSearchParameters searchParams) throws CmsDataAccessException {
        ArrayList<CmsUser> users = new ArrayList<CmsUser>();
        try {
            CmsJpaUserQueryBuilder builder = new CmsJpaUserQueryBuilder();
            CmsPair<String, List<Object>> queryData = ((CmsUserQueryBuilder)builder).createUserQuery(searchParams, false);
            Query q = this.m_sqlManager.createQueryWithParametersFromJPQL(dbc, queryData.getFirst(), queryData.getSecond());
            q.setMaxResults(searchParams.getPageSize());
            q.setFirstResult(searchParams.getPageSize() * (searchParams.getPage() - 1));
            List res = q.getResultList();
            for (Object singleRes : res) {
                CmsDAOUsers daoUser = null;
                if (singleRes instanceof Object[]) {
                    Object[] resArray = (Object[])singleRes;
                    daoUser = (CmsDAOUsers)resArray[0];
                } else {
                    daoUser = (CmsDAOUsers)singleRes;
                }
                users.add(this.internalCreateUser(dbc, daoUser));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return users;
    }

    @Override
    public void setDriverManager(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
    }

    @Override
    public void setSqlManager(org.opencms.db.CmsSqlManager sqlManager) {
        this.m_sqlManager = (CmsSqlManager)sqlManager;
    }

    @Override
    public void setUsersOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, CmsUser user) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_USERS_SET_ORGUNIT_2);
            q.setParameter(1, (Object)user.getId().toString());
            List res = q.getResultList();
            for (CmsDAOUsers u : res) {
                u.setUserOu(orgUnit == null ? null : "/" + orgUnit.getName());
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writeAccessControlEntry(CmsDbContext dbc, CmsProject project, CmsAccessControlEntry acEntry) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, project, C_ACCESS_READ_ENTRY_2);
            q.setParameter(1, (Object)acEntry.getResource().toString());
            q.setParameter(2, (Object)acEntry.getPrincipal().toString());
            try {
                I_CmsDAOAccessControl ac = (I_CmsDAOAccessControl)q.getSingleResult();
                q = this.m_sqlManager.createQuery(dbc, project, C_ACCESS_UPDATE_5);
                q.setParameter(1, (Object)acEntry.getResource().toString());
                q.setParameter(2, (Object)acEntry.getPrincipal().toString());
                List res = q.getResultList();
                for (I_CmsDAOAccessControl a : res) {
                    a.setAccessAllowed(acEntry.getAllowedPermissions());
                    a.setAccessDenied(acEntry.getDeniedPermissions());
                    a.setAccessFlags(acEntry.getFlags());
                }
            }
            catch (NoResultException e) {
                this.m_driverManager.getUserDriver(dbc).createAccessControlEntry(dbc, project, acEntry.getResource(), acEntry.getPrincipal(), acEntry.getAllowedPermissions(), acEntry.getDeniedPermissions(), acEntry.getFlags());
                return;
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writeGroup(CmsDbContext dbc, CmsGroup group) throws CmsDataAccessException {
        if (group != null) {
            try {
                Query q = this.m_sqlManager.createQuery(dbc, C_GROUPS_WRITE_GROUP_4);
                q.setParameter(1, (Object)group.getId().toString());
                List res = q.getResultList();
                for (CmsDAOGroups g : res) {
                    g.setGroupDescription(this.m_sqlManager.validateEmpty(group.getDescription()));
                    g.setGroupFlags(group.getFlags());
                    g.setParentGroupId(group.getParentId().toString());
                }
            }
            catch (PersistenceException e) {
                throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
            }
        } else {
            throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_UNKNOWN_GROUP_1", "null"));
        }
    }

    @Override
    public void writeOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit organizationalUnit) throws CmsDataAccessException {
        try {
            CmsResource resource = this.m_driverManager.readResource(dbc, organizationalUnit.getId(), CmsResourceFilter.DEFAULT);
            this.internalWriteOrgUnitProperty(dbc, resource, new CmsProperty(ORGUNIT_PROPERTY_DESCRIPTION, organizationalUnit.getDescription(), null));
            CmsUUID projectId = dbc.getProjectId() == null || dbc.getProjectId().isNullUUID() ? dbc.currentProject().getUuid() : dbc.getProjectId();
            resource.setFlags(organizationalUnit.getFlags() | 0x200);
            this.m_driverManager.writeResource(dbc, resource);
            resource.setState(CmsResource.STATE_UNCHANGED);
            this.m_driverManager.getVfsDriver().writeResource(dbc, projectId, resource, 0);
            if (!dbc.currentProject().isOnlineProject()) {
                CmsProject onlineProject = this.m_driverManager.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
                resource.setState(CmsResource.STATE_UNCHANGED);
                this.m_driverManager.getVfsDriver(dbc).writeResource(dbc, onlineProject.getUuid(), resource, 0);
            }
            OpenCms.fireCmsEvent(17, null);
        }
        catch (CmsException e) {
            throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
        }
    }

    @Override
    public void writePassword(CmsDbContext dbc, String userFqn, String oldPassword, String newPassword) throws CmsDataAccessException, CmsPasswordEncryptionException {
        if (oldPassword != null) {
            this.readUser(dbc, userFqn, oldPassword, "");
        }
        String pwd = newPassword;
        if (dbc.getRequestContext().getAttribute(REQ_ATTR_DONT_DIGEST_PASSWORD) == null) {
            pwd = OpenCms.getPasswordHandler().digest(newPassword);
        }
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_USERS_SET_PWD_3);
            q.setParameter(1, (Object)CmsOrganizationalUnit.getSimpleName(userFqn));
            q.setParameter(2, (Object)("/" + CmsOrganizationalUnit.getParentFqn(userFqn)));
            List res = q.getResultList();
            for (CmsDAOUsers u : res) {
                u.setUserPassword(pwd);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writeUser(CmsDbContext dbc, CmsUser user) throws CmsDataAccessException {
        String att_login = (String)dbc.getAttribute("A_LOGIN");
        if (CmsStringUtil.isNotEmpty(att_login)) {
            try {
                Query q = this.m_sqlManager.createQuery(dbc, C_USERS_WRITE_2);
                q.setParameter(1, (Object)user.getLastlogin());
                q.setParameter(2, (Object)String.valueOf(user.getId().toString()));
                q.executeUpdate();
            }
            catch (PersistenceException e) {
                throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
            }
        }
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_USERS_WRITE_6);
            q.setParameter(1, (Object)user.getId().toString());
            List res = q.getResultList();
            for (CmsDAOUsers u : res) {
                u.setUserFirstName(this.m_sqlManager.validateEmpty(user.getFirstname()));
                u.setUserLastName(this.m_sqlManager.validateEmpty(user.getLastname()));
                u.setUserEmail(this.m_sqlManager.validateEmpty(user.getEmail()));
                u.setUserLastLogin(user.getLastlogin());
                u.setUserFlags(user.getFlags());
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        this.internalWriteUserInfos(dbc, user.getId(), user.getAdditionalInfo());
    }

    @Override
    public void writeUserInfo(CmsDbContext dbc, CmsUUID userId, String key, Object value) throws CmsDataAccessException {
        String mode = (String)dbc.getAttribute(ATTRIBUTE_USERADDINFO);
        if (CmsStringUtil.isNotEmpty(mode) && mode.equals(ATTRIBUTE_USERADDINFO_VALUE_DELETE)) {
            this.internalDeleteUserInfo(dbc, userId, key);
        } else if (CmsStringUtil.isNotEmpty(mode) && mode.equals(ATTRIBUTE_USERADDINFO_VALUE_UPDATE)) {
            this.internalUpdateUserInfo(dbc, userId, key, value);
        } else {
            this.internalWriteUserInfo(dbc, userId, key, value);
        }
    }

    protected Query createQueryFromStringAndParams(String queryString, List<Object> queryParams) {
        return null;
    }

    protected String createRoleQuery(String mainQuery, boolean includeSubOus, boolean readRoles) {
        String sqlQuery = this.m_sqlManager.readQuery(mainQuery);
        sqlQuery = sqlQuery + " ";
        sqlQuery = includeSubOus ? sqlQuery + this.m_sqlManager.readQuery(C_GROUPS_GROUP_OU_LIKE_1) : sqlQuery + this.m_sqlManager.readQuery(C_GROUPS_GROUP_OU_EQUALS_1);
        sqlQuery = sqlQuery + " AND ";
        sqlQuery = readRoles ? sqlQuery + this.m_sqlManager.readQuery(C_GROUPS_SELECT_ROLES_1) : sqlQuery + this.m_sqlManager.readQuery(C_GROUPS_SELECT_GROUPS_1);
        sqlQuery = sqlQuery + " ";
        sqlQuery = sqlQuery + this.m_sqlManager.readQuery(C_GROUPS_ORDER_0);
        return sqlQuery;
    }

    protected CmsAccessControlEntry internalCreateAce(I_CmsDAOAccessControl ac) {
        return this.internalCreateAce(ac, new CmsUUID(ac.getResourceId()));
    }

    protected CmsAccessControlEntry internalCreateAce(I_CmsDAOAccessControl ac, CmsUUID newId) {
        return new CmsAccessControlEntry(newId, new CmsUUID(ac.getPrincipalId()), ac.getAccessAllowed(), ac.getAccessDenied(), ac.getAccessFlags());
    }

    protected void internalCreateDefaultGroups(CmsDbContext dbc, String ouFqn, String ouDescription, boolean webuser) throws CmsException {
        String rootAdminRole = CmsRole.ROOT_ADMIN.getGroupName();
        try {
            if (CmsOrganizationalUnit.getParentFqn(ouFqn) != null || CmsOrganizationalUnit.getParentFqn(ouFqn) == null && !this.existsGroup(dbc, rootAdminRole)) {
                for (CmsRole role : CmsRole.getSystemRoles()) {
                    if (webuser && role != CmsRole.ACCOUNT_MANAGER || role.isOrganizationalUnitIndependent() && CmsOrganizationalUnit.getParentFqn(ouFqn) != null) continue;
                    String groupName = ouFqn + role.getGroupName();
                    int flags = 0x100000;
                    this.createGroup(dbc, CmsUUID.getConstantUUID(groupName), groupName, "A system role group", flags, null);
                }
                if (CmsOrganizationalUnit.getParentFqn(ouFqn) == null && CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)org.opencms.db.generic.Messages.get().getBundle().key("INIT_SYSTEM_ROLES_CREATED_0"));
                }
            }
        }
        catch (CmsException e) {
            if (CmsOrganizationalUnit.getParentFqn(ouFqn) == null && CmsLog.INIT.isErrorEnabled()) {
                CmsLog.INIT.error((Object)org.opencms.db.generic.Messages.get().getBundle().key("INIT_SYSTEM_ROLES_CREATION_FAILED_0"), (Throwable)e);
            }
            throw new CmsInitException(org.opencms.db.generic.Messages.get().container("ERR_INITIALIZING_USER_DRIVER_0"), (Throwable)e);
        }
        if (webuser) {
            return;
        }
        String administratorsGroup = ouFqn + OpenCms.getDefaultUsers().getGroupAdministrators();
        String guestGroup = ouFqn + OpenCms.getDefaultUsers().getGroupGuests();
        String usersGroup = ouFqn + OpenCms.getDefaultUsers().getGroupUsers();
        String guestUser = ouFqn + OpenCms.getDefaultUsers().getUserGuest();
        String adminUser = ouFqn + OpenCms.getDefaultUsers().getUserAdmin();
        String exportUser = ouFqn + OpenCms.getDefaultUsers().getUserExport();
        String deleteUser = ouFqn + OpenCms.getDefaultUsers().getUserDeletedResource();
        if (this.existsGroup(dbc, administratorsGroup)) {
            if (CmsOrganizationalUnit.getParentFqn(ouFqn) == null) {
                this.internalUpdateRoleGroup(dbc, administratorsGroup, CmsRole.ROOT_ADMIN);
                this.internalUpdateRoleGroup(dbc, usersGroup, CmsRole.WORKPLACE_USER.forOrgUnit(ouFqn));
            }
            return;
        }
        String parentOu = CmsOrganizationalUnit.getParentFqn(ouFqn);
        String parentGroup = null;
        if (parentOu != null) {
            parentGroup = parentOu + OpenCms.getDefaultUsers().getGroupUsers();
        }
        String groupDescription = CmsStringUtil.isNotEmptyOrWhitespaceOnly(ouDescription) ? CmsMacroResolver.localizedKeyMacro("GUI_DEFAULTGROUP_OU_USERS_DESCRIPTION_1", new String[]{ouDescription}) : CmsMacroResolver.localizedKeyMacro("GUI_DEFAULTGROUP_ROOT_USERS_DESCRIPTION_0", null);
        this.createGroup(dbc, CmsUUID.getConstantUUID(usersGroup), usersGroup, groupDescription, 0 | CmsRole.WORKPLACE_USER.getVirtualGroupFlags(), parentGroup);
        if (parentOu != null) {
            return;
        }
        CmsGroup guests = this.createGroup(dbc, CmsUUID.getConstantUUID(guestGroup), guestGroup, CmsMacroResolver.localizedKeyMacro("GUI_DEFAULTGROUP_ROOT_GUESTS_DESCRIPTION_0", null), 0, null);
        int flags = CmsRole.ROOT_ADMIN.getVirtualGroupFlags();
        this.createGroup(dbc, CmsUUID.getConstantUUID(administratorsGroup), administratorsGroup, CmsMacroResolver.localizedKeyMacro("GUI_DEFAULTGROUP_ROOT_ADMINS_DESCRIPTION_0", null), 0 | flags, null);
        CmsUser guest = this.createUser(dbc, CmsUUID.getConstantUUID(guestUser), guestUser, OpenCms.getPasswordHandler().digest(new CmsUUID().toString()), " ", " ", " ", 0L, 0, 0L, Collections.singletonMap("USER_DESCRIPTION", CmsMacroResolver.localizedKeyMacro("GUI_DEFAULTUSER_ROOT_GUEST_DESCRIPTION_0", null)));
        this.createUserInGroup(dbc, guest.getId(), guests.getId());
        CmsUser admin = this.createUser(dbc, CmsUUID.getConstantUUID(adminUser), adminUser, OpenCms.getPasswordHandler().digest("admin"), " ", " ", " ", 0L, 0, 0L, Collections.singletonMap("USER_DESCRIPTION", CmsMacroResolver.localizedKeyMacro("GUI_DEFAULTUSER_ROOT_ADMIN_DESCRIPTION_0", null)));
        this.createUserInGroup(dbc, admin.getId(), CmsUUID.getConstantUUID(CmsRole.ROOT_ADMIN.getGroupName()));
        this.createUserInGroup(dbc, admin.getId(), CmsUUID.getConstantUUID(administratorsGroup));
        if (!OpenCms.getDefaultUsers().getUserExport().equals(OpenCms.getDefaultUsers().getUserAdmin()) && !OpenCms.getDefaultUsers().getUserExport().equals(OpenCms.getDefaultUsers().getUserGuest())) {
            CmsUser export = this.createUser(dbc, CmsUUID.getConstantUUID(exportUser), exportUser, OpenCms.getPasswordHandler().digest(new CmsUUID().toString()), " ", " ", " ", 0L, 0, 0L, Collections.singletonMap("USER_DESCRIPTION", CmsMacroResolver.localizedKeyMacro("GUI_DEFAULTUSER_ROOT_EXPORT_DESCRIPTION_0", null)));
            this.createUserInGroup(dbc, export.getId(), guests.getId());
        }
        if (!(OpenCms.getDefaultUsers().getUserDeletedResource().equals(OpenCms.getDefaultUsers().getUserAdmin()) || OpenCms.getDefaultUsers().getUserDeletedResource().equals(OpenCms.getDefaultUsers().getUserGuest()) || OpenCms.getDefaultUsers().getUserDeletedResource().equals(OpenCms.getDefaultUsers().getUserExport()))) {
            this.createUser(dbc, CmsUUID.getConstantUUID(deleteUser), deleteUser, OpenCms.getPasswordHandler().digest(new CmsUUID().toString()), " ", " ", " ", 0L, 0, 0L, Collections.singletonMap("USER_DESCRIPTION", CmsMacroResolver.localizedKeyMacro("GUI_DEFAULTUSER_ROOT_DELETED_DESCRIPTION_0", null)));
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.db.generic.Messages.get().getBundle().key("INIT_DEFAULT_USERS_CREATED_0"));
        }
    }

    protected CmsGroup internalCreateGroup(CmsDAOGroups g) {
        String ou = CmsOrganizationalUnit.removeLeadingSeparator(g.getGroupOu());
        String description = g.getGroupDescription();
        return new CmsGroup(new CmsUUID(g.getGroupId()), new CmsUUID(g.getParentGroupId()), ou + g.getGroupName(), description, g.getGroupFlags());
    }

    protected CmsOrganizationalUnit internalCreateOrgUnitFromResource(CmsDbContext dbc, CmsResource resource) throws CmsException {
        if (!resource.getRootPath().startsWith(ORGUNIT_BASE_FOLDER)) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_READ_ORGUNIT_1", resource.getRootPath()));
        }
        String name = resource.getRootPath().substring(ORGUNIT_BASE_FOLDER.length());
        if (name.length() > 0 && !name.endsWith("/")) {
            name = name + "/";
        }
        String description = this.m_driverManager.readPropertyObject(dbc, resource, ORGUNIT_PROPERTY_DESCRIPTION, false).getStructureValue();
        int flags = resource.getFlags() & 0xFFFFFDFF;
        String projectId = this.m_driverManager.readPropertyObject(dbc, resource, ORGUNIT_PROPERTY_PROJECTID, false).getStructureValue();
        return new CmsOrganizationalUnit(resource.getStructureId(), name, description, flags, projectId == null ? null : new CmsUUID(projectId));
    }

    protected CmsResource internalCreateResourceForOrgUnit(CmsDbContext dbc, String path, int flags) throws CmsException {
        CmsFolder resource = new CmsFolder(new CmsUUID(), new CmsUUID(), path, 0, 0x200 | flags, dbc.currentProject().getUuid(), CmsResource.STATE_NEW, 0L, dbc.currentUser().getId(), 0L, dbc.currentUser().getId(), 0L, Long.MAX_VALUE, 0);
        CmsUUID projectId = dbc.getProjectId() == null || dbc.getProjectId().isNullUUID() ? dbc.currentProject().getUuid() : dbc.getProjectId();
        this.m_driverManager.getVfsDriver(dbc).createResource(dbc, projectId, resource, null);
        resource.setState(CmsResource.STATE_UNCHANGED);
        this.m_driverManager.getVfsDriver(dbc).writeResource(dbc, projectId, resource, 0);
        if (!dbc.currentProject().isOnlineProject() && dbc.getProjectId().isNullUUID()) {
            CmsProject onlineProject = this.m_driverManager.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
            this.m_driverManager.getVfsDriver(dbc).createResource(dbc, onlineProject.getUuid(), resource, null);
        }
        OpenCms.getMemoryMonitor().clearAccessControlListCache();
        OpenCms.getMemoryMonitor().flushCache(CmsMemoryMonitor.CacheType.PROPERTY);
        OpenCms.getMemoryMonitor().flushCache(CmsMemoryMonitor.CacheType.PROPERTY_LIST);
        OpenCms.fireCmsEvent(new CmsEvent(23, Collections.singletonMap("resource", resource)));
        return resource;
    }

    protected CmsUser internalCreateUser(CmsDbContext dbc, CmsDAOUsers u) throws CmsDataAccessException {
        String userName = u.getUserName();
        String ou = CmsOrganizationalUnit.removeLeadingSeparator(u.getUserOu());
        CmsUUID userId = new CmsUUID(u.getUserId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.db.generic.Messages.get().getBundle().key("LOG_DBG_CREATE_USER_1", userName));
        }
        Map<String, Object> info = this.readUserInfos(dbc, userId);
        return new CmsUser(userId, ou + userName, u.getUserPassword(), u.getUserFirstName(), u.getUserLastName(), u.getUserEmail(), u.getUserLastLogin(), u.getUserFlags(), u.getUserDateCreated(), info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalDeleteOrgUnitResource(CmsDbContext dbc, CmsResource resource) throws CmsException {
        CmsRelationFilter filter = CmsRelationFilter.TARGETS;
        if (!dbc.currentProject().isOnlineProject()) {
            CmsProject project = dbc.currentProject();
            dbc.getRequestContext().setCurrentProject(this.m_driverManager.readProject(dbc, CmsProject.ONLINE_PROJECT_ID));
            try {
                this.m_driverManager.getVfsDriver(dbc).deletePropertyObjects(dbc, CmsProject.ONLINE_PROJECT_ID, resource, 1);
                this.m_driverManager.getVfsDriver(dbc).removeFolder(dbc, dbc.currentProject(), resource);
                this.m_driverManager.getUserDriver(dbc).removeAccessControlEntries(dbc, dbc.currentProject(), resource.getResourceId());
                this.m_driverManager.getVfsDriver(dbc).deleteRelations(dbc, dbc.getRequestContext().getCurrentProject().getUuid(), resource, filter);
            }
            finally {
                dbc.getRequestContext().setCurrentProject(project);
            }
        }
        this.m_driverManager.getVfsDriver(dbc).deletePropertyObjects(dbc, CmsProject.ONLINE_PROJECT_ID, resource, 1);
        this.m_driverManager.getVfsDriver(dbc).removeFolder(dbc, dbc.currentProject(), resource);
        this.m_driverManager.getUserDriver(dbc).removeAccessControlEntries(dbc, dbc.currentProject(), resource.getResourceId());
        this.m_driverManager.getVfsDriver(dbc).deleteRelations(dbc, dbc.getRequestContext().getCurrentProject().getUuid(), resource, filter);
        OpenCms.getMemoryMonitor().clearAccessControlListCache();
        OpenCms.getMemoryMonitor().flushCache(CmsMemoryMonitor.CacheType.PROPERTY);
        OpenCms.getMemoryMonitor().flushCache(CmsMemoryMonitor.CacheType.PROPERTY_LIST);
        OpenCms.getMemoryMonitor().flushCache(CmsMemoryMonitor.CacheType.PROJECT_RESOURCES);
        OpenCms.fireCmsEvent(new CmsEvent(25, Collections.singletonMap("resources", Collections.singletonList(resource))));
        OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", resource)));
    }

    protected void internalDeleteUserInfo(CmsDbContext dbc, CmsUUID userId, String key) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_USERDATA_DELETE_2);
            q.setParameter(1, (Object)userId.toString());
            q.setParameter(2, (Object)key);
            q.executeUpdate();
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    protected CmsResource internalOrgUnitFolder(CmsDbContext dbc, CmsOrganizationalUnit orgUnit) throws CmsException {
        if (orgUnit != null) {
            return this.m_driverManager.readResource(dbc, ORGUNIT_BASE_FOLDER + orgUnit.getName(), CmsResourceFilter.DEFAULT);
        }
        return null;
    }

    protected List<String> internalResourcesForOrgUnit(CmsDbContext dbc, CmsResource ouResource) throws CmsException {
        List<CmsRelation> relations = this.m_driverManager.getRelationsForResource(dbc, ouResource, CmsRelationFilter.TARGETS);
        ArrayList<String> paths = new ArrayList<String>();
        for (CmsRelation relation : relations) {
            paths.add(relation.getTargetPath());
        }
        return paths;
    }

    protected void internalUpdateRoleGroup(CmsDbContext dbc, String groupName, CmsRole role) throws CmsDataAccessException {
        CmsGroup group;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.db.generic.Messages.get().getBundle().key("LOG_DBG_UPDATE_ROLEGROUP_2", groupName, role.getRoleName()));
        }
        if (CmsRole.valueOf(group = this.readGroup(dbc, groupName)) == null || !CmsRole.valueOf(group).equals(role)) {
            Iterator<CmsUser> it;
            CmsGroup roleGroup = this.readGroup(dbc, role.getGroupName());
            try {
                it = this.m_driverManager.getUsersOfGroup(dbc, groupName, false, false, false).iterator();
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                it = this.readUsersOfGroup(dbc, groupName, false).iterator();
            }
            while (it.hasNext()) {
                CmsUser user = it.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)org.opencms.db.generic.Messages.get().getBundle().key("LOG_DBG_UPDATE_ROLEGROUP_USER_1", user));
                }
                this.createUserInGroup(dbc, user.getId(), roleGroup.getId());
            }
            group.setFlags(role.getVirtualGroupFlags());
        }
    }

    protected void internalUpdateUserInfo(CmsDbContext dbc, CmsUUID userId, String key, Object value) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_USERDATA_UPDATE_4);
            q.setParameter(1, (Object)CmsDataTypeUtil.dataSerialize(value));
            q.setParameter(2, (Object)value.getClass().getName());
            q.setParameter(3, (Object)userId.toString());
            q.setParameter(4, (Object)key);
            q.executeUpdate();
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(org.opencms.db.generic.Messages.get().container("ERR_GENERIC_SQL_1", C_USERDATA_UPDATE_4), (Throwable)e);
        }
        catch (IOException e) {
            throw new CmsDbIoException(org.opencms.db.generic.Messages.get().container("ERR_SERIALIZING_USER_DATA_1", userId), (Throwable)e);
        }
    }

    protected void internalValidateResourceForOrgUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, String rootPath) throws CmsException {
        CmsResource parentResource = this.m_driverManager.readResource(dbc, ORGUNIT_BASE_FOLDER + orgUnit.getName(), CmsResourceFilter.ALL);
        boolean found = false;
        Iterator<String> itParentPaths = this.internalResourcesForOrgUnit(dbc, parentResource).iterator();
        while (!found && itParentPaths.hasNext()) {
            String parentPath = itParentPaths.next();
            if (!rootPath.startsWith(parentPath)) continue;
            found = true;
        }
        if (!found) {
            throw new CmsException(org.opencms.db.generic.Messages.get().container("ERR_PATH_NOT_IN_PARENT_ORGUNIT_SCOPE_2", orgUnit.getName(), dbc.removeSiteRoot(rootPath)));
        }
    }

    protected boolean internalValidateUserInGroup(CmsDbContext dbc, CmsUUID userId, CmsUUID groupId) throws CmsDataAccessException {
        boolean userInGroup = false;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_GROUPS_USER_IN_GROUP_2);
            q.setParameter(1, (Object)groupId.toString());
            q.setParameter(2, (Object)userId.toString());
            try {
                CmsDAOGroupUsers gu = (CmsDAOGroupUsers)q.getSingleResult();
                userInGroup = true;
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return userInGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalWriteOrgUnitProperty(CmsDbContext dbc, CmsResource resource, CmsProperty property) throws CmsException {
        CmsUUID projectId = dbc.getProjectId() == null || dbc.getProjectId().isNullUUID() ? dbc.currentProject().getUuid() : dbc.getProjectId();
        this.m_driverManager.writePropertyObject(dbc, resource, property);
        resource.setState(CmsResource.STATE_UNCHANGED);
        this.m_driverManager.getVfsDriver(dbc).writeResource(dbc, projectId, resource, 0);
        CmsProject project = dbc.currentProject();
        dbc.getRequestContext().setCurrentProject(this.m_driverManager.readProject(dbc, CmsProject.ONLINE_PROJECT_ID));
        try {
            this.m_driverManager.writePropertyObject(dbc, resource, property);
            resource.setState(CmsResource.STATE_UNCHANGED);
            this.m_driverManager.getVfsDriver(dbc).writeResource(dbc, dbc.currentProject().getUuid(), resource, 0);
        }
        finally {
            dbc.getRequestContext().setCurrentProject(project);
        }
    }

    protected void internalWriteUserInfo(CmsDbContext dbc, CmsUUID userId, String key, Object value) throws CmsDataAccessException {
        try {
            CmsDAOUserData u = new CmsDAOUserData();
            u.setUserId(userId.toString());
            u.setDataKey(key);
            u.setDataValue(CmsDataTypeUtil.dataSerialize(value));
            u.setDataType(value.getClass().getName());
            this.m_sqlManager.persist(dbc, u);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(org.opencms.db.generic.Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        catch (IOException e) {
            throw new CmsDbIoException(org.opencms.db.generic.Messages.get().container("ERR_SERIALIZING_USER_DATA_1", userId), (Throwable)e);
        }
    }

    protected void internalWriteUserInfos(CmsDbContext dbc, CmsUUID userId, Map<String, Object> additionalInfo) throws CmsDataAccessException {
        Map<String, Object> existingInfos = this.readUserInfos(dbc, userId);
        for (Map.Entry<String, Object> entry : existingInfos.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            if (!additionalInfo.containsKey(entry.getKey())) {
                dbc.setAttribute(ATTRIBUTE_USERADDINFO, ATTRIBUTE_USERADDINFO_VALUE_DELETE);
                this.writeUserInfo(dbc, userId, entry.getKey(), entry.getValue());
                continue;
            }
            Object newValue = additionalInfo.get(entry.getKey());
            if (newValue == null || newValue.equals(entry.getValue())) continue;
            dbc.setAttribute(ATTRIBUTE_USERADDINFO, ATTRIBUTE_USERADDINFO_VALUE_UPDATE);
            this.writeUserInfo(dbc, userId, entry.getKey(), newValue);
        }
        for (Map.Entry<String, Object> entry : additionalInfo.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || existingInfos.containsKey(entry.getKey())) continue;
            dbc.setAttribute(ATTRIBUTE_USERADDINFO, ATTRIBUTE_USERADDINFO_VALUE_INSERT);
            this.writeUserInfo(dbc, userId, entry.getKey(), entry.getValue());
        }
    }
}

