/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.collectors.CmsCollectorData;
import org.opencms.file.collectors.Messages;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsExtendedCollectorData
extends CmsCollectorData {
    private static final Log LOG = CmsLog.getLog(CmsExtendedCollectorData.class);
    private List<String> m_additionalParams;

    protected CmsExtendedCollectorData() {
    }

    public CmsExtendedCollectorData(String data) {
        String count;
        if (data == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_PARAM_EMPTY_0"));
        }
        List<String> args = CmsStringUtil.splitAsList(data, '|', true);
        if (args.size() < 3) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_PARAM_INVALID_1", data));
        }
        this.setFileName(args.get(0));
        String type = args.get(1);
        try {
            I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(type);
            this.setType(resourceType.getTypeId());
        }
        catch (CmsLoaderException e1) {
            try {
                int typeInt = Integer.parseInt(type);
                I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(typeInt);
                this.setType(resourceType.getTypeId());
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_RESTYPE_INTID_2", resourceType.getTypeName(), new Integer(resourceType.getTypeId())));
                }
            }
            catch (NumberFormatException e2) {
                throw new CmsRuntimeException(Messages.get().container("ERR_COLLECTOR_PARAM_INVALID_1", data), (Throwable)e2);
            }
            catch (CmsLoaderException e2) {
                throw new CmsRuntimeException(Messages.get().container("ERR_UNKNOWN_RESTYPE_1", type), (Throwable)e2);
            }
        }
        this.setCount(5);
        if (args.size() > 2 && CmsStringUtil.isNotEmpty(count = args.get(2))) {
            try {
                this.setCount(Integer.parseInt(count));
            }
            catch (NumberFormatException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_COLLECTOR_PARAM_INVALID_1", data), (Throwable)e);
            }
        }
        if (args.size() > 3) {
            if ("excludeTimerange".equalsIgnoreCase(args.get(3))) {
                this.setExcludeTimerange(true);
                if (args.size() > 4) {
                    this.m_additionalParams = args.subList(4, args.size());
                }
            } else {
                this.m_additionalParams = args.subList(3, args.size());
            }
        }
    }

    public List<String> getAdditionalParams() {
        return this.m_additionalParams;
    }

    protected void setAdditionalParams(List<String> additionalParams) {
        this.m_additionalParams = additionalParams;
    }
}

