/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.wrapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.I_CmsResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.file.wrapper.CmsResourceWrapperUtils;
import org.opencms.file.wrapper.CmsWrappedResource;
import org.opencms.file.wrapper.I_CmsResourceWrapper;
import org.opencms.file.wrapper.Messages;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

public class CmsObjectWrapper {
    public static final String ATTRIBUTE_NAME = "org.opencms.file.wrapper.CmsObjectWrapper";
    private static final Log LOG = CmsLog.getLog(CmsObjectWrapper.class);
    private boolean m_addByteOrderMark = true;
    private CmsObject m_cms;
    private List<I_CmsResourceWrapper> m_wrappers;

    public CmsObjectWrapper(CmsObject cms, List<I_CmsResourceWrapper> wrappers) {
        this.m_cms = cms;
        this.m_wrappers = wrappers;
    }

    public void copyResource(String source, String destination, CmsResource.CmsResourceCopyMode siblingMode) throws CmsException, CmsIllegalArgumentException {
        I_CmsResourceWrapper wrapper;
        boolean exec = false;
        List<I_CmsResourceWrapper> wrappers = this.getWrappers();
        Iterator<I_CmsResourceWrapper> iter = wrappers.iterator();
        while (iter.hasNext() && !(exec = (wrapper = iter.next()).copyResource(this.m_cms, source, destination, siblingMode))) {
        }
        if (!exec) {
            this.m_cms.copyResource(source, destination, siblingMode);
        }
    }

    public CmsResource createResource(String resourcename, int type) throws CmsException, CmsIllegalArgumentException {
        return this.createResource(resourcename, type, new byte[0], new ArrayList<CmsProperty>(0));
    }

    public CmsResource createResource(String resourcename, int type, byte[] content, List<CmsProperty> properties) throws CmsException, CmsIllegalArgumentException {
        I_CmsResourceWrapper wrapper;
        CmsResource res = null;
        List<I_CmsResourceWrapper> wrappers = this.getWrappers();
        Iterator<I_CmsResourceWrapper> iter = wrappers.iterator();
        while (iter.hasNext() && (res = (wrapper = iter.next()).createResource(this.m_cms, resourcename, type, content, properties)) == null) {
        }
        if (res == null) {
            res = this.m_cms.createResource(resourcename, type, content, properties);
        }
        return res;
    }

    public void deleteResource(String resourcename, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        I_CmsResourceWrapper wrapper;
        boolean exec = false;
        List<I_CmsResourceWrapper> wrappers = this.getWrappers();
        Iterator<I_CmsResourceWrapper> iter = wrappers.iterator();
        while (iter.hasNext() && !(exec = (wrapper = iter.next()).deleteResource(this.m_cms, resourcename, siblingMode))) {
        }
        if (!exec) {
            this.m_cms.deleteResource(resourcename, siblingMode);
        }
    }

    public boolean existsResource(String resourcename) {
        boolean ret = this.m_cms.existsResource(resourcename);
        if (!ret) {
            List<I_CmsResourceWrapper> wrappers = this.getWrappers();
            for (I_CmsResourceWrapper wrapper : wrappers) {
                try {
                    CmsResource res = wrapper.readResource(this.m_cms, resourcename, CmsResourceFilter.DEFAULT);
                    if (res == null) continue;
                    ret = true;
                    break;
                }
                catch (CmsException ex) {
                }
            }
        }
        return ret;
    }

    public CmsLock getLock(CmsResource resource) throws CmsException {
        I_CmsResourceWrapper wrapper;
        CmsLock lock = null;
        List<I_CmsResourceWrapper> wrappers = this.getWrappers();
        Iterator<I_CmsResourceWrapper> iter = wrappers.iterator();
        while (iter.hasNext() && (lock = (wrapper = iter.next()).getLock(this.m_cms, resource)) == null) {
        }
        if (lock == null) {
            lock = this.m_cms.getLock(resource);
        }
        return lock;
    }

    public CmsRequestContext getRequestContext() {
        return this.m_cms.getRequestContext();
    }

    public List<CmsResource> getResourcesInFolder(String resourcename, CmsResourceFilter filter) throws CmsException {
        ArrayList<CmsResource> list = new ArrayList<CmsResource>();
        try {
            list.addAll(this.m_cms.getResourcesInFolder(resourcename, filter));
        }
        catch (CmsException ex) {
            // empty catch block
        }
        List<I_CmsResourceWrapper> wrappers = this.getWrappers();
        for (I_CmsResourceWrapper wrapper : wrappers) {
            List<CmsResource> added = wrapper.addResourcesToFolder(this.m_cms, resourcename, filter);
            if (added == null) continue;
            list.addAll(added);
        }
        ArrayList<CmsResource> wrapped = new ArrayList<CmsResource>();
        for (CmsResource res : list) {
            I_CmsResourceWrapper resWrapper;
            if (this.needUtf8Marker(res) && !this.startsWithUtf8Marker(res)) {
                CmsWrappedResource wrap = new CmsWrappedResource(res);
                wrap.setLength(res.getLength() + CmsResourceWrapperUtils.UTF8_MARKER.length);
                res = wrap.getResource();
            }
            if ((resWrapper = this.getResourceTypeWrapper(res)) != null) {
                wrapped.add(resWrapper.wrapResource(this.m_cms, res));
                continue;
            }
            wrapped.add(res);
        }
        Collections.sort(wrapped, I_CmsResource.COMPARE_ROOT_PATH_IGNORE_CASE_FOLDERS_FIRST);
        return wrapped;
    }

    public String getSitePath(CmsResource resource) {
        return this.m_cms.getSitePath(resource);
    }

    public List<I_CmsResourceWrapper> getWrappers() {
        return this.m_wrappers;
    }

    public void lockResource(String resourcename) throws CmsException {
        I_CmsResourceWrapper wrapper;
        boolean exec = false;
        List<I_CmsResourceWrapper> wrappers = this.getWrappers();
        Iterator<I_CmsResourceWrapper> iter = wrappers.iterator();
        while (iter.hasNext() && !(exec = (wrapper = iter.next()).lockResource(this.m_cms, resourcename, false))) {
        }
        if (!exec) {
            this.m_cms.lockResource(resourcename);
        }
    }

    public void lockResourceTemporary(String resourceName) throws CmsException {
        I_CmsResourceWrapper wrapper;
        boolean exec = false;
        List<I_CmsResourceWrapper> wrappers = this.getWrappers();
        Iterator<I_CmsResourceWrapper> i$ = wrappers.iterator();
        while (i$.hasNext() && !(exec = (wrapper = i$.next()).lockResource(this.m_cms, resourceName, true))) {
        }
        if (!exec) {
            this.m_cms.lockResourceTemporary(resourceName);
        }
    }

    public void moveResource(String source, String destination) throws CmsException {
        I_CmsResourceWrapper wrapper;
        boolean exec = false;
        List<I_CmsResourceWrapper> wrappers = this.getWrappers();
        Iterator<I_CmsResourceWrapper> iter = wrappers.iterator();
        while (iter.hasNext() && !(exec = (wrapper = iter.next()).moveResource(this.m_cms, source, destination))) {
        }
        if (!exec) {
            this.m_cms.moveResource(source, destination);
        }
    }

    public CmsFile readFile(String resourcename, CmsResourceFilter filter) throws CmsException {
        I_CmsResourceWrapper wrapper;
        CmsFile res = null;
        List<I_CmsResourceWrapper> wrappers = this.getWrappers();
        Iterator<I_CmsResourceWrapper> iter = wrappers.iterator();
        while (iter.hasNext() && (res = (wrapper = iter.next()).readFile(this.m_cms, resourcename, filter)) == null) {
        }
        if (res == null) {
            res = this.m_cms.readFile(resourcename, filter);
        }
        if (this.needUtf8Marker(res)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_UTF8_MARKER_1", res.getRootPath()));
            }
            res.setContents(CmsResourceWrapperUtils.addUtf8Marker(res.getContents()));
        }
        return res;
    }

    public CmsProperty readPropertyObject(CmsResource resource, String property, boolean search) throws CmsException {
        return this.m_cms.readPropertyObject(resource, property, search);
    }

    public CmsResource readResource(CmsUUID structureID, CmsResourceFilter filter) throws CmsException {
        return this.m_cms.readResource(structureID, filter);
    }

    public CmsResource readResource(String resourcename, CmsResourceFilter filter) throws CmsException {
        I_CmsResourceWrapper wrapper;
        CmsResource res = null;
        List<I_CmsResourceWrapper> wrappers = this.getWrappers();
        Iterator<I_CmsResourceWrapper> iter = wrappers.iterator();
        while (iter.hasNext() && (res = (wrapper = iter.next()).readResource(this.m_cms, resourcename, filter)) == null) {
        }
        if (res == null) {
            res = this.m_cms.readResource(resourcename, filter);
        }
        if (this.needUtf8Marker(res) && !this.startsWithUtf8Marker(res)) {
            CmsWrappedResource wrap = new CmsWrappedResource(res);
            wrap.setLength(res.getLength() + CmsResourceWrapperUtils.UTF8_MARKER.length);
            return wrap.getResource();
        }
        return res;
    }

    public CmsUser readUser(CmsUUID userId) throws CmsException {
        return this.m_cms.readUser(userId);
    }

    public String restoreLink(String path) {
        if (path != null && path.startsWith("#")) {
            return path;
        }
        String ret = null;
        List<I_CmsResourceWrapper> wrappers = this.getWrappers();
        for (I_CmsResourceWrapper wrapper : wrappers) {
            ret = wrapper.restoreLink(this.m_cms, this.m_cms.getRequestContext().removeSiteRoot(path));
            if (ret == null) continue;
            return ret;
        }
        return path;
    }

    public String rewriteLink(String path) {
        CmsResource res = null;
        try {
            res = this.readResource(this.m_cms.getRequestContext().removeSiteRoot(path), CmsResourceFilter.ALL);
            if (res != null) {
                String ret = null;
                List<I_CmsResourceWrapper> wrappers = this.getWrappers();
                for (I_CmsResourceWrapper wrapper : wrappers) {
                    ret = wrapper.rewriteLink(this.m_cms, res);
                    if (ret == null) continue;
                    return ret;
                }
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return path;
    }

    public void setAddByteOrderMark(boolean addByteOrderMark) {
        this.m_addByteOrderMark = addByteOrderMark;
    }

    public void unlockResource(String resourcename) throws CmsException {
        I_CmsResourceWrapper wrapper;
        boolean exec = false;
        List<I_CmsResourceWrapper> wrappers = this.getWrappers();
        Iterator<I_CmsResourceWrapper> iter = wrappers.iterator();
        while (iter.hasNext() && !(exec = (wrapper = iter.next()).unlockResource(this.m_cms, resourcename))) {
        }
        if (!exec) {
            this.m_cms.unlockResource(resourcename);
        }
    }

    public CmsFile writeFile(CmsFile resource) throws CmsException {
        String resourcename;
        CmsFile res = null;
        if (this.needUtf8Marker(resource)) {
            resource.setContents(CmsResourceWrapperUtils.removeUtf8Marker(resource.getContents()));
        }
        if (!this.m_cms.existsResource(resourcename = this.m_cms.getSitePath(resource))) {
            I_CmsResourceWrapper wrapper;
            List<I_CmsResourceWrapper> wrappers = this.getWrappers();
            Iterator<I_CmsResourceWrapper> iter = wrappers.iterator();
            while (iter.hasNext() && (res = (wrapper = iter.next()).writeFile(this.m_cms, resource)) == null) {
            }
            if (res == null) {
                res = this.m_cms.writeFile(resource);
            }
        } else {
            res = this.m_cms.writeFile(resource);
        }
        return res;
    }

    private I_CmsResourceWrapper getResourceTypeWrapper(CmsResource res) {
        for (I_CmsResourceWrapper wrapper : this.getWrappers()) {
            if (!wrapper.isWrappedResource(this.m_cms, res)) continue;
            return wrapper;
        }
        return null;
    }

    private boolean needUtf8Marker(CmsResource res) {
        if (!this.m_addByteOrderMark) {
            return false;
        }
        String encoding = CmsLocaleManager.getResourceEncoding(this.m_cms, res);
        boolean result = false;
        if ("UTF-8".equals(encoding)) {
            try {
                I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(res.getTypeId());
                if (resType instanceof CmsResourceTypeJsp) {
                    result = true;
                } else if (resType instanceof CmsResourceTypePlain) {
                    result = true;
                } else if (resType instanceof CmsResourceTypeXmlContent) {
                    result = true;
                } else if (resType instanceof CmsResourceTypeXmlPage) {
                    result = true;
                }
            }
            catch (CmsLoaderException e) {
                LOG.debug((Object)e);
            }
        }
        return result;
    }

    private boolean startsWithUtf8Marker(CmsResource res) {
        boolean result = false;
        try {
            CmsFile file;
            if (res.isFile() && (file = this.m_cms.readFile(res)).getContents().length >= 3 && file.getContents()[0] == CmsResourceWrapperUtils.UTF8_MARKER[0] && file.getContents()[1] == CmsResourceWrapperUtils.UTF8_MARKER[1] && file.getContents()[2] == CmsResourceWrapperUtils.UTF8_MARKER[2]) {
                result = true;
            }
        }
        catch (CmsException e) {
            LOG.debug((Object)e);
        }
        return result;
    }
}

