/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.configuration.preferences.I_CmsPreference;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.gwt.shared.CmsUserSettingsBean;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.workplace.commons.CmsPreferences;
import org.opencms.workplace.commons.Messages;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsClientUserSettingConverter {
    private static final Log LOG = CmsLog.getLog(CmsClientUserSettingConverter.class);
    private CmsObject m_cms;
    private CmsPreferences m_preferences;
    private HttpServletRequest m_request;
    private CmsMacroResolver m_macroResolver = new CmsMacroResolver();
    private CmsDefaultUserSettings m_currentPreferences;

    public CmsClientUserSettingConverter(CmsObject cms, HttpServletRequest request, HttpServletResponse response) {
        this.m_cms = cms;
        this.m_request = request;
        this.m_preferences = new CmsPreferences(new NoJspActionElement(cms, request, response));
        this.m_currentPreferences = new CmsDefaultUserSettings();
        this.m_currentPreferences.init(cms.getRequestContext().getCurrentUser());
        this.m_preferences.setUserSettings(this.m_currentPreferences);
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        CmsMultiMessages messages = new CmsMultiMessages(locale);
        messages.addMessages(OpenCms.getWorkplaceManager().getMessages(locale));
        messages.addMessages(Messages.get().getBundle(locale));
        this.m_macroResolver.setMessages(messages);
    }

    public CmsUserSettingsBean loadSettings() {
        CmsUserSettingsBean result = new CmsUserSettingsBean();
        CmsDefaultUserSettings currentSettings = new CmsDefaultUserSettings();
        currentSettings.init(this.m_preferences.getUserSettings().getUser());
        for (I_CmsPreference pref : OpenCms.getWorkplaceManager().getDefaultUserSettings().getPreferences().values()) {
            String tab = pref.getTab();
            if ("hidden".equals(tab)) continue;
            CmsXmlContentProperty prop2 = pref.getPropertyDefinition(this.m_cms);
            String value = pref.getValue(currentSettings);
            CmsXmlContentProperty resolvedProp = CmsXmlContentPropertyHelper.resolveMacrosInProperty(prop2.withDefaultWidget("string"), this.m_macroResolver);
            result.addSetting(value, resolvedProp, "basic".equals(tab));
        }
        this.addAccountInfo(result);
        return result;
    }

    public void saveSettings(Map<String, String> settings) throws Exception {
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.saveSetting(key, value);
        }
        this.m_preferences.getUserSettings().save(this.m_cms);
        this.m_preferences.updatePreferences(this.m_cms, this.m_request);
    }

    private void addAccountInfo(CmsUserSettingsBean prefs) {
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
        CmsMessages wpMessages = Messages.get().getBundle(wpLocale);
        CmsUser user = this.m_currentPreferences.getUser();
        prefs.addAccountInfo(wpMessages.key("GUI_LABEL_USER_0"), user.getName());
        prefs.addAccountInfo(wpMessages.key("GUI_LABEL_EMAIL_0"), user.getEmail());
        prefs.addAccountInfo(wpMessages.key("GUI_LABEL_LASTNAME_0"), user.getLastname());
        prefs.addAccountInfo(wpMessages.key("GUI_LABEL_FIRSTNAME_0"), user.getFirstname());
        prefs.addAccountInfo(wpMessages.key("GUI_INPUT_ADRESS_0"), user.getAddress());
        prefs.addAccountInfo(wpMessages.key("GUI_LABEL_DESCRIPTION_0"), user.getDescription(wpLocale));
    }

    private void saveSetting(String key, String value) throws Exception {
        Map<String, I_CmsPreference> prefs = OpenCms.getWorkplaceManager().getDefaultUserSettings().getPreferences();
        if (prefs.containsKey(key)) {
            prefs.get(key).setValue(this.m_currentPreferences, value);
        } else {
            LOG.error((Object)("Can't save user setting '" + key + "'"));
        }
    }

    class NoJspActionElement
    extends CmsJspActionElement {
        private CmsObject m_setCms;

        public NoJspActionElement(CmsObject cms, HttpServletRequest req, HttpServletResponse res) {
            super(null, req, res);
            this.m_setCms = cms;
        }

        @Override
        public CmsObject getCmsObject() {
            return this.m_setCms;
        }

        @Override
        protected void handleMissingFlexController() {
        }
    }
}

