/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt.shared.property;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opencms.gwt.shared.property.CmsLazyPropertyMap;
import org.opencms.gwt.shared.property.CmsPathValue;
import org.opencms.util.CmsStringUtil;

public class CmsClientProperty
implements IsSerializable {
    public static final Function<String, CmsClientProperty> CREATE_PROPERTY = new Function<String, CmsClientProperty>(){

        public CmsClientProperty apply(String name) {
            return new CmsClientProperty(name, "", "");
        }
    };
    public static final String PATH_RESOURCE_VALUE = "R";
    public static final String PATH_STRUCTURE_VALUE = "S";
    public static final String PROPERTY_COPYRIGHT = "Copyright";
    public static final String PROPERTY_DEFAULTFILE = "default-file";
    public static final String PROPERTY_DESCRIPTION = "Description";
    public static final String PROPERTY_NAVINFO = "NavInfo";
    public static final String PROPERTY_NAVPOS = "NavPos";
    public static final String PROPERTY_NAVTEXT = "NavText";
    public static final String PROPERTY_TEMPLATE = "template";
    public static final String PROPERTY_TITLE = "Title";
    private String m_name;
    private String m_origin;
    private String m_resourceValue;
    private String m_structureValue;

    public CmsClientProperty(CmsClientProperty property) {
        this.m_name = property.m_name;
        this.m_structureValue = property.m_structureValue;
        this.m_resourceValue = property.m_resourceValue;
    }

    public CmsClientProperty(String name, String structureValue, String resourceValue) {
        this.m_name = name;
        this.m_structureValue = structureValue;
        this.m_resourceValue = resourceValue;
    }

    protected CmsClientProperty() {
    }

    public static Map<String, CmsClientProperty> copyProperties(Map<String, CmsClientProperty> props) {
        HashMap<String, CmsClientProperty> result = new HashMap<String, CmsClientProperty>();
        for (Map.Entry<String, CmsClientProperty> entry : props.entrySet()) {
            String key = entry.getKey();
            CmsClientProperty copiedValue = new CmsClientProperty(entry.getValue());
            result.put(key, copiedValue);
        }
        return result;
    }

    public static CmsPathValue getPathValue(CmsClientProperty property, Mode mode) {
        if (property != null) {
            return property.getPathValue(mode);
        }
        switch (mode) {
            case resource: {
                return new CmsPathValue("", PATH_RESOURCE_VALUE);
            }
            case structure: {
                return new CmsPathValue("", PATH_STRUCTURE_VALUE);
            }
            case effective: {
                return new CmsPathValue("", PATH_STRUCTURE_VALUE);
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isPropertyEmpty(CmsClientProperty prop) {
        return prop == null || prop.isEmpty();
    }

    public static Map<String, CmsClientProperty> makeLazyCopy(Map<String, CmsClientProperty> properties) {
        if (properties == null) {
            return null;
        }
        return CmsClientProperty.toLazyMap(CmsClientProperty.copyProperties(properties));
    }

    public static void removeEmptyProperties(Map<String, CmsClientProperty> props) {
        Iterator<Map.Entry<String, CmsClientProperty>> iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, CmsClientProperty> entry = iter.next();
            CmsClientProperty value = entry.getValue();
            if (!value.isEmpty()) continue;
            iter.remove();
        }
    }

    public static Map<String, CmsClientProperty> toLazyMap(Map<String, CmsClientProperty> properties) {
        CmsLazyPropertyMap result = new CmsLazyPropertyMap(properties);
        return result;
    }

    public String getEffectiveValue() {
        return this.getPathValue().getValue();
    }

    public String getName() {
        return this.m_name;
    }

    public String getOrigin() {
        return this.m_origin;
    }

    public CmsPathValue getPathValue() {
        if (!CmsStringUtil.isEmpty(this.m_structureValue)) {
            return new CmsPathValue(this.m_structureValue, PATH_STRUCTURE_VALUE);
        }
        if (!CmsStringUtil.isEmpty(this.m_resourceValue)) {
            return new CmsPathValue(this.m_resourceValue, PATH_RESOURCE_VALUE);
        }
        return new CmsPathValue(null, PATH_STRUCTURE_VALUE);
    }

    public CmsPathValue getPathValue(Mode mode) {
        switch (mode) {
            case resource: {
                return new CmsPathValue(this.m_resourceValue, PATH_RESOURCE_VALUE);
            }
            case structure: {
                return new CmsPathValue(this.m_structureValue, PATH_STRUCTURE_VALUE);
            }
        }
        return this.getPathValue();
    }

    public String getResourceValue() {
        return this.m_resourceValue;
    }

    public String getStructureValue() {
        return this.m_structureValue;
    }

    public boolean isEmpty() {
        return CmsStringUtil.isEmpty(this.m_resourceValue) && CmsStringUtil.isEmpty(this.m_structureValue);
    }

    public void setOrigin(String origin) {
        this.m_origin = origin;
    }

    public void setResourceValue(String resourceValue) {
        this.m_resourceValue = resourceValue;
    }

    public void setStructureValue(String structureValue) {
        this.m_structureValue = structureValue;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.m_name).add("structureValue", (Object)this.m_structureValue).add("resourceValue", (Object)this.m_resourceValue).toString();
    }

    public CmsClientProperty withOrigin(String origin) {
        CmsClientProperty property = new CmsClientProperty(this);
        property.setOrigin(origin);
        return property;
    }

    public static enum Mode {
        effective,
        resource,
        structure;

    }
}

