/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import com.google.common.collect.ComparisonChain;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportHelper;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.I_CmsImport;
import org.opencms.importexport.Messages;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationType;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlErrorHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CmsImportVersion7
implements I_CmsImport {
    public static final String A_NAME = "name";
    public static final String A_TYPE = "type";
    public static final String DTD_FILENAME = "opencms-import7.dtd";
    public static final String DTD_LOCATION = "org/opencms/importexport/";
    public static final int IMPORT_VERSION7 = 7;
    public static final String N_ACCESSCONTROL_ALLOWEDPERMISSIONS = "allowed";
    public static final String N_ACCESSCONTROL_DENIEDPERMISSIONS = "denied";
    public static final String N_ACCESSCONTROL_ENTRIES = "accesscontrol";
    public static final String N_ACCESSCONTROL_ENTRY = "accessentry";
    public static final String N_ACCESSCONTROL_PERMISSIONSET = "permissionset";
    public static final String N_ACCESSCONTROL_PRINCIPAL = "uuidprincipal";
    public static final String N_ACCOUNTS = "accounts";
    public static final String N_DATECREATED = "datecreated";
    public static final String N_DATEEXPIRED = "dateexpired";
    public static final String N_DATELASTMODIFIED = "datelastmodified";
    public static final String N_DATERELEASED = "datereleased";
    public static final String N_DESCRIPTION = "description";
    public static final String N_DESTINATION = "destination";
    public static final String N_EMAIL = "email";
    public static final String N_FILE = "file";
    public static final String N_FILES = "files";
    public static final String N_FIRSTNAME = "firstname";
    public static final String N_FLAGS = "flags";
    public static final String N_GROUP = "group";
    public static final String N_GROUPS = "groups";
    public static final String N_ID = "id";
    public static final String N_LASTNAME = "lastname";
    public static final String N_MANAGERSGROUP = "managersgroup";
    public static final String N_NAME = "name";
    public static final String N_ORGUNIT = "orgunit";
    public static final String N_ORGUNITS = "orgunits";
    public static final String N_PARENTGROUP = "parentgroup";
    public static final String N_PASSWORD = "password";
    public static final String N_PATH = "path";
    public static final String N_PROJECT = "project";
    public static final String N_PROJECTS = "projects";
    public static final String N_PROPERTIES = "properties";
    public static final String N_PROPERTY = "property";
    public static final String N_RELATION = "relation";
    public static final String N_RELATIONS = "relations";
    public static final String N_RESOURCE = "resource";
    public static final String N_RESOURCES = "resources";
    public static final String N_SOURCE = "source";
    public static final String N_TYPE = "type";
    public static final String N_USER = "user";
    public static final String N_USERCREATED = "usercreated";
    public static final String N_USERGROUP = "usergroup";
    public static final String N_USERGROUPS = "usergroups";
    public static final String N_USERINFO = "userinfo";
    public static final String N_USERINFO_ENTRY = "entry";
    public static final String N_USERLASTMODIFIED = "userlastmodified";
    public static final String N_USERROLE = "userrole";
    public static final String N_USERROLES = "userroles";
    public static final String N_USERS = "users";
    public static final String N_USERSGROUP = "usersgroup";
    public static final String N_UUIDRESOURCE = "uuidresource";
    public static final String N_UUIDSTRUCTURE = "uuidstructure";
    public static final String N_VALUE = "value";
    public static final String PROPERTY_ATTRIB_TYPE_SHARED = "shared";
    private static final Log LOG = CmsLog.getLog(CmsImportVersion7.class);
    private int m_aceFlags;
    private int m_acePermissionsAllowed;
    private int m_acePermissionsDenied;
    private CmsUUID m_acePrincipalId;
    private List<CmsAccessControlEntry> m_aces;
    private CmsObject m_cms;
    private Set<CmsUUID> m_contentFiles = new HashSet<CmsUUID>();
    private long m_dateCreated;
    private long m_dateExpired = Long.MAX_VALUE;
    private long m_dateLastModified;
    private long m_dateReleased = 0L;
    private String m_destination;
    private int m_fileCounter;
    private int m_flags;
    private String m_groupDescription;
    private int m_groupFlags;
    private String m_groupName;
    private String m_groupParent;
    private Map<String, List<String>> m_groupParents;
    private CmsImportHelper m_helper;
    private List<String> m_ignoredProperties;
    private List<String> m_immutables;
    private boolean m_importACEs;
    private Map<String, Map<String, Map<String, String>>> m_membership;
    private CmsOrganizationalUnit m_orgUnit;
    private String m_orgUnitDescription;
    private int m_orgUnitFlags;
    private String m_orgUnitName;
    private Map<String, List<String>> m_orgUnitResources;
    private CmsImportParameters m_parameters;
    private List<CmsResource> m_parseables;
    private String m_projectDescription;
    private String m_projectManagers;
    private String m_projectName;
    private List<String> m_projectResources;
    private String m_projectUsers;
    private Map<String, CmsProperty> m_properties;
    private String m_propertyName;
    private String m_propertyValue;
    private CmsUUID m_relationId;
    private String m_relationPath;
    private Map<String, List<CmsRelation>> m_relations;
    private CmsRelationType m_relationType;
    private I_CmsReport m_report;
    private CmsResource m_resource;
    private CmsUUID m_resourceId;
    private String m_source;
    private CmsUUID m_structureId;
    private Throwable m_throwable;
    private int m_totalFiles;
    private I_CmsResourceType m_type;
    private CmsUser m_user;
    private CmsUUID m_userCreated;
    private long m_userDateCreated;
    private String m_userEmail;
    private String m_userFirstname;
    private int m_userFlags;
    private Map<String, Object> m_userInfos;
    private CmsUUID m_userLastModified;
    private String m_userLastname;
    private String m_userName;
    private String m_userPassword;
    private int m_version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessControlEntry() {
        try {
            if (this.m_resource == null || !this.m_importACEs) {
                return;
            }
            if (this.m_throwable != null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ERROR_IMPORTING_ACE_1", this.getCms().getRequestContext().removeSiteRoot(this.m_resource.getRootPath())), this.m_throwable);
                }
                this.getReport().println(this.m_throwable);
                this.getReport().addError(this.m_throwable);
                return;
            }
            if (this.m_aces == null) {
                this.m_aces = new ArrayList<CmsAccessControlEntry>();
            }
            this.m_aces.add(new CmsAccessControlEntry(this.m_resource.getResourceId(), this.m_acePrincipalId, this.m_acePermissionsAllowed, this.m_acePermissionsDenied, this.m_aceFlags));
        }
        finally {
            this.m_throwable = null;
            this.m_acePrincipalId = null;
            this.m_acePermissionsAllowed = 0;
            this.m_acePermissionsDenied = 0;
            this.m_aceFlags = 0;
        }
    }

    public void addContentFile(String source, String resourceId) {
        if (source != null && resourceId != null) {
            try {
                this.m_helper.getFileBytes(source);
                this.m_contentFiles.add(new CmsUUID(resourceId));
            }
            catch (CmsImportExportException e) {
                LOG.info((Object)("File not found in import: " + source));
            }
        }
    }

    public void addOrgUnitResource(String resourceName) {
        List<String> resources;
        if (this.m_throwable != null || this.m_orgUnitName == null) {
            return;
        }
        if (this.m_orgUnitResources == null) {
            this.m_orgUnitResources = new HashMap<String, List<String>>();
        }
        if ((resources = this.m_orgUnitResources.get(this.m_orgUnitName)) == null) {
            resources = new ArrayList<String>();
            this.m_orgUnitResources.put(this.m_orgUnitName, resources);
        }
        resources.add(resourceName);
    }

    public void addProjectResource(String resourceName) {
        if (this.m_throwable != null || this.m_projectName == null) {
            return;
        }
        if (this.m_projectResources == null) {
            this.m_projectResources = new ArrayList<String>();
        }
        this.m_projectResources.add(resourceName);
    }

    public void addProperty() {
        this.addProperty("individual");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String propertyType) {
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, CmsProperty>();
        }
        try {
            if (this.m_propertyName == null || this.getIgnoredProperties().contains(this.m_propertyName)) {
                return;
            }
            CmsProperty property = this.m_properties.get(this.m_propertyName);
            if (property == null) {
                property = new CmsProperty();
                property.setName(this.m_propertyName);
                property.setAutoCreatePropertyDefinition(true);
                this.m_properties.put(this.m_propertyName, property);
            }
            if (this.m_propertyValue == null) {
                this.m_propertyValue = "";
            }
            if (propertyType != null && propertyType.equals(PROPERTY_ATTRIB_TYPE_SHARED)) {
                property.setResourceValue(this.m_propertyValue);
            } else {
                property.setStructureValue(this.m_propertyValue);
            }
        }
        finally {
            this.m_propertyName = null;
            this.m_propertyValue = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelation() {
        if (this.m_relations == null) {
            this.m_relations = new HashMap<String, List<CmsRelation>>();
        }
        try {
            if (this.m_resource == null) {
                return;
            }
            if (this.m_throwable != null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ERROR_IMPORTING_RELATION_1", this.getCms().getRequestContext().removeSiteRoot(this.m_resource.getRootPath())), this.m_throwable);
                }
                this.getReport().println(this.m_throwable);
                this.getReport().addError(this.m_throwable);
                this.m_throwable = null;
                return;
            }
            List<CmsRelation> currentRelations = this.m_relations.get(this.m_resource.getRootPath());
            if (currentRelations == null) {
                currentRelations = new ArrayList<CmsRelation>();
                this.m_relations.put(this.m_resource.getRootPath(), currentRelations);
            }
            currentRelations.add(new CmsRelation(this.m_resource.getStructureId(), this.m_resource.getRootPath(), this.m_relationId, this.m_relationPath, this.m_relationType));
        }
        finally {
            this.m_relationId = null;
            this.m_relationPath = null;
            this.m_relationType = null;
        }
    }

    public void addXmlDigesterRules(Digester digester) {
        String xpath = "export/accounts/orgunits/orgunit/";
        this.addAccountsOrgunitRules(digester, xpath);
        this.addAccountsGroupRules(digester, xpath);
        this.addAccountsUserRules(digester, xpath);
        digester.addCallMethod("export/accounts/orgunits/orgunit", "setMembership");
        xpath = "export/files/file/";
        this.addResourceAttributesRules(digester, xpath);
        this.addResourcePropertyRules(digester, xpath);
        this.addResourceRelationRules(digester, xpath);
        this.addResourceAceRules(digester, xpath);
        digester.addCallMethod("export/files/file", "increaseCounter");
        digester.addCallMethod("export/files", "importRelations");
        digester.addCallMethod("export/files", "rewriteParseables");
        digester.addCallMethod("export/files", "associateOrgUnitResources");
        xpath = "export/projects/project/";
        this.addProjectRules(digester, xpath);
    }

    public void addXmlPreprocessingDigesterRules(Digester digester) {
        digester.addCallMethod("export/files/file", "increaseTotalFiles");
        digester.addCallMethod("export/info/export_version", "setVersion", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateOrgUnitResources() {
        if (this.m_orgUnitResources == null || this.m_orgUnitResources.isEmpty()) {
            return;
        }
        String site = this.getCms().getRequestContext().getSiteRoot();
        try {
            this.getCms().getRequestContext().setSiteRoot("");
            ArrayList<String> orgUnits = new ArrayList<String>(this.m_orgUnitResources.keySet());
            Collections.sort(orgUnits);
            for (String orgUnitName : orgUnits) {
                List<String> resources = this.m_orgUnitResources.get(orgUnitName);
                if (orgUnitName.equals("")) continue;
                for (String resourceName : resources) {
                    try {
                        OpenCms.getOrgUnitManager().addResourceToOrgUnit(this.getCms(), orgUnitName, resourceName);
                    }
                    catch (CmsException e) {
                        this.getReport().addWarning(e);
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)e.getLocalizedMessage());
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                try {
                    String resName = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.getCms(), CmsOrganizationalUnit.getParentFqn(orgUnitName)).get(0).getRootPath();
                    if (resources.contains(resName)) continue;
                    OpenCms.getOrgUnitManager().removeResourceFromOrgUnit(this.getCms(), orgUnitName, resName);
                }
                catch (CmsException e) {
                    this.getReport().addWarning(e);
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)e.getLocalizedMessage());
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        finally {
            this.getCms().getRequestContext().setSiteRoot(site);
        }
        this.m_orgUnitResources = null;
    }

    public int getAceFlags() {
        return this.m_aceFlags;
    }

    public int getAcePermissionsAllowed() {
        return this.m_acePermissionsAllowed;
    }

    public int getAcePermissionsDenied() {
        return this.m_acePermissionsDenied;
    }

    public CmsUUID getAcePrincipalId() {
        return this.m_acePrincipalId;
    }

    public CmsObject getCms() {
        return this.m_cms;
    }

    public long getDateCreated() {
        return this.m_dateCreated;
    }

    public long getDateExpired() {
        return this.m_dateExpired;
    }

    public long getDateLastModified() {
        return this.m_dateLastModified;
    }

    public long getDateReleased() {
        return this.m_dateReleased;
    }

    public String getDestination() {
        return this.m_destination;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public String getGroupDescription() {
        return this.m_groupDescription;
    }

    public int getGroupFlags() {
        return this.m_groupFlags;
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public String getGroupParent() {
        return this.m_groupParent;
    }

    public String getOrgUnitDescription() {
        return this.m_orgUnitDescription;
    }

    public int getOrgUnitFlags() {
        return this.m_orgUnitFlags;
    }

    public String getOrgUnitName() {
        return this.m_orgUnitName;
    }

    public String getProjectDescription() {
        return this.m_projectDescription;
    }

    public String getProjectManagers() {
        return this.m_projectManagers;
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public String getProjectUsers() {
        return this.m_projectUsers;
    }

    public String getPropertyName() {
        return this.m_propertyName;
    }

    public String getPropertyValue() {
        return this.m_propertyValue;
    }

    public CmsUUID getRelationId() {
        return this.m_relationId;
    }

    public String getRelationPath() {
        return this.m_relationPath;
    }

    public CmsRelationType getRelationType() {
        return this.m_relationType;
    }

    public I_CmsReport getReport() {
        return this.m_report;
    }

    public CmsUUID getResourceId() {
        return this.m_resourceId;
    }

    public String getSource() {
        return this.m_source;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public Throwable getThrowable() {
        return this.m_throwable;
    }

    public I_CmsResourceType getType() {
        return this.m_type;
    }

    public CmsUUID getUserCreated() {
        return this.m_userCreated;
    }

    public long getUserDateCreated() {
        return this.m_userDateCreated;
    }

    public String getUserEmail() {
        return this.m_userEmail;
    }

    public String getUserFirstname() {
        return this.m_userFirstname;
    }

    public int getUserFlags() {
        return this.m_userFlags;
    }

    public CmsUUID getUserLastModified() {
        return this.m_userLastModified;
    }

    public String getUserLastname() {
        return this.m_userLastname;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getUserPassword() {
        return this.m_userPassword;
    }

    @Override
    public int getVersion() {
        return 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAccessControlEntries() {
        if (this.m_resource == null || !this.m_importACEs) {
            return;
        }
        if (this.m_aces == null || this.m_aces.size() == 0) {
            return;
        }
        try {
            this.getCms().importAccessControlEntries(this.m_resource, this.m_aces);
        }
        catch (CmsException exc) {
            this.getReport().println(Messages.get().container("RPT_IMPORT_ACL_DATA_FAILED_0"), 1);
        }
        finally {
            this.m_aces = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importData(CmsObject cms, I_CmsReport report, CmsImportParameters parameters) {
        this.m_cms = cms;
        this.m_report = report;
        this.m_parameters = parameters;
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.setValidating(this.m_parameters.isXmlValidation());
        digester.setEntityResolver((EntityResolver)new CmsXmlEntityResolver(null));
        digester.setRuleNamespaceURI(null);
        digester.setErrorHandler((ErrorHandler)new CmsXmlErrorHandler("manifest.xml"));
        digester.push((Object)this);
        this.addXmlDigesterRules(digester);
        InputStream stream = null;
        this.m_helper = new CmsImportHelper(this.m_parameters);
        try {
            this.m_helper.openFile();
            this.m_helper.cacheDtdSystemId(DTD_LOCATION, DTD_FILENAME, "http://www.opencms.org/dtd/6.0/");
            this.findContentFiles();
            stream = this.m_helper.getFileStream("manifest.xml");
            digester.parse(stream);
        }
        catch (Exception ioe) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_IMPORTEXPORT_ERROR_READING_FILE_1", "manifest.xml"), (Throwable)ioe);
            }
            this.getReport().println(ioe);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {}
            this.m_helper.closeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importGroup() {
        if (this.m_orgUnit == null) {
            return;
        }
        if (this.m_groupDescription == null) {
            this.m_groupDescription = "";
        }
        if (this.m_groupParents == null) {
            this.m_groupParents = new HashMap<String, List<String>>();
        }
        String groupName = this.m_orgUnit.getName() + this.m_groupName;
        try {
            if (this.m_throwable != null) {
                this.getReport().println(this.m_throwable);
                CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_GROUP_1", groupName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), this.m_throwable);
                }
                this.m_throwable = null;
                return;
            }
            this.getReport().print(Messages.get().container("RPT_IMPORT_GROUP_0"), 3);
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", groupName));
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            try {
                this.getCms().readGroup(groupName);
                this.getReport().println(Messages.get().container("RPT_NOT_CREATED_0"), 4);
            }
            catch (CmsDbEntryNotFoundException e) {
                CmsUUID parentGroupId = null;
                if (CmsStringUtil.isNotEmpty(this.m_groupParent)) {
                    try {
                        parentGroupId = this.getCms().readGroup(this.m_groupParent).getId();
                    }
                    catch (CmsDbEntryNotFoundException exc) {
                        List<String> childs = this.m_groupParents.get(this.m_groupParent);
                        if (childs == null) {
                            childs = new ArrayList<String>();
                            this.m_groupParents.put(this.m_groupParent, childs);
                        }
                        childs.add(groupName);
                    }
                }
                this.getCms().createGroup(groupName, this.m_groupDescription, this.m_groupFlags, parentGroupId == null ? null : this.m_groupParent);
                this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                List<String> childs = this.m_groupParents.remove(groupName);
                if (childs != null) {
                    for (String childGroup : childs) {
                        this.getCms().setParentGroup(childGroup, groupName);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getReport().println(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_GROUP_1", groupName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
        }
        finally {
            this.m_groupDescription = null;
            this.m_groupFlags = 0;
            this.m_groupName = null;
            this.m_groupParent = null;
            this.m_throwable = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importOrgUnit() {
        try {
            if (this.m_throwable != null) {
                this.getReport().println(this.m_throwable);
                this.getReport().addError(this.m_throwable);
                CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_ORGUNITS_0");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), this.m_throwable);
                }
                this.m_throwable = null;
                this.m_orgUnit = null;
                return;
            }
            this.getReport().print(Messages.get().container("RPT_IMPORT_ORGUNIT_0"), 3);
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.m_orgUnitName));
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            try {
                this.m_orgUnit = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.m_orgUnitName);
                this.getReport().println(Messages.get().container("RPT_NOT_CREATED_0"), 4);
                this.m_orgUnitResources.remove(this.m_orgUnitName);
                return;
            }
            catch (CmsDataAccessException e) {
                try {
                    ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
                    String site = this.getCms().getRequestContext().getSiteRoot();
                    try {
                        this.getCms().getRequestContext().setSiteRoot("");
                        boolean remove = true;
                        List ouResources = CmsCollectionsGenericWrapper.list(this.m_orgUnitResources.get(this.m_orgUnitName));
                        if (ouResources != null) {
                            Iterator itResNames = ouResources.iterator();
                            while (itResNames.hasNext()) {
                                String resName = (String)itResNames.next();
                                try {
                                    resources.add(this.getCms().readResource(resName, CmsResourceFilter.ALL));
                                    itResNames.remove();
                                }
                                catch (CmsVfsResourceNotFoundException e2) {
                                    remove = false;
                                }
                            }
                        }
                        if (remove) {
                            this.m_orgUnitResources.remove(this.m_orgUnitName);
                        }
                    }
                    finally {
                        this.getCms().getRequestContext().setSiteRoot(site);
                    }
                    if (resources.isEmpty()) {
                        resources.add(OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.getCms(), CmsOrganizationalUnit.getParentFqn(this.m_orgUnitName)).get(0));
                    }
                    this.m_orgUnit = OpenCms.getOrgUnitManager().createOrganizationalUnit(this.getCms(), this.m_orgUnitName, this.m_orgUnitDescription, this.m_orgUnitFlags, ((CmsResource)resources.get(0)).getRootPath());
                    for (int i = 1; i < resources.size(); ++i) {
                        OpenCms.getOrgUnitManager().addResourceToOrgUnit(this.getCms(), this.m_orgUnitName, ((CmsResource)resources.get(i)).getRootPath());
                    }
                    this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    this.m_orgUnitName = null;
                    this.m_orgUnitDescription = null;
                    this.m_orgUnitFlags = 0;
                }
                catch (CmsException e3) {
                    this.getReport().println(e3);
                    this.getReport().addError(e3);
                    CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_ORGUNITS_0");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)message.key(), (Throwable)e3);
                    }
                    this.m_throwable = null;
                    this.m_orgUnit = null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.m_orgUnitName = null;
            this.m_orgUnitDescription = null;
            this.m_orgUnitFlags = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importProject() {
        try {
            if (this.m_throwable != null) {
                this.getReport().println(this.m_throwable);
                this.getReport().addError(this.m_throwable);
                CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_PROJECTS_0");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), this.m_throwable);
                }
                this.m_throwable = null;
                return;
            }
            this.getReport().print(Messages.get().container("RPT_IMPORT_PROJECT_0"), 3);
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.m_projectName));
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            try {
                this.getCms().readProject(this.m_projectName);
                this.getReport().println(Messages.get().container("RPT_NOT_CREATED_0"), 4);
                return;
            }
            catch (CmsDataAccessException e) {
                try {
                    CmsProject project = this.getCms().createProject(this.m_projectName, this.m_projectDescription, this.m_projectUsers, this.m_projectManagers, CmsProject.PROJECT_TYPE_NORMAL);
                    if (this.m_projectResources != null) {
                        String site = this.getCms().getRequestContext().getSiteRoot();
                        CmsProject currentProject = this.getCms().getRequestContext().getCurrentProject();
                        try {
                            this.getCms().getRequestContext().setSiteRoot("");
                            this.getCms().getRequestContext().setCurrentProject(project);
                            for (String resName : this.m_projectResources) {
                                try {
                                    this.getCms().copyResourceToProject(resName);
                                }
                                catch (CmsVfsResourceNotFoundException e2) {}
                            }
                        }
                        finally {
                            this.getCms().getRequestContext().setSiteRoot(site);
                            this.getCms().getRequestContext().setCurrentProject(currentProject);
                        }
                    }
                    this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    this.m_projectName = null;
                    this.m_projectDescription = null;
                    this.m_projectManagers = null;
                    this.m_projectUsers = null;
                    this.m_projectResources = null;
                }
                catch (CmsException e3) {
                    this.getReport().println(e3);
                    this.getReport().addError(e3);
                    CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_PROJECTS_0");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)message.key(), (Throwable)e3);
                    }
                    this.m_throwable = null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.m_projectName = null;
            this.m_projectDescription = null;
            this.m_projectManagers = null;
            this.m_projectUsers = null;
            this.m_projectResources = null;
        }
    }

    public void importRelations() {
        if (this.m_relations == null || this.m_relations.isEmpty()) {
            return;
        }
        this.getReport().println(Messages.get().container("RPT_START_IMPORT_RELATIONS_0"), 2);
        int i = 0;
        for (Map.Entry<String, List<CmsRelation>> entry : this.m_relations.entrySet()) {
            String resourcePath = entry.getKey();
            List<CmsRelation> relations = entry.getValue();
            if (this.checkImmutable(resourcePath)) continue;
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(i + 1), String.valueOf(this.m_relations.size())), 3);
            this.getReport().print(Messages.get().container("RPT_IMPORTING_RELATIONS_FOR_2", resourcePath, new Integer(relations.size())), 3);
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            boolean withErrors = false;
            for (CmsRelation relation : relations) {
                try {
                    this.getCms().importRelation(this.getCms().getSitePath(relation.getSource(this.getCms(), CmsResourceFilter.ALL)), this.getCms().getSitePath(relation.getTarget(this.getCms(), CmsResourceFilter.ALL)), relation.getType().getName());
                }
                catch (CmsException e) {
                    this.getReport().addWarning(e);
                    withErrors = true;
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)e.getLocalizedMessage());
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (!withErrors) {
                this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            } else {
                this.getReport().println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
            }
            ++i;
        }
        this.getReport().println(Messages.get().container("RPT_END_IMPORT_RELATIONS_0"), 2);
        this.m_relations = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importResource() {
        boolean resourceIdWasNull = false;
        try {
            if (this.m_throwable != null) {
                this.getReport().println(this.m_throwable);
                this.getReport().addError(this.m_throwable);
                CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCES_0");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), this.m_throwable);
                }
                this.m_throwable = null;
                this.m_importACEs = false;
                this.m_resource = null;
                return;
            }
            String translatedName = this.getCms().getRequestContext().addSiteRoot(this.m_parameters.getDestinationPath() + this.m_destination);
            boolean resourceImmutable = this.checkImmutable(translatedName);
            translatedName = this.getCms().getRequestContext().removeSiteRoot(translatedName);
            if (!resourceImmutable) {
                this.getReport().print(Messages.get().container("RPT_IMPORTING_0"), 3);
                this.getReport().print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                boolean exists = this.getCms().existsResource(translatedName, CmsResourceFilter.ALL);
                byte[] content = null;
                if (this.m_source != null) {
                    content = this.m_helper.getFileBytes(this.m_source);
                }
                int size = 0;
                if (content != null) {
                    size = content.length;
                }
                if (this.m_structureId == null) {
                    this.m_structureId = new CmsUUID();
                }
                if (this.m_resourceId == null || this.m_type.isFolder()) {
                    this.m_resourceId = new CmsUUID();
                    resourceIdWasNull = true;
                }
                CmsResource resource = new CmsResource(this.m_structureId, this.m_resourceId, translatedName, this.m_type.getTypeId(), this.m_type.isFolder(), this.m_flags, this.getCms().getRequestContext().getCurrentProject().getUuid(), CmsResource.STATE_NEW, this.m_dateCreated, this.m_userCreated, this.m_dateLastModified, this.m_userLastModified, this.m_dateReleased, this.m_dateExpired, 1, size, System.currentTimeMillis(), 0);
                if (this.m_properties == null) {
                    this.m_properties = new HashMap<String, CmsProperty>();
                }
                if (this.m_type.isFolder() || resourceIdWasNull || this.hasContentInVfsOrImport(resource)) {
                    this.m_resource = this.getCms().importResource(translatedName, resource, content, new ArrayList<CmsProperty>(this.m_properties.values()));
                }
                boolean bl = this.m_importACEs = this.m_resource != null && (!exists || !this.m_parameters.isKeepPermissions());
                if (this.m_resource != null) {
                    this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    if (OpenCms.getResourceManager().getResourceType(this.m_resource.getTypeId()) instanceof I_CmsLinkParseable) {
                        this.m_parseables.add(this.m_resource);
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)Messages.get().getBundle().key("LOG_IMPORTING_4", new Object[]{String.valueOf(this.m_fileCounter), String.valueOf(this.m_totalFiles), translatedName, this.m_destination}));
                    }
                } else {
                    this.getReport().print(Messages.get().container("RPT_SKIPPING_0"), 3);
                    this.getReport().println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)Messages.get().getBundle().key("LOG_SKIPPING_3", String.valueOf(this.m_fileCounter), String.valueOf(this.m_totalFiles), translatedName));
                    }
                }
            } else {
                this.m_resource = null;
                this.getReport().print(Messages.get().container("RPT_SKIPPING_0"), 3);
                this.getReport().println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_SKIPPING_3", String.valueOf(this.m_fileCounter), String.valueOf(this.m_totalFiles), translatedName));
                }
                this.m_importACEs = false;
            }
        }
        catch (Exception e) {
            this.m_resource = null;
            this.m_importACEs = false;
            this.getReport().println(e);
            this.getReport().addError(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCES_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            return;
        }
        finally {
            this.m_structureId = null;
            this.m_resourceId = null;
            this.m_destination = null;
            this.m_source = null;
            this.m_type = null;
            this.m_flags = 0;
            this.m_dateCreated = 0L;
            this.m_dateLastModified = 0L;
            this.m_dateReleased = 0L;
            this.m_dateExpired = Long.MAX_VALUE;
            this.m_properties = null;
            this.m_throwable = null;
            this.m_aces = null;
            this.m_properties = null;
        }
    }

    @Override
    @Deprecated
    public void importResources(CmsObject cms, String importPath, I_CmsReport report, File importResource, ZipFile importZip, Document docXml) {
        CmsImportParameters params = new CmsImportParameters(importResource.getAbsolutePath(), importPath, true);
        this.importData(cms, report, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importUser() {
        String userName = this.m_orgUnit.getName() + this.m_userName;
        try {
            if (this.m_throwable != null) {
                this.m_user = null;
                this.getReport().println(this.m_throwable);
                CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_USER_1", userName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), this.m_throwable);
                }
                this.m_throwable = null;
                return;
            }
            this.getReport().print(Messages.get().container("RPT_IMPORT_USER_0"), 3);
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", userName));
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            try {
                this.getCms().readUser(userName);
                this.getReport().println(Messages.get().container("RPT_NOT_CREATED_0"), 4);
                this.m_user = null;
                return;
            }
            catch (CmsDbEntryNotFoundException e) {
                try {
                    CmsParameterConfiguration config = OpenCms.getPasswordHandler().getConfiguration();
                    if (config != null && config.containsKey("compatibility.convert.digestencoding") && config.getBoolean("compatibility.convert.digestencoding", false)) {
                        this.m_userPassword = this.convertDigestEncoding(this.m_userPassword);
                    }
                    this.m_user = this.getCms().importUser(new CmsUUID().toString(), userName, this.m_userPassword, this.m_userFirstname, this.m_userLastname, this.m_userEmail, this.m_userFlags, this.m_userDateCreated, this.m_userInfos);
                    this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    this.m_userName = null;
                    this.m_userPassword = null;
                    this.m_userFirstname = null;
                    this.m_userLastname = null;
                    this.m_userEmail = null;
                    this.m_userFlags = 0;
                    this.m_userDateCreated = 0L;
                    this.m_userInfos = null;
                }
                catch (Throwable e2) {
                    this.m_user = null;
                    this.getReport().println(e2);
                    CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_USER_1", userName);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)message.key(), e2);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.m_userName = null;
            this.m_userPassword = null;
            this.m_userFirstname = null;
            this.m_userLastname = null;
            this.m_userEmail = null;
            this.m_userFlags = 0;
            this.m_userDateCreated = 0L;
            this.m_userInfos = null;
        }
    }

    public void importUserGroup(String groupName) {
        block7: {
            if (this.m_throwable != null || this.m_user == null) {
                return;
            }
            groupName = OpenCms.getImportExportManager().translateGroup(groupName);
            try {
                String ouName = CmsOrganizationalUnit.getParentFqn(groupName);
                try {
                    OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), ouName);
                    this.getCms().addUserToGroup(this.m_user.getName(), groupName);
                    return;
                }
                catch (CmsDbEntryNotFoundException e) {
                    Map<String, String> groups;
                    Map<String, Map<String, String>> membership = this.m_membership.get(ouName);
                    if (membership == null) {
                        membership = new HashMap<String, Map<String, String>>();
                        this.m_membership.put(ouName, membership);
                    }
                    if ((groups = membership.get("GROUP")) == null) {
                        groups = new HashMap<String, String>();
                        membership.put("GROUP", groups);
                    }
                    groups.put(this.m_user.getName(), groupName);
                }
            }
            catch (Throwable e) {
                this.getReport().println(Messages.get().container("RPT_USER_COULDNT_BE_ADDED_TO_GROUP_2", this.m_user.getName(), groupName), 1);
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)e.getLocalizedMessage(), e);
            }
        }
    }

    public void importUserInfo(String infoName, String infoType, String infoValue) {
        block3: {
            if (this.m_userInfos == null) {
                this.m_userInfos = new HashMap<String, Object>();
            }
            try {
                this.m_userInfos.put(infoName, CmsDataTypeUtil.dataImport(infoValue, infoType));
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e.getLocalizedMessage(), e);
            }
        }
    }

    public void importUserRole(String roleName) {
        block7: {
            if (this.m_throwable != null || this.m_user == null) {
                return;
            }
            try {
                CmsRole role = CmsRole.valueOfRoleName(roleName);
                try {
                    OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), role.getOuFqn());
                    OpenCms.getRoleManager().addUserToRole(this.getCms(), role, this.m_user.getName());
                    return;
                }
                catch (CmsDbEntryNotFoundException e) {
                    Map<String, String> roles;
                    Map<String, Map<String, String>> membership = this.m_membership.get(role.getOuFqn());
                    if (membership == null) {
                        membership = new HashMap<String, Map<String, String>>();
                        this.m_membership.put(role.getOuFqn(), membership);
                    }
                    if ((roles = membership.get("USER")) == null) {
                        roles = new HashMap<String, String>();
                        membership.put("USER", roles);
                    }
                    roles.put(this.m_user.getName(), role.getFqn());
                }
            }
            catch (Throwable e) {
                this.getReport().println(Messages.get().container("RPT_USER_COULDNT_BE_ADDED_TO_ROLE_2", this.m_user.getName(), roleName), 1);
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)e.getLocalizedMessage(), e);
            }
        }
    }

    public void increaseCounter() {
        ++this.m_fileCounter;
    }

    public void increaseTotalFiles() {
        ++this.m_totalFiles;
    }

    @Override
    public boolean matches(CmsImportParameters parameters) throws CmsImportExportException {
        this.m_fileCounter = 1;
        this.m_totalFiles = 0;
        this.m_parseables = new ArrayList<CmsResource>();
        this.m_parameters = parameters;
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.setValidating(this.m_parameters.isXmlValidation());
        digester.setEntityResolver((EntityResolver)new CmsXmlEntityResolver(null));
        digester.setRuleNamespaceURI(null);
        digester.setErrorHandler((ErrorHandler)new CmsXmlErrorHandler("manifest.xml"));
        digester.push((Object)this);
        this.addXmlPreprocessingDigesterRules(digester);
        InputStream stream = null;
        this.m_helper = new CmsImportHelper(this.m_parameters);
        this.m_helper.cacheDtdSystemId(DTD_LOCATION, DTD_FILENAME, "http://www.opencms.org/dtd/6.0/");
        try {
            this.m_helper.openFile();
            stream = this.m_helper.getFileStream("manifest.xml");
            digester.parse(stream);
        }
        catch (Exception ioe) {
            CmsMessageContainer msg = Messages.get().container("ERR_IMPORTEXPORT_ERROR_READING_FILE_1", "manifest.xml");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg.key(), (Throwable)ioe);
            }
            throw new CmsImportExportException(msg, (Throwable)ioe);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {}
            this.m_helper.closeFile();
        }
        return this.m_version == this.getVersion();
    }

    public void rewriteParseables() {
        if (this.m_parseables.isEmpty()) {
            return;
        }
        I_CmsReport report = this.getReport();
        CmsObject cms = this.getCms();
        cms.getRequestContext().setAttribute("ATTR_LOG_ENTRY", Boolean.FALSE);
        report.println(Messages.get().container("RPT_START_PARSE_LINKS_0"), 2);
        this.parseLinks(cms, report);
        report.println(Messages.get().container("RPT_END_PARSE_LINKS_0"), 2);
        this.m_parseables = null;
    }

    public void setAceFlags(String aceFlags) {
        try {
            this.m_aceFlags = Integer.parseInt(aceFlags);
        }
        catch (Throwable e) {
            this.m_throwable = e;
        }
    }

    public void setAcePermissionsAllowed(String acePermissionsAllowed) {
        try {
            this.m_acePermissionsAllowed = Integer.parseInt(acePermissionsAllowed);
        }
        catch (Throwable e) {
            this.m_throwable = e;
        }
    }

    public void setAcePermissionsDenied(String acePermissionsDenied) {
        try {
            this.m_acePermissionsDenied = Integer.parseInt(acePermissionsDenied);
        }
        catch (Throwable e) {
            this.m_throwable = e;
        }
    }

    public void setAcePrincipalId(String acePrincipalId) {
        try {
            CmsUUID principalId = null;
            String principal = acePrincipalId.substring(acePrincipalId.indexOf(46) + 1, acePrincipalId.length());
            if (acePrincipalId.startsWith("GROUP")) {
                principal = OpenCms.getImportExportManager().translateGroup(principal);
                principalId = this.getCms().readGroup(principal).getId();
            } else if (acePrincipalId.startsWith("USER")) {
                principal = OpenCms.getImportExportManager().translateUser(principal);
                principalId = this.getCms().readUser(principal).getId();
            } else if (acePrincipalId.startsWith("ROLE")) {
                principalId = CmsRole.valueOfRoleName(principal).getId();
            } else if (acePrincipalId.equalsIgnoreCase("ALL_OTHERS")) {
                principalId = CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID;
            } else if (acePrincipalId.equalsIgnoreCase("OVERWRITE_ALL")) {
                principalId = CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID;
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ERROR_IMPORTING_ACE_1", acePrincipalId));
                }
                throw new CmsIllegalStateException(Messages.get().container("LOG_IMPORTEXPORT_ERROR_IMPORTING_ACE_1", acePrincipalId));
            }
            this.m_acePrincipalId = principalId;
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setDateCreated(String dateCreated) {
        try {
            this.m_dateCreated = dateCreated != null ? this.convertTimestamp(dateCreated) : System.currentTimeMillis();
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setDateExpired(String dateExpired) {
        try {
            this.m_dateExpired = dateExpired != null ? this.convertTimestamp(dateExpired) : Long.MAX_VALUE;
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setDateLastModified(String dateLastModified) {
        try {
            this.m_dateLastModified = dateLastModified != null ? this.convertTimestamp(dateLastModified) : System.currentTimeMillis();
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setDateReleased(String dateReleased) {
        try {
            this.m_dateReleased = dateReleased != null ? this.convertTimestamp(dateReleased) : 0L;
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setDestination(String destination) {
        this.m_destination = destination;
    }

    public void setFlags(String flags) {
        try {
            this.m_flags = Integer.parseInt(flags);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setGroupDescription(String groupDescription) {
        this.m_groupDescription = groupDescription;
    }

    public void setGroupFlags(String groupFlags) {
        try {
            this.m_groupFlags = Integer.parseInt(groupFlags);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setGroupName(String groupName) {
        this.m_groupName = OpenCms.getImportExportManager().translateGroup(groupName);
    }

    public void setGroupParent(String groupParent) {
        this.m_groupParent = OpenCms.getImportExportManager().translateGroup(groupParent);
    }

    public void setMembership() {
        Map<String, String> roles;
        if (this.m_orgUnit == null || this.m_membership == null) {
            return;
        }
        Map<String, Map<String, String>> membership = this.m_membership.get(this.m_orgUnit.getName());
        if (membership == null) {
            return;
        }
        Map<String, String> groups = membership.get("GROUP");
        if (groups != null) {
            for (Map.Entry<String, String> entry : groups.entrySet()) {
                String userName = entry.getKey();
                String groupName = entry.getValue();
                try {
                    this.getCms().addUserToGroup(userName, groupName);
                }
                catch (Throwable e) {
                    this.getReport().println(Messages.get().container("RPT_USER_COULDNT_BE_ADDED_TO_GROUP_2", userName, groupName), 1);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), e);
                }
            }
        }
        if ((roles = membership.get("USER")) != null) {
            for (Map.Entry<String, String> entry : roles.entrySet()) {
                String userName = entry.getKey();
                String roleName = entry.getValue();
                CmsRole role = CmsRole.valueOfRoleName(roleName);
                try {
                    OpenCms.getRoleManager().addUserToRole(this.getCms(), role, userName);
                    return;
                }
                catch (Throwable e) {
                    this.getReport().println(Messages.get().container("RPT_USER_COULDNT_BE_ADDED_TO_ROLE_2", userName, roleName), 1);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public void setOrgUnitDescription(String orgUnitDescription) {
        this.m_orgUnitDescription = orgUnitDescription;
    }

    public void setOrgUnitFlags(String orgUnitFlags) {
        try {
            this.m_orgUnitFlags = Integer.parseInt(orgUnitFlags);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setOrgUnitName(String orgUnitName) {
        this.m_orgUnitName = orgUnitName;
    }

    public void setProjectDescription(String projectDescription) {
        this.m_projectDescription = projectDescription;
    }

    public void setProjectManagers(String projectManagers) {
        this.m_projectManagers = projectManagers;
    }

    public void setProjectName(String projectName) {
        this.m_projectName = projectName;
    }

    public void setProjectUsers(String projectUsers) {
        this.m_projectUsers = projectUsers;
    }

    public void setPropertyName(String propertyName) {
        this.m_propertyName = propertyName;
    }

    public void setPropertyValue(String propertyValue) {
        this.m_propertyValue = propertyValue;
    }

    public void setRelationId(String relationId) {
        try {
            this.m_relationId = new CmsUUID(relationId);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setRelationPath(String relationPath) {
        this.m_relationPath = relationPath;
    }

    public void setRelationType(String relationType) {
        try {
            this.m_relationType = CmsRelationType.valueOf(relationType);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setResourceId(String resourceId) {
        try {
            this.m_resourceId = !this.m_type.isFolder() ? new CmsUUID(resourceId) : new CmsUUID();
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setSource(String source) {
        this.m_source = source;
    }

    public void setStructureId(String structureId) {
        try {
            this.m_structureId = new CmsUUID(structureId);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setThrowable(Throwable throwable) {
        this.m_throwable = throwable;
    }

    public void setType(String typeName) {
        try {
            try {
                this.m_type = OpenCms.getResourceManager().getResourceType(typeName);
            }
            catch (CmsLoaderException e) {
                int plainId;
                try {
                    plainId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()).getTypeId();
                }
                catch (CmsLoaderException e1) {
                    plainId = CmsResourceTypePlain.getStaticTypeId();
                }
                this.m_type = OpenCms.getResourceManager().getResourceType(plainId);
            }
            if (this.m_type.isFolder() && !CmsResource.isFolder(this.m_destination)) {
                this.m_destination = this.m_destination + "/";
            }
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setUserCreated(CmsUUID userCreated) {
        this.m_userCreated = userCreated;
    }

    public void setUserCreated(String userCreated) {
        try {
            String userCreatedName = OpenCms.getImportExportManager().translateUser(userCreated);
            try {
                this.m_userCreated = this.getCms().readUser(userCreatedName).getId();
            }
            catch (CmsDbEntryNotFoundException e) {
                this.m_userCreated = this.getCms().getRequestContext().getCurrentUser().getId();
            }
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setUserDateCreated(String userDateCreated) {
        try {
            this.m_userDateCreated = this.convertTimestamp(userDateCreated);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setUserEmail(String userEmail) {
        this.m_userEmail = userEmail;
    }

    public void setUserFirstname(String userFirstname) {
        this.m_userFirstname = userFirstname;
    }

    public void setUserFlags(String userFlags) {
        try {
            this.m_userFlags = Integer.parseInt(userFlags);
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setUserLastModified(CmsUUID userLastModified) {
        this.m_userLastModified = userLastModified;
    }

    public void setUserLastModified(String userLastModified) {
        try {
            String userLastModifiedName = OpenCms.getImportExportManager().translateUser(userLastModified);
            try {
                this.m_userLastModified = this.getCms().readUser(userLastModifiedName).getId();
            }
            catch (CmsDbEntryNotFoundException e) {
                this.m_userLastModified = this.getCms().getRequestContext().getCurrentUser().getId();
            }
        }
        catch (Throwable e) {
            this.setThrowable(e);
        }
    }

    public void setUserLastname(String userLastname) {
        this.m_userLastname = userLastname;
    }

    public void setUserName(String userName) {
        this.m_userName = OpenCms.getImportExportManager().translateUser(userName);
    }

    public void setUserPassword(String userPassword) {
        this.m_userPassword = new String(Base64.decodeBase64((byte[])userPassword.trim().getBytes()));
    }

    public void setVersion(String version) {
        this.m_version = Integer.parseInt(version);
    }

    protected void addAccountsGroupRules(Digester digester, String xpath) {
        String xp_group = xpath + N_GROUPS + "/" + N_GROUP;
        digester.addCallMethod(xp_group, "importGroup");
        xp_group = xp_group + "/";
        digester.addCallMethod(xp_group + "name", "setGroupName", 0);
        digester.addCallMethod(xp_group + N_DESCRIPTION, "setGroupDescription", 0);
        digester.addCallMethod(xp_group + N_FLAGS, "setGroupFlags", 0);
        digester.addCallMethod(xp_group + N_PARENTGROUP, "setGroupParent", 0);
    }

    protected void addAccountsOrgunitRules(Digester digester, String xpath) {
        digester.addCallMethod(xpath + "name", "setOrgUnitName", 0);
        digester.addCallMethod(xpath + N_DESCRIPTION, "setOrgUnitDescription", 0);
        digester.addCallMethod(xpath + N_FLAGS, "setOrgUnitFlags", 0);
        digester.addCallMethod(xpath + N_RESOURCES + "/" + N_RESOURCE, "addOrgUnitResource", 0);
        digester.addCallMethod(xpath + N_RESOURCES, "importOrgUnit");
    }

    protected void addAccountsUserRules(Digester digester, String xpath) {
        String xp_user = xpath + N_USERS + "/" + N_USER + "/";
        digester.addCallMethod(xp_user + "name", "setUserName", 0);
        digester.addCallMethod(xp_user + N_PASSWORD, "setUserPassword", 0);
        digester.addCallMethod(xp_user + N_FIRSTNAME, "setUserFirstname", 0);
        digester.addCallMethod(xp_user + N_LASTNAME, "setUserLastname", 0);
        digester.addCallMethod(xp_user + N_EMAIL, "setUserEmail", 0);
        digester.addCallMethod(xp_user + N_FLAGS, "setUserFlags", 0);
        digester.addCallMethod(xp_user + N_DATECREATED, "setUserDateCreated", 0);
        digester.addCallMethod(xp_user + N_USERINFO, "importUser");
        String xp_info = xp_user + N_USERINFO + "/" + N_USERINFO_ENTRY;
        digester.addCallMethod(xp_info, "importUserInfo", 3);
        digester.addCallParam(xp_info, 0, "name");
        digester.addCallParam(xp_info, 1, "type");
        digester.addCallParam(xp_info, 2);
        digester.addCallMethod(xp_user + N_USERROLES + "/" + N_USERROLE, "importUserRole", 0);
        digester.addCallMethod(xp_user + N_USERGROUPS + "/" + N_USERGROUP, "importUserGroup", 0);
    }

    protected void addProjectRules(Digester digester, String xpath) {
        digester.addCallMethod(xpath + "name", "setProjectName", 0);
        digester.addCallMethod(xpath + N_DESCRIPTION, "setProjectDescription", 0);
        digester.addCallMethod(xpath + N_MANAGERSGROUP, "setProjectManagers", 0);
        digester.addCallMethod(xpath + N_USERSGROUP, "setProjectUsers", 0);
        digester.addCallMethod(xpath + N_RESOURCES + "/" + N_RESOURCE, "addProjectResource", 0);
        digester.addCallMethod(xpath + N_RESOURCES, "importProject");
    }

    protected void addResourceAceRules(Digester digester, String xpath) {
        String xp_ace = xpath + N_ACCESSCONTROL_ENTRIES + "/" + N_ACCESSCONTROL_ENTRY;
        digester.addCallMethod(xpath + N_ACCESSCONTROL_ENTRIES, "importAccessControlEntries");
        digester.addCallMethod(xp_ace, "addAccessControlEntry");
        digester.addCallMethod(xp_ace + "/" + N_ACCESSCONTROL_PRINCIPAL, "setAcePrincipalId", 0);
        digester.addCallMethod(xp_ace + "/" + N_FLAGS, "setAceFlags", 0);
        String xp_perms = xp_ace + "/" + N_ACCESSCONTROL_PERMISSIONSET + "/";
        digester.addCallMethod(xp_perms + N_ACCESSCONTROL_ALLOWEDPERMISSIONS, "setAcePermissionsAllowed", 0);
        digester.addCallMethod(xp_perms + N_ACCESSCONTROL_DENIEDPERMISSIONS, "setAcePermissionsDenied", 0);
    }

    protected void addResourceAttributesRules(Digester digester, String xpath) {
        digester.addCallMethod(xpath + N_SOURCE, "setSource", 0);
        digester.addCallMethod(xpath + N_DESTINATION, "setDestination", 0);
        digester.addCallMethod(xpath + "type", "setType", 0);
        digester.addCallMethod(xpath + N_UUIDSTRUCTURE, "setStructureId", 0);
        digester.addCallMethod(xpath + N_UUIDRESOURCE, "setResourceId", 0);
        digester.addCallMethod(xpath + N_DATELASTMODIFIED, "setDateLastModified", 0);
        digester.addCallMethod(xpath + N_USERLASTMODIFIED, "setUserLastModified", 0);
        digester.addCallMethod(xpath + N_DATECREATED, "setDateCreated", 0);
        digester.addCallMethod(xpath + N_USERCREATED, "setUserCreated", 0);
        digester.addCallMethod(xpath + N_DATERELEASED, "setDateReleased", 0);
        digester.addCallMethod(xpath + N_DATEEXPIRED, "setDateExpired", 0);
        digester.addCallMethod(xpath + N_FLAGS, "setFlags", 0);
    }

    protected void addResourcePropertyRules(Digester digester, String xpath) {
        String xp_props = xpath + N_PROPERTIES + "/" + N_PROPERTY;
        digester.addCallMethod(xp_props, "addProperty");
        digester.addCallMethod(xp_props, "addProperty", 1);
        digester.addCallParam(xp_props, 0, "type");
        digester.addCallMethod(xp_props + "/" + "name", "setPropertyName", 0);
        digester.addCallMethod(xp_props + "/" + N_VALUE, "setPropertyValue", 0);
        digester.addCallMethod(xpath + N_PROPERTIES, "importResource");
    }

    protected void addResourceRelationRules(Digester digester, String xpath) {
        String xp_rels = xpath + N_RELATIONS + "/" + N_RELATION;
        digester.addCallMethod(xp_rels, "addRelation");
        digester.addCallMethod(xp_rels + "/" + N_ID, "setRelationId", 0);
        digester.addCallMethod(xp_rels + "/" + N_PATH, "setRelationPath", 0);
        digester.addCallMethod(xp_rels + "/" + "type", "setRelationType", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkImmutable(String resourceName) {
        boolean resourceImmutable = false;
        if (this.getImmutableResources().contains(resourceName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_RESOURCENAME_IMMUTABLE_1", resourceName));
            }
            String storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
            try {
                this.getCms().getRequestContext().setSiteRoot("/");
                this.getCms().readResource(resourceName);
                resourceImmutable = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_IMMUTABLE_FLAG_SET_1", resourceName));
                }
            }
            catch (CmsException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ERROR_ON_TEST_IMMUTABLE_1", resourceName), (Throwable)e);
                }
            }
            finally {
                this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
        return resourceImmutable;
    }

    protected String convertDigestEncoding(String value) {
        byte[] data = new byte[value.length() / 2];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(Integer.parseInt(value.substring(i * 2, i * 2 + 2), 16) - 128);
        }
        return new String(Base64.encodeBase64((byte[])data));
    }

    protected long convertTimestamp(String timestamp) {
        long value = 0L;
        try {
            value = Long.parseLong(timestamp);
        }
        catch (NumberFormatException e) {
            try {
                value = CmsDateUtil.parseHeaderDate(timestamp);
            }
            catch (ParseException pe) {
                value = System.currentTimeMillis();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findContentFiles() throws CmsImportExportException, IOException, SAXException {
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.setValidating(false);
        digester.setEntityResolver((EntityResolver)new CmsXmlEntityResolver(null));
        digester.setRuleNamespaceURI(null);
        digester.setErrorHandler((ErrorHandler)new CmsXmlErrorHandler("manifest.xml"));
        digester.addCallMethod("export/files/file", "addContentFile", 2);
        digester.addCallParam("export/files/file/source", 0);
        digester.addCallParam("export/files/file/uuidresource", 1);
        this.m_contentFiles.clear();
        digester.push((Object)this);
        InputStream stream = null;
        try {
            stream = this.m_helper.getFileStream("manifest.xml");
            digester.parse(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected CmsImportHelper getHelper() {
        return this.m_helper;
    }

    protected List<String> getIgnoredProperties() {
        if (this.m_ignoredProperties == null) {
            this.m_ignoredProperties = OpenCms.getImportExportManager().getIgnoredProperties();
            if (this.m_ignoredProperties == null) {
                this.m_ignoredProperties = Collections.emptyList();
            }
        }
        return this.m_ignoredProperties;
    }

    protected List<String> getImmutableResources() {
        if (this.m_immutables == null) {
            this.m_immutables = OpenCms.getImportExportManager().getImmutableResources();
            if (this.m_immutables == null) {
                this.m_immutables = Collections.emptyList();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_IMMUTABLE_RESOURCES_SIZE_1", Integer.toString(this.m_immutables.size())));
            }
        }
        return this.m_immutables;
    }

    protected void sortParseableResources(List<CmsResource> parseables) {
        Collections.sort(parseables, new Comparator<CmsResource>(){

            @Override
            public int compare(CmsResource a, CmsResource b) {
                return ComparisonChain.start().compare(this.getRank(a), this.getRank(b)).compare((Comparable)((Object)a.getRootPath()), (Comparable)((Object)b.getRootPath())).result();
            }

            int getRank(CmsResource res) {
                if (CmsResourceTypeXmlContainerPage.isContainerPage(res)) {
                    return 0;
                }
                return 1;
            }
        });
    }

    private boolean hasContentInVfsOrImport(CmsResource resource) {
        if (this.m_contentFiles.contains(resource.getResourceId())) {
            return true;
        }
        try {
            List<CmsResource> resources = this.getCms().readSiblings(resource, CmsResourceFilter.ALL);
            if (!resources.isEmpty()) {
                return true;
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return false;
    }

    private void parseLinks(CmsObject cms, I_CmsReport report) {
        int i = 0;
        this.sortParseableResources(this.m_parseables);
        for (CmsResource parsableRes : this.m_parseables) {
            block7: {
                String resName = cms.getSitePath(parsableRes);
                report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(i + 1), String.valueOf(this.m_parseables.size())), 3);
                LOG.info((Object)("Rewriting parsable resource: " + resName));
                report.print(Messages.get().container("RPT_PARSE_LINKS_FOR_1", resName), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                try {
                    CmsFile file = cms.readFile(resName);
                    file.setDateLastModified(file.getDateLastModified());
                    CmsLock lock = cms.getLock(file);
                    if (lock.isUnlocked()) {
                        cms.lockResource(resName);
                    } else if (!lock.isDirectlyOwnedInProjectBy(cms)) {
                        cms.changeLock(resName);
                    }
                    cms.writeFile(file);
                    report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                }
                catch (Throwable e) {
                    report.addWarning(e);
                    report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_REWRITING_1", resName));
                        LOG.warn((Object)e.getMessage(), e);
                    }
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)e.getLocalizedMessage(), e);
                }
            }
            ++i;
        }
        cms.getRequestContext().removeAttribute("ATTR_LOG_ENTRY");
    }
}

