/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.decorator;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.decorator.CmsDecorationBundle;
import org.opencms.jsp.decorator.CmsDecorationDefintion;
import org.opencms.jsp.decorator.I_CmsDecoratorConfiguration;
import org.opencms.main.CmsException;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsDecoratorConfiguration
implements I_CmsDecoratorConfiguration {
    public static final String XPATH_DECORATION = "decoration";
    public static final String XPATH_EXCLUDE = "exclude";
    public static final String XPATH_USELOCALE = "uselocale";
    private static final String XPATH_FILENAME = "filename";
    private static final String XPATH_MARKFIRST = "markfirst";
    private static final String XPATH_NAME = "name";
    private static final String XPATH_POSTTEXT = "posttext";
    private static final String XPATH_POSTTEXTFIRST = "posttextfirst";
    private static final String XPATH_PRETEXT = "pretext";
    private static final String XPATH_PRETEXTFIRST = "pretextfirst";
    private CmsObject m_cms;
    private String m_configFile = null;
    private Locale m_configurationLocale = CmsLocaleManager.getLocale("en");
    private CmsDecorationBundle m_decorations = new CmsDecorationBundle();
    private List<String> m_excludes;
    private Locale m_locale;
    private List<String> m_usedDecorations;
    private List<CmsDecorationDefintion> m_decorationDefinitions;

    public CmsDecoratorConfiguration() {
        this.m_cms = null;
        this.m_locale = null;
        this.m_usedDecorations = new ArrayList<String>();
        this.m_excludes = new ArrayList<String>();
        this.m_decorationDefinitions = new ArrayList<CmsDecorationDefintion>();
    }

    public CmsDecoratorConfiguration(CmsObject cms) throws CmsException {
        this.m_cms = cms;
        this.m_locale = this.m_cms.getRequestContext().getLocale();
        this.m_usedDecorations = new ArrayList<String>();
        this.m_excludes = new ArrayList<String>();
        this.m_decorationDefinitions = new ArrayList<CmsDecorationDefintion>();
        this.init(cms, null, null);
    }

    public CmsDecoratorConfiguration(CmsObject cms, String configFile) throws CmsException {
        this.m_cms = cms;
        this.m_locale = this.m_cms.getRequestContext().getLocale();
        this.m_usedDecorations = new ArrayList<String>();
        this.m_excludes = new ArrayList<String>();
        this.m_decorationDefinitions = new ArrayList<CmsDecorationDefintion>();
        this.init(cms, configFile, null);
    }

    public CmsDecoratorConfiguration(CmsObject cms, String configFile, Locale locale) throws CmsException {
        this.m_cms = cms;
        this.m_locale = this.m_cms.getRequestContext().getLocale();
        this.m_usedDecorations = new ArrayList<String>();
        this.m_excludes = new ArrayList<String>();
        this.m_decorationDefinitions = new ArrayList<CmsDecorationDefintion>();
        this.init(cms, configFile, locale);
    }

    public void addDecorations(CmsDecorationDefintion decorationDefinition) throws CmsException {
        this.m_decorations.putAll(decorationDefinition.createDecorationBundle(this.m_cms, this.m_configurationLocale).getAll());
    }

    public CmsObject getCms() {
        return this.m_cms;
    }

    public String getConfigFile() {
        return this.m_configFile;
    }

    public Locale getConfigurationLocale() {
        return this.m_configurationLocale;
    }

    @Override
    public CmsDecorationDefintion getDecorationDefinition(CmsXmlContent configuration, int i) {
        CmsDecorationDefintion decDef = new CmsDecorationDefintion();
        String name = configuration.getValue("decoration[" + i + "]/" + XPATH_NAME, this.m_configurationLocale).getStringValue(this.m_cms);
        String markfirst = configuration.getValue("decoration[" + i + "]/" + XPATH_MARKFIRST, this.m_configurationLocale).getStringValue(this.m_cms);
        String pretext = configuration.getValue("decoration[" + i + "]/" + XPATH_PRETEXT, this.m_configurationLocale).getStringValue(this.m_cms);
        String posttext = configuration.getValue("decoration[" + i + "]/" + XPATH_POSTTEXT, this.m_configurationLocale).getStringValue(this.m_cms);
        String pretextfirst = configuration.getValue("decoration[" + i + "]/" + XPATH_PRETEXTFIRST, this.m_configurationLocale).getStringValue(this.m_cms);
        String posttextfirst = configuration.getValue("decoration[" + i + "]/" + XPATH_POSTTEXTFIRST, this.m_configurationLocale).getStringValue(this.m_cms);
        String filenname = configuration.getValue("decoration[" + i + "]/" + XPATH_FILENAME, this.m_configurationLocale).getStringValue(this.m_cms);
        decDef.setName(name);
        decDef.setMarkFirst(markfirst.equals("true"));
        decDef.setPreText(pretext);
        decDef.setPostText(posttext);
        decDef.setPreTextFirst(pretextfirst);
        decDef.setPostTextFirst(posttextfirst);
        decDef.setConfigurationFile(filenname);
        return decDef;
    }

    public List<CmsDecorationDefintion> getDecorationDefinitions() {
        return this.m_decorationDefinitions;
    }

    @Override
    public CmsDecorationBundle getDecorations() {
        return this.m_decorations;
    }

    public List<String> getExcludes() {
        return this.m_excludes;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public List<String> getUsedDecorations() {
        return this.m_usedDecorations;
    }

    @Override
    public boolean hasUsed(String key) {
        return this.m_usedDecorations.contains(key);
    }

    @Override
    public void init(CmsObject cms, String configFile, Locale locale) throws CmsException {
        this.m_cms = cms;
        this.m_locale = cms.getRequestContext().getLocale();
        if (configFile != null) {
            this.m_configFile = configFile;
        }
        if (locale != null) {
            this.m_decorations = new CmsDecorationBundle(locale);
            this.m_locale = locale;
        }
        if (this.m_configFile != null) {
            CmsResource res = this.m_cms.readResource(this.m_configFile);
            CmsFile file = this.m_cms.readFile(res);
            CmsXmlContent configuration = CmsXmlContentFactory.unmarshal(this.m_cms, file);
            String uselocale = configuration.getValue(XPATH_USELOCALE, this.m_configurationLocale).getStringValue(this.m_cms);
            if (!uselocale.equals("true")) {
                this.m_locale = null;
            }
            int decorationDefCount = configuration.getIndexCount(XPATH_DECORATION, this.m_configurationLocale);
            for (int i = 1; i <= decorationDefCount; ++i) {
                CmsDecorationDefintion decDef = this.getDecorationDefinition(configuration, i);
                this.m_decorationDefinitions.add(decDef);
                CmsDecorationBundle decBundle = decDef.createDecorationBundle(this.m_cms, this.m_locale);
                this.m_decorations.putAll(decBundle.getAll());
            }
            int excludeValuesCount = configuration.getIndexCount(XPATH_EXCLUDE, this.m_configurationLocale);
            for (int i = 1; i <= excludeValuesCount; ++i) {
                String excludeValue = configuration.getStringValue(this.m_cms, "exclude[" + i + "]", this.m_configurationLocale);
                this.m_excludes.add(excludeValue.toLowerCase());
            }
        }
    }

    @Override
    public boolean isExcluded(String tag) {
        return this.m_excludes.contains(tag.toLowerCase());
    }

    @Override
    public void markAsUsed(String key) {
        this.m_usedDecorations.add(key);
    }

    @Override
    public void resetMarkedDecorations() {
        this.m_usedDecorations = new ArrayList<String>();
    }

    public void setCms(CmsObject cms) {
        this.m_cms = cms;
    }

    public void setConfigFile(String configFile) {
        this.m_configFile = configFile;
    }

    public void setConfigurationLocale(Locale configurationLocale) {
        this.m_configurationLocale = configurationLocale;
    }

    public void setDecorationDefinitions(List<CmsDecorationDefintion> decorationDefinitions) {
        this.m_decorationDefinitions = decorationDefinitions;
    }

    public void setDecorations(CmsDecorationBundle decorations) {
        this.m_decorations = decorations;
    }

    public void setExcludes(List<String> excludes) {
        this.m_excludes = excludes;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setUsedDecorations(List<String> usedDecorations) {
        this.m_usedDecorations = usedDecorations;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append(" [configFile = '");
        buf.append(this.m_configFile);
        buf.append("', decorations = '");
        buf.append(this.m_decorations);
        buf.append("', locale = '");
        buf.append(this.m_locale);
        buf.append("']");
        return buf.toString();
    }
}

