/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.Locale;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;

public class CmsContextInfo {
    public static final String ATTRIBUTE_REQUEST_TIME = "__org.opencms.main.CmsContextInfo#m_requestTime";
    public static final long CURRENT_TIME = -1L;
    public static final String LOCALHOST = "127.0.0.1";
    private CmsResource m_detailResource;
    private String m_encoding;
    private boolean m_frozen;
    private boolean m_isSecureRequest;
    private Locale m_locale;
    private String m_localeName;
    private String m_ouFqn;
    private CmsProject m_project;
    private String m_projectName;
    private String m_remoteAddr;
    private String m_requestedUri;
    private long m_requestTime;
    private String m_siteRoot;
    private CmsUser m_user;
    private String m_userName;

    public CmsContextInfo() {
        this.setUserName(OpenCms.getDefaultUsers().getUserGuest());
        this.setProjectName("Online");
        this.setRequestedUri("/");
        this.setSiteRoot("/");
        this.setLocaleName(CmsLocaleManager.getDefaultLocale().toString());
        this.setEncoding(OpenCms.getSystemInfo().getDefaultEncoding());
        this.setRemoteAddr(LOCALHOST);
        this.setRequestTime(-1L);
        this.setOuFqn("");
    }

    public CmsContextInfo(CmsRequestContext requestContext) {
        this.setUserName(requestContext.getCurrentUser().getName());
        this.setProjectName(requestContext.getCurrentProject().getName());
        this.setRequestedUri(requestContext.getUri());
        this.setSiteRoot(requestContext.getSiteRoot());
        this.setLocale(requestContext.getLocale());
        this.setEncoding(requestContext.getEncoding());
        this.setRemoteAddr(requestContext.getRemoteAddress());
        this.setRequestTime(requestContext.getRequestTime());
        this.setIsSecureRequest(requestContext.isSecureRequest());
        this.setOuFqn(requestContext.getOuFqn());
        this.setDetailResource(requestContext.getDetailResource());
    }

    public CmsContextInfo(CmsUser user, CmsProject project, String requestedUri, String siteRoot, boolean isSecureRequest, Locale locale, String encoding, String remoteAddr, long requestTime, String ouFqn) {
        this.m_user = user;
        this.setUserName(this.m_user.getName());
        this.m_project = project;
        this.setProjectName(this.m_project.getName());
        this.setRequestedUri(requestedUri);
        this.setSiteRoot(siteRoot);
        this.setIsSecureRequest(isSecureRequest);
        this.setLocale(locale);
        this.setEncoding(encoding);
        this.setRemoteAddr(remoteAddr);
        this.setRequestTime(requestTime);
        this.setOuFqn(ouFqn);
    }

    public CmsContextInfo(String userName) {
        this();
        this.setUserName(userName);
    }

    public Object clone() {
        CmsContextInfo result = new CmsContextInfo();
        result.m_encoding = this.m_encoding;
        result.m_frozen = false;
        result.m_locale = this.m_locale;
        result.m_localeName = this.m_localeName;
        result.m_project = this.m_project;
        result.m_projectName = this.m_projectName;
        result.m_isSecureRequest = this.m_isSecureRequest;
        result.m_remoteAddr = this.m_remoteAddr;
        result.m_requestedUri = this.m_requestedUri;
        result.m_requestTime = this.m_requestTime;
        result.m_siteRoot = this.m_siteRoot;
        result.m_user = this.m_user;
        result.m_userName = this.m_userName;
        return result;
    }

    public void freeze() {
        this.m_frozen = true;
    }

    public CmsResource getDetailResource() {
        return this.m_detailResource;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getLocaleName() {
        return this.m_localeName;
    }

    public String getOuFqn() {
        return this.m_ouFqn;
    }

    public CmsProject getProject() {
        return this.m_project;
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public String getRemoteAddr() {
        return this.m_remoteAddr;
    }

    public String getRequestedUri() {
        return this.m_requestedUri;
    }

    public long getRequestTime() {
        return this.m_requestTime;
    }

    public String getSiteRoot() {
        return this.m_siteRoot;
    }

    public CmsUser getUser() {
        return this.m_user;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public boolean isSecureRequest() {
        return this.m_isSecureRequest;
    }

    public void setDetailResource(CmsResource detailResource) {
        this.m_detailResource = detailResource;
    }

    public void setEncoding(String encoding) {
        this.checkFrozen();
        this.m_encoding = CmsEncoder.lookupEncoding(encoding, OpenCms.getSystemInfo().getDefaultEncoding());
    }

    public void setIsSecureRequest(boolean isSecureRequest) {
        this.m_isSecureRequest = isSecureRequest;
    }

    public void setLocale(Locale locale) {
        this.checkFrozen();
        this.m_locale = locale;
        this.m_localeName = this.m_locale.toString();
    }

    public void setLocaleName(String localeName) {
        this.checkFrozen();
        this.m_localeName = localeName;
        this.m_locale = CmsLocaleManager.getLocale(localeName);
    }

    public void setOuFqn(String ouFqn) {
        this.checkFrozen();
        this.m_ouFqn = ouFqn;
    }

    public void setProjectName(String projectName) {
        this.checkFrozen();
        this.m_projectName = projectName;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.checkFrozen();
        this.m_remoteAddr = remoteAddr;
    }

    public void setRequestedUri(String requestedUri) {
        this.checkFrozen();
        this.m_requestedUri = requestedUri;
    }

    public void setRequestTime(long requestTime) {
        this.checkFrozen();
        this.m_requestTime = requestTime == -1L ? System.currentTimeMillis() : requestTime;
    }

    public void setSiteRoot(String siteRoot) {
        this.checkFrozen();
        this.m_siteRoot = siteRoot;
    }

    public void setUserName(String userName) {
        this.checkFrozen();
        this.m_userName = userName;
        this.setOuFqn(CmsOrganizationalUnit.getParentFqn(userName));
    }

    protected void checkFrozen() throws CmsRuntimeException {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONTEXT_INFO_FROZEN_0"));
        }
    }
}

