/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsBroadcast;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.I_CmsSessionDestroyHandler;
import org.opencms.main.I_CmsSessionStorageProvider;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsCore;
import org.opencms.main.OpenCmsServlet;
import org.opencms.security.CmsCustomLoginException;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSessionManager {
    private static final Log LOG = CmsLog.getLog(CmsSessionManager.class);
    private Object m_lockSessionCount = new Object();
    private int m_sessionCountCurrent;
    private int m_sessionCountTotal;
    private I_CmsSessionStorageProvider m_sessionStorageProvider;
    private CmsSystemConfiguration.UserSessionMode m_userSessionMode;

    protected CmsSessionManager() {
    }

    public void checkCreateSessionForUser(CmsUser user) throws CmsException {
        List<CmsSessionInfo> infos;
        if (this.getUserSessionMode() == CmsSystemConfiguration.UserSessionMode.single && !(infos = this.getSessionInfos(user.getId())).isEmpty()) {
            throw new CmsCustomLoginException(org.opencms.security.Messages.get().container("ERR_ALREADY_LOGGED_IN_0"));
        }
    }

    public Buffer getBroadcastQueue(String sessionId) {
        CmsSessionInfo sessionInfo = this.getSessionInfo(this.getSessionUUID(sessionId));
        if (sessionInfo == null) {
            return BufferUtils.synchronizedBuffer((Buffer)new CircularFifoBuffer(10));
        }
        return sessionInfo.getBroadcastQueue();
    }

    public int getSessionCountAuthenticated() {
        if (this.m_sessionStorageProvider == null) {
            return 0;
        }
        return this.m_sessionStorageProvider.getSize();
    }

    public int getSessionCountCurrent() {
        return this.m_sessionCountCurrent;
    }

    public int getSessionCountTotal() {
        return this.m_sessionCountTotal;
    }

    public CmsSessionInfo getSessionInfo(CmsUUID sessionId) {
        if (this.m_sessionStorageProvider == null) {
            return null;
        }
        return this.m_sessionStorageProvider.get(sessionId);
    }

    public CmsSessionInfo getSessionInfo(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session == null) {
            String sessionId = req.getHeader("JSESSIONID");
            return sessionId == null ? null : this.getSessionInfo(sessionId);
        }
        return this.getSessionInfo(session);
    }

    public CmsSessionInfo getSessionInfo(HttpSession session) {
        if (session == null) {
            return null;
        }
        CmsUUID sessionId = (CmsUUID)session.getAttribute("__org.opencms.main.CmsSessionInfo#m_sessionId");
        return sessionId == null ? null : this.getSessionInfo(sessionId);
    }

    public CmsSessionInfo getSessionInfo(String sessionId) {
        return this.getSessionInfo(this.getSessionUUID(sessionId));
    }

    public List<CmsSessionInfo> getSessionInfos() {
        if (this.m_sessionStorageProvider == null) {
            return Collections.emptyList();
        }
        return this.m_sessionStorageProvider.getAll();
    }

    public List<CmsSessionInfo> getSessionInfos(CmsUUID userId) {
        if (this.m_sessionStorageProvider == null) {
            return Collections.emptyList();
        }
        return this.m_sessionStorageProvider.getAllOfUser(userId);
    }

    public CmsSystemConfiguration.UserSessionMode getUserSessionMode() {
        return this.m_userSessionMode;
    }

    public void killSession(CmsObject cms, CmsUser user) throws CmsException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ACCOUNT_MANAGER);
        List<CmsSessionInfo> infos = this.getSessionInfos(user.getId());
        for (CmsSessionInfo info : infos) {
            this.m_sessionStorageProvider.remove(info.getSessionId());
        }
    }

    public void killSession(CmsObject cms, CmsUUID sessionid) throws CmsException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ACCOUNT_MANAGER);
        this.m_sessionStorageProvider.remove(sessionid);
    }

    public void sendBroadcast(CmsObject cms, String message) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(message)) {
            return;
        }
        CmsBroadcast broadcast = new CmsBroadcast(cms.getRequestContext().getCurrentUser(), message);
        for (CmsSessionInfo sessionInfo : this.m_sessionStorageProvider.getAll()) {
            if (this.m_sessionStorageProvider.get(sessionInfo.getSessionId()) == null) continue;
            sessionInfo.getBroadcastQueue().add((Object)broadcast);
        }
    }

    public void sendBroadcast(CmsObject cms, String message, String sessionId) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(message)) {
            return;
        }
        CmsSessionInfo sessionInfo = this.m_sessionStorageProvider.get(new CmsUUID(sessionId));
        if (sessionInfo != null) {
            sessionInfo.getBroadcastQueue().add((Object)new CmsBroadcast(cms.getRequestContext().getCurrentUser(), message));
        }
    }

    public void sendBroadcast(CmsUser fromUser, String message, CmsUser toUser) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(message)) {
            return;
        }
        CmsBroadcast broadcast = new CmsBroadcast(fromUser, message);
        List<CmsSessionInfo> userSessions = this.getSessionInfos(toUser.getId());
        for (CmsSessionInfo sessionInfo : userSessions) {
            if (this.m_sessionStorageProvider.get(sessionInfo.getSessionId()) == null) continue;
            sessionInfo.getBroadcastQueue().add((Object)broadcast);
        }
    }

    public void switchUser(CmsObject cms, HttpServletRequest req, CmsUser user) throws CmsException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN.forOrgUnit(user.getOuFqn()));
        CmsSessionInfo info = this.getSessionInfo(req);
        HttpSession session = req.getSession(false);
        if (info == null || session == null) {
            throw new CmsException(Messages.get().container("ERR_NO_SESSIONINFO_SESSION_0"));
        }
        if (!OpenCms.getRoleManager().hasRole(cms, user.getName(), CmsRole.WORKPLACE_USER)) {
            throw new CmsSecurityException(Messages.get().container("ERR_NO_WORKPLACE_PERMISSIONS_0"));
        }
        CmsUserSettings settings = new CmsUserSettings(user);
        String ouFqn = user.getOuFqn();
        CmsProject userProject = cms.readProject(ouFqn + OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartProject());
        try {
            userProject = cms.readProject(settings.getStartProject());
        }
        catch (Exception e) {
            // empty catch block
        }
        String userSiteRoot = settings.getStartSite();
        CmsRequestContext context = new CmsRequestContext(user, userProject, null, userSiteRoot, cms.getRequestContext().isSecureRequest(), null, null, null, 0L, null, null, ouFqn);
        session.removeAttribute("__CmsWorkplace.WORKPLACE_SETTINGS");
        CmsSessionInfo newInfo = new CmsSessionInfo(context, info.getSessionId(), info.getMaxInactiveInterval());
        this.addSessionInfo(newInfo);
        cms.getRequestContext().setSiteRoot(userSiteRoot);
        cms.getRequestContext().setCurrentProject(userProject);
        cms.getRequestContext().setOuFqn(user.getOuFqn());
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        Iterator<CmsSessionInfo> i = this.m_sessionStorageProvider.getAll().iterator();
        output.append("[CmsSessions]:\n");
        while (i.hasNext()) {
            CmsSessionInfo sessionInfo = i.next();
            output.append(sessionInfo.getSessionId().toString());
            output.append(" : ");
            output.append(sessionInfo.getUserId().toString());
            output.append('\n');
        }
        return output.toString();
    }

    public void updateSessionInfos(CmsObject cms) {
        List<CmsSessionInfo> userSessions = this.getSessionInfos();
        for (CmsSessionInfo sessionInfo : userSessions) {
            CmsUUID projectId = sessionInfo.getProject();
            try {
                cms.readProject(projectId);
            }
            catch (CmsException e) {
                sessionInfo.setProject(CmsProject.ONLINE_PROJECT_ID);
                this.addSessionInfo(sessionInfo);
            }
        }
    }

    protected void addSessionInfo(CmsSessionInfo sessionInfo) {
        if (this.getUserSessionMode() == CmsSystemConfiguration.UserSessionMode.standard) {
            this.m_sessionStorageProvider.put(sessionInfo);
        } else if (this.getUserSessionMode() == CmsSystemConfiguration.UserSessionMode.single) {
            CmsUUID userId = sessionInfo.getUserId();
            List<CmsSessionInfo> infos = this.getSessionInfos(userId);
            if (infos.isEmpty() || infos.size() == 1 && infos.get(0).getSessionId().equals(sessionInfo.getSessionId())) {
                this.m_sessionStorageProvider.put(sessionInfo);
            } else {
                throw new RuntimeException("Can't create another session for the same user.");
            }
        }
    }

    protected CmsUUID getSessionUUID(String sessionId) {
        return new CmsUUID(sessionId);
    }

    protected void initialize(I_CmsSessionStorageProvider sessionStorageProvider) {
        this.m_sessionStorageProvider = sessionStorageProvider;
        this.m_sessionStorageProvider.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionCreated(HttpSessionEvent event) {
        HttpServletRequest request = OpenCmsServlet.currentRequest.get();
        String tid = "[" + Thread.currentThread().getId() + "] ";
        Object object = this.m_lockSessionCount;
        synchronized (object) {
            this.m_sessionCountCurrent = this.m_sessionCountCurrent <= 0 ? 1 : this.m_sessionCountCurrent + 1;
            ++this.m_sessionCountTotal;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(tid + Messages.get().getBundle().key("LOG_SESSION_CREATED_2", new Integer(this.m_sessionCountTotal), new Integer(this.m_sessionCountCurrent))));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(tid + Messages.get().getBundle().key("LOG_SESSION_CREATED_1", event.getSession().getId())));
            if (request != null) {
                LOG.debug((Object)(tid + "Session created in request: " + request.getRequestURL()));
            }
            StringWriter sw = new StringWriter();
            new Throwable("").printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            LOG.debug((Object)(tid + "Stack = \n" + stackTrace));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionDestroyed(HttpSessionEvent event) {
        Object object = this.m_lockSessionCount;
        synchronized (object) {
            int n = this.m_sessionCountCurrent = this.m_sessionCountCurrent <= 0 ? 0 : this.m_sessionCountCurrent - 1;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_SESSION_DESTROYED_2", new Integer(this.m_sessionCountTotal), new Integer(this.m_sessionCountCurrent)));
            }
        }
        CmsSessionInfo sessionInfo = this.getSessionInfo(event.getSession());
        CmsUUID userId = null;
        if (sessionInfo != null) {
            userId = sessionInfo.getUserId();
            this.m_sessionStorageProvider.remove(sessionInfo.getSessionId());
        }
        if (userId != null && this.getSessionInfos(userId).size() == 0) {
            OpenCmsCore.getInstance().getLockManager().removeTempLocks(userId);
        }
        HttpSession session = event.getSession();
        Enumeration attrNames = session.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            Object attribute = session.getAttribute(attrName);
            if (!(attribute instanceof I_CmsSessionDestroyHandler)) continue;
            try {
                ((I_CmsSessionDestroyHandler)attribute).onSessionDestroyed();
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SESSION_DESTROYED_1", event.getSession().getId()));
        }
    }

    protected void setUserSessionMode(CmsSystemConfiguration.UserSessionMode userSessionMode) {
        this.m_userSessionMode = userSessionMode;
    }

    protected void shutdown() throws Exception {
        if (this.m_sessionStorageProvider != null) {
            this.m_sessionStorageProvider.shutdown();
        }
    }

    protected void updateSessionInfo(CmsObject cms, HttpServletRequest req) {
        if (!cms.getRequestContext().isUpdateSessionEnabled()) {
            return;
        }
        if (cms.getRequestContext().getUri().equals("/system/workplace/views/admin/admin-main.jsp")) {
            return;
        }
        if (!cms.getRequestContext().getCurrentUser().isGuestUser()) {
            CmsSessionInfo sessionInfo = this.getSessionInfo(req);
            if (sessionInfo != null) {
                sessionInfo.update(cms.getRequestContext());
                this.addSessionInfo(sessionInfo);
            } else {
                HttpSession session = req.getSession(false);
                if (session != null) {
                    sessionInfo = new CmsSessionInfo(cms.getRequestContext(), new CmsUUID(), session.getMaxInactiveInterval());
                    session.setAttribute("__org.opencms.main.CmsSessionInfo#m_sessionId", sessionInfo.getSessionId().clone());
                    this.addSessionInfo(sessionInfo);
                }
            }
        }
    }

    protected void validateSessionInfos() {
        if (this.m_sessionStorageProvider == null) {
            return;
        }
        this.m_sessionStorageProvider.validate();
    }
}

