/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opencms.file.CmsResource;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsUUID;

public final class CmsRelationFilter
implements Cloneable {
    public static final CmsRelationFilter ALL = new CmsRelationFilter(true, true);
    public static final CmsRelationFilter SOURCES = new CmsRelationFilter(true, false);
    public static final CmsRelationFilter TARGETS = new CmsRelationFilter(false, true);
    private boolean m_includeSubresources;
    private String m_path;
    private boolean m_source;
    private CmsUUID m_structureId;
    private boolean m_target;
    private Set<CmsRelationType> m_types = new HashSet<CmsRelationType>();

    private CmsRelationFilter(boolean source, boolean target) {
        this.m_source = source;
        this.m_target = target;
    }

    public static CmsRelationFilter relationsFromStructureId(CmsUUID structureId) {
        return SOURCES.filterStructureId(structureId);
    }

    public static CmsRelationFilter relationsToStructureId(CmsUUID structureId) {
        return TARGETS.filterStructureId(structureId);
    }

    public Object clone() {
        CmsRelationFilter filter = new CmsRelationFilter(this.m_source, this.m_target);
        filter.m_structureId = this.m_structureId;
        filter.m_types = new HashSet<CmsRelationType>(this.m_types);
        filter.m_path = this.m_path;
        filter.m_includeSubresources = this.m_includeSubresources;
        return filter;
    }

    public CmsRelationFilter filterDefinedInContent() {
        CmsRelationFilter filter = (CmsRelationFilter)this.clone();
        if (filter.m_types.isEmpty()) {
            filter.m_types.addAll(CmsRelationType.getAllDefinedInContent());
        } else {
            filter.m_types = new HashSet<CmsRelationType>(CmsRelationType.filterDefinedInContent(filter.m_types));
        }
        return filter;
    }

    public CmsRelationFilter filterIncludeChildren() {
        CmsRelationFilter filter = (CmsRelationFilter)this.clone();
        filter.m_includeSubresources = true;
        return filter;
    }

    public CmsRelationFilter filterInternal() {
        CmsRelationFilter filter = (CmsRelationFilter)this.clone();
        if (filter.m_types.isEmpty()) {
            filter.m_types.addAll(CmsRelationType.getAllInternal());
        } else {
            filter.m_types = new HashSet<CmsRelationType>(CmsRelationType.filterInternal(filter.m_types));
        }
        return filter;
    }

    public CmsRelationFilter filterNotDefinedInContent() {
        CmsRelationFilter filter = (CmsRelationFilter)this.clone();
        if (filter.m_types.isEmpty()) {
            filter.m_types.addAll(CmsRelationType.getAllNotDefinedInContent());
        } else {
            filter.m_types = new HashSet<CmsRelationType>(CmsRelationType.filterNotDefinedInContent(filter.m_types));
        }
        return filter;
    }

    public CmsRelationFilter filterPath(String path) {
        CmsRelationFilter filter = (CmsRelationFilter)this.clone();
        filter.m_path = path;
        return filter;
    }

    public CmsRelationFilter filterResource(CmsResource resource) {
        CmsRelationFilter filter = this.filterStructureId(resource.getStructureId());
        filter = this.filterPath(resource.getRootPath());
        return filter;
    }

    public CmsRelationFilter filterStrong() {
        CmsRelationFilter filter = (CmsRelationFilter)this.clone();
        if (filter.m_types.isEmpty()) {
            filter.m_types.addAll(CmsRelationType.getAllStrong());
        } else {
            filter.m_types = new HashSet<CmsRelationType>(CmsRelationType.filterStrong(filter.m_types));
        }
        return filter;
    }

    public CmsRelationFilter filterStructureId(CmsUUID structureId) {
        CmsRelationFilter filter = (CmsRelationFilter)this.clone();
        filter.m_structureId = structureId;
        return filter;
    }

    public CmsRelationFilter filterType(CmsRelationType type) {
        CmsRelationFilter filter = (CmsRelationFilter)this.clone();
        filter.m_types.add(type);
        return filter;
    }

    public CmsRelationFilter filterUserDefined() {
        CmsRelationFilter filter = (CmsRelationFilter)this.clone();
        if (filter.m_types.isEmpty()) {
            filter.m_types.addAll(CmsRelationType.getAllUserDefined());
        } else {
            filter.m_types = new HashSet<CmsRelationType>(CmsRelationType.filterUserDefined(filter.m_types));
        }
        return filter;
    }

    public CmsRelationFilter filterWeak() {
        CmsRelationFilter filter = (CmsRelationFilter)this.clone();
        if (filter.m_types.isEmpty()) {
            filter.m_types.addAll(CmsRelationType.getAllWeak());
        } else {
            filter.m_types = new HashSet<CmsRelationType>(CmsRelationType.filterWeak(filter.m_types));
        }
        return filter;
    }

    public String getPath() {
        return this.m_path;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public Set<CmsRelationType> getTypes() {
        return Collections.unmodifiableSet(this.m_types);
    }

    public boolean includesDefinedInContent() {
        if (this.m_types == null || this.m_types.isEmpty()) {
            return true;
        }
        for (CmsRelationType type : this.m_types) {
            if (!type.isDefinedInContent()) continue;
            return true;
        }
        return false;
    }

    public boolean isIncludeSubresources() {
        return this.m_includeSubresources;
    }

    public boolean isSource() {
        return this.m_source;
    }

    public boolean isTarget() {
        return this.m_target;
    }

    public boolean matchType(CmsRelationType type) {
        if (this.m_types.isEmpty()) {
            return true;
        }
        return this.m_types.contains(type);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(128);
        str.append("[");
        String mode = null;
        mode = this.m_source ? (this.m_target ? "both" : "source") : (this.m_target ? "target" : "none");
        str.append(mode).append("=").append(this.m_structureId).append(", ");
        str.append("path").append("=").append(this.m_path).append(", ");
        str.append("types").append("=").append(this.m_types).append(", ");
        str.append("subresources").append("=").append(this.m_includeSubresources);
        str.append("]");
        return str.toString();
    }
}

