/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsIndexingThreadManager;
import org.opencms.search.CmsSearchAnalyzer;
import org.opencms.search.CmsSearchDocumentType;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchIndexUpdateData;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsIndexer;
import org.opencms.search.Messages;
import org.opencms.search.documents.A_CmsVfsDocument;
import org.opencms.search.documents.CmsExtractionResultCache;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.documents.I_CmsTermHighlighter;
import org.opencms.search.fields.CmsLuceneField;
import org.opencms.search.fields.CmsLuceneFieldConfiguration;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.galleries.CmsGallerySearchAnalyzer;
import org.opencms.search.solr.CmsSolrConfiguration;
import org.opencms.search.solr.CmsSolrFieldConfiguration;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.CmsSolrIndexWriter;
import org.opencms.search.solr.spellchecking.CmsSolrSpellchecker;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.A_CmsModeStringEnumeration;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsWaitHandle;

public class CmsSearchManager
implements I_CmsScheduledJob,
I_CmsEventListener {
    public static final int DEFAULT_EXCERPT_LENGTH = 1024;
    public static final float DEFAULT_EXTRACTION_CACHE_MAX_AGE = 672.0f;
    public static final int DEFAULT_MAX_MODIFICATIONS_BEFORE_COMMIT = 500;
    public static final int DEFAULT_OFFLINE_UPDATE_FREQNENCY = 15000;
    public static final int DEFAULT_TIMEOUT = 60000;
    public static final String JOB_PARAM_INDEXLIST = "indexList";
    public static final String JOB_PARAM_WRITELOG = "writeLog";
    public static final String LUCENE_ANALYZER = "org.apache.lucene.analysis.core.";
    protected static final Log LOG = CmsLog.getLog(CmsSearchManager.class);
    protected CmsObject m_adminCms;
    protected List<CmsSearchIndex> m_offlineIndexes;
    protected CmsSearchOfflineIndexThread m_offlineIndexThread;
    private HashMap<Locale, CmsSearchAnalyzer> m_analyzers;
    private long m_configuredOfflineIndexingFrequency;
    private CoreContainer m_coreContainer;
    private List<CmsSearchDocumentType> m_documentTypeConfigs;
    private Map<String, I_CmsDocumentFactory> m_documentTypes = new HashMap<String, I_CmsDocumentFactory>();
    private float m_extractionCacheMaxAge = 672.0f;
    private CmsExtractionResultCache m_extractionResultCache;
    private Map<String, CmsSearchFieldConfiguration> m_fieldConfigurations;
    private CmsSearchForceUnlockMode m_forceUnlockMode;
    private I_CmsTermHighlighter m_highlighter;
    private List<CmsSearchIndex> m_indexes;
    private int m_indexLockMaxWaitSeconds = 10;
    private Map<String, CmsSearchIndexSource> m_indexSources;
    private int m_maxExcerptLength = 1024;
    private int m_maxModificationsBeforeCommit = 500;
    private CmsSearchOfflineHandler m_offlineHandler;
    private long m_offlineUpdateFrequency = 15000L;
    private String m_path;
    private CmsSolrConfiguration m_solrConfig;
    private long m_timeout;

    public CmsSearchManager() {
        this.m_documentTypeConfigs = new ArrayList<CmsSearchDocumentType>();
        this.m_analyzers = new HashMap();
        this.m_indexes = new ArrayList<CmsSearchIndex>();
        this.m_indexSources = new TreeMap<String, CmsSearchIndexSource>();
        this.m_offlineHandler = new CmsSearchOfflineHandler();
        this.m_fieldConfigurations = new HashMap<String, CmsSearchFieldConfiguration>();
        this.addFieldConfiguration(CmsLuceneFieldConfiguration.DEFAULT_STANDARD);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_START_SEARCH_CONFIG_0"));
        }
    }

    public static Analyzer getAnalyzer(String className) throws Exception {
        return CmsSearchManager.getAnalyzer(className, null);
    }

    public static final CmsSolrIndex getIndexSolr(CmsObject cms, Map<String, String[]> params) {
        List<CmsSolrIndex> solrs;
        String indexName = null;
        CmsSolrIndex index = null;
        if (params != null) {
            String string = params.get("core") != null ? params.get("core")[0] : (indexName = params.get("index") != null ? params.get("index")[0] : null);
        }
        if (indexName == null) {
            indexName = cms.getRequestContext().getCurrentProject().isOnlineProject() ? "Solr Online" : "Solr Offline";
        }
        CmsSolrIndex cmsSolrIndex = index = indexName != null ? OpenCms.getSearchManager().getIndexSolr(indexName) : null;
        if (index == null && (solrs = OpenCms.getSearchManager().getAllSolrIndexes()) != null && !solrs.isEmpty() && solrs.size() == 1) {
            index = solrs.get(0);
        }
        return index;
    }

    public static boolean isLuceneIndex(String indexName) {
        CmsSearchIndex i = OpenCms.getSearchManager().getIndex(indexName);
        return !(i instanceof CmsSolrIndex);
    }

    @Deprecated
    private static Analyzer getAnalyzer(String className, String stemmer) throws Exception {
        Class<?> analyzerClass;
        Object analyzer = null;
        try {
            analyzerClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            analyzerClass = Class.forName(LUCENE_ANALYZER + className);
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (StandardAnalyzer.class.equals(analyzerClass)) {
            analyzer = new StandardAnalyzer(CmsSearchIndex.LUCENE_VERSION);
        } else if (CmsGallerySearchAnalyzer.class.equals(analyzerClass)) {
            analyzer = new CmsGallerySearchAnalyzer(CmsSearchIndex.LUCENE_VERSION);
        } else {
            boolean hasEmpty = false;
            boolean hasVersion = false;
            boolean hasVersionWithString = false;
            Constructor<?>[] constructors = analyzerClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> c = constructors[i];
                Class<?>[] parameters = c.getParameterTypes();
                if (parameters.length == 0) {
                    hasEmpty = true;
                }
                if (parameters.length == 1 && parameters[0].equals(Version.class)) {
                    hasVersion = true;
                }
                if (stemmer == null || parameters.length != 2 || !parameters[0].equals(Version.class) || !parameters[1].equals(String.class)) continue;
                hasVersionWithString = true;
            }
            if (hasVersionWithString) {
                analyzer = (Analyzer)analyzerClass.getDeclaredConstructor(Version.class, String.class).newInstance(CmsSearchIndex.LUCENE_VERSION, stemmer);
            } else if (hasVersion) {
                analyzer = (Analyzer)analyzerClass.getDeclaredConstructor(Version.class).newInstance(CmsSearchIndex.LUCENE_VERSION);
            } else if (hasEmpty) {
                analyzer = (Analyzer)analyzerClass.newInstance();
            }
        }
        return analyzer;
    }

    public void addAnalyzer(CmsSearchAnalyzer analyzer) {
        this.m_analyzers.put(analyzer.getLocale(), analyzer);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_ANALYZER_2", analyzer.getLocale(), analyzer.getClassName()));
        }
    }

    public void addDocumentTypeConfig(CmsSearchDocumentType documentType) {
        this.m_documentTypeConfigs.add(documentType);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_DOC_TYPES_2", documentType.getName(), documentType.getClassName()));
        }
    }

    public void addFieldConfiguration(CmsSearchFieldConfiguration fieldConfiguration) {
        this.m_fieldConfigurations.put(fieldConfiguration.getName(), fieldConfiguration);
        if (fieldConfiguration.getFields().isEmpty()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FIELD_CONFIGURATION_IS_EMPTY_1", fieldConfiguration.getName()));
        }
    }

    public void addSearchIndex(CmsSearchIndex searchIndex) {
        String name;
        if ((searchIndex.getSources() == null || searchIndex.getPath() == null) && OpenCms.getRunLevel() > 2) {
            try {
                searchIndex.initialize();
            }
            catch (CmsException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name = searchIndex.getName())) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_MISSING_NAME_0"));
        }
        if (this.m_indexSources.keySet().contains(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_INVALID_NAME_1", name));
        }
        this.m_indexes.add(searchIndex);
        if (this.m_adminCms != null) {
            this.initOfflineIndexes();
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_SEARCH_INDEX_2", searchIndex.getName(), searchIndex.getProject()));
        }
    }

    public void addSearchIndexSource(CmsSearchIndexSource searchIndexSource) {
        this.m_indexSources.put(searchIndexSource.getName(), searchIndexSource);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_INDEX_SOURCE_2", searchIndexSource.getName(), searchIndexSource.getIndexerClassName()));
        }
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 32: {
                List<String> indexNames = null;
                if (event.getData() != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)event.getData().get("indexNames"))) {
                    indexNames = CmsStringUtil.splitAsList((String)event.getData().get("indexNames"), ",", true);
                }
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_REBUILD_SEARCHINDEX_1", indexNames == null ? "" : CmsStringUtil.collectionAsString(indexNames, ",")), (Throwable)new Exception());
                    }
                    if (indexNames == null) {
                        this.rebuildAllIndexes(this.getEventReport(event));
                        break;
                    }
                    this.rebuildIndexes(indexNames, this.getEventReport(event));
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break;
                    LOG.error((Object)Messages.get().getBundle().key("ERR_EVENT_REBUILD_SEARCHINDEX_1", indexNames == null ? "" : CmsStringUtil.collectionAsString(indexNames, ",")), (Throwable)e);
                }
                break;
            }
            case 5: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_CLEAR_CACHES_0"), (Throwable)new Exception());
                break;
            }
            case 2: {
                CmsUUID publishHistoryId = new CmsUUID((String)event.getData().get("publishHistoryId"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_PUBLISH_PROJECT_1", publishHistoryId));
                }
                this.updateAllIndexes(this.m_adminCms, publishHistoryId, this.getEventReport(event));
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_PUBLISH_PROJECT_FINISHED_1", publishHistoryId));
                break;
            }
        }
    }

    public List<CmsSolrIndex> getAllSolrIndexes() {
        ArrayList<CmsSolrIndex> result = new ArrayList<CmsSolrIndex>();
        for (String indexName : this.getIndexNames()) {
            CmsSolrIndex index = this.getIndexSolr(indexName);
            if (index == null) continue;
            result.add(index);
        }
        return result;
    }

    public Analyzer getAnalyzer(Locale locale) throws CmsSearchException {
        Analyzer analyzer = null;
        Object className = null;
        CmsSearchAnalyzer analyzerConf = this.m_analyzers.get(locale);
        if (analyzerConf == null) {
            throw new CmsSearchException(Messages.get().container("ERR_ANALYZER_NOT_FOUND_1", locale));
        }
        try {
            analyzer = CmsSearchManager.getAnalyzer(analyzerConf.getClassName(), analyzerConf.getStemmerAlgorithm());
        }
        catch (Exception e) {
            throw new CmsSearchException(Messages.get().container("ERR_LOAD_ANALYZER_1", (Object)className), (Throwable)e);
        }
        return analyzer;
    }

    public Map<Locale, CmsSearchAnalyzer> getAnalyzers() {
        return Collections.unmodifiableMap(this.m_analyzers);
    }

    public CmsSearchAnalyzer getCmsSearchAnalyzer(Locale locale) {
        return this.m_analyzers.get(locale);
    }

    public String getDirectory() {
        return this.m_path;
    }

    public String getDirectorySolr() {
        return this.m_solrConfig != null ? this.m_solrConfig.getHome() : null;
    }

    public I_CmsDocumentFactory getDocumentFactory(CmsResource resource) {
        String mimeType = OpenCms.getResourceManager().getMimeType(resource.getRootPath(), null, "unknown");
        String resourceType = null;
        try {
            resourceType = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getTypeName();
        }
        catch (CmsLoaderException e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return this.getDocumentFactory(resourceType, mimeType);
    }

    public I_CmsDocumentFactory getDocumentFactory(String resourceType, String mimeType) {
        String documentTypeKey;
        I_CmsDocumentFactory result = null;
        if (resourceType != null && (result = this.m_documentTypes.get(documentTypeKey = A_CmsVfsDocument.getDocumentKey(resourceType, mimeType))) == null) {
            result = this.m_documentTypes.get(A_CmsVfsDocument.getDocumentKey(resourceType, null));
        }
        return result;
    }

    public CmsSearchDocumentType getDocumentTypeConfig(String name) {
        for (int i = 0; i < this.m_documentTypeConfigs.size(); ++i) {
            CmsSearchDocumentType type = this.m_documentTypeConfigs.get(i);
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    public List<CmsSearchDocumentType> getDocumentTypeConfigs() {
        return Collections.unmodifiableList(this.m_documentTypeConfigs);
    }

    public float getExtractionCacheMaxAge() {
        return this.m_extractionCacheMaxAge;
    }

    public CmsSearchFieldConfiguration getFieldConfiguration(String name) {
        return this.m_fieldConfigurations.get(name);
    }

    public List<CmsSearchFieldConfiguration> getFieldConfigurations() {
        ArrayList<CmsSearchFieldConfiguration> result = new ArrayList<CmsSearchFieldConfiguration>(this.m_fieldConfigurations.values());
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    public List<CmsLuceneFieldConfiguration> getFieldConfigurationsLucene() {
        ArrayList<CmsLuceneFieldConfiguration> result = new ArrayList<CmsLuceneFieldConfiguration>();
        for (CmsSearchFieldConfiguration conf : this.m_fieldConfigurations.values()) {
            if (!(conf instanceof CmsLuceneFieldConfiguration)) continue;
            result.add((CmsLuceneFieldConfiguration)conf);
        }
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    public List<CmsSolrFieldConfiguration> getFieldConfigurationsSolr() {
        ArrayList<CmsSolrFieldConfiguration> result = new ArrayList<CmsSolrFieldConfiguration>();
        for (CmsSearchFieldConfiguration conf : this.m_fieldConfigurations.values()) {
            if (!(conf instanceof CmsSolrFieldConfiguration)) continue;
            result.add((CmsSolrFieldConfiguration)conf);
        }
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    public CmsSearchForceUnlockMode getForceunlock() {
        return this.m_forceUnlockMode;
    }

    public I_CmsTermHighlighter getHighlighter() {
        return this.m_highlighter;
    }

    public CmsSearchIndex getIndex(String indexName) {
        for (CmsSearchIndex index : this.m_indexes) {
            if (!indexName.equalsIgnoreCase(index.getName())) continue;
            return index;
        }
        return null;
    }

    public int getIndexLockMaxWaitSeconds() {
        return this.m_indexLockMaxWaitSeconds;
    }

    public List<String> getIndexNames() {
        ArrayList<String> indexNames = new ArrayList<String>();
        int n = this.m_indexes.size();
        for (int i = 0; i < n; ++i) {
            indexNames.add(this.m_indexes.get(i).getName());
        }
        return indexNames;
    }

    public CmsSolrIndex getIndexSolr(String indexName) {
        CmsSearchIndex index = this.getIndex(indexName);
        if (index instanceof CmsSolrIndex) {
            return (CmsSolrIndex)index;
        }
        return null;
    }

    public CmsSearchIndexSource getIndexSource(String sourceName) {
        return this.m_indexSources.get(sourceName);
    }

    public int getMaxExcerptLength() {
        return this.m_maxExcerptLength;
    }

    public int getMaxModificationsBeforeCommit() {
        return this.m_maxModificationsBeforeCommit;
    }

    public long getOfflineUpdateFrequency() {
        return this.m_offlineUpdateFrequency;
    }

    public List<CmsSearchIndex> getSearchIndexes() {
        return Collections.unmodifiableList(this.m_indexes);
    }

    public List<CmsSearchIndex> getSearchIndexesAll() {
        return Collections.unmodifiableList(this.m_indexes);
    }

    public List<CmsSolrIndex> getSearchIndexesSolr() {
        ArrayList<CmsSolrIndex> indexes = new ArrayList<CmsSolrIndex>();
        for (CmsSearchIndex index : this.m_indexes) {
            if (!(index instanceof CmsSolrIndex)) continue;
            indexes.add((CmsSolrIndex)index);
        }
        return Collections.unmodifiableList(indexes);
    }

    public Map<String, CmsSearchIndexSource> getSearchIndexSources() {
        return Collections.unmodifiableMap(this.m_indexSources);
    }

    public CmsSolrSpellchecker getSolrDictionary(CmsObject cms) {
        if (this.m_coreContainer == null) {
            this.initCoreContainer();
        }
        SolrCore spellcheckCore = null;
        if (this.m_coreContainer != null) {
            spellcheckCore = this.m_coreContainer.getCore("spellcheck");
        }
        if (spellcheckCore == null) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_SPELLCHECK_CORE_NOT_AVAILABLE_1", "spellcheck"));
            return null;
        }
        return CmsSolrSpellchecker.getInstance(this.m_coreContainer, spellcheckCore);
    }

    public CmsSolrConfiguration getSolrServerConfiguration() {
        return this.m_solrConfig;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public void initialize(CmsObject cms) throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.WORKPLACE_MANAGER);
        try {
            this.m_adminCms = OpenCms.initCmsObject(cms);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_adminCms.getRequestContext().setSiteRoot("/");
        this.m_extractionResultCache = new CmsExtractionResultCache(OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(this.getDirectory()), "/extractCache");
        this.initializeIndexes();
        this.initOfflineIndexes();
        OpenCms.addCmsEventListener(this, new int[]{5, 2, 32});
    }

    public void initializeIndexes() {
        this.initAvailableDocumentTypes();
        this.initSearchIndexes();
    }

    public void initOfflineIndexes() {
        ArrayList<CmsSearchIndex> offlineIndexes = new ArrayList<CmsSearchIndex>();
        for (CmsSearchIndex index : this.m_indexes) {
            if (!"offline".equals(index.getRebuildMode())) continue;
            offlineIndexes.add(index);
        }
        this.m_offlineIndexes = offlineIndexes;
        this.m_offlineHandler.initialize();
    }

    public boolean isOfflineIndexingPaused() {
        return this.m_offlineUpdateFrequency == Long.MAX_VALUE;
    }

    @Override
    public String launch(CmsObject cms, Map<String, String> parameters) throws Exception {
        CmsSearchManager manager = OpenCms.getSearchManager();
        CmsLogReport report = null;
        boolean writeLog = Boolean.valueOf(parameters.get(JOB_PARAM_WRITELOG));
        if (writeLog) {
            report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsSearchManager.class);
        }
        ArrayList<String> updateList = null;
        String indexList = parameters.get(JOB_PARAM_INDEXLIST);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(indexList)) {
            updateList = new ArrayList<String>();
            String[] indexNames = CmsStringUtil.splitAsArray(indexList, '|');
            for (int i = 0; i < indexNames.length; ++i) {
                if (manager.getIndex(indexNames[i]) != null) {
                    updateList.add(indexNames[i]);
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_NO_INDEX_WITH_NAME_1", indexNames[i]));
            }
        }
        long startTime = System.currentTimeMillis();
        if (updateList == null) {
            manager.rebuildAllIndexes(report);
        } else {
            manager.rebuildIndexes(updateList, report);
        }
        long runTime = System.currentTimeMillis() - startTime;
        String finishMessage = Messages.get().getBundle().key("LOG_REBUILD_INDEXES_FINISHED_1", CmsStringUtil.formatRuntime(runTime));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)finishMessage);
        }
        return finishMessage;
    }

    public void pauseOfflineIndexing() {
        if (this.m_offlineUpdateFrequency != Long.MAX_VALUE) {
            this.m_configuredOfflineIndexingFrequency = this.m_offlineUpdateFrequency;
            this.m_offlineUpdateFrequency = Long.MAX_VALUE;
            this.updateOfflineIndexes(0L);
        }
    }

    public synchronized void rebuildAllIndexes(I_CmsReport report) throws CmsException {
        CmsMessageContainer container = null;
        int n = this.m_indexes.size();
        for (int i = 0; i < n; ++i) {
            CmsSearchIndex searchIndex = this.m_indexes.get(i);
            try {
                this.updateIndex(searchIndex, report, null);
                continue;
            }
            catch (CmsException e) {
                container = new CmsMessageContainer(Messages.get(), "ERR_INDEX_REBUILD_ALL_1", searchIndex.getName());
                LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_REBUILD_ALL_1", searchIndex.getName()), (Throwable)e);
            }
        }
        this.cleanExtractionCache();
        if (container != null) {
            throw new CmsSearchException(container);
        }
    }

    public synchronized void rebuildIndex(String indexName, I_CmsReport report) throws CmsException {
        CmsSearchIndex index = this.getIndex(indexName);
        this.updateIndex(index, report, null);
        this.cleanExtractionCache();
    }

    public synchronized void rebuildIndexes(List<String> indexNames, I_CmsReport report) throws CmsException {
        for (String indexName : indexNames) {
            CmsSearchIndex index = this.getIndex(indexName);
            if (index != null) {
                this.updateIndex(index, report, null);
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn((Object)Messages.get().getBundle().key("LOG_NO_INDEX_WITH_NAME_1", indexName));
        }
        this.cleanExtractionCache();
    }

    public void registerSolrIndex(CmsSolrIndex index) throws CmsConfigurationException {
        if (this.m_solrConfig == null || !this.m_solrConfig.isEnabled()) {
            throw new CmsConfigurationException(Messages.get().container("ERR_SOLR_NOT_ENABLED_0"));
        }
        if (this.m_solrConfig.getServerUrl() != null) {
            index.setSolrServer((SolrServer)new HttpSolrServer(this.m_solrConfig.getServerUrl()));
        }
        if (this.m_coreContainer == null) {
            this.initCoreContainer();
        }
        if (this.m_coreContainer != null && !this.m_coreContainer.getCoreNames().contains(index.getName())) {
            File dataDir = new File(index.getPath());
            if (!dataDir.exists() && !dataDir.exists()) {
                dataDir.mkdirs();
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SOLR_INDEX_DIR_CREATED_2", index.getName(), index.getPath()));
                }
            }
            CoreDescriptor descriptor = new CoreDescriptor(this.m_coreContainer, "descriptor", this.m_solrConfig.getHome());
            descriptor.setDataDir(dataDir.getAbsolutePath());
            try {
                SolrCore core = this.m_coreContainer.create(descriptor);
                core.setName(index.getName());
                this.m_coreContainer.register(core, false);
                index.setSolrServer((SolrServer)new EmbeddedSolrServer(this.m_coreContainer, index.getName()));
            }
            catch (Exception e) {
                throw new CmsConfigurationException(Messages.get().container("ERR_SOLR_SERVER_NOT_CREATED_3", index.getName(), index.getPath(), this.m_solrConfig.getSolrConfigFile().getAbsolutePath()), (Throwable)e);
            }
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SOLR_SERVER_CREATED_1", index.getName()));
        }
    }

    public boolean removeSearchFieldConfiguration(CmsSearchFieldConfiguration fieldConfiguration) throws CmsIllegalStateException {
        if (fieldConfiguration.getName().equals("standard")) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INDEX_CONFIGURATION_DELETE_STANDARD_1", fieldConfiguration.getName()));
        }
        Iterator<CmsSearchIndex> itIndexes = this.m_indexes.iterator();
        ArrayList<CmsSearchIndex> referrers = new ArrayList<CmsSearchIndex>();
        while (itIndexes.hasNext()) {
            CmsSearchIndex idx = itIndexes.next();
            CmsSearchFieldConfiguration refFieldConfig = idx.getFieldConfiguration();
            if (!refFieldConfig.equals(fieldConfiguration)) continue;
            referrers.add(idx);
        }
        if (referrers.size() > 0) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INDEX_CONFIGURATION_DELETE_2", fieldConfiguration.getName(), ((Object)referrers).toString()));
        }
        return this.m_fieldConfigurations.remove(fieldConfiguration.getName()) != null;
    }

    public boolean removeSearchFieldConfigurationField(CmsSearchFieldConfiguration fieldConfiguration, CmsSearchField field) throws CmsIllegalStateException {
        if (fieldConfiguration.getFields().size() < 2) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_CONFIGURATION_FIELD_DELETE_2", field.getName(), fieldConfiguration.getName()));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_REMOVE_FIELDCONFIGURATION_FIELD_INDEX_2", field.getName(), fieldConfiguration.getName()));
        }
        return fieldConfiguration.getFields().remove(field);
    }

    public boolean removeSearchFieldMapping(CmsLuceneField field, CmsSearchFieldMapping mapping) throws CmsIllegalStateException {
        if (field.getMappings().size() < 2) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_FIELD_MAPPING_DELETE_2", mapping.getType().toString(), field.getName()));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_REMOVE_FIELD_MAPPING_INDEX_2", mapping.toString(), field.getName()));
        }
        return field.getMappings().remove(mapping);
    }

    public void removeSearchIndex(CmsSearchIndex searchIndex) {
        this.m_indexes.remove(searchIndex);
        this.initOfflineIndexes();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_REMOVE_SEARCH_INDEX_2", searchIndex.getName(), searchIndex.getProject()));
        }
    }

    public void removeSearchIndexes(List<String> indexNames) {
        for (String indexName : indexNames) {
            CmsSearchIndex index = this.getIndex(indexName);
            if (index != null) {
                this.removeSearchIndex(index);
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn((Object)Messages.get().getBundle().key("LOG_NO_INDEX_WITH_NAME_1", indexName));
        }
    }

    public boolean removeSearchIndexSource(CmsSearchIndexSource indexsource) throws CmsIllegalStateException {
        Iterator<CmsSearchIndex> itIndexes = this.m_indexes.iterator();
        ArrayList<CmsSearchIndex> referrers = new ArrayList<CmsSearchIndex>();
        while (itIndexes.hasNext()) {
            CmsSearchIndex idx = itIndexes.next();
            List<CmsSearchIndexSource> refsources = idx.getSources();
            if (refsources == null || !refsources.contains(indexsource)) continue;
            referrers.add(idx);
        }
        if (referrers.size() > 0) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INDEX_SOURCE_DELETE_2", indexsource.getName(), ((Object)referrers).toString()));
        }
        return this.m_indexSources.remove(indexsource.getName()) != null;
    }

    public void resumeOfflineIndexing() {
        if (this.m_offlineUpdateFrequency == Long.MAX_VALUE) {
            this.setOfflineUpdateFrequency(this.m_configuredOfflineIndexingFrequency > 0L ? this.m_configuredOfflineIndexingFrequency : 15000L);
        }
    }

    public void setDirectory(String value) {
        this.m_path = value;
    }

    public void setExtractionCacheMaxAge(float extractionCacheMaxAge) {
        this.m_extractionCacheMaxAge = extractionCacheMaxAge;
    }

    public void setExtractionCacheMaxAge(String extractionCacheMaxAge) {
        try {
            this.setExtractionCacheMaxAge(Float.parseFloat(extractionCacheMaxAge));
        }
        catch (NumberFormatException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_EXTRACTION_CACHE_AGE_FAILED_2", extractionCacheMaxAge, new Float(672.0f)), (Throwable)e);
            this.setExtractionCacheMaxAge(672.0f);
        }
    }

    public void setForceunlock(String value) {
        this.m_forceUnlockMode = CmsSearchForceUnlockMode.valueOf(value);
    }

    public void setHighlighter(String highlighter) {
        try {
            this.m_highlighter = (I_CmsTermHighlighter)Class.forName(highlighter).newInstance();
        }
        catch (Exception e) {
            this.m_highlighter = null;
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setIndexLockMaxWaitSeconds(int value) {
        this.m_indexLockMaxWaitSeconds = value;
    }

    public void setMaxExcerptLength(int maxExcerptLength) {
        this.m_maxExcerptLength = maxExcerptLength;
    }

    public void setMaxExcerptLength(String maxExcerptLength) {
        try {
            this.setMaxExcerptLength(Integer.parseInt(maxExcerptLength));
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_EXCERPT_LENGTH_FAILED_2", maxExcerptLength, new Integer(1024)), (Throwable)e);
            this.setMaxExcerptLength(1024);
        }
    }

    public void setMaxModificationsBeforeCommit(int maxModificationsBeforeCommit) {
        this.m_maxModificationsBeforeCommit = maxModificationsBeforeCommit;
    }

    public void setMaxModificationsBeforeCommit(String value) {
        try {
            this.setMaxModificationsBeforeCommit(Integer.parseInt(value));
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_MAXCOMMIT_FAILED_2", value, new Integer(500)), (Throwable)e);
            this.setMaxModificationsBeforeCommit(500);
        }
    }

    public void setOfflineUpdateFrequency(long offlineUpdateFrequency) {
        this.m_offlineUpdateFrequency = offlineUpdateFrequency;
        this.updateOfflineIndexes(0L);
    }

    public void setOfflineUpdateFrequency(String offlineUpdateFrequency) {
        try {
            this.setOfflineUpdateFrequency(Long.parseLong(offlineUpdateFrequency));
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_OFFLINE_UPDATE_FAILED_2", offlineUpdateFrequency, new Long(15000L)), (Throwable)e);
            this.setOfflineUpdateFrequency(15000L);
        }
    }

    public void setSolrServerConfiguration(CmsSolrConfiguration config) {
        this.m_solrConfig = config;
    }

    public void setTimeout(long value) {
        this.m_timeout = value;
    }

    public void setTimeout(String value) {
        try {
            this.setTimeout(Long.parseLong(value));
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_TIMEOUT_FAILED_2", value, new Long(60000L)), (Throwable)e);
            this.setTimeout(60000L);
        }
    }

    public void shutDown() {
        if (this.m_offlineIndexThread != null) {
            this.m_offlineIndexThread.shutDown();
        }
        if (this.m_offlineHandler != null) {
            OpenCms.removeCmsEventListener(this.m_offlineHandler);
        }
        for (CmsSearchIndex index : this.m_indexes) {
            index.shutDown();
            Object var2_2 = null;
        }
        this.m_indexes.clear();
        this.shutDownSolrContainer();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_MANAGER_0"));
        }
    }

    public void updateOfflineIndexes(long waitTime) {
        if (this.m_offlineIndexThread != null && this.m_offlineIndexThread.isAlive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_OI_UPDATE_INTERRUPT_0"));
            }
            this.m_offlineIndexThread.interrupt();
            if (waitTime > 0L) {
                this.m_offlineIndexThread.getWaitHandle().enter(waitTime);
            }
        }
    }

    protected void cleanExtractionCache() {
        this.m_extractionResultCache.cleanCache(this.m_extractionCacheMaxAge);
    }

    protected List<CmsPublishedResource> findRelatedContainerPages(CmsObject adminCms, List<CmsPublishedResource> updateResources) {
        HashSet<CmsResource> elementGroups = new HashSet<CmsResource>();
        HashSet<CmsResource> containerPages = new HashSet<CmsResource>();
        int containerPageTypeId = -1;
        try {
            containerPageTypeId = CmsResourceTypeXmlContainerPage.getContainerPageTypeId();
        }
        catch (CmsLoaderException e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (containerPageTypeId != -1) {
            CmsResource res;
            List<CmsRelation> relations;
            CmsRelationFilter filter;
            for (CmsPublishedResource cmsPublishedResource : updateResources) {
                try {
                    if (OpenCms.getResourceManager().getResourceType(cmsPublishedResource.getType()) instanceof CmsResourceTypeXmlContent) {
                        filter = CmsRelationFilter.relationsToStructureId(cmsPublishedResource.getStructureId());
                        filter.filterStrong();
                        relations = adminCms.readRelations(filter);
                        for (CmsRelation relation : relations) {
                            res = relation.getSource(adminCms, CmsResourceFilter.ALL);
                            if (CmsResourceTypeXmlContainerPage.isContainerPage(res)) {
                                containerPages.add(res);
                                if (!CmsJspTagContainer.isDetailContainersPage(adminCms, adminCms.getSitePath(res))) continue;
                                this.addDetailContent(adminCms, containerPages, adminCms.getSitePath(res));
                                continue;
                            }
                            if (!OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName().equals("groupcontainer")) continue;
                            elementGroups.add(res);
                        }
                    }
                    if (containerPageTypeId != cmsPublishedResource.getType()) continue;
                    this.addDetailContent(adminCms, containerPages, adminCms.getRequestContext().removeSiteRoot(cmsPublishedResource.getRootPath()));
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            for (CmsResource cmsResource : elementGroups) {
                try {
                    filter = CmsRelationFilter.relationsToStructureId(cmsResource.getStructureId());
                    filter.filterStrong();
                    relations = adminCms.readRelations(filter);
                    for (CmsRelation relation : relations) {
                        res = relation.getSource(adminCms, CmsResourceFilter.ALL);
                        if (!CmsResourceTypeXmlContainerPage.isContainerPage(res)) continue;
                        containerPages.add(res);
                        if (!CmsJspTagContainer.isDetailContainersPage(adminCms, adminCms.getSitePath(res))) continue;
                        this.addDetailContent(adminCms, containerPages, adminCms.getSitePath(res));
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            for (CmsResource cmsResource : containerPages) {
                CmsPublishedResource pubCont = new CmsPublishedResource(cmsResource);
                if (updateResources.contains(pubCont)) continue;
                updateResources.add(pubCont);
            }
        }
        return updateResources;
    }

    protected List<String> getDocumentTypes() {
        ArrayList<String> names = new ArrayList<String>();
        for (I_CmsDocumentFactory factory : this.m_documentTypes.values()) {
            names.add(factory.getName());
        }
        return names;
    }

    protected CmsProject getOfflineIndexProject() {
        CmsProject result = null;
        for (CmsSearchIndex index : this.m_offlineIndexes) {
            try {
                result = this.m_adminCms.readProject(index.getProject());
                if (result.isOnlineProject()) continue;
                break;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected CmsIndexingThreadManager getThreadManager() {
        return new CmsIndexingThreadManager(this.m_timeout, this.m_maxModificationsBeforeCommit);
    }

    protected void initAvailableDocumentTypes() {
        CmsSearchDocumentType documenttype = null;
        String className = null;
        String name = null;
        I_CmsDocumentFactory documentFactory = null;
        List<String> resourceTypes = null;
        List<String> mimeTypes = null;
        Class<?> c = null;
        this.m_documentTypes = new HashMap<String, I_CmsDocumentFactory>();
        int n = this.m_documentTypeConfigs.size();
        for (int i = 0; i < n; ++i) {
            documenttype = this.m_documentTypeConfigs.get(i);
            name = documenttype.getName();
            try {
                className = documenttype.getClassName();
                resourceTypes = documenttype.getResourceTypes();
                mimeTypes = documenttype.getMimeTypes();
                if (name == null) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCTYPE_NO_NAME_0"));
                }
                if (className == null) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCTYPE_NO_CLASS_DEF_0"));
                }
                if (resourceTypes.size() == 0) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCTYPE_NO_RESOURCETYPE_DEF_0"));
                }
                try {
                    c = Class.forName(className);
                    documentFactory = (I_CmsDocumentFactory)c.getConstructor(String.class).newInstance(name);
                }
                catch (ClassNotFoundException exc) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCCLASS_NOT_FOUND_1", className), (Throwable)exc);
                }
                catch (Exception exc) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCCLASS_INIT_1", className), (Throwable)exc);
                }
                if (documentFactory.isUsingCache()) {
                    documentFactory.setCache(this.m_extractionResultCache);
                }
                Iterator<String> key = documentFactory.getDocumentKeys(resourceTypes, mimeTypes).iterator();
                while (key.hasNext()) {
                    this.m_documentTypes.put(key.next(), documentFactory);
                }
                continue;
            }
            catch (CmsException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_DOCTYPE_CONFIG_FAILED_1", name), (Throwable)e);
            }
        }
    }

    protected void initSearchIndexes() {
        CmsSearchIndex index = null;
        int n = this.m_indexes.size();
        for (int i = 0; i < n; ++i) {
            block5: {
                index = this.m_indexes.get(i);
                index.setEnabled(true);
                if (index.checkConfiguration(this.m_adminCms)) {
                    try {
                        index.initialize();
                    }
                    catch (Exception e) {
                        if (!CmsLog.INIT.isWarnEnabled()) break block5;
                        CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_SEARCH_INIT_FAILED_1", index), (Throwable)e);
                    }
                }
            }
            if (!CmsLog.INIT.isInfoEnabled()) continue;
            if (index.isEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_INDEX_CONFIGURED_2", index, index.getProject()));
                continue;
            }
            CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_INDEX_NOT_CONFIGURED_2", index, index.getProject()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateAllIndexes(CmsObject adminCms, CmsUUID publishHistoryId, I_CmsReport report) {
        int oldPriority = Thread.currentThread().getPriority();
        try {
            List<CmsPublishedResource> publishedResources;
            Thread.currentThread().setPriority(1);
            try {
                publishedResources = adminCms.readPublishedResources(publishHistoryId);
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_READING_CHANGED_RESOURCES_FAILED_1", publishHistoryId), (Throwable)e);
                Thread.currentThread().setPriority(oldPriority);
                return;
            }
            Set<CmsUUID> bothNewAndDeleted = this.getIdsOfPublishResourcesWhichAreBothNewAndDeleted(publishedResources);
            ArrayList<CmsPublishedResource> updateResources = new ArrayList<CmsPublishedResource>();
            for (CmsPublishedResource res : publishedResources) {
                if (res.isFolder() || res.getState().isUnchanged() || !res.getState().isDeleted() && !res.getState().isNew() && !res.getState().isChanged()) continue;
                if (updateResources.contains(res)) {
                    boolean hasMoved;
                    boolean bl = hasMoved = bothNewAndDeleted.contains(res.getStructureId()) || res.getMovedState() == CmsPublishedResource.STATE_MOVED_DESTINATION || res.getMovedState() == CmsPublishedResource.STATE_MOVED_SOURCE;
                    if (!hasMoved) {
                        updateResources.remove(res);
                    }
                    updateResources.add(res);
                    continue;
                }
                updateResources.add(res);
                if (res.getState().isDeleted() || res.getSiblingCount() <= 1) continue;
                try {
                    List<CmsResource> siblings = adminCms.readSiblings(res.getRootPath(), CmsResourceFilter.ALL);
                    for (CmsResource sibling : siblings) {
                        CmsPublishedResource sib = new CmsPublishedResource(sibling);
                        if (updateResources.contains(sib)) continue;
                        updateResources.add(sib);
                    }
                }
                catch (CmsException e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_SIBLINGS_1", res.getRootPath()), (Throwable)e);
                }
            }
            this.findRelatedContainerPages(adminCms, updateResources);
            if (!updateResources.isEmpty()) {
                Collections.sort(updateResources);
                for (CmsSearchIndex index : this.m_indexes) {
                    if (!"auto".equals(index.getRebuildMode())) continue;
                    try {
                        this.updateIndex(index, report, updateResources);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_UPDATE_INDEX_FAILED_1", index.getName()), (Throwable)e);
                    }
                }
            }
            this.cleanExtractionCache();
        }
        finally {
            Thread.currentThread().setPriority(oldPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateIndex(CmsSearchIndex index, I_CmsReport report, List<CmsPublishedResource> resourcesToIndex) throws CmsException {
        CmsObject cms = OpenCms.initCmsObject(this.m_adminCms);
        if (report == null) {
            report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsSearchManager.class);
        }
        if (!index.checkConfiguration(cms)) {
            return;
        }
        cms.getRequestContext().setSiteRoot("/");
        cms.getRequestContext().setCurrentProject(cms.readProject(index.getProject()));
        if (resourcesToIndex == null || resourcesToIndex.isEmpty()) {
            CmsIndexingThreadManager threadManager = this.getThreadManager();
            boolean isOfflineIndex = false;
            if ("offline".equals(index.getRebuildMode())) {
                isOfflineIndex = true;
                index.setRebuildMode("manual");
                this.initOfflineIndexes();
            }
            I_CmsIndexWriter writer = null;
            try {
                String backup = index.createIndexBackup();
                if (backup != null) {
                    index.indexSearcherOpen(backup);
                }
                if ((writer = index.getIndexWriter(report, true)) instanceof CmsSolrIndexWriter) {
                    try {
                        ((CmsSolrIndexWriter)writer).deleteAllDocuments();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                report.println(Messages.get().container("RPT_SEARCH_INDEXING_REBUILD_BEGIN_1", index.getName()), 2);
                for (CmsSearchIndexSource source : index.getSources()) {
                    block27: {
                        I_CmsIndexer indexer = source.getIndexer().newInstance(cms, report, index);
                        indexer.rebuildIndex(writer, threadManager, source);
                        while (threadManager.isRunning()) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                        try {
                            writer.commit();
                        }
                        catch (IOException e) {
                            if (!LOG.isWarnEnabled()) break block27;
                            LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_COMMIT_2", index.getName(), index.getPath()), (Throwable)e);
                        }
                    }
                    try {
                        writer.optimize();
                    }
                    catch (IOException e) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_OPTIMIZE_2", index.getName(), index.getPath()), (Throwable)e);
                    }
                }
                if (backup != null) {
                    index.indexSearcherClose();
                    index.removeIndexBackup(backup);
                }
                report.println(Messages.get().container("RPT_SEARCH_INDEXING_REBUILD_END_1", index.getName()), 2);
            }
            finally {
                block29: {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            if (!LOG.isWarnEnabled()) break block29;
                            LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_CLOSE_2", index.getPath(), index.getName()), (Throwable)e);
                        }
                    }
                }
                if (isOfflineIndex) {
                    index.setRebuildMode("offline");
                    this.initOfflineIndexes();
                }
                index.indexSearcherOpen(index.getPath());
            }
            threadManager.reportStatistics(report);
        } else {
            this.updateIndexIncremental(cms, index, report, resourcesToIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateIndexIncremental(CmsObject cms, CmsSearchIndex index, I_CmsReport report, List<CmsPublishedResource> resourcesToIndex) throws CmsException {
        ArrayList<CmsSearchIndexUpdateData> updateCollections = new ArrayList<CmsSearchIndexUpdateData>();
        boolean hasResourcesToDelete = false;
        boolean hasResourcesToUpdate = false;
        for (CmsSearchIndexSource source : index.getSources()) {
            I_CmsIndexer indexer = source.getIndexer().newInstance(cms, report, index);
            CmsSearchIndexUpdateData updateData = indexer.getUpdateData(source, resourcesToIndex);
            if (updateData.isEmpty()) continue;
            updateCollections.add(updateData);
            hasResourcesToDelete |= updateData.hasResourcesToDelete();
            hasResourcesToUpdate |= updateData.hasResourceToUpdate();
        }
        if (hasResourcesToDelete || hasResourcesToUpdate) {
            report.println(Messages.get().container("RPT_SEARCH_INDEXING_UPDATE_BEGIN_1", index.getName()), 2);
            I_CmsIndexWriter writer = null;
            try {
                writer = index.getIndexWriter(report, false);
                if (hasResourcesToDelete) {
                    for (CmsSearchIndexUpdateData updateCollection : updateCollections) {
                        if (!updateCollection.hasResourcesToDelete()) continue;
                        updateCollection.getIndexer().deleteResources(writer, updateCollection.getResourcesToDelete());
                    }
                }
                if (hasResourcesToUpdate) {
                    CmsIndexingThreadManager threadManager = this.getThreadManager();
                    for (CmsSearchIndexUpdateData updateCollection : updateCollections) {
                        if (!updateCollection.hasResourceToUpdate()) continue;
                        updateCollection.getIndexer().updateResources(writer, threadManager, updateCollection.getResourcesToUpdate());
                    }
                    while (threadManager.isRunning()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.commit();
                    }
                    catch (IOException e) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_COMMIT_2", index.getName(), index.getPath()), (Throwable)e);
                    }
                }
                index.indexSearcherUpdate();
            }
            report.println(Messages.get().container("RPT_SEARCH_INDEXING_UPDATE_END_1", index.getName()), 2);
        }
    }

    protected void updateIndexOffline(I_CmsReport report, List<CmsPublishedResource> resourcesToIndex) {
        CmsObject cms = this.m_adminCms;
        try {
            cms = OpenCms.initCmsObject(this.m_adminCms);
            cms.getRequestContext().setSiteRoot("/");
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        for (CmsSearchIndex index : this.m_offlineIndexes) {
            if (index.getSources() == null) continue;
            try {
                cms.getRequestContext().setCurrentProject(cms.readProject(index.getProject()));
                this.updateIndexIncremental(cms, index, report, resourcesToIndex);
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_UPDATE_INDEX_FAILED_1", index.getName()), (Throwable)e);
            }
        }
    }

    private void addDetailContent(CmsObject adminCms, Set<CmsResource> containerPages, String containerPage) {
        block3: {
            if (CmsJspTagContainer.isDetailContainersPage(adminCms, containerPage)) {
                try {
                    CmsResource detailRes = adminCms.readResource(CmsJspTagContainer.getDetailContentPath(containerPage), CmsResourceFilter.IGNORE_EXPIRATION);
                    containerPages.add(detailRes);
                }
                catch (Throwable e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)e.getLocalizedMessage(), e);
                }
            }
        }
    }

    private I_CmsReport getEventReport(CmsEvent event) {
        I_CmsReport report = null;
        if (event.getData() != null) {
            report = (I_CmsReport)event.getData().get("report");
        }
        if (report == null) {
            report = new CmsLogReport(Locale.ENGLISH, this.getClass());
        }
        return report;
    }

    private Set<CmsUUID> getIdsOfPublishResourcesWhichAreBothNewAndDeleted(List<CmsPublishedResource> publishedResources) {
        HashSet<CmsUUID> result = new HashSet<CmsUUID>();
        HashSet<CmsUUID> deletedSet = new HashSet<CmsUUID>();
        for (CmsPublishedResource pubRes : publishedResources) {
            if (pubRes.getState().isNew()) {
                result.add(pubRes.getStructureId());
            }
            if (!pubRes.getState().isDeleted()) continue;
            deletedSet.add(pubRes.getStructureId());
        }
        result.retainAll(deletedSet);
        return result;
    }

    private synchronized void initCoreContainer() {
        if (this.m_coreContainer == null) {
            try {
                this.m_coreContainer = new CoreContainer(this.m_solrConfig.getHome(), this.m_solrConfig.getSolrFile());
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SOLR_CORE_CONTAINER_CREATED_2", this.m_solrConfig.getHome(), this.m_solrConfig.getSolrFile().getName()));
                }
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().container("ERR_SOLR_CORE_CONTAINER_NOT_CREATED_1", this.m_solrConfig.getSolrFile().getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private void shutDownSolrContainer() {
        if (this.m_coreContainer != null) {
            for (SolrCore core : this.m_coreContainer.getCores()) {
                this.m_coreContainer.remove(core.getName());
                if (core.getOpenCount() > 0) {
                    LOG.error((Object)("There are still " + core.getOpenCount() + " open Solr cores left, potetial resource leak!"));
                    while (core.getOpenCount() >= 0) {
                        core.close();
                    }
                    continue;
                }
                core.close();
            }
            CmsSolrSpellchecker spell = CmsSolrSpellchecker.getInstance();
            if (spell != null) {
                spell.shutDown();
            }
            this.m_coreContainer.shutdown();
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SOLR_SHUTDOWN_SUCCESS_0"));
            }
            this.m_coreContainer = null;
        }
    }

    protected class CmsSearchOfflineIndexWorkThread
    extends Thread {
        I_CmsReport m_report;
        List<CmsPublishedResource> m_resourcesToIndex;

        protected CmsSearchOfflineIndexWorkThread(I_CmsReport report, List<CmsPublishedResource> resourcesToIndex) {
            super("OpenCms: Offline Search Index Worker");
            this.m_report = report;
            this.m_resourcesToIndex = resourcesToIndex;
        }

        @Override
        public void run() {
            CmsSearchManager.this.updateIndexOffline(this.m_report, this.m_resourcesToIndex);
            if (CmsSearchManager.this.m_offlineIndexThread != null) {
                CmsSearchManager.this.m_offlineIndexThread.getWaitHandle().release();
            }
        }
    }

    protected class CmsSearchOfflineIndexThread
    extends Thread {
        CmsSearchOfflineHandler m_handler;
        boolean m_isAlive;
        private boolean m_isUpdating;
        private boolean m_updateTriggered;
        private CmsWaitHandle m_waitHandle;

        protected CmsSearchOfflineIndexThread(CmsSearchOfflineHandler handler) {
            super("OpenCms: Offline Search Indexer");
            this.m_waitHandle = new CmsWaitHandle();
            this.m_handler = handler;
        }

        public CmsWaitHandle getWaitHandle() {
            return this.m_waitHandle;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this.m_updateTriggered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CmsLogReport report = new CmsLogReport(CmsSearchManager.this.m_adminCms.getRequestContext().getLocale(), CmsSearchManager.class);
            long offlineUpdateFrequency = CmsSearchManager.this.getOfflineUpdateFrequency();
            this.m_updateTriggered = false;
            try {
                while (this.m_isAlive) {
                    if (!this.m_updateTriggered) {
                        try {
                            CmsSearchOfflineIndexThread.sleep(offlineUpdateFrequency);
                        }
                        catch (InterruptedException e) {
                            if (!this.m_isAlive) continue;
                            if (offlineUpdateFrequency != CmsSearchManager.this.getOfflineUpdateFrequency()) {
                                offlineUpdateFrequency = CmsSearchManager.this.getOfflineUpdateFrequency();
                            }
                            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    if (!this.m_isAlive) continue;
                    this.m_updateTriggered = false;
                    List<CmsPublishedResource> resourcesToIndex = this.getResourcesToIndex();
                    if (resourcesToIndex.size() > 0) {
                        this.startOfflineUpdateThread(report, resourcesToIndex);
                    } else {
                        this.getWaitHandle().release();
                    }
                    CmsSearchOfflineIndexThread.interrupted();
                }
            }
            finally {
                this.m_isAlive = false;
            }
        }

        @Override
        public synchronized void start() {
            this.m_isAlive = true;
            super.start();
        }

        protected List<CmsPublishedResource> getResourcesToIndex() {
            List<CmsPublishedResource> resourcesToIndex = this.m_handler.getResourcesToIndex();
            ArrayList<CmsPublishedResource> result = new ArrayList<CmsPublishedResource>(resourcesToIndex.size());
            for (CmsPublishedResource pubRes : resourcesToIndex) {
                int pos = result.indexOf(pubRes);
                if (pos < 0) {
                    result.add(pubRes);
                    continue;
                }
                CmsPublishedResource curRes = (CmsPublishedResource)result.get(pos);
                if (pubRes.getState() == curRes.getState() && pubRes.getMovedState() == curRes.getMovedState() && pubRes.getRootPath().equals(curRes.getRootPath())) continue;
                result.add(pubRes);
            }
            return this.changeStateOfMoveOriginsToDeleted(result);
        }

        protected void shutDown() {
            this.m_isAlive = false;
            this.interrupt();
            if (this.m_isUpdating) {
                long waitTime = CmsSearchManager.this.getOfflineUpdateFrequency() / 2L;
                int waitSteps = 0;
                do {
                    try {
                        Thread.sleep(waitTime);
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                } while (++waitSteps < 5 && this.m_isUpdating);
            }
        }

        protected void startOfflineUpdateThread(I_CmsReport report, List<CmsPublishedResource> resourcesToIndex) {
            CmsSearchOfflineIndexWorkThread thread = new CmsSearchOfflineIndexWorkThread(report, resourcesToIndex);
            long startTime = System.currentTimeMillis();
            long waitTime = CmsSearchManager.this.getOfflineUpdateFrequency() / 2L;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_OI_UPDATE_START_1", resourcesToIndex.size()));
            }
            this.m_isUpdating = true;
            thread.start();
            do {
                try {
                    thread.join(waitTime);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                if (!thread.isAlive()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_OI_UPDATE_LONG_2", resourcesToIndex.size(), System.currentTimeMillis() - startTime));
            } while (thread.isAlive());
            this.m_isUpdating = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_OI_UPDATE_FINISH_2", resourcesToIndex.size(), System.currentTimeMillis() - startTime));
            }
        }

        private List<CmsPublishedResource> changeStateOfMoveOriginsToDeleted(List<CmsPublishedResource> resourcesToIndex) {
            HashMap<CmsUUID, String> lastValidPaths = new HashMap<CmsUUID, String>();
            for (CmsPublishedResource resource : resourcesToIndex) {
                if (resource.getState().isDeleted()) continue;
                lastValidPaths.put(resource.getStructureId(), resource.getRootPath());
            }
            ArrayList<CmsPublishedResource> result = new ArrayList<CmsPublishedResource>();
            for (CmsPublishedResource resource : resourcesToIndex) {
                if (resource.getState().isDeleted()) {
                    result.add(resource);
                    continue;
                }
                String lastValidPath = (String)lastValidPaths.get(resource.getStructureId());
                if (resource.getRootPath().equals(lastValidPath) || resource.getStructureId().isNullUUID()) {
                    result.add(resource);
                    continue;
                }
                result.add(new CmsPublishedResource(resource.getStructureId(), resource.getResourceId(), resource.getPublishTag(), resource.getRootPath(), resource.getType(), resource.isFolder(), CmsResource.STATE_DELETED, resource.getSiblingCount()));
            }
            return result;
        }
    }

    protected class CmsSearchOfflineHandler
    implements I_CmsEventListener {
        private boolean m_isEventRegistered;
        private List<CmsPublishedResource> m_resourcesToIndex = new ArrayList<CmsPublishedResource>();

        protected CmsSearchOfflineHandler() {
        }

        @Override
        public void cmsEvent(CmsEvent event) {
            switch (event.getType()) {
                case 11: 
                case 14: 
                case 15: 
                case 23: {
                    Object change = event.getData().get("change");
                    if (change != null && change.equals(new Integer(0))) {
                        return;
                    }
                    List<CmsResource> resources = Collections.singletonList((CmsResource)event.getData().get("resource"));
                    this.reIndexResources(resources);
                    break;
                }
                case 25: {
                    List eventResources = (List)event.getData().get("resources");
                    ArrayList<CmsResource> resourcesToDelete = new ArrayList<CmsResource>(eventResources);
                    for (CmsResource res : resourcesToDelete) {
                        if (!res.getState().isNew()) continue;
                        res.setState(CmsResourceState.STATE_DELETED);
                    }
                    this.reIndexResources(resourcesToDelete);
                    break;
                }
                case 12: 
                case 22: 
                case 24: 
                case 27: {
                    this.reIndexResources((List)event.getData().get("resources"));
                    break;
                }
            }
        }

        protected synchronized void addResourcesToIndex(List<CmsPublishedResource> resourcesToIndex) {
            this.m_resourcesToIndex.addAll(resourcesToIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<CmsPublishedResource> getResourcesToIndex() {
            List<CmsPublishedResource> result;
            CmsSearchOfflineHandler cmsSearchOfflineHandler = this;
            synchronized (cmsSearchOfflineHandler) {
                result = this.m_resourcesToIndex;
                this.m_resourcesToIndex = new ArrayList<CmsPublishedResource>();
            }
            try {
                CmsObject cms = CmsSearchManager.this.m_adminCms;
                CmsProject offline = CmsSearchManager.this.getOfflineIndexProject();
                if (offline != null) {
                    cms = OpenCms.initCmsObject(CmsSearchManager.this.m_adminCms);
                    cms.getRequestContext().setCurrentProject(offline);
                }
                CmsSearchManager.this.findRelatedContainerPages(cms, result);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return result;
        }

        protected void initialize() {
            if (CmsSearchManager.this.m_offlineIndexes.size() > 0) {
                if (CmsSearchManager.this.m_offlineIndexThread == null || !CmsSearchManager.this.m_offlineIndexThread.isAlive()) {
                    CmsSearchManager.this.m_offlineIndexThread = new CmsSearchOfflineIndexThread(this);
                    CmsSearchManager.this.m_offlineIndexThread.start();
                }
            } else if (CmsSearchManager.this.m_offlineIndexThread != null && CmsSearchManager.this.m_offlineIndexThread.isAlive()) {
                CmsSearchManager.this.m_offlineIndexThread.shutDown();
                CmsSearchManager.this.m_offlineIndexThread = null;
            }
            if (!this.m_isEventRegistered && CmsSearchManager.this.m_offlineIndexes.size() > 0) {
                this.m_isEventRegistered = true;
                OpenCms.addCmsEventListener(this, new int[]{14, 23, 15, 11, 27, 22, 25, 24, 12});
            }
        }

        protected synchronized void reIndexResources(List<CmsResource> resources) {
            ArrayList<CmsPublishedResource> resourcesToIndex = new ArrayList<CmsPublishedResource>(resources.size());
            for (CmsResource res : resources) {
                CmsPublishedResource pubRes = new CmsPublishedResource(res);
                resourcesToIndex.add(pubRes);
            }
            if (resourcesToIndex.size() > 0) {
                this.addResourcesToIndex(resourcesToIndex);
            }
        }
    }

    public static final class CmsSearchForceUnlockMode
    extends A_CmsModeStringEnumeration {
        public static final CmsSearchForceUnlockMode ALWAYS = new CmsSearchForceUnlockMode("always");
        public static final CmsSearchForceUnlockMode NEVER = new CmsSearchForceUnlockMode("never");
        public static final CmsSearchForceUnlockMode ONLYFULL = new CmsSearchForceUnlockMode("onlyfull");
        private static final long serialVersionUID = 74746076708908673L;

        protected CmsSearchForceUnlockMode(String mode) {
            super(mode);
        }

        public static CmsSearchForceUnlockMode valueOf(String type) {
            if (type.equals(ALWAYS.toString())) {
                return ALWAYS;
            }
            if (type.equals(NEVER.toString())) {
                return NEVER;
            }
            return ONLYFULL;
        }
    }
}

