/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.A_CmsVfsDocument;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsDocumentContainerPage
extends A_CmsVfsDocument {
    private static final Log LOG = CmsLog.getLog(CmsDocumentContainerPage.class);

    public CmsDocumentContainerPage(String name) {
        super(name);
    }

    @Override
    public I_CmsSearchDocument createDocument(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        I_CmsExtractionResult content = null;
        if (index.isExtractingContent()) {
            try {
                content = this.extractContent(cms, resource, index);
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
            }
        }
        return index.getFieldConfiguration().createDocument(cms, resource, index, content);
    }

    @Override
    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        this.logContentExtraction(resource, index);
        try {
            CmsFile file = this.readFile(cms, resource);
            CmsXmlContainerPage containerPage = CmsXmlContainerPageFactory.unmarshal(cms, file);
            Locale locale = index.getLocaleForResource(cms, resource, null);
            StringBuffer content = new StringBuffer();
            HashMap<String, String> items = new HashMap<String, String>();
            CmsContainerPageBean containerBean = containerPage.getContainerPage(cms);
            for (CmsContainerElementBean element : containerBean.getElements()) {
                element.initResource(cms);
                CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(cms, file.getRootPath());
                CmsFormatterConfiguration formatters = adeConfig.getFormatters(cms, element.getResource());
                if (!formatters.isSearchContent(element.getFormatterId())) continue;
                element.initResource(cms);
                CmsFile elementFile = this.readFile(cms, element.getResource());
                CmsXmlContent elementContent = CmsXmlContentFactory.unmarshal(cms, elementFile);
                List<String> elementNames = elementContent.getNames(locale);
                for (String xpath : elementNames) {
                    String extracted;
                    I_CmsXmlContentValue value = elementContent.getValue(xpath, locale);
                    if (!value.getContentDefinition().getContentHandler().isSearchable(value) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted = value.getPlainText(cms))) continue;
                    items.put(elementFile.getRootPath() + "/" + xpath, extracted);
                    content.append(extracted);
                    content.append('\n');
                }
            }
            return new CmsExtractionResult(content.toString(), items);
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
    }

    @Override
    public boolean isLocaleDependend() {
        return true;
    }

    @Override
    public boolean isUsingCache() {
        return true;
    }
}

