/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.Version;
import org.opencms.search.CmsSearchIndex;

public class CmsGallerySearchAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;

    public CmsGallerySearchAnalyzer(Version version) throws IOException {
        super(version, WordlistLoader.getWordSet((Reader)new BufferedReader(new InputStreamReader(CmsGallerySearchAnalyzer.class.getResourceAsStream("stopwords_multilanguage.txt"))), (String)"#", (Version)CmsSearchIndex.LUCENE_VERSION));
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer src = new StandardTokenizer(this.matchVersion, reader);
        src.setMaxTokenLength(255);
        StandardFilter tok = new StandardFilter(this.matchVersion, (TokenStream)src);
        tok = new LowerCaseFilter(this.matchVersion, (TokenStream)tok);
        tok = new StopFilter(this.matchVersion, (TokenStream)tok, this.stopwords);
        return new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)tok);
    }
}

