/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.fields.CmsSearchFieldConfiguration;

public class CmsGallerySearchParameters {
    public static final Sort SORT_DATE_CREATED_ASC = new Sort(new SortField("created", SortField.Type.STRING, false));
    public static final Sort SORT_DATE_CREATED_DESC = new Sort(new SortField("created", SortField.Type.STRING, true));
    public static final Sort SORT_DATE_EXPIRED_ASC = new Sort(new SortField("res_dateExpired", SortField.Type.STRING, false));
    public static final Sort SORT_DATE_EXPIRED_DESC = new Sort(new SortField("res_dateExpired", SortField.Type.STRING, true));
    public static final Sort SORT_DATE_LASTMODIFIED_ASC = new Sort(new SortField("lastmodified", SortField.Type.STRING, false));
    public static final Sort SORT_DATE_LASTMODIFIED_DESC = new Sort(new SortField("lastmodified", SortField.Type.STRING, true));
    public static final Sort SORT_DATE_RELEASED_ASC = new Sort(new SortField("res_dateReleased", SortField.Type.STRING, false));
    public static final Sort SORT_DATE_RELEASED_DESC = new Sort(new SortField("res_dateReleased", SortField.Type.STRING, true));
    public static final Sort SORT_LENGTH_ASC = new Sort(new SortField[]{new SortField("res_length", SortField.Type.INT, false), SortField.FIELD_SCORE});
    public static final Sort SORT_LENGTH_DESC = new Sort(new SortField[]{new SortField("res_length", SortField.Type.INT, true), SortField.FIELD_SCORE});
    public static final Sort SORT_PATH_ASC = new Sort(new SortField("path", SortField.Type.STRING, false));
    public static final Sort SORT_PATH_DESC = new Sort(new SortField("path", SortField.Type.STRING, true));
    public static final Sort SORT_SCORE = Sort.RELEVANCE;
    public static final Sort SORT_STATE_ASC = new Sort(new SortField[]{new SortField("res_state", SortField.Type.INT, false), SortField.FIELD_SCORE});
    public static final Sort SORT_STATE_DESC = new Sort(new SortField[]{new SortField("res_state", SortField.Type.INT, true), SortField.FIELD_SCORE});
    public static final Sort SORT_TITLE_ASC = new Sort(new SortField[]{new SortField("title-key", SortField.Type.STRING, false), SortField.FIELD_SCORE});
    public static final Sort SORT_TITLE_DESC = new Sort(new SortField[]{new SortField("title-key", SortField.Type.STRING, true), SortField.FIELD_SCORE});
    public static final Sort SORT_TYPE_ASC = new Sort(new SortField[]{new SortField("type", SortField.Type.STRING, false), SortField.FIELD_SCORE});
    public static final Sort SORT_TYPE_DESC = new Sort(new SortField[]{new SortField("type", SortField.Type.STRING, true), SortField.FIELD_SCORE});
    public static final Sort SORT_USER_CREATED_ASC = new Sort(new SortField[]{new SortField("res_userCreated", SortField.Type.STRING, false), new SortField("created", SortField.Type.STRING, true)});
    public static final Sort SORT_USER_CREATED_DESC = new Sort(new SortField[]{new SortField("res_userCreated", SortField.Type.STRING, true), new SortField("created", SortField.Type.STRING, true)});
    public static final Sort SORT_USER_LASTMODIFIED_ASC = new Sort(new SortField[]{new SortField("res_userLastModified", SortField.Type.STRING, false), new SortField("lastmodified", SortField.Type.STRING, true)});
    public static final Sort SORT_USER_LASTMODIFIED_DESC = new Sort(new SortField[]{new SortField("res_userLastModified", SortField.Type.STRING, true), new SortField("lastmodified", SortField.Type.STRING, true)});
    private List<String> m_categories;
    private List<String> m_containerTypes;
    private CmsGallerySearchTimeRange m_dateCreatedTimeRange;
    private CmsGallerySearchTimeRange m_dateLastModifiedTimeRange;
    private List<String> m_fields;
    private List<String> m_folders;
    private List<String> m_galleries;
    private boolean m_ignoreSearchExclude;
    private String m_locale;
    private int m_matchesPerPage = 10;
    private String m_referencePath;
    private List<String> m_resourceTypes;
    private int m_resultPage = 1;
    private CmsGallerySearchScope m_scope;
    private CmsGallerySortParam m_sortOrder;
    private String m_words;

    public List<String> getCategories() {
        return this.m_categories;
    }

    public List<String> getContainerTypes() {
        return this.m_containerTypes;
    }

    public CmsGallerySearchTimeRange getDateCreatedRange() {
        if (this.m_dateCreatedTimeRange == null) {
            this.m_dateCreatedTimeRange = new CmsGallerySearchTimeRange();
        }
        return this.m_dateCreatedTimeRange;
    }

    public CmsGallerySearchTimeRange getDateLastModifiedRange() {
        if (this.m_dateLastModifiedTimeRange == null) {
            this.m_dateLastModifiedTimeRange = new CmsGallerySearchTimeRange();
        }
        return this.m_dateLastModifiedTimeRange;
    }

    public List<String> getFields() {
        if (this.m_fields == null) {
            this.setFields(Arrays.asList(CmsSearchIndex.DOC_META_FIELDS));
        }
        return this.m_fields;
    }

    public List<String> getFolders() {
        return this.m_folders;
    }

    public List<String> getGalleries() {
        return this.m_galleries;
    }

    public String getLocale() {
        if (this.m_locale == null) {
            this.m_locale = CmsLocaleManager.getDefaultLocale().toString();
        }
        return this.m_locale;
    }

    public int getMatchesPerPage() {
        return this.m_matchesPerPage;
    }

    public String getReferencePath() {
        return this.m_referencePath;
    }

    public List<String> getResourceTypes() {
        return this.m_resourceTypes;
    }

    public int getResultPage() {
        return this.m_resultPage;
    }

    public CmsGallerySearchScope getScope() {
        if (this.m_scope == null) {
            return OpenCms.getWorkplaceManager().getGalleryDefaultScope();
        }
        return this.m_scope;
    }

    public String getSearchWords() {
        return this.m_words;
    }

    public Sort getSort() {
        switch (this.getSortOrder()) {
            case dateCreated_asc: {
                return SORT_DATE_CREATED_ASC;
            }
            case dateCreated_desc: {
                return SORT_DATE_CREATED_DESC;
            }
            case dateExpired_asc: {
                return SORT_DATE_EXPIRED_ASC;
            }
            case dateExpired_desc: {
                return SORT_DATE_EXPIRED_DESC;
            }
            case dateLastModified_asc: {
                return SORT_DATE_LASTMODIFIED_ASC;
            }
            case dateLastModified_desc: {
                return SORT_DATE_LASTMODIFIED_DESC;
            }
            case dateReleased_asc: {
                return SORT_DATE_RELEASED_ASC;
            }
            case dateReleased_desc: {
                return SORT_DATE_RELEASED_DESC;
            }
            case length_asc: {
                return SORT_LENGTH_ASC;
            }
            case length_desc: {
                return SORT_LENGTH_DESC;
            }
            case path_asc: {
                return SORT_PATH_ASC;
            }
            case path_desc: {
                return SORT_PATH_DESC;
            }
            case score: {
                return SORT_SCORE;
            }
            case state_asc: {
                return SORT_STATE_ASC;
            }
            case state_desc: {
                return SORT_STATE_DESC;
            }
            case title_asc: {
                return this.getTitleSort(this.getLocale(), false);
            }
            case title_desc: {
                return this.getTitleSort(this.getLocale(), true);
            }
            case type_asc: {
                return SORT_TYPE_ASC;
            }
            case type_desc: {
                return SORT_TYPE_DESC;
            }
            case userCreated_asc: {
                return SORT_USER_CREATED_ASC;
            }
            case userCreated_desc: {
                return SORT_USER_CREATED_DESC;
            }
            case userLastModified_asc: {
                return SORT_USER_LASTMODIFIED_ASC;
            }
            case userLastModified_desc: {
                return SORT_USER_LASTMODIFIED_DESC;
            }
        }
        return SORT_TITLE_ASC;
    }

    public CmsGallerySortParam getSortOrder() {
        if (this.m_sortOrder == null) {
            this.m_sortOrder = CmsGallerySortParam.DEFAULT;
        }
        return this.m_sortOrder;
    }

    public Sort getTitleSort(String locale, boolean desc) {
        String titleName = CmsSearchFieldConfiguration.getLocaleExtendedName("sort-title", locale);
        return new Sort(new SortField[]{new SortField(titleName, SortField.Type.STRING, desc), new SortField("sort-title", SortField.Type.STRING, desc), SortField.FIELD_SCORE});
    }

    public boolean isIgnoreSearchExclude() {
        return this.m_ignoreSearchExclude;
    }

    public void setCategories(List<String> categories) {
        this.m_categories = categories;
    }

    public void setContainerTypes(List<String> containerTypes) {
        this.m_containerTypes = containerTypes;
    }

    public void setDateCreatedTimeRange(long startTime, long endTime) {
        if (this.m_dateCreatedTimeRange == null) {
            this.m_dateCreatedTimeRange = new CmsGallerySearchTimeRange(startTime, endTime);
        }
    }

    public void setDateLastModifiedTimeRange(long startTime, long endTime) {
        if (this.m_dateLastModifiedTimeRange == null) {
            this.m_dateLastModifiedTimeRange = new CmsGallerySearchTimeRange(startTime, endTime);
        }
    }

    public void setFields(List<String> fields) {
        this.m_fields = fields;
    }

    public void setFolders(List<String> folders) {
        this.m_folders = folders;
    }

    public void setGalleries(List<String> galleries) {
        this.m_galleries = galleries;
    }

    public void setIgnoreSearchExclude(boolean excludeForPageEditor) {
        this.m_ignoreSearchExclude = excludeForPageEditor;
    }

    public void setMatchesPerPage(int matchesPerPage) {
        this.m_matchesPerPage = matchesPerPage;
    }

    public void setReferencePath(String referencePath) {
        this.m_referencePath = referencePath;
    }

    public void setResourceTypes(List<String> resourceTypes) {
        this.m_resourceTypes = resourceTypes;
    }

    public void setResultPage(int resultPage) {
        this.m_resultPage = resultPage;
    }

    public void setScope(CmsGallerySearchScope scope) {
        this.m_scope = scope;
    }

    public void setSearchLocale(String locale) {
        this.m_locale = locale;
    }

    public void setSearchWords(String words) {
        this.m_words = words;
    }

    public void setSortOrder(CmsGallerySortParam sortOrder) {
        this.m_sortOrder = sortOrder;
    }

    protected CmsSearchParameters getCmsSearchParams() {
        CmsSearchParameters result = new CmsSearchParameters();
        result.setFields(this.getFields());
        result.setExcerptOnlySearchedFields(true);
        if (this.getSearchWords() != null) {
            result.setQuery(this.getSearchWords());
            result.setIgnoreQuery(false);
        } else {
            result.setIgnoreQuery(true);
        }
        return result;
    }

    public static enum CmsGallerySortParam {
        dateCreated_asc,
        dateCreated_desc,
        dateExpired_asc,
        dateExpired_desc,
        dateLastModified_asc,
        dateLastModified_desc,
        dateReleased_asc,
        dateReleased_desc,
        length_asc,
        length_desc,
        path_asc,
        path_desc,
        score,
        state_asc,
        state_desc,
        title_asc,
        title_desc,
        type_asc,
        type_desc,
        userCreated_asc,
        userCreated_desc,
        userLastModified_asc,
        userLastModified_desc;

        public static final CmsGallerySortParam DEFAULT;

        static {
            DEFAULT = title_asc;
        }
    }

    public class CmsGallerySearchTimeRange {
        private long m_endTime;
        private long m_startTime;

        public CmsGallerySearchTimeRange() {
            this.m_startTime = Long.MIN_VALUE;
            this.m_endTime = Long.MAX_VALUE;
        }

        public CmsGallerySearchTimeRange(long startTime, long endTime) {
            this.m_startTime = startTime;
            this.m_endTime = endTime;
        }

        public long getEndTime() {
            return this.m_endTime;
        }

        public long getStartTime() {
            return this.m_startTime;
        }
    }
}

