/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsGallerySearchResult
implements Comparable<CmsGallerySearchResult> {
    public static final Log LOG = CmsLog.getLog(CmsGallerySearchResult.class);
    protected String m_additonalInfo;
    protected List<String> m_containerTypes;
    protected Date m_dateCreated;
    protected Date m_dateExpired;
    protected Date m_dateLastModified;
    protected Date m_dateReleased;
    protected String m_description;
    protected String m_excerpt;
    protected int m_length;
    protected List<String> m_locales;
    protected String m_path;
    protected String m_resourceType;
    protected int m_score;
    protected int m_state;
    protected String m_structureId;
    protected String m_title;
    protected String m_userCreated;
    protected String m_userLastModified;

    public CmsGallerySearchResult(CmsObject cms, CmsResource res) {
        try {
            Map<String, String> props = CmsProperty.toMap(cms.readPropertyObjects(res, CmsResourceTypeXmlContainerPage.isContainerPage(res)));
            this.m_title = props.get("Title");
            this.m_description = props.get("Description");
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (this.m_description == null) {
            this.m_description = "";
        }
        if (this.m_title == null) {
            this.m_title = res.getName();
        }
        this.m_dateCreated = new Date(res.getDateCreated());
        this.m_dateExpired = new Date(res.getDateExpired());
        this.m_dateLastModified = new Date(res.getDateLastModified());
        this.m_dateReleased = new Date(res.getDateReleased());
        this.m_length = res.getLength();
        this.m_locales = null;
        this.m_path = res.getRootPath();
        try {
            this.m_resourceType = OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName();
        }
        catch (CmsLoaderException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_state = res.getState().getState();
        this.m_structureId = res.getStructureId().toString();
        try {
            this.m_userCreated = cms.readUser(res.getUserCreated()).getFullName();
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            this.m_userLastModified = cms.readUser(res.getUserLastModified()).getFullName();
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public CmsGallerySearchResult(CmsObject cms, int score, Document doc, String excerpt, Locale locale) {
        this.m_score = score;
        this.m_excerpt = excerpt;
        this.m_path = null;
        IndexableField f = doc.getField("path");
        if (f != null) {
            this.m_path = f.stringValue();
        }
        if (locale == null) {
            OpenCms.getLocaleManager();
            locale = CmsLocaleManager.getDefaultLocale();
        }
        this.m_title = null;
        f = doc.getField("title-key");
        if (f != null) {
            this.m_title = f.stringValue();
        }
        if (this.m_title == null && (f = doc.getField(CmsSearchFieldConfiguration.getLocaleExtendedName("title-key", locale))) != null) {
            this.m_title = f.stringValue();
        }
        this.m_description = null;
        f = doc.getField("description");
        if (f != null) {
            this.m_description = f.stringValue();
        }
        if (this.m_description == null && (f = doc.getField(CmsSearchFieldConfiguration.getLocaleExtendedName("description", locale))) != null) {
            this.m_description = f.stringValue();
        }
        this.m_resourceType = null;
        f = doc.getField("type");
        if (f != null) {
            this.m_resourceType = f.stringValue();
        }
        this.m_dateCreated = null;
        f = doc.getField("created");
        if (f != null) {
            try {
                this.m_dateCreated = DateTools.stringToDate((String)f.stringValue());
            }
            catch (ParseException exc) {
                // empty catch block
            }
        }
        this.m_dateLastModified = null;
        f = doc.getField("lastmodified");
        if (f != null) {
            try {
                this.m_dateLastModified = DateTools.stringToDate((String)f.stringValue());
            }
            catch (ParseException exc) {
                // empty catch block
            }
        }
        this.m_dateExpired = null;
        f = doc.getField("res_dateExpired");
        if (f != null) {
            try {
                this.m_dateExpired = DateTools.stringToDate((String)f.stringValue());
            }
            catch (ParseException exc) {
                // empty catch block
            }
        }
        this.m_dateReleased = null;
        f = doc.getField("res_dateReleased");
        if (f != null) {
            try {
                this.m_dateReleased = DateTools.stringToDate((String)f.stringValue());
            }
            catch (ParseException exc) {
                // empty catch block
            }
        }
        this.m_length = 0;
        f = doc.getField("res_length");
        if (f != null) {
            try {
                this.m_length = Integer.parseInt(f.stringValue());
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        this.m_state = 0;
        f = doc.getField("res_state");
        if (f != null) {
            try {
                this.m_state = Integer.parseInt(f.stringValue());
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        this.m_userCreated = null;
        f = doc.getField("res_userCreated");
        if (f != null) {
            this.m_userCreated = f.stringValue();
        }
        this.m_structureId = null;
        f = doc.getField("res_structureId");
        if (f != null) {
            this.m_structureId = f.stringValue();
        }
        this.m_userLastModified = null;
        f = doc.getField("res_userLastModified");
        if (f != null) {
            this.m_userLastModified = f.stringValue();
        }
        this.m_additonalInfo = null;
        f = doc.getField("additional_info");
        if (f != null) {
            this.m_additonalInfo = f.stringValue();
        }
        this.m_containerTypes = null;
        f = doc.getField("container_types");
        if (f != null) {
            String containers = f.stringValue();
            this.m_containerTypes = CmsStringUtil.splitAsList(containers, ' ');
        }
        this.m_locales = null;
        f = doc.getField("res_locales");
        if (f != null) {
            String locales = f.stringValue();
            this.m_locales = CmsStringUtil.splitAsList(locales, ' ');
        }
        if (cms != null) {
            this.initializeMissingFieldsFromVfs(cms, new CmsUUID(this.m_structureId));
        }
    }

    public CmsGallerySearchResult(int score, Document doc, String excerpt, Locale locale) {
        this(null, score, doc, excerpt, locale);
    }

    @Override
    public int compareTo(CmsGallerySearchResult other) {
        if (other == this) {
            return 0;
        }
        return other.m_score - this.m_score;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsGallerySearchResult) {
            CmsGallerySearchResult other = (CmsGallerySearchResult)obj;
            return this.m_path.equals(other.m_path);
        }
        return false;
    }

    public String getAdditonalInfo() {
        return this.m_additonalInfo;
    }

    public List<String> getContainerTypes() {
        return this.m_containerTypes;
    }

    public Date getDateCreated() {
        return this.m_dateCreated;
    }

    public Date getDateExpired() {
        return this.m_dateExpired;
    }

    public Date getDateLastModified() {
        return this.m_dateLastModified;
    }

    public Date getDateReleased() {
        return this.m_dateReleased;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getExcerpt() {
        return this.m_excerpt;
    }

    public int getLength() {
        return this.m_length;
    }

    public List<String> getLocales() {
        return this.m_locales;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    public int getScore() {
        return this.m_score;
    }

    public int getState() {
        return this.m_state;
    }

    public String getStructureId() {
        return this.m_structureId;
    }

    public String getTitle() {
        return this.m_title;
    }

    public String getUserCreated() {
        return this.m_userCreated;
    }

    public String getUserLastModified() {
        return this.m_userLastModified;
    }

    public int hashCode() {
        return this.m_path.hashCode();
    }

    public boolean isReleaseAndNotExpired(CmsObject cms) {
        long time = cms.getRequestContext().getRequestTime();
        return time == Long.MIN_VALUE || time > this.m_dateReleased.getTime() && time < this.m_dateExpired.getTime();
    }

    protected void initializeMissingFieldsFromVfs(CmsObject cms, CmsUUID structureId) {
        if (structureId == null) {
            return;
        }
        if (this.m_title != null && this.m_description != null) {
            return;
        }
        try {
            CmsResource res = cms.readResource(structureId);
            if (this.m_description == null) {
                CmsProperty descProp = cms.readPropertyObject(res, "Description", CmsResourceTypeXmlContainerPage.isContainerPage(res));
                this.m_description = descProp.getValue();
            }
            if (this.m_title == null) {
                CmsProperty titleProp = cms.readPropertyObject(res, "Title", CmsResourceTypeXmlContainerPage.isContainerPage(res));
                this.m_title = titleProp.getValue();
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_title)) {
                    this.m_title = res.getName();
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return;
        }
    }
}

