/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.schema.IndexSchema;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.solr.Messages;
import org.opencms.util.CmsStringUtil;
import org.xml.sax.InputSource;

public class CmsSolrConfiguration {
    public static final String CONF_FOLDER = File.separatorChar + "conf" + File.separatorChar;
    public static final String SOLR_CONFIG_FILE = "solr.xml";
    public static final long SOLR_DEFAULT_COMMIT_MS = 10000L;
    public static final String SOLR_HOME_DEFAULT = "solr" + File.separatorChar;
    public static final String SOLR_HOME_PROPERTY = "solr.solr.home";
    public static final String SOLR_SCHEMA_NAME = "OpenCms SOLR schema";
    private static final Log LOG = CmsLog.getLog(CmsSolrConfiguration.class);
    private long m_commitMs = 10000L;
    private boolean m_enabled;
    private String m_home;
    private String m_homeFolderPath;
    private IndexSchema m_schema;
    private String m_serverUrl;
    private SolrConfig m_solrConfig;
    private File m_solrFile;
    private String m_solrFileName;

    public String getHome() {
        if (this.m_homeFolderPath == null) {
            this.m_home = CmsStringUtil.isNotEmpty(System.getProperty(SOLR_HOME_PROPERTY)) ? System.getProperty(SOLR_HOME_PROPERTY) : OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(SOLR_HOME_DEFAULT);
            this.m_home = this.m_home.endsWith(File.separator) ? this.m_home.substring(0, this.m_home.lastIndexOf(File.separator)) : this.m_home;
        } else {
            this.m_home = this.m_homeFolderPath;
        }
        return this.m_home;
    }

    public String getHomeFolderPath() {
        return this.m_homeFolderPath;
    }

    public String getServerUrl() {
        return this.m_serverUrl;
    }

    public long getSolrCommitMs() {
        return this.m_commitMs;
    }

    public SolrConfig getSolrConfig() {
        if (this.m_solrConfig == null) {
            try {
                InputSource solrConfig = new InputSource(new FileInputStream(this.getSolrConfigFile()));
                this.m_solrConfig = new SolrConfig(this.getHome(), null, solrConfig);
            }
            catch (FileNotFoundException e) {
                CmsConfigurationException ex = new CmsConfigurationException(Messages.get().container("LOG_SOLR_ERR_CONFIG_XML_NOT_FOUND_1", this.getSolrConfigFile()), (Throwable)e);
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
            catch (Exception e) {
                CmsConfigurationException ex = new CmsConfigurationException(Messages.get().container("LOG_SOLR_ERR_CONFIG_XML_NOT_READABLE_1", this.getSolrConfigFile()), (Throwable)e);
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return this.m_solrConfig;
    }

    public File getSolrConfigFile() {
        return new File(this.getHome() + CONF_FOLDER + "solrconfig.xml");
    }

    public File getSolrFile() {
        if (this.m_solrFile == null) {
            String solrFileName = this.m_solrFileName != null ? this.m_solrFileName : SOLR_CONFIG_FILE;
            this.m_solrFile = new File(this.getHome() + File.separator + solrFileName);
        }
        return this.m_solrFile;
    }

    public String getSolrFileName() {
        return this.m_solrFileName;
    }

    public IndexSchema getSolrSchema() {
        if (this.m_schema == null) {
            try {
                InputSource solrSchema = new InputSource(new FileInputStream(this.getSolrSchemaFile()));
                this.m_schema = new IndexSchema(this.getSolrConfig(), SOLR_SCHEMA_NAME, solrSchema);
            }
            catch (FileNotFoundException e) {
                CmsConfigurationException ex = new CmsConfigurationException(Messages.get().container("LOG_SOLR_ERR_SCHEMA_XML_NOT_FOUND_1", this.getSolrSchemaFile().getPath()), (Throwable)e);
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return this.m_schema;
    }

    public File getSolrSchemaFile() {
        return new File(this.getHome() + CONF_FOLDER + "schema.xml");
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(String isEnabled) {
        this.m_enabled = Boolean.valueOf(isEnabled);
    }

    public void setHomeFolderPath(String homeFolderPath) {
        this.m_homeFolderPath = homeFolderPath;
    }

    public void setServerUrl(String url) {
        this.m_serverUrl = url;
    }

    public void setSolrCommitMs(String time) {
        this.m_commitMs = new Long(time);
    }

    public void setSolrFileName(String name) {
        this.m_solrFileName = name;
    }
}

