/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.documents.CmsDocumentXmlContent;
import org.opencms.search.documents.CmsIndexNoContentException;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.solr.CmsSolrDocumentContainerPage;
import org.opencms.search.solr.CmsSolrFieldConfiguration;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsSolrDocumentXmlContent
extends CmsDocumentXmlContent {
    private static final Log LOG = CmsLog.getLog(CmsSolrDocumentXmlContent.class);
    public static final String TYPE_XMLCONTENT_SOLR = "xmlcontent-solr";

    public CmsSolrDocumentXmlContent(String name) {
        super(name);
    }

    public static CmsExtractionResult extractXmlContent(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        CmsFile file = cms.readFile(resource);
        if (file.getLength() <= 0) {
            throw new CmsIndexNoContentException(Messages.get().container("ERR_NO_CONTENT_1", resource.getRootPath()));
        }
        CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, file);
        HashMap<String, String> items = new HashMap<String, String>();
        StringBuffer locales = new StringBuffer();
        Locale resourceLocale = index.getLocaleForResource(cms, resource, xmlContent.getLocales());
        String defaultContent = null;
        for (Locale locale : xmlContent.getLocales()) {
            StringBuffer textContent = new StringBuffer();
            locales.append(locale.toString());
            locales.append(' ');
            List<String> paths = xmlContent.getNames(locale);
            for (String xpath : paths) {
                String extracted = null;
                I_CmsXmlContentValue value = xmlContent.getValue(xpath, locale);
                try {
                    extracted = value.getPlainText(cms);
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly(extracted) && value.isSimpleType()) {
                        extracted = value.getStringValue(cms);
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)Messages.get().container("LOG_EXTRACT_VALUE_2", xpath, resource), (Throwable)e);
                }
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted)) {
                    items.put(CmsXmlUtils.concatXpath(locale.toString(), xpath), extracted);
                }
                if (!value.getContentDefinition().getContentHandler().isSearchable(value) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted)) continue;
                textContent.append(extracted);
                textContent.append('\n');
            }
            if (textContent.length() <= 0) continue;
            String key = CmsSearchFieldConfiguration.getLocaleExtendedName("content", locale);
            items.put(key, textContent.toString());
            if (!resourceLocale.equals(locale)) continue;
            defaultContent = textContent.toString();
        }
        items.put("res_locales", locales.toString().trim());
        return new CmsExtractionResult(defaultContent, items);
    }

    @Override
    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        this.logContentExtraction(resource, index);
        try {
            I_CmsExtractionResult result = null;
            if (this.hasDetailContainers(cms, resource)) {
                String detailContainerPage = CmsJspTagContainer.getDetailOnlyPageName(cms.getSitePath(resource));
                CmsResource detailContainers = cms.readResource(detailContainerPage);
                ArrayList<I_CmsExtractionResult> ex = new ArrayList<I_CmsExtractionResult>();
                CmsSolrDocumentContainerPage containerpageExtractor = new CmsSolrDocumentContainerPage("");
                I_CmsExtractionResult containersExtractionResult = containerpageExtractor.extractContent(cms, detailContainers, index);
                containersExtractionResult.getContentItems().remove("res_locales");
                ex.add(containersExtractionResult);
                ex.add(CmsSolrDocumentXmlContent.extractXmlContent(cms, resource, index));
                result = CmsSolrDocumentContainerPage.merge(cms, resource, ex, (CmsSolrFieldConfiguration)index.getFieldConfiguration());
            } else {
                result = CmsSolrDocumentXmlContent.extractXmlContent(cms, resource, index);
            }
            return result;
        }
        catch (Throwable t) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource), t);
        }
    }

    public boolean hasDetailContainers(CmsObject cms, CmsResource resource) {
        String detailContainerPage = CmsJspTagContainer.getDetailOnlyPageName(cms.getSitePath(resource));
        return cms.existsResource(detailContainerPage);
    }
}

