/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site.xmlsitemap;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.db.CmsAlias;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.shared.alias.CmsAliasMode;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.CmsResourceManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.site.CmsSite;
import org.opencms.site.xmlsitemap.CmsPathIncludeExcludeSet;
import org.opencms.site.xmlsitemap.CmsXmlSitemapUrlBean;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsXmlSitemapGenerator {
    public static final String DEFAULT_CHANGE_FREQUENCY = "daily";
    public static final double DEFAULT_PRIORITY = 0.5;
    private static final Log LOG = CmsLog.getLog(CmsXmlSitemapGenerator.class);
    protected String m_baseFolderRootPath;
    protected String m_baseFolderSitePath;
    protected boolean m_computeContainerPageDates;
    protected List<CmsDetailPageInfo> m_detailPageInfos = new ArrayList<CmsDetailPageInfo>();
    protected Map<String, List<CmsResource>> m_detailResources = new HashMap<String, List<CmsResource>>();
    protected Multimap<String, String> m_detailTypesByPage = ArrayListMultimap.create();
    protected CmsObject m_guestCms;
    protected CmsPathIncludeExcludeSet m_includeExcludeSet = new CmsPathIncludeExcludeSet();
    protected Multimap<CmsUUID, CmsAlias> m_pageAliasesBelowBaseFolderByStructureId = ArrayListMultimap.create();
    protected Map<String, ResultEntry> m_resultMap = new LinkedHashMap<String, ResultEntry>();
    protected CmsObject m_siteGuestCms;
    protected String m_siteRoot;
    protected String m_siteRootLink;

    public CmsXmlSitemapGenerator(String folderRootPath) throws CmsException {
        this.m_baseFolderRootPath = CmsFileUtil.removeTrailingSeparator(folderRootPath);
        this.m_guestCms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
        this.m_siteGuestCms = OpenCms.initCmsObject(this.m_guestCms);
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(CmsStringUtil.joinPaths(folderRootPath, "/"));
        this.m_siteRoot = site.getSiteRoot();
        this.m_siteGuestCms.getRequestContext().setSiteRoot(this.m_siteRoot);
        this.m_baseFolderSitePath = CmsStringUtil.joinPaths("/", this.m_siteGuestCms.getRequestContext().removeSiteRoot(this.m_baseFolderRootPath));
    }

    protected static String getChangeFrequency(List<CmsProperty> properties) {
        CmsProperty prop = CmsProperty.get("xmlsitemap.changefreq", properties);
        if (prop.isNullProperty()) {
            return null;
        }
        String result = prop.getValue().trim();
        return result;
    }

    protected static void removeInternalFiles(List<CmsResource> resources) {
        Iterator<CmsResource> iter = resources.iterator();
        while (iter.hasNext()) {
            CmsResource resource = iter.next();
            if (!resource.isInternal()) continue;
            iter.remove();
        }
    }

    private static double getPriority(List<CmsProperty> properties) {
        CmsProperty prop = CmsProperty.get("xmlsitemap.priority", properties);
        if (prop.isNullProperty()) {
            return -1.0;
        }
        try {
            double result = Double.parseDouble(prop.getValue().trim());
            return result;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    public List<CmsXmlSitemapUrlBean> generateSitemapBeans() throws CmsException {
        String baseSitePath = this.m_siteGuestCms.getRequestContext().removeSiteRoot(this.m_baseFolderRootPath);
        this.initializeFileData(baseSitePath);
        for (CmsResource resource : this.getDirectPages()) {
            String sitePath = this.m_siteGuestCms.getSitePath(resource);
            List<CmsProperty> propertyList = this.m_siteGuestCms.readPropertyObjects(resource, true);
            String onlineLink = OpenCms.getLinkManager().getOnlineLink(this.m_siteGuestCms, sitePath);
            boolean isContainerPage = CmsResourceTypeXmlContainerPage.isContainerPage(resource);
            long dateModified = resource.getDateLastModified();
            if (isContainerPage) {
                dateModified = this.m_computeContainerPageDates ? this.computeContainerPageModificationDate(resource) : -1L;
            }
            CmsXmlSitemapUrlBean urlBean = new CmsXmlSitemapUrlBean(onlineLink, dateModified, CmsXmlSitemapGenerator.getChangeFrequency(propertyList), CmsXmlSitemapGenerator.getPriority(propertyList));
            urlBean.setOriginalResource(resource);
            this.addResult(urlBean, 3);
            if (!isContainerPage) continue;
            Locale locale = this.getLocale(resource, propertyList);
            this.addDetailLinks(resource, locale);
        }
        for (CmsUUID aliasStructureId : this.m_pageAliasesBelowBaseFolderByStructureId.keySet()) {
            this.addAliasLinks(aliasStructureId);
        }
        ArrayList<CmsXmlSitemapUrlBean> result = new ArrayList<CmsXmlSitemapUrlBean>();
        for (ResultEntry resultEntry : this.m_resultMap.values()) {
            result.add(resultEntry.getUrlBean());
        }
        return result;
    }

    public CmsPathIncludeExcludeSet getIncludeExcludeSet() {
        return this.m_includeExcludeSet;
    }

    public String renderSitemap() throws CmsException {
        StringBuffer buffer = new StringBuffer();
        List<CmsXmlSitemapUrlBean> urlBeans = this.generateSitemapBeans();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append(this.getUrlSetOpenTag() + "\n");
        for (CmsXmlSitemapUrlBean bean : urlBeans) {
            buffer.append(this.getXmlForEntry(bean));
            buffer.append("\n");
        }
        buffer.append("</urlset>");
        return buffer.toString();
    }

    public void setComputeContainerPageDates(boolean computeContainerPageDates) {
        this.m_computeContainerPageDates = computeContainerPageDates;
    }

    protected void addResult(CmsXmlSitemapUrlBean result, int resultPriority) {
        String url = CmsFileUtil.removeTrailingSeparator(result.getUrl());
        boolean writeEntry = true;
        if (this.m_resultMap.containsKey(url)) {
            LOG.warn((Object)("Encountered duplicate URL with while generating sitemap: " + result.getUrl()));
            ResultEntry entry = this.m_resultMap.get(url);
            boolean bl = writeEntry = entry.getPriority() <= resultPriority;
        }
        if (writeEntry) {
            this.m_resultMap.put(url, new ResultEntry(result, resultPriority));
        }
    }

    protected long computeContainerPageModificationDate(CmsResource containerPage) throws CmsException {
        CmsRelationFilter filter = CmsRelationFilter.relationsFromStructureId(containerPage.getStructureId()).filterType(CmsRelationType.XML_STRONG);
        List<CmsRelation> relations = this.m_guestCms.readRelations(filter);
        long result = containerPage.getDateLastModified();
        for (CmsRelation relation : relations) {
            try {
                CmsResource target = relation.getTarget(this.m_guestCms, CmsResourceFilter.DEFAULT_FILES.addRequireVisible());
                long targetDate = target.getDateLastModified();
                if (targetDate <= result) continue;
                result = targetDate;
            }
            catch (CmsException e) {
                LOG.warn((Object)("Could not get relation target for relation " + relation.toString() + " | " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDetailLink(CmsResource pageRes, CmsResource detailRes, Locale locale) {
        String pageSitePath = this.m_siteGuestCms.getSitePath(pageRes);
        String detailSitePath = this.m_siteGuestCms.getSitePath(detailRes);
        CmsRequestContext requestContext = this.m_siteGuestCms.getRequestContext();
        String originalUri = requestContext.getUri();
        Locale originalLocale = requestContext.getLocale();
        try {
            requestContext.setUri(pageSitePath);
            requestContext.setLocale(locale);
            String string = OpenCms.getLinkManager().getOnlineLink(this.m_siteGuestCms, detailSitePath, true);
            return string;
        }
        finally {
            requestContext.setUri(originalUri);
            requestContext.setLocale(originalLocale);
        }
    }

    protected List<I_CmsResourceType> getDetailTypesForPage(CmsResource resource) {
        Collection typesForPage = this.m_detailTypesByPage.get((Object)resource.getRootPath());
        String parentPath = CmsFileUtil.removeTrailingSeparator(CmsResource.getParentFolder(resource.getRootPath()));
        Collection typesForFolder = this.m_detailTypesByPage.get((Object)parentPath);
        HashSet allTypes = new HashSet();
        allTypes.addAll(typesForPage);
        allTypes.addAll(typesForFolder);
        ArrayList<I_CmsResourceType> resTypes = new ArrayList<I_CmsResourceType>();
        CmsResourceManager resMan = OpenCms.getResourceManager();
        for (String typeName : allTypes) {
            try {
                I_CmsResourceType resType = resMan.getResourceType(typeName);
                resTypes.add(resType);
            }
            catch (CmsLoaderException e) {
                LOG.warn((Object)("Invalid resource type name" + typeName + "! " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return resTypes;
    }

    protected List<CmsResource> getDirectPages() throws CmsException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        result.addAll(this.getNavigationPages());
        Set<String> includeRoots = this.m_includeExcludeSet.getIncludeRoots();
        for (String includeRoot : includeRoots) {
            try {
                CmsResource resource = this.m_guestCms.readResource(includeRoot);
                if (resource.isFile()) {
                    result.add(resource);
                    continue;
                }
                List<CmsResource> subtreeFiles = this.m_guestCms.readResources(includeRoot, CmsResourceFilter.DEFAULT_FILES, true);
                result.addAll(subtreeFiles);
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.warn((Object)("Could not read include resource: " + includeRoot));
            }
        }
        Iterator filterIter = result.iterator();
        while (filterIter.hasNext()) {
            CmsResource currentResource = (CmsResource)filterIter.next();
            if (!currentResource.isInternal() && !this.m_includeExcludeSet.isExcluded(currentResource.getRootPath())) continue;
            filterIter.remove();
        }
        return result;
    }

    protected String getInnerXmlForEntry(CmsXmlSitemapUrlBean entry) {
        StringBuffer buffer = new StringBuffer();
        entry.writeElement(buffer, "loc", entry.getUrl());
        entry.writeLastmod(buffer);
        entry.writeChangefreq(buffer);
        entry.writePriority(buffer);
        return buffer.toString();
    }

    protected List<CmsResource> getNavigationPages() {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        CmsJspNavBuilder navBuilder = new CmsJspNavBuilder(this.m_siteGuestCms);
        List<CmsJspNavElement> navElements = navBuilder.getSiteNavigation(this.m_baseFolderSitePath, -1);
        for (CmsJspNavElement navElement : navElements) {
            CmsResource navResource = navElement.getResource();
            if (navResource.isFolder()) {
                try {
                    CmsResource defaultFile = this.m_guestCms.readDefaultFile(navResource, CmsResourceFilter.DEFAULT_FILES);
                    if (defaultFile != null) {
                        result.add(defaultFile);
                        continue;
                    }
                    LOG.warn((Object)("Could not get default file for " + navResource.getRootPath()));
                }
                catch (CmsException e) {
                    LOG.warn((Object)("Could not get default file for " + navResource.getRootPath()));
                }
                continue;
            }
            result.add(navResource);
        }
        return result;
    }

    protected String getUrlSetOpenTag() {
        return "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">";
    }

    protected String getXmlForEntry(CmsXmlSitemapUrlBean entry) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<url>");
        buffer.append(this.getInnerXmlForEntry(entry));
        buffer.append("</url>");
        return buffer.toString();
    }

    protected boolean isAliasBelowBaseFolder(CmsAlias alias) {
        boolean isBelowBaseFolder = CmsStringUtil.isPrefixPath(this.m_baseFolderSitePath, alias.getAliasPath());
        return isBelowBaseFolder;
    }

    private void addAliasLinks(CmsUUID aliasStructureId) {
        try {
            CmsResource aliasTarget = this.m_guestCms.readResource(aliasStructureId);
            List<CmsProperty> properties = this.m_guestCms.readPropertyObjects(aliasTarget, true);
            double priority = CmsXmlSitemapGenerator.getPriority(properties);
            String changeFrequency = CmsXmlSitemapGenerator.getChangeFrequency(properties);
            Collection aliases = this.m_pageAliasesBelowBaseFolderByStructureId.get((Object)aliasStructureId);
            for (CmsAlias alias : aliases) {
                String aliasLink = (this.m_siteRootLink + "/" + alias.getAliasPath()).replaceAll("(?<!:)//+", "/");
                CmsXmlSitemapUrlBean aliasUrlBean = new CmsXmlSitemapUrlBean(aliasLink, -1L, changeFrequency, priority);
                aliasUrlBean.setOriginalResource(aliasTarget);
                this.addResult(aliasUrlBean, 1);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void addDetailLinks(CmsResource containerPage, Locale locale) throws CmsException {
        List<I_CmsResourceType> types = this.getDetailTypesForPage(containerPage);
        for (I_CmsResourceType type : types) {
            List<CmsResource> resourcesForType = this.getDetailResources(type);
            for (CmsResource detailRes : resourcesForType) {
                if (!this.isValidDetailPageCombination(containerPage, locale, detailRes)) continue;
                List<CmsProperty> detailProps = this.m_guestCms.readPropertyObjects(detailRes, true);
                String detailLink = this.getDetailLink(containerPage, detailRes, locale);
                detailLink = CmsFileUtil.removeTrailingSeparator(detailLink);
                CmsXmlSitemapUrlBean detailUrlBean = new CmsXmlSitemapUrlBean(detailLink, detailRes.getDateLastModified(), CmsXmlSitemapGenerator.getChangeFrequency(detailProps), CmsXmlSitemapGenerator.getPriority(detailProps));
                detailUrlBean.setOriginalResource(detailRes);
                detailUrlBean.setDetailPageResource(containerPage);
                this.addResult(detailUrlBean, 2);
            }
        }
    }

    private List<CmsResource> getDetailResources(I_CmsResourceType type) throws CmsException {
        String typeName = type.getTypeName();
        if (!this.m_detailResources.containsKey(typeName)) {
            ArrayList<CmsResource> result = new ArrayList<CmsResource>();
            CmsResourceFilter filter = CmsResourceFilter.DEFAULT_FILES.addRequireType(type.getTypeId());
            List<CmsResource> siteFiles = this.m_guestCms.readResources(this.m_siteRoot, filter, true);
            result.addAll(siteFiles);
            String shared = CmsFileUtil.removeTrailingSeparator(OpenCms.getSiteManager().getSharedFolder());
            if (shared != null) {
                List<CmsResource> sharedFiles = this.m_guestCms.readResources(shared, filter, true);
                result.addAll(sharedFiles);
            }
            this.m_detailResources.put(typeName, result);
        }
        return this.m_detailResources.get(typeName);
    }

    private Locale getLocale(CmsResource resource, List<CmsProperty> propertyList) {
        return OpenCms.getLocaleManager().getDefaultLocale(this.m_guestCms, this.m_guestCms.getSitePath(resource));
    }

    private void initializeFileData(String baseSitePath) throws CmsException {
        this.m_resultMap.clear();
        this.m_siteRootLink = OpenCms.getLinkManager().getOnlineLink(this.m_siteGuestCms, "/");
        this.m_siteRootLink = CmsFileUtil.removeTrailingSeparator(this.m_siteRootLink);
        this.m_detailPageInfos = OpenCms.getADEManager().getAllDetailPages(this.m_guestCms);
        for (CmsDetailPageInfo detailPageInfo : this.m_detailPageInfos) {
            String type = detailPageInfo.getType();
            String path = detailPageInfo.getUri();
            path = CmsFileUtil.removeTrailingSeparator(path);
            this.m_detailTypesByPage.put((Object)path, (Object)type);
        }
        List<CmsAlias> siteAliases = OpenCms.getAliasManager().getAliasesForSite(this.m_siteGuestCms, this.m_siteGuestCms.getRequestContext().getSiteRoot());
        for (CmsAlias alias : siteAliases) {
            if (!this.isAliasBelowBaseFolder(alias) || alias.getMode() != CmsAliasMode.page) continue;
            CmsUUID aliasId = alias.getStructureId();
            this.m_pageAliasesBelowBaseFolderByStructureId.put((Object)aliasId, (Object)alias);
        }
    }

    private boolean isValidDetailPageCombination(CmsResource page, Locale locale, CmsResource detailRes) {
        return true;
    }

    protected class ResultEntry {
        private int m_priority;
        private CmsXmlSitemapUrlBean m_urlBean;

        public ResultEntry(CmsXmlSitemapUrlBean urlBean, int priority) {
            this.m_priority = priority;
            this.m_urlBean = urlBean;
        }

        public int getPriority() {
            return this.m_priority;
        }

        public CmsXmlSitemapUrlBean getUrlBean() {
            return this.m_urlBean;
        }
    }
}

