/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ugc;

import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ugc.CmsUgcConfiguration;
import org.opencms.ugc.Messages;
import org.opencms.ugc.shared.CmsUgcConstants;
import org.opencms.ugc.shared.CmsUgcException;

public class CmsUgcSessionSecurityUtil {
    private static final Log LOG = CmsLog.getLog(CmsUgcSessionSecurityUtil.class);

    private CmsUgcSessionSecurityUtil() {
    }

    public static void checkCreateContent(CmsObject cms, CmsUgcConfiguration config) throws CmsUgcException {
        if (config.getMaxContentNumber().isPresent()) {
            int maxContents = (Integer)config.getMaxContentNumber().get();
            String sitePath = cms.getSitePath(config.getContentParentFolder());
            try {
                if (cms.getFilesInFolder(sitePath).size() >= maxContents) {
                    String message = Messages.get().getBundle(cms.getRequestContext().getLocale()).key("ERR_TOO_MANY_CONTENTS_1", config.getContentParentFolder());
                    throw new CmsUgcException(CmsUgcConstants.ErrorCode.errMaxContentsExceeded, message);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                throw new CmsUgcException(e);
            }
        }
    }

    public static void checkCreateUpload(CmsObject cms, CmsUgcConfiguration config, String name, long size) throws CmsUgcException {
        if (!config.getUploadParentFolder().isPresent()) {
            String message = Messages.get().container("ERR_NO_UPLOADS_ALLOWED_0").key(cms.getRequestContext().getLocale());
            throw new CmsUgcException(CmsUgcConstants.ErrorCode.errNoUploadAllowed, message);
        }
        if (config.getMaxUploadSize().isPresent() && (Long)config.getMaxUploadSize().get() < size) {
            String message = Messages.get().container("ERR_UPLOAD_TOO_BIG_1", name).key(cms.getRequestContext().getLocale());
            throw new CmsUgcException(CmsUgcConstants.ErrorCode.errMaxUploadSizeExceeded, message);
        }
        if (config.getValidExtensions().isPresent()) {
            List validExtensions = (List)config.getValidExtensions().get();
            boolean foundExtension = false;
            for (String extension : validExtensions) {
                if (!name.toLowerCase().endsWith(extension.toLowerCase())) continue;
                foundExtension = true;
                break;
            }
            if (!foundExtension) {
                String message = Messages.get().container("ERR_UPLOAD_FILE_EXTENSION_NOT_ALLOWED_1", name).key(cms.getRequestContext().getLocale());
                throw new CmsUgcException(CmsUgcConstants.ErrorCode.errInvalidExtension, message);
            }
        }
    }
}

